/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Multiplex Container Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiplexContainerSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiplexContainerSettings.Builder, MultiplexContainerSettings> {
    private static final SdkField<MultiplexM2tsSettings> MULTIPLEX_M2_TS_SETTINGS_FIELD = SdkField
            .<MultiplexM2tsSettings> builder(MarshallingType.SDK_POJO).memberName("MultiplexM2tsSettings")
            .getter(getter(MultiplexContainerSettings::multiplexM2tsSettings)).setter(setter(Builder::multiplexM2tsSettings))
            .constructor(MultiplexM2tsSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexM2tsSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MULTIPLEX_M2_TS_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final MultiplexM2tsSettings multiplexM2tsSettings;

    private MultiplexContainerSettings(BuilderImpl builder) {
        this.multiplexM2tsSettings = builder.multiplexM2tsSettings;
    }

    /**
     * Returns the value of the MultiplexM2tsSettings property for this object.
     * 
     * @return The value of the MultiplexM2tsSettings property for this object.
     */
    public final MultiplexM2tsSettings multiplexM2tsSettings() {
        return multiplexM2tsSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(multiplexM2tsSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexContainerSettings)) {
            return false;
        }
        MultiplexContainerSettings other = (MultiplexContainerSettings) obj;
        return Objects.equals(multiplexM2tsSettings(), other.multiplexM2tsSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiplexContainerSettings").add("MultiplexM2tsSettings", multiplexM2tsSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultiplexM2tsSettings":
            return Optional.ofNullable(clazz.cast(multiplexM2tsSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiplexContainerSettings, T> g) {
        return obj -> g.apply((MultiplexContainerSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiplexContainerSettings> {
        /**
         * Sets the value of the MultiplexM2tsSettings property for this object.
         *
         * @param multiplexM2tsSettings
         *        The new value for the MultiplexM2tsSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexM2tsSettings(MultiplexM2tsSettings multiplexM2tsSettings);

        /**
         * Sets the value of the MultiplexM2tsSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MultiplexM2tsSettings.Builder} avoiding
         * the need to create one manually via {@link MultiplexM2tsSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiplexM2tsSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #multiplexM2tsSettings(MultiplexM2tsSettings)}.
         * 
         * @param multiplexM2tsSettings
         *        a consumer that will call methods on {@link MultiplexM2tsSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiplexM2tsSettings(MultiplexM2tsSettings)
         */
        default Builder multiplexM2tsSettings(Consumer<MultiplexM2tsSettings.Builder> multiplexM2tsSettings) {
            return multiplexM2tsSettings(MultiplexM2tsSettings.builder().applyMutation(multiplexM2tsSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MultiplexM2tsSettings multiplexM2tsSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexContainerSettings model) {
            multiplexM2tsSettings(model.multiplexM2tsSettings);
        }

        public final MultiplexM2tsSettings.Builder getMultiplexM2tsSettings() {
            return multiplexM2tsSettings != null ? multiplexM2tsSettings.toBuilder() : null;
        }

        public final void setMultiplexM2tsSettings(MultiplexM2tsSettings.BuilderImpl multiplexM2tsSettings) {
            this.multiplexM2tsSettings = multiplexM2tsSettings != null ? multiplexM2tsSettings.build() : null;
        }

        @Override
        public final Builder multiplexM2tsSettings(MultiplexM2tsSettings multiplexM2tsSettings) {
            this.multiplexM2tsSettings = multiplexM2tsSettings;
            return this;
        }

        @Override
        public MultiplexContainerSettings build() {
            return new MultiplexContainerSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
