/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for OutputDestination
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputDestination.Builder, OutputDestination> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(OutputDestination::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<List<MediaPackageOutputDestinationSettings>> MEDIA_PACKAGE_SETTINGS_FIELD = SdkField
            .<List<MediaPackageOutputDestinationSettings>> builder(MarshallingType.LIST)
            .memberName("MediaPackageSettings")
            .getter(getter(OutputDestination::mediaPackageSettings))
            .setter(setter(Builder::mediaPackageSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaPackageSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaPackageOutputDestinationSettings> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaPackageOutputDestinationSettings::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MultiplexProgramChannelDestinationSettings> MULTIPLEX_SETTINGS_FIELD = SdkField
            .<MultiplexProgramChannelDestinationSettings> builder(MarshallingType.SDK_POJO).memberName("MultiplexSettings")
            .getter(getter(OutputDestination::multiplexSettings)).setter(setter(Builder::multiplexSettings))
            .constructor(MultiplexProgramChannelDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexSettings").build()).build();

    private static final SdkField<List<OutputDestinationSettings>> SETTINGS_FIELD = SdkField
            .<List<OutputDestinationSettings>> builder(MarshallingType.LIST)
            .memberName("Settings")
            .getter(getter(OutputDestination::settings))
            .setter(setter(Builder::settings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputDestinationSettings> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputDestinationSettings::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SrtOutputDestinationSettings>> SRT_SETTINGS_FIELD = SdkField
            .<List<SrtOutputDestinationSettings>> builder(MarshallingType.LIST)
            .memberName("SrtSettings")
            .getter(getter(OutputDestination::srtSettings))
            .setter(setter(Builder::srtSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SrtOutputDestinationSettings> builder(MarshallingType.SDK_POJO)
                                            .constructor(SrtOutputDestinationSettings::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            MEDIA_PACKAGE_SETTINGS_FIELD, MULTIPLEX_SETTINGS_FIELD, SETTINGS_FIELD, SRT_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final List<MediaPackageOutputDestinationSettings> mediaPackageSettings;

    private final MultiplexProgramChannelDestinationSettings multiplexSettings;

    private final List<OutputDestinationSettings> settings;

    private final List<SrtOutputDestinationSettings> srtSettings;

    private OutputDestination(BuilderImpl builder) {
        this.id = builder.id;
        this.mediaPackageSettings = builder.mediaPackageSettings;
        this.multiplexSettings = builder.multiplexSettings;
        this.settings = builder.settings;
        this.srtSettings = builder.srtSettings;
    }

    /**
     * User-specified id. This is used in an output group or an output.
     * 
     * @return User-specified id. This is used in an output group or an output.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaPackageSettings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMediaPackageSettings() {
        return mediaPackageSettings != null && !(mediaPackageSettings instanceof SdkAutoConstructList);
    }

    /**
     * Destination settings for a MediaPackage output; one destination for both encoders.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaPackageSettings} method.
     * </p>
     * 
     * @return Destination settings for a MediaPackage output; one destination for both encoders.
     */
    public final List<MediaPackageOutputDestinationSettings> mediaPackageSettings() {
        return mediaPackageSettings;
    }

    /**
     * Destination settings for a Multiplex output; one destination for both encoders.
     * 
     * @return Destination settings for a Multiplex output; one destination for both encoders.
     */
    public final MultiplexProgramChannelDestinationSettings multiplexSettings() {
        return multiplexSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Settings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSettings() {
        return settings != null && !(settings instanceof SdkAutoConstructList);
    }

    /**
     * Destination settings for a standard output; one destination for each redundant encoder.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSettings} method.
     * </p>
     * 
     * @return Destination settings for a standard output; one destination for each redundant encoder.
     */
    public final List<OutputDestinationSettings> settings() {
        return settings;
    }

    /**
     * For responses, this returns true if the service returned a value for the SrtSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSrtSettings() {
        return srtSettings != null && !(srtSettings instanceof SdkAutoConstructList);
    }

    /**
     * SRT settings for an SRT output; one destination for each redundant encoder.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSrtSettings} method.
     * </p>
     * 
     * @return SRT settings for an SRT output; one destination for each redundant encoder.
     */
    public final List<SrtOutputDestinationSettings> srtSettings() {
        return srtSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaPackageSettings() ? mediaPackageSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(multiplexSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasSettings() ? settings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSrtSettings() ? srtSettings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDestination)) {
            return false;
        }
        OutputDestination other = (OutputDestination) obj;
        return Objects.equals(id(), other.id()) && hasMediaPackageSettings() == other.hasMediaPackageSettings()
                && Objects.equals(mediaPackageSettings(), other.mediaPackageSettings())
                && Objects.equals(multiplexSettings(), other.multiplexSettings()) && hasSettings() == other.hasSettings()
                && Objects.equals(settings(), other.settings()) && hasSrtSettings() == other.hasSrtSettings()
                && Objects.equals(srtSettings(), other.srtSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputDestination").add("Id", id())
                .add("MediaPackageSettings", hasMediaPackageSettings() ? mediaPackageSettings() : null)
                .add("MultiplexSettings", multiplexSettings()).add("Settings", hasSettings() ? settings() : null)
                .add("SrtSettings", hasSrtSettings() ? srtSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "MediaPackageSettings":
            return Optional.ofNullable(clazz.cast(mediaPackageSettings()));
        case "MultiplexSettings":
            return Optional.ofNullable(clazz.cast(multiplexSettings()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        case "SrtSettings":
            return Optional.ofNullable(clazz.cast(srtSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputDestination, T> g) {
        return obj -> g.apply((OutputDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputDestination> {
        /**
         * User-specified id. This is used in an output group or an output.
         * 
         * @param id
         *        User-specified id. This is used in an output group or an output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Destination settings for a MediaPackage output; one destination for both encoders.
         * 
         * @param mediaPackageSettings
         *        Destination settings for a MediaPackage output; one destination for both encoders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPackageSettings(Collection<MediaPackageOutputDestinationSettings> mediaPackageSettings);

        /**
         * Destination settings for a MediaPackage output; one destination for both encoders.
         * 
         * @param mediaPackageSettings
         *        Destination settings for a MediaPackage output; one destination for both encoders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPackageSettings(MediaPackageOutputDestinationSettings... mediaPackageSettings);

        /**
         * Destination settings for a MediaPackage output; one destination for both encoders. This is a convenience
         * method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.MediaPackageOutputDestinationSettings.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.MediaPackageOutputDestinationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.MediaPackageOutputDestinationSettings.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #mediaPackageSettings(List<MediaPackageOutputDestinationSettings>)}.
         * 
         * @param mediaPackageSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.MediaPackageOutputDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaPackageSettings(java.util.Collection<MediaPackageOutputDestinationSettings>)
         */
        Builder mediaPackageSettings(Consumer<MediaPackageOutputDestinationSettings.Builder>... mediaPackageSettings);

        /**
         * Destination settings for a Multiplex output; one destination for both encoders.
         * 
         * @param multiplexSettings
         *        Destination settings for a Multiplex output; one destination for both encoders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexSettings(MultiplexProgramChannelDestinationSettings multiplexSettings);

        /**
         * Destination settings for a Multiplex output; one destination for both encoders. This is a convenience method
         * that creates an instance of the {@link MultiplexProgramChannelDestinationSettings.Builder} avoiding the need
         * to create one manually via {@link MultiplexProgramChannelDestinationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiplexProgramChannelDestinationSettings.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #multiplexSettings(MultiplexProgramChannelDestinationSettings)}.
         * 
         * @param multiplexSettings
         *        a consumer that will call methods on {@link MultiplexProgramChannelDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiplexSettings(MultiplexProgramChannelDestinationSettings)
         */
        default Builder multiplexSettings(Consumer<MultiplexProgramChannelDestinationSettings.Builder> multiplexSettings) {
            return multiplexSettings(MultiplexProgramChannelDestinationSettings.builder().applyMutation(multiplexSettings)
                    .build());
        }

        /**
         * Destination settings for a standard output; one destination for each redundant encoder.
         * 
         * @param settings
         *        Destination settings for a standard output; one destination for each redundant encoder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(Collection<OutputDestinationSettings> settings);

        /**
         * Destination settings for a standard output; one destination for each redundant encoder.
         * 
         * @param settings
         *        Destination settings for a standard output; one destination for each redundant encoder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(OutputDestinationSettings... settings);

        /**
         * Destination settings for a standard output; one destination for each redundant encoder. This is a convenience
         * method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.OutputDestinationSettings.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.OutputDestinationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.OutputDestinationSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #settings(List<OutputDestinationSettings>)}.
         * 
         * @param settings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.OutputDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(java.util.Collection<OutputDestinationSettings>)
         */
        Builder settings(Consumer<OutputDestinationSettings.Builder>... settings);

        /**
         * SRT settings for an SRT output; one destination for each redundant encoder.
         * 
         * @param srtSettings
         *        SRT settings for an SRT output; one destination for each redundant encoder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder srtSettings(Collection<SrtOutputDestinationSettings> srtSettings);

        /**
         * SRT settings for an SRT output; one destination for each redundant encoder.
         * 
         * @param srtSettings
         *        SRT settings for an SRT output; one destination for each redundant encoder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder srtSettings(SrtOutputDestinationSettings... srtSettings);

        /**
         * SRT settings for an SRT output; one destination for each redundant encoder. This is a convenience method that
         * creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.SrtOutputDestinationSettings.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.SrtOutputDestinationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.SrtOutputDestinationSettings.Builder#build()} is
         * called immediately and its result is passed to {@link #srtSettings(List<SrtOutputDestinationSettings>)}.
         * 
         * @param srtSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.SrtOutputDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #srtSettings(java.util.Collection<SrtOutputDestinationSettings>)
         */
        Builder srtSettings(Consumer<SrtOutputDestinationSettings.Builder>... srtSettings);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private List<MediaPackageOutputDestinationSettings> mediaPackageSettings = DefaultSdkAutoConstructList.getInstance();

        private MultiplexProgramChannelDestinationSettings multiplexSettings;

        private List<OutputDestinationSettings> settings = DefaultSdkAutoConstructList.getInstance();

        private List<SrtOutputDestinationSettings> srtSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OutputDestination model) {
            id(model.id);
            mediaPackageSettings(model.mediaPackageSettings);
            multiplexSettings(model.multiplexSettings);
            settings(model.settings);
            srtSettings(model.srtSettings);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<MediaPackageOutputDestinationSettings.Builder> getMediaPackageSettings() {
            List<MediaPackageOutputDestinationSettings.Builder> result = ___listOfMediaPackageOutputDestinationSettingsCopier
                    .copyToBuilder(this.mediaPackageSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaPackageSettings(
                Collection<MediaPackageOutputDestinationSettings.BuilderImpl> mediaPackageSettings) {
            this.mediaPackageSettings = ___listOfMediaPackageOutputDestinationSettingsCopier
                    .copyFromBuilder(mediaPackageSettings);
        }

        @Override
        public final Builder mediaPackageSettings(Collection<MediaPackageOutputDestinationSettings> mediaPackageSettings) {
            this.mediaPackageSettings = ___listOfMediaPackageOutputDestinationSettingsCopier.copy(mediaPackageSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaPackageSettings(MediaPackageOutputDestinationSettings... mediaPackageSettings) {
            mediaPackageSettings(Arrays.asList(mediaPackageSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaPackageSettings(Consumer<MediaPackageOutputDestinationSettings.Builder>... mediaPackageSettings) {
            mediaPackageSettings(Stream.of(mediaPackageSettings)
                    .map(c -> MediaPackageOutputDestinationSettings.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final MultiplexProgramChannelDestinationSettings.Builder getMultiplexSettings() {
            return multiplexSettings != null ? multiplexSettings.toBuilder() : null;
        }

        public final void setMultiplexSettings(MultiplexProgramChannelDestinationSettings.BuilderImpl multiplexSettings) {
            this.multiplexSettings = multiplexSettings != null ? multiplexSettings.build() : null;
        }

        @Override
        public final Builder multiplexSettings(MultiplexProgramChannelDestinationSettings multiplexSettings) {
            this.multiplexSettings = multiplexSettings;
            return this;
        }

        public final List<OutputDestinationSettings.Builder> getSettings() {
            List<OutputDestinationSettings.Builder> result = ___listOfOutputDestinationSettingsCopier
                    .copyToBuilder(this.settings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSettings(Collection<OutputDestinationSettings.BuilderImpl> settings) {
            this.settings = ___listOfOutputDestinationSettingsCopier.copyFromBuilder(settings);
        }

        @Override
        @Transient
        public final Builder settings(Collection<OutputDestinationSettings> settings) {
            this.settings = ___listOfOutputDestinationSettingsCopier.copy(settings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(OutputDestinationSettings... settings) {
            settings(Arrays.asList(settings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(Consumer<OutputDestinationSettings.Builder>... settings) {
            settings(Stream.of(settings).map(c -> OutputDestinationSettings.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SrtOutputDestinationSettings.Builder> getSrtSettings() {
            List<SrtOutputDestinationSettings.Builder> result = ___listOfSrtOutputDestinationSettingsCopier
                    .copyToBuilder(this.srtSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSrtSettings(Collection<SrtOutputDestinationSettings.BuilderImpl> srtSettings) {
            this.srtSettings = ___listOfSrtOutputDestinationSettingsCopier.copyFromBuilder(srtSettings);
        }

        @Override
        public final Builder srtSettings(Collection<SrtOutputDestinationSettings> srtSettings) {
            this.srtSettings = ___listOfSrtOutputDestinationSettingsCopier.copy(srtSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder srtSettings(SrtOutputDestinationSettings... srtSettings) {
            srtSettings(Arrays.asList(srtSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder srtSettings(Consumer<SrtOutputDestinationSettings.Builder>... srtSettings) {
            srtSettings(Stream.of(srtSettings).map(c -> SrtOutputDestinationSettings.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public OutputDestination build() {
            return new OutputDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
