/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Srt Group Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class SrtGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<SrtGroupSettings.Builder, SrtGroupSettings> {
    private static final SdkField<String> INPUT_LOSS_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputLossAction").getter(getter(SrtGroupSettings::inputLossActionAsString))
            .setter(setter(Builder::inputLossAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_LOSS_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputLossAction;

    private SrtGroupSettings(BuilderImpl builder) {
        this.inputLossAction = builder.inputLossAction;
    }

    /**
     * Specifies behavior of last resort when input video is lost, and no more backup inputs are available. When dropTs
     * is selected the entire transport stream will stop being emitted. When dropProgram is selected the program can be
     * dropped from the transport stream (and replaced with null packets to meet the TS bitrate requirement). Or, when
     * emitProgram is chosen the transport stream will continue to be produced normally with repeat frames, black
     * frames, or slate frames substituted for the absent input video.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputLossAction}
     * will return {@link InputLossActionForUdpOut#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #inputLossActionAsString}.
     * </p>
     * 
     * @return Specifies behavior of last resort when input video is lost, and no more backup inputs are available. When
     *         dropTs is selected the entire transport stream will stop being emitted. When dropProgram is selected the
     *         program can be dropped from the transport stream (and replaced with null packets to meet the TS bitrate
     *         requirement). Or, when emitProgram is chosen the transport stream will continue to be produced normally
     *         with repeat frames, black frames, or slate frames substituted for the absent input video.
     * @see InputLossActionForUdpOut
     */
    public final InputLossActionForUdpOut inputLossAction() {
        return InputLossActionForUdpOut.fromValue(inputLossAction);
    }

    /**
     * Specifies behavior of last resort when input video is lost, and no more backup inputs are available. When dropTs
     * is selected the entire transport stream will stop being emitted. When dropProgram is selected the program can be
     * dropped from the transport stream (and replaced with null packets to meet the TS bitrate requirement). Or, when
     * emitProgram is chosen the transport stream will continue to be produced normally with repeat frames, black
     * frames, or slate frames substituted for the absent input video.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputLossAction}
     * will return {@link InputLossActionForUdpOut#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #inputLossActionAsString}.
     * </p>
     * 
     * @return Specifies behavior of last resort when input video is lost, and no more backup inputs are available. When
     *         dropTs is selected the entire transport stream will stop being emitted. When dropProgram is selected the
     *         program can be dropped from the transport stream (and replaced with null packets to meet the TS bitrate
     *         requirement). Or, when emitProgram is chosen the transport stream will continue to be produced normally
     *         with repeat frames, black frames, or slate frames substituted for the absent input video.
     * @see InputLossActionForUdpOut
     */
    public final String inputLossActionAsString() {
        return inputLossAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputLossActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtGroupSettings)) {
            return false;
        }
        SrtGroupSettings other = (SrtGroupSettings) obj;
        return Objects.equals(inputLossActionAsString(), other.inputLossActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SrtGroupSettings").add("InputLossAction", inputLossActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputLossAction":
            return Optional.ofNullable(clazz.cast(inputLossActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SrtGroupSettings, T> g) {
        return obj -> g.apply((SrtGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SrtGroupSettings> {
        /**
         * Specifies behavior of last resort when input video is lost, and no more backup inputs are available. When
         * dropTs is selected the entire transport stream will stop being emitted. When dropProgram is selected the
         * program can be dropped from the transport stream (and replaced with null packets to meet the TS bitrate
         * requirement). Or, when emitProgram is chosen the transport stream will continue to be produced normally with
         * repeat frames, black frames, or slate frames substituted for the absent input video.
         * 
         * @param inputLossAction
         *        Specifies behavior of last resort when input video is lost, and no more backup inputs are available.
         *        When dropTs is selected the entire transport stream will stop being emitted. When dropProgram is
         *        selected the program can be dropped from the transport stream (and replaced with null packets to meet
         *        the TS bitrate requirement). Or, when emitProgram is chosen the transport stream will continue to be
         *        produced normally with repeat frames, black frames, or slate frames substituted for the absent input
         *        video.
         * @see InputLossActionForUdpOut
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputLossActionForUdpOut
         */
        Builder inputLossAction(String inputLossAction);

        /**
         * Specifies behavior of last resort when input video is lost, and no more backup inputs are available. When
         * dropTs is selected the entire transport stream will stop being emitted. When dropProgram is selected the
         * program can be dropped from the transport stream (and replaced with null packets to meet the TS bitrate
         * requirement). Or, when emitProgram is chosen the transport stream will continue to be produced normally with
         * repeat frames, black frames, or slate frames substituted for the absent input video.
         * 
         * @param inputLossAction
         *        Specifies behavior of last resort when input video is lost, and no more backup inputs are available.
         *        When dropTs is selected the entire transport stream will stop being emitted. When dropProgram is
         *        selected the program can be dropped from the transport stream (and replaced with null packets to meet
         *        the TS bitrate requirement). Or, when emitProgram is chosen the transport stream will continue to be
         *        produced normally with repeat frames, black frames, or slate frames substituted for the absent input
         *        video.
         * @see InputLossActionForUdpOut
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputLossActionForUdpOut
         */
        Builder inputLossAction(InputLossActionForUdpOut inputLossAction);
    }

    static final class BuilderImpl implements Builder {
        private String inputLossAction;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtGroupSettings model) {
            inputLossAction(model.inputLossAction);
        }

        public final String getInputLossAction() {
            return inputLossAction;
        }

        public final void setInputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
        }

        @Override
        public final Builder inputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
            return this;
        }

        @Override
        public final Builder inputLossAction(InputLossActionForUdpOut inputLossAction) {
            this.inputLossAction(inputLossAction == null ? null : inputLossAction.toString());
            return this;
        }

        @Override
        public SrtGroupSettings build() {
            return new SrtGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
