/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for SrtOutputDestinationSettings
 */
@Generated("software.amazon.awssdk:codegen")
public final class SrtOutputDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<SrtOutputDestinationSettings.Builder, SrtOutputDestinationSettings> {
    private static final SdkField<String> ENCRYPTION_PASSPHRASE_SECRET_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EncryptionPassphraseSecretArn")
            .getter(getter(SrtOutputDestinationSettings::encryptionPassphraseSecretArn))
            .setter(setter(Builder::encryptionPassphraseSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionPassphraseSecretArn")
                    .build()).build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamId").getter(getter(SrtOutputDestinationSettings::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(SrtOutputDestinationSettings::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENCRYPTION_PASSPHRASE_SECRET_ARN_FIELD, STREAM_ID_FIELD, URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String encryptionPassphraseSecretArn;

    private final String streamId;

    private final String url;

    private SrtOutputDestinationSettings(BuilderImpl builder) {
        this.encryptionPassphraseSecretArn = builder.encryptionPassphraseSecretArn;
        this.streamId = builder.streamId;
        this.url = builder.url;
    }

    /**
     * Arn used to extract the password from Secrets Manager
     * 
     * @return Arn used to extract the password from Secrets Manager
     */
    public final String encryptionPassphraseSecretArn() {
        return encryptionPassphraseSecretArn;
    }

    /**
     * Stream id for SRT destinations (URLs of type srt://)
     * 
     * @return Stream id for SRT destinations (URLs of type srt://)
     */
    public final String streamId() {
        return streamId;
    }

    /**
     * A URL specifying a destination
     * 
     * @return A URL specifying a destination
     */
    public final String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionPassphraseSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtOutputDestinationSettings)) {
            return false;
        }
        SrtOutputDestinationSettings other = (SrtOutputDestinationSettings) obj;
        return Objects.equals(encryptionPassphraseSecretArn(), other.encryptionPassphraseSecretArn())
                && Objects.equals(streamId(), other.streamId()) && Objects.equals(url(), other.url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SrtOutputDestinationSettings")
                .add("EncryptionPassphraseSecretArn", encryptionPassphraseSecretArn()).add("StreamId", streamId())
                .add("Url", url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionPassphraseSecretArn":
            return Optional.ofNullable(clazz.cast(encryptionPassphraseSecretArn()));
        case "StreamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SrtOutputDestinationSettings, T> g) {
        return obj -> g.apply((SrtOutputDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SrtOutputDestinationSettings> {
        /**
         * Arn used to extract the password from Secrets Manager
         * 
         * @param encryptionPassphraseSecretArn
         *        Arn used to extract the password from Secrets Manager
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionPassphraseSecretArn(String encryptionPassphraseSecretArn);

        /**
         * Stream id for SRT destinations (URLs of type srt://)
         * 
         * @param streamId
         *        Stream id for SRT destinations (URLs of type srt://)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        /**
         * A URL specifying a destination
         * 
         * @param url
         *        A URL specifying a destination
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String encryptionPassphraseSecretArn;

        private String streamId;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtOutputDestinationSettings model) {
            encryptionPassphraseSecretArn(model.encryptionPassphraseSecretArn);
            streamId(model.streamId);
            url(model.url);
        }

        public final String getEncryptionPassphraseSecretArn() {
            return encryptionPassphraseSecretArn;
        }

        public final void setEncryptionPassphraseSecretArn(String encryptionPassphraseSecretArn) {
            this.encryptionPassphraseSecretArn = encryptionPassphraseSecretArn;
        }

        @Override
        public final Builder encryptionPassphraseSecretArn(String encryptionPassphraseSecretArn) {
            this.encryptionPassphraseSecretArn = encryptionPassphraseSecretArn;
            return this;
        }

        public final String getStreamId() {
            return streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public SrtOutputDestinationSettings build() {
            return new SrtOutputDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
