/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Represents the latest successful monitor deployment of a signal map.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuccessfulMonitorDeployment implements SdkPojo, Serializable,
        ToCopyableBuilder<SuccessfulMonitorDeployment.Builder, SuccessfulMonitorDeployment> {
    private static final SdkField<String> DETAILS_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailsUri").getter(getter(SuccessfulMonitorDeployment::detailsUri)).setter(setter(Builder::detailsUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detailsUri").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SuccessfulMonitorDeployment::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_URI_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String detailsUri;

    private final String status;

    private SuccessfulMonitorDeployment(BuilderImpl builder) {
        this.detailsUri = builder.detailsUri;
        this.status = builder.status;
    }

    /**
     * URI associated with a signal map's monitor deployment.
     * 
     * @return URI associated with a signal map's monitor deployment.
     */
    public final String detailsUri() {
        return detailsUri;
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SignalMapMonitorDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see SignalMapMonitorDeploymentStatus
     */
    public final SignalMapMonitorDeploymentStatus status() {
        return SignalMapMonitorDeploymentStatus.fromValue(status);
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SignalMapMonitorDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see SignalMapMonitorDeploymentStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detailsUri());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuccessfulMonitorDeployment)) {
            return false;
        }
        SuccessfulMonitorDeployment other = (SuccessfulMonitorDeployment) obj;
        return Objects.equals(detailsUri(), other.detailsUri()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuccessfulMonitorDeployment").add("DetailsUri", detailsUri()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetailsUri":
            return Optional.ofNullable(clazz.cast(detailsUri()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuccessfulMonitorDeployment, T> g) {
        return obj -> g.apply((SuccessfulMonitorDeployment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuccessfulMonitorDeployment> {
        /**
         * URI associated with a signal map's monitor deployment.
         * 
         * @param detailsUri
         *        URI associated with a signal map's monitor deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailsUri(String detailsUri);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see SignalMapMonitorDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalMapMonitorDeploymentStatus
         */
        Builder status(String status);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see SignalMapMonitorDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SignalMapMonitorDeploymentStatus
         */
        Builder status(SignalMapMonitorDeploymentStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String detailsUri;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(SuccessfulMonitorDeployment model) {
            detailsUri(model.detailsUri);
            status(model.status);
        }

        public final String getDetailsUri() {
            return detailsUri;
        }

        public final void setDetailsUri(String detailsUri) {
            this.detailsUri = detailsUri;
        }

        @Override
        public final Builder detailsUri(String detailsUri) {
            this.detailsUri = detailsUri;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SignalMapMonitorDeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public SuccessfulMonitorDeployment build() {
            return new SuccessfulMonitorDeployment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
