/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to update the channel placement group
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateChannelPlacementGroupRequest extends MediaLiveRequest implements
        ToCopyableBuilder<UpdateChannelPlacementGroupRequest.Builder, UpdateChannelPlacementGroupRequest> {
    private static final SdkField<String> CHANNEL_PLACEMENT_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelPlacementGroupId").getter(getter(UpdateChannelPlacementGroupRequest::channelPlacementGroupId))
            .setter(setter(Builder::channelPlacementGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelPlacementGroupId").build())
            .build();

    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(UpdateChannelPlacementGroupRequest::clusterId))
            .setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateChannelPlacementGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> NODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Nodes")
            .getter(getter(UpdateChannelPlacementGroupRequest::nodes))
            .setter(setter(Builder::nodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CHANNEL_PLACEMENT_GROUP_ID_FIELD, CLUSTER_ID_FIELD, NAME_FIELD, NODES_FIELD));

    private final String channelPlacementGroupId;

    private final String clusterId;

    private final String name;

    private final List<String> nodes;

    private UpdateChannelPlacementGroupRequest(BuilderImpl builder) {
        super(builder);
        this.channelPlacementGroupId = builder.channelPlacementGroupId;
        this.clusterId = builder.clusterId;
        this.name = builder.name;
        this.nodes = builder.nodes;
    }

    /**
     * The ID of the channel placement group.
     * 
     * @return The ID of the channel placement group.
     */
    public final String channelPlacementGroupId() {
        return channelPlacementGroupId;
    }

    /**
     * The ID of the cluster.
     * 
     * @return The ID of the cluster.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * Include this parameter only if you want to change the current name of the ChannelPlacementGroup. Specify a name
     * that is unique in the Cluster. You can't change the name. Names are case-sensitive.
     * 
     * @return Include this parameter only if you want to change the current name of the ChannelPlacementGroup. Specify
     *         a name that is unique in the Cluster. You can't change the name. Names are case-sensitive.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Nodes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNodes() {
        return nodes != null && !(nodes instanceof SdkAutoConstructList);
    }

    /**
     * Include this parameter only if you want to change the list of Nodes that are associated with the
     * ChannelPlacementGroup.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodes} method.
     * </p>
     * 
     * @return Include this parameter only if you want to change the list of Nodes that are associated with the
     *         ChannelPlacementGroup.
     */
    public final List<String> nodes() {
        return nodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelPlacementGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodes() ? nodes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelPlacementGroupRequest)) {
            return false;
        }
        UpdateChannelPlacementGroupRequest other = (UpdateChannelPlacementGroupRequest) obj;
        return Objects.equals(channelPlacementGroupId(), other.channelPlacementGroupId())
                && Objects.equals(clusterId(), other.clusterId()) && Objects.equals(name(), other.name())
                && hasNodes() == other.hasNodes() && Objects.equals(nodes(), other.nodes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateChannelPlacementGroupRequest").add("ChannelPlacementGroupId", channelPlacementGroupId())
                .add("ClusterId", clusterId()).add("Name", name()).add("Nodes", hasNodes() ? nodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelPlacementGroupId":
            return Optional.ofNullable(clazz.cast(channelPlacementGroupId()));
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Nodes":
            return Optional.ofNullable(clazz.cast(nodes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelPlacementGroupRequest, T> g) {
        return obj -> g.apply((UpdateChannelPlacementGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateChannelPlacementGroupRequest> {
        /**
         * The ID of the channel placement group.
         * 
         * @param channelPlacementGroupId
         *        The ID of the channel placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelPlacementGroupId(String channelPlacementGroupId);

        /**
         * The ID of the cluster.
         * 
         * @param clusterId
         *        The ID of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * Include this parameter only if you want to change the current name of the ChannelPlacementGroup. Specify a
         * name that is unique in the Cluster. You can't change the name. Names are case-sensitive.
         * 
         * @param name
         *        Include this parameter only if you want to change the current name of the ChannelPlacementGroup.
         *        Specify a name that is unique in the Cluster. You can't change the name. Names are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Include this parameter only if you want to change the list of Nodes that are associated with the
         * ChannelPlacementGroup.
         * 
         * @param nodes
         *        Include this parameter only if you want to change the list of Nodes that are associated with the
         *        ChannelPlacementGroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodes(Collection<String> nodes);

        /**
         * Include this parameter only if you want to change the list of Nodes that are associated with the
         * ChannelPlacementGroup.
         * 
         * @param nodes
         *        Include this parameter only if you want to change the list of Nodes that are associated with the
         *        ChannelPlacementGroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodes(String... nodes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String channelPlacementGroupId;

        private String clusterId;

        private String name;

        private List<String> nodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelPlacementGroupRequest model) {
            super(model);
            channelPlacementGroupId(model.channelPlacementGroupId);
            clusterId(model.clusterId);
            name(model.name);
            nodes(model.nodes);
        }

        public final String getChannelPlacementGroupId() {
            return channelPlacementGroupId;
        }

        public final void setChannelPlacementGroupId(String channelPlacementGroupId) {
            this.channelPlacementGroupId = channelPlacementGroupId;
        }

        @Override
        public final Builder channelPlacementGroupId(String channelPlacementGroupId) {
            this.channelPlacementGroupId = channelPlacementGroupId;
            return this;
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getNodes() {
            if (nodes instanceof SdkAutoConstructList) {
                return null;
            }
            return nodes;
        }

        public final void setNodes(Collection<String> nodes) {
            this.nodes = ___listOf__stringCopier.copy(nodes);
        }

        @Override
        public final Builder nodes(Collection<String> nodes) {
            this.nodes = ___listOf__stringCopier.copy(nodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(String... nodes) {
            nodes(Arrays.asList(nodes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChannelPlacementGroupRequest build() {
            return new UpdateChannelPlacementGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
