/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to update the network.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNetworkRequest extends MediaLiveRequest implements
        ToCopyableBuilder<UpdateNetworkRequest.Builder, UpdateNetworkRequest> {
    private static final SdkField<List<IpPoolUpdateRequest>> IP_POOLS_FIELD = SdkField
            .<List<IpPoolUpdateRequest>> builder(MarshallingType.LIST)
            .memberName("IpPools")
            .getter(getter(UpdateNetworkRequest::ipPools))
            .setter(setter(Builder::ipPools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipPools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpPoolUpdateRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPoolUpdateRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateNetworkRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkId").getter(getter(UpdateNetworkRequest::networkId)).setter(setter(Builder::networkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()).build();

    private static final SdkField<List<RouteUpdateRequest>> ROUTES_FIELD = SdkField
            .<List<RouteUpdateRequest>> builder(MarshallingType.LIST)
            .memberName("Routes")
            .getter(getter(UpdateNetworkRequest::routes))
            .setter(setter(Builder::routes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteUpdateRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteUpdateRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_POOLS_FIELD, NAME_FIELD,
            NETWORK_ID_FIELD, ROUTES_FIELD));

    private final List<IpPoolUpdateRequest> ipPools;

    private final String name;

    private final String networkId;

    private final List<RouteUpdateRequest> routes;

    private UpdateNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.ipPools = builder.ipPools;
        this.name = builder.name;
        this.networkId = builder.networkId;
        this.routes = builder.routes;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpPools property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIpPools() {
        return ipPools != null && !(ipPools instanceof SdkAutoConstructList);
    }

    /**
     * Include this parameter only if you want to change the pool of IP addresses in the network. An array of
     * IpPoolCreateRequests that identify a collection of IP addresses in this network that you want to reserve for use
     * in MediaLive Anywhere. MediaLive Anywhere uses these IP addresses for Push inputs (in both Bridge and NAT
     * networks) and for output destinations (only in Bridge networks). Each IpPoolUpdateRequest specifies one CIDR
     * block.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpPools} method.
     * </p>
     * 
     * @return Include this parameter only if you want to change the pool of IP addresses in the network. An array of
     *         IpPoolCreateRequests that identify a collection of IP addresses in this network that you want to reserve
     *         for use in MediaLive Anywhere. MediaLive Anywhere uses these IP addresses for Push inputs (in both Bridge
     *         and NAT networks) and for output destinations (only in Bridge networks). Each IpPoolUpdateRequest
     *         specifies one CIDR block.
     */
    public final List<IpPoolUpdateRequest> ipPools() {
        return ipPools;
    }

    /**
     * Include this parameter only if you want to change the name of the Network. Specify a name that is unique in the
     * AWS account. Names are case-sensitive.
     * 
     * @return Include this parameter only if you want to change the name of the Network. Specify a name that is unique
     *         in the AWS account. Names are case-sensitive.
     */
    public final String name() {
        return name;
    }

    /**
     * The ID of the network
     * 
     * @return The ID of the network
     */
    public final String networkId() {
        return networkId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Routes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRoutes() {
        return routes != null && !(routes instanceof SdkAutoConstructList);
    }

    /**
     * Include this parameter only if you want to change or add routes in the Network. An array of Routes that MediaLive
     * Anywhere needs to know about in order to route encoding traffic.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutes} method.
     * </p>
     * 
     * @return Include this parameter only if you want to change or add routes in the Network. An array of Routes that
     *         MediaLive Anywhere needs to know about in order to route encoding traffic.
     */
    public final List<RouteUpdateRequest> routes() {
        return routes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIpPools() ? ipPools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutes() ? routes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNetworkRequest)) {
            return false;
        }
        UpdateNetworkRequest other = (UpdateNetworkRequest) obj;
        return hasIpPools() == other.hasIpPools() && Objects.equals(ipPools(), other.ipPools())
                && Objects.equals(name(), other.name()) && Objects.equals(networkId(), other.networkId())
                && hasRoutes() == other.hasRoutes() && Objects.equals(routes(), other.routes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateNetworkRequest").add("IpPools", hasIpPools() ? ipPools() : null).add("Name", name())
                .add("NetworkId", networkId()).add("Routes", hasRoutes() ? routes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpPools":
            return Optional.ofNullable(clazz.cast(ipPools()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkId":
            return Optional.ofNullable(clazz.cast(networkId()));
        case "Routes":
            return Optional.ofNullable(clazz.cast(routes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNetworkRequest, T> g) {
        return obj -> g.apply((UpdateNetworkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateNetworkRequest> {
        /**
         * Include this parameter only if you want to change the pool of IP addresses in the network. An array of
         * IpPoolCreateRequests that identify a collection of IP addresses in this network that you want to reserve for
         * use in MediaLive Anywhere. MediaLive Anywhere uses these IP addresses for Push inputs (in both Bridge and NAT
         * networks) and for output destinations (only in Bridge networks). Each IpPoolUpdateRequest specifies one CIDR
         * block.
         * 
         * @param ipPools
         *        Include this parameter only if you want to change the pool of IP addresses in the network. An array of
         *        IpPoolCreateRequests that identify a collection of IP addresses in this network that you want to
         *        reserve for use in MediaLive Anywhere. MediaLive Anywhere uses these IP addresses for Push inputs (in
         *        both Bridge and NAT networks) and for output destinations (only in Bridge networks). Each
         *        IpPoolUpdateRequest specifies one CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPools(Collection<IpPoolUpdateRequest> ipPools);

        /**
         * Include this parameter only if you want to change the pool of IP addresses in the network. An array of
         * IpPoolCreateRequests that identify a collection of IP addresses in this network that you want to reserve for
         * use in MediaLive Anywhere. MediaLive Anywhere uses these IP addresses for Push inputs (in both Bridge and NAT
         * networks) and for output destinations (only in Bridge networks). Each IpPoolUpdateRequest specifies one CIDR
         * block.
         * 
         * @param ipPools
         *        Include this parameter only if you want to change the pool of IP addresses in the network. An array of
         *        IpPoolCreateRequests that identify a collection of IP addresses in this network that you want to
         *        reserve for use in MediaLive Anywhere. MediaLive Anywhere uses these IP addresses for Push inputs (in
         *        both Bridge and NAT networks) and for output destinations (only in Bridge networks). Each
         *        IpPoolUpdateRequest specifies one CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPools(IpPoolUpdateRequest... ipPools);

        /**
         * Include this parameter only if you want to change the pool of IP addresses in the network. An array of
         * IpPoolCreateRequests that identify a collection of IP addresses in this network that you want to reserve for
         * use in MediaLive Anywhere. MediaLive Anywhere uses these IP addresses for Push inputs (in both Bridge and NAT
         * networks) and for output destinations (only in Bridge networks). Each IpPoolUpdateRequest specifies one CIDR
         * block. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.IpPoolUpdateRequest.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.medialive.model.IpPoolUpdateRequest#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.IpPoolUpdateRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #ipPools(List<IpPoolUpdateRequest>)}.
         * 
         * @param ipPools
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.IpPoolUpdateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipPools(java.util.Collection<IpPoolUpdateRequest>)
         */
        Builder ipPools(Consumer<IpPoolUpdateRequest.Builder>... ipPools);

        /**
         * Include this parameter only if you want to change the name of the Network. Specify a name that is unique in
         * the AWS account. Names are case-sensitive.
         * 
         * @param name
         *        Include this parameter only if you want to change the name of the Network. Specify a name that is
         *        unique in the AWS account. Names are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The ID of the network
         * 
         * @param networkId
         *        The ID of the network
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkId(String networkId);

        /**
         * Include this parameter only if you want to change or add routes in the Network. An array of Routes that
         * MediaLive Anywhere needs to know about in order to route encoding traffic.
         * 
         * @param routes
         *        Include this parameter only if you want to change or add routes in the Network. An array of Routes
         *        that MediaLive Anywhere needs to know about in order to route encoding traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Collection<RouteUpdateRequest> routes);

        /**
         * Include this parameter only if you want to change or add routes in the Network. An array of Routes that
         * MediaLive Anywhere needs to know about in order to route encoding traffic.
         * 
         * @param routes
         *        Include this parameter only if you want to change or add routes in the Network. An array of Routes
         *        that MediaLive Anywhere needs to know about in order to route encoding traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(RouteUpdateRequest... routes);

        /**
         * Include this parameter only if you want to change or add routes in the Network. An array of Routes that
         * MediaLive Anywhere needs to know about in order to route encoding traffic. This is a convenience method that
         * creates an instance of the {@link software.amazon.awssdk.services.medialive.model.RouteUpdateRequest.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.RouteUpdateRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.RouteUpdateRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #routes(List<RouteUpdateRequest>)}.
         * 
         * @param routes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.RouteUpdateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routes(java.util.Collection<RouteUpdateRequest>)
         */
        Builder routes(Consumer<RouteUpdateRequest.Builder>... routes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private List<IpPoolUpdateRequest> ipPools = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String networkId;

        private List<RouteUpdateRequest> routes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNetworkRequest model) {
            super(model);
            ipPools(model.ipPools);
            name(model.name);
            networkId(model.networkId);
            routes(model.routes);
        }

        public final List<IpPoolUpdateRequest.Builder> getIpPools() {
            List<IpPoolUpdateRequest.Builder> result = ___listOfIpPoolUpdateRequestCopier.copyToBuilder(this.ipPools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpPools(Collection<IpPoolUpdateRequest.BuilderImpl> ipPools) {
            this.ipPools = ___listOfIpPoolUpdateRequestCopier.copyFromBuilder(ipPools);
        }

        @Override
        public final Builder ipPools(Collection<IpPoolUpdateRequest> ipPools) {
            this.ipPools = ___listOfIpPoolUpdateRequestCopier.copy(ipPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPools(IpPoolUpdateRequest... ipPools) {
            ipPools(Arrays.asList(ipPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPools(Consumer<IpPoolUpdateRequest.Builder>... ipPools) {
            ipPools(Stream.of(ipPools).map(c -> IpPoolUpdateRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNetworkId() {
            return networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final List<RouteUpdateRequest.Builder> getRoutes() {
            List<RouteUpdateRequest.Builder> result = ___listOfRouteUpdateRequestCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<RouteUpdateRequest.BuilderImpl> routes) {
            this.routes = ___listOfRouteUpdateRequestCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<RouteUpdateRequest> routes) {
            this.routes = ___listOfRouteUpdateRequestCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(RouteUpdateRequest... routes) {
            routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<RouteUpdateRequest.Builder>... routes) {
            routes(Stream.of(routes).map(c -> RouteUpdateRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNetworkRequest build() {
            return new UpdateNetworkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
