/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for UpdateNetworkResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNetworkResponse extends MediaLiveResponse implements
        ToCopyableBuilder<UpdateNetworkResponse.Builder, UpdateNetworkResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateNetworkResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<String>> ASSOCIATED_CLUSTER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssociatedClusterIds")
            .getter(getter(UpdateNetworkResponse::associatedClusterIds))
            .setter(setter(Builder::associatedClusterIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedClusterIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateNetworkResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<List<IpPool>> IP_POOLS_FIELD = SdkField
            .<List<IpPool>> builder(MarshallingType.LIST)
            .memberName("IpPools")
            .getter(getter(UpdateNetworkResponse::ipPools))
            .setter(setter(Builder::ipPools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipPools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpPool> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPool::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateNetworkResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<Route>> ROUTES_FIELD = SdkField
            .<List<Route>> builder(MarshallingType.LIST)
            .memberName("Routes")
            .getter(getter(UpdateNetworkResponse::routes))
            .setter(setter(Builder::routes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Route> builder(MarshallingType.SDK_POJO)
                                            .constructor(Route::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(UpdateNetworkResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            ASSOCIATED_CLUSTER_IDS_FIELD, ID_FIELD, IP_POOLS_FIELD, NAME_FIELD, ROUTES_FIELD, STATE_FIELD));

    private final String arn;

    private final List<String> associatedClusterIds;

    private final String id;

    private final List<IpPool> ipPools;

    private final String name;

    private final List<Route> routes;

    private final String state;

    private UpdateNetworkResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.associatedClusterIds = builder.associatedClusterIds;
        this.id = builder.id;
        this.ipPools = builder.ipPools;
        this.name = builder.name;
        this.routes = builder.routes;
        this.state = builder.state;
    }

    /**
     * The ARN of this Network. It is automatically assigned when the Network is created.
     * 
     * @return The ARN of this Network. It is automatically assigned when the Network is created.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedClusterIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedClusterIds() {
        return associatedClusterIds != null && !(associatedClusterIds instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AssociatedClusterIds property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedClusterIds} method.
     * </p>
     * 
     * @return The value of the AssociatedClusterIds property for this object.
     */
    public final List<String> associatedClusterIds() {
        return associatedClusterIds;
    }

    /**
     * The ID of the Network. Unique in the AWS account. The ID is the resource-id portion of the ARN.
     * 
     * @return The ID of the Network. Unique in the AWS account. The ID is the resource-id portion of the ARN.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpPools property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIpPools() {
        return ipPools != null && !(ipPools instanceof SdkAutoConstructList);
    }

    /**
     * An array of IpPools in your organization's network that identify a collection of IP addresses in this network
     * that are reserved for use in MediaLive Anywhere. MediaLive Anywhere uses these IP addresses for Push inputs (in
     * both Bridge and NAT networks) and for output destinations (only in Bridge networks). Each IpPool specifies one
     * CIDR block.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpPools} method.
     * </p>
     * 
     * @return An array of IpPools in your organization's network that identify a collection of IP addresses in this
     *         network that are reserved for use in MediaLive Anywhere. MediaLive Anywhere uses these IP addresses for
     *         Push inputs (in both Bridge and NAT networks) and for output destinations (only in Bridge networks). Each
     *         IpPool specifies one CIDR block.
     */
    public final List<IpPool> ipPools() {
        return ipPools;
    }

    /**
     * The name that you specified for the Network.
     * 
     * @return The name that you specified for the Network.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Routes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRoutes() {
        return routes != null && !(routes instanceof SdkAutoConstructList);
    }

    /**
     * An array of Routes that MediaLive Anywhere needs to know about in order to route encoding traffic.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutes} method.
     * </p>
     * 
     * @return An array of Routes that MediaLive Anywhere needs to know about in order to route encoding traffic.
     */
    public final List<Route> routes() {
        return routes;
    }

    /**
     * The current state of the Network. Only MediaLive Anywhere can change the state.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link NetworkState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the Network. Only MediaLive Anywhere can change the state.
     * @see NetworkState
     */
    public final NetworkState state() {
        return NetworkState.fromValue(state);
    }

    /**
     * The current state of the Network. Only MediaLive Anywhere can change the state.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link NetworkState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the Network. Only MediaLive Anywhere can change the state.
     * @see NetworkState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedClusterIds() ? associatedClusterIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpPools() ? ipPools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutes() ? routes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNetworkResponse)) {
            return false;
        }
        UpdateNetworkResponse other = (UpdateNetworkResponse) obj;
        return Objects.equals(arn(), other.arn()) && hasAssociatedClusterIds() == other.hasAssociatedClusterIds()
                && Objects.equals(associatedClusterIds(), other.associatedClusterIds()) && Objects.equals(id(), other.id())
                && hasIpPools() == other.hasIpPools() && Objects.equals(ipPools(), other.ipPools())
                && Objects.equals(name(), other.name()) && hasRoutes() == other.hasRoutes()
                && Objects.equals(routes(), other.routes()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateNetworkResponse").add("Arn", arn())
                .add("AssociatedClusterIds", hasAssociatedClusterIds() ? associatedClusterIds() : null).add("Id", id())
                .add("IpPools", hasIpPools() ? ipPools() : null).add("Name", name()).add("Routes", hasRoutes() ? routes() : null)
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AssociatedClusterIds":
            return Optional.ofNullable(clazz.cast(associatedClusterIds()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IpPools":
            return Optional.ofNullable(clazz.cast(ipPools()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Routes":
            return Optional.ofNullable(clazz.cast(routes()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNetworkResponse, T> g) {
        return obj -> g.apply((UpdateNetworkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateNetworkResponse> {
        /**
         * The ARN of this Network. It is automatically assigned when the Network is created.
         * 
         * @param arn
         *        The ARN of this Network. It is automatically assigned when the Network is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Sets the value of the AssociatedClusterIds property for this object.
         *
         * @param associatedClusterIds
         *        The new value for the AssociatedClusterIds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedClusterIds(Collection<String> associatedClusterIds);

        /**
         * Sets the value of the AssociatedClusterIds property for this object.
         *
         * @param associatedClusterIds
         *        The new value for the AssociatedClusterIds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedClusterIds(String... associatedClusterIds);

        /**
         * The ID of the Network. Unique in the AWS account. The ID is the resource-id portion of the ARN.
         * 
         * @param id
         *        The ID of the Network. Unique in the AWS account. The ID is the resource-id portion of the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * An array of IpPools in your organization's network that identify a collection of IP addresses in this network
         * that are reserved for use in MediaLive Anywhere. MediaLive Anywhere uses these IP addresses for Push inputs
         * (in both Bridge and NAT networks) and for output destinations (only in Bridge networks). Each IpPool
         * specifies one CIDR block.
         * 
         * @param ipPools
         *        An array of IpPools in your organization's network that identify a collection of IP addresses in this
         *        network that are reserved for use in MediaLive Anywhere. MediaLive Anywhere uses these IP addresses
         *        for Push inputs (in both Bridge and NAT networks) and for output destinations (only in Bridge
         *        networks). Each IpPool specifies one CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPools(Collection<IpPool> ipPools);

        /**
         * An array of IpPools in your organization's network that identify a collection of IP addresses in this network
         * that are reserved for use in MediaLive Anywhere. MediaLive Anywhere uses these IP addresses for Push inputs
         * (in both Bridge and NAT networks) and for output destinations (only in Bridge networks). Each IpPool
         * specifies one CIDR block.
         * 
         * @param ipPools
         *        An array of IpPools in your organization's network that identify a collection of IP addresses in this
         *        network that are reserved for use in MediaLive Anywhere. MediaLive Anywhere uses these IP addresses
         *        for Push inputs (in both Bridge and NAT networks) and for output destinations (only in Bridge
         *        networks). Each IpPool specifies one CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipPools(IpPool... ipPools);

        /**
         * An array of IpPools in your organization's network that identify a collection of IP addresses in this network
         * that are reserved for use in MediaLive Anywhere. MediaLive Anywhere uses these IP addresses for Push inputs
         * (in both Bridge and NAT networks) and for output destinations (only in Bridge networks). Each IpPool
         * specifies one CIDR block. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.IpPool.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.medialive.model.IpPool#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.IpPool.Builder#build()} is called immediately and its
         * result is passed to {@link #ipPools(List<IpPool>)}.
         * 
         * @param ipPools
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.IpPool.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipPools(java.util.Collection<IpPool>)
         */
        Builder ipPools(Consumer<IpPool.Builder>... ipPools);

        /**
         * The name that you specified for the Network.
         * 
         * @param name
         *        The name that you specified for the Network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * An array of Routes that MediaLive Anywhere needs to know about in order to route encoding traffic.
         * 
         * @param routes
         *        An array of Routes that MediaLive Anywhere needs to know about in order to route encoding traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Collection<Route> routes);

        /**
         * An array of Routes that MediaLive Anywhere needs to know about in order to route encoding traffic.
         * 
         * @param routes
         *        An array of Routes that MediaLive Anywhere needs to know about in order to route encoding traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Route... routes);

        /**
         * An array of Routes that MediaLive Anywhere needs to know about in order to route encoding traffic. This is a
         * convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.Route.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.medialive.model.Route#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.Route.Builder#build()} is called immediately and its
         * result is passed to {@link #routes(List<Route>)}.
         * 
         * @param routes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.Route.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routes(java.util.Collection<Route>)
         */
        Builder routes(Consumer<Route.Builder>... routes);

        /**
         * The current state of the Network. Only MediaLive Anywhere can change the state.
         * 
         * @param state
         *        The current state of the Network. Only MediaLive Anywhere can change the state.
         * @see NetworkState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkState
         */
        Builder state(String state);

        /**
         * The current state of the Network. Only MediaLive Anywhere can change the state.
         * 
         * @param state
         *        The current state of the Network. Only MediaLive Anywhere can change the state.
         * @see NetworkState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkState
         */
        Builder state(NetworkState state);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String arn;

        private List<String> associatedClusterIds = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private List<IpPool> ipPools = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private List<Route> routes = DefaultSdkAutoConstructList.getInstance();

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNetworkResponse model) {
            super(model);
            arn(model.arn);
            associatedClusterIds(model.associatedClusterIds);
            id(model.id);
            ipPools(model.ipPools);
            name(model.name);
            routes(model.routes);
            state(model.state);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAssociatedClusterIds() {
            if (associatedClusterIds instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedClusterIds;
        }

        public final void setAssociatedClusterIds(Collection<String> associatedClusterIds) {
            this.associatedClusterIds = ___listOf__stringCopier.copy(associatedClusterIds);
        }

        @Override
        public final Builder associatedClusterIds(Collection<String> associatedClusterIds) {
            this.associatedClusterIds = ___listOf__stringCopier.copy(associatedClusterIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedClusterIds(String... associatedClusterIds) {
            associatedClusterIds(Arrays.asList(associatedClusterIds));
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<IpPool.Builder> getIpPools() {
            List<IpPool.Builder> result = ___listOfIpPoolCopier.copyToBuilder(this.ipPools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpPools(Collection<IpPool.BuilderImpl> ipPools) {
            this.ipPools = ___listOfIpPoolCopier.copyFromBuilder(ipPools);
        }

        @Override
        public final Builder ipPools(Collection<IpPool> ipPools) {
            this.ipPools = ___listOfIpPoolCopier.copy(ipPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPools(IpPool... ipPools) {
            ipPools(Arrays.asList(ipPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPools(Consumer<IpPool.Builder>... ipPools) {
            ipPools(Stream.of(ipPools).map(c -> IpPool.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Route.Builder> getRoutes() {
            List<Route.Builder> result = ___listOfRouteCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<Route.BuilderImpl> routes) {
            this.routes = ___listOfRouteCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<Route> routes) {
            this.routes = ___listOfRouteCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Route... routes) {
            routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<Route.Builder>... routes) {
            routes(Stream.of(routes).map(c -> Route.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(NetworkState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public UpdateNetworkResponse build() {
            return new UpdateNetworkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
