/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to update the node.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNodeRequest extends MediaLiveRequest implements
        ToCopyableBuilder<UpdateNodeRequest.Builder, UpdateNodeRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(UpdateNodeRequest::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateNodeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(UpdateNodeRequest::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("nodeId").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(UpdateNodeRequest::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, NAME_FIELD,
            NODE_ID_FIELD, ROLE_FIELD));

    private final String clusterId;

    private final String name;

    private final String nodeId;

    private final String role;

    private UpdateNodeRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.name = builder.name;
        this.nodeId = builder.nodeId;
        this.role = builder.role;
    }

    /**
     * The ID of the cluster
     * 
     * @return The ID of the cluster
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * Include this parameter only if you want to change the current name of the Node. Specify a name that is unique in
     * the Cluster. You can't change the name. Names are case-sensitive.
     * 
     * @return Include this parameter only if you want to change the current name of the Node. Specify a name that is
     *         unique in the Cluster. You can't change the name. Names are case-sensitive.
     */
    public final String name() {
        return name;
    }

    /**
     * The ID of the node.
     * 
     * @return The ID of the node.
     */
    public final String nodeId() {
        return nodeId;
    }

    /**
     * The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP means the
     * Node is a redundant Node and might get used if an ACTIVE Node fails.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link NodeRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP
     *         means the Node is a redundant Node and might get used if an ACTIVE Node fails.
     * @see NodeRole
     */
    public final NodeRole role() {
        return NodeRole.fromValue(role);
    }

    /**
     * The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP means the
     * Node is a redundant Node and might get used if an ACTIVE Node fails.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link NodeRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP
     *         means the Node is a redundant Node and might get used if an ACTIVE Node fails.
     * @see NodeRole
     */
    public final String roleAsString() {
        return role;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNodeRequest)) {
            return false;
        }
        UpdateNodeRequest other = (UpdateNodeRequest) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(name(), other.name())
                && Objects.equals(nodeId(), other.nodeId()) && Objects.equals(roleAsString(), other.roleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateNodeRequest").add("ClusterId", clusterId()).add("Name", name()).add("NodeId", nodeId())
                .add("Role", roleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNodeRequest, T> g) {
        return obj -> g.apply((UpdateNodeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateNodeRequest> {
        /**
         * The ID of the cluster
         * 
         * @param clusterId
         *        The ID of the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * Include this parameter only if you want to change the current name of the Node. Specify a name that is unique
         * in the Cluster. You can't change the name. Names are case-sensitive.
         * 
         * @param name
         *        Include this parameter only if you want to change the current name of the Node. Specify a name that is
         *        unique in the Cluster. You can't change the name. Names are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The ID of the node.
         * 
         * @param nodeId
         *        The ID of the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP means
         * the Node is a redundant Node and might get used if an ACTIVE Node fails.
         * 
         * @param role
         *        The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP
         *        means the Node is a redundant Node and might get used if an ACTIVE Node fails.
         * @see NodeRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeRole
         */
        Builder role(String role);

        /**
         * The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP means
         * the Node is a redundant Node and might get used if an ACTIVE Node fails.
         * 
         * @param role
         *        The initial role of the Node in the Cluster. ACTIVE means the Node is available for encoding. BACKUP
         *        means the Node is a redundant Node and might get used if an ACTIVE Node fails.
         * @see NodeRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeRole
         */
        Builder role(NodeRole role);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String clusterId;

        private String name;

        private String nodeId;

        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNodeRequest model) {
            super(model);
            clusterId(model.clusterId);
            name(model.name);
            nodeId(model.nodeId);
            role(model.role);
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(NodeRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNodeRequest build() {
            return new UpdateNodeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
