/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfInterfaceMappingCopier {
    static List<InterfaceMapping> copy(Collection<? extends InterfaceMapping> __listOfInterfaceMappingParam) {
        List<InterfaceMapping> list;
        if (__listOfInterfaceMappingParam == null || __listOfInterfaceMappingParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InterfaceMapping> modifiableList = new ArrayList<>(__listOfInterfaceMappingParam.size());
            __listOfInterfaceMappingParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<InterfaceMapping> copyFromBuilder(Collection<? extends InterfaceMapping.Builder> __listOfInterfaceMappingParam) {
        List<InterfaceMapping> list;
        if (__listOfInterfaceMappingParam == null || __listOfInterfaceMappingParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InterfaceMapping> modifiableList = new ArrayList<>(__listOfInterfaceMappingParam.size());
            __listOfInterfaceMappingParam.forEach(entry -> {
                InterfaceMapping member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<InterfaceMapping.Builder> copyToBuilder(Collection<? extends InterfaceMapping> __listOfInterfaceMappingParam) {
        List<InterfaceMapping.Builder> list;
        if (__listOfInterfaceMappingParam == null || __listOfInterfaceMappingParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InterfaceMapping.Builder> modifiableList = new ArrayList<>(__listOfInterfaceMappingParam.size());
            __listOfInterfaceMappingParam.forEach(entry -> {
                InterfaceMapping.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
