/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransferInputDeviceRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, TransferInputDeviceRequest> {
    private static final SdkField<String> INPUT_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputDeviceId").getter(TransferInputDeviceRequest.getter(TransferInputDeviceRequest::inputDeviceId)).setter(TransferInputDeviceRequest.setter(Builder::inputDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputDeviceId").build()}).build();
    private static final SdkField<String> TARGET_CUSTOMER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetCustomerId").getter(TransferInputDeviceRequest.getter(TransferInputDeviceRequest::targetCustomerId)).setter(TransferInputDeviceRequest.setter(Builder::targetCustomerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetCustomerId").build()}).build();
    private static final SdkField<String> TARGET_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetRegion").getter(TransferInputDeviceRequest.getter(TransferInputDeviceRequest::targetRegion)).setter(TransferInputDeviceRequest.setter(Builder::targetRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRegion").build()}).build();
    private static final SdkField<String> TRANSFER_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransferMessage").getter(TransferInputDeviceRequest.getter(TransferInputDeviceRequest::transferMessage)).setter(TransferInputDeviceRequest.setter(Builder::transferMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_DEVICE_ID_FIELD, TARGET_CUSTOMER_ID_FIELD, TARGET_REGION_FIELD, TRANSFER_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("inputDeviceId", INPUT_DEVICE_ID_FIELD);
            this.put("targetCustomerId", TARGET_CUSTOMER_ID_FIELD);
            this.put("targetRegion", TARGET_REGION_FIELD);
            this.put("transferMessage", TRANSFER_MESSAGE_FIELD);
        }
    });
    private final String inputDeviceId;
    private final String targetCustomerId;
    private final String targetRegion;
    private final String transferMessage;

    private TransferInputDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.inputDeviceId = builder.inputDeviceId;
        this.targetCustomerId = builder.targetCustomerId;
        this.targetRegion = builder.targetRegion;
        this.transferMessage = builder.transferMessage;
    }

    public final String inputDeviceId() {
        return this.inputDeviceId;
    }

    public final String targetCustomerId() {
        return this.targetCustomerId;
    }

    public final String targetRegion() {
        return this.targetRegion;
    }

    public final String transferMessage() {
        return this.transferMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCustomerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferInputDeviceRequest)) {
            return false;
        }
        TransferInputDeviceRequest other = (TransferInputDeviceRequest)((Object)obj);
        return Objects.equals(this.inputDeviceId(), other.inputDeviceId()) && Objects.equals(this.targetCustomerId(), other.targetCustomerId()) && Objects.equals(this.targetRegion(), other.targetRegion()) && Objects.equals(this.transferMessage(), other.transferMessage());
    }

    public final String toString() {
        return ToString.builder((String)"TransferInputDeviceRequest").add("InputDeviceId", (Object)this.inputDeviceId()).add("TargetCustomerId", (Object)this.targetCustomerId()).add("TargetRegion", (Object)this.targetRegion()).add("TransferMessage", (Object)this.transferMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputDeviceId": {
                return Optional.ofNullable(clazz.cast(this.inputDeviceId()));
            }
            case "TargetCustomerId": {
                return Optional.ofNullable(clazz.cast(this.targetCustomerId()));
            }
            case "TargetRegion": {
                return Optional.ofNullable(clazz.cast(this.targetRegion()));
            }
            case "TransferMessage": {
                return Optional.ofNullable(clazz.cast(this.transferMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TransferInputDeviceRequest, T> g) {
        return obj -> g.apply((TransferInputDeviceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String inputDeviceId;
        private String targetCustomerId;
        private String targetRegion;
        private String transferMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(TransferInputDeviceRequest model) {
            super(model);
            this.inputDeviceId(model.inputDeviceId);
            this.targetCustomerId(model.targetCustomerId);
            this.targetRegion(model.targetRegion);
            this.transferMessage(model.transferMessage);
        }

        public final String getInputDeviceId() {
            return this.inputDeviceId;
        }

        public final void setInputDeviceId(String inputDeviceId) {
            this.inputDeviceId = inputDeviceId;
        }

        @Override
        public final Builder inputDeviceId(String inputDeviceId) {
            this.inputDeviceId = inputDeviceId;
            return this;
        }

        public final String getTargetCustomerId() {
            return this.targetCustomerId;
        }

        public final void setTargetCustomerId(String targetCustomerId) {
            this.targetCustomerId = targetCustomerId;
        }

        @Override
        public final Builder targetCustomerId(String targetCustomerId) {
            this.targetCustomerId = targetCustomerId;
            return this;
        }

        public final String getTargetRegion() {
            return this.targetRegion;
        }

        public final void setTargetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
        }

        @Override
        public final Builder targetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
            return this;
        }

        public final String getTransferMessage() {
            return this.transferMessage;
        }

        public final void setTransferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
        }

        @Override
        public final Builder transferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TransferInputDeviceRequest build() {
            return new TransferInputDeviceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TransferInputDeviceRequest> {
        public Builder inputDeviceId(String var1);

        public Builder targetCustomerId(String var1);

        public Builder targetRegion(String var1);

        public Builder transferMessage(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

