/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse;
import software.amazon.awssdk.services.medialive.model.MultiplexSummary;

public class ListMultiplexesPublisher
implements SdkPublisher<ListMultiplexesResponse> {
    private final MediaLiveAsyncClient client;
    private final ListMultiplexesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMultiplexesPublisher(MediaLiveAsyncClient client, ListMultiplexesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMultiplexesPublisher(MediaLiveAsyncClient client, ListMultiplexesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMultiplexesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMultiplexesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MultiplexSummary> multiplexes() {
        Function<ListMultiplexesResponse, Iterator> getIterator = response -> {
            if (response != null && response.multiplexes() != null) {
                return response.multiplexes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMultiplexesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMultiplexesResponseFetcher
    implements AsyncPageFetcher<ListMultiplexesResponse> {
        private ListMultiplexesResponseFetcher() {
        }

        public boolean hasNextPage(ListMultiplexesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMultiplexesResponse> nextPage(ListMultiplexesResponse previousPage) {
            if (previousPage == null) {
                return ListMultiplexesPublisher.this.client.listMultiplexes(ListMultiplexesPublisher.this.firstRequest);
            }
            return ListMultiplexesPublisher.this.client.listMultiplexes((ListMultiplexesRequest)((Object)ListMultiplexesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

