/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for DescribeInputDeviceThumbnailRequest
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInputDeviceThumbnailRequest extends MediaLiveRequest implements
        ToCopyableBuilder<DescribeInputDeviceThumbnailRequest.Builder, DescribeInputDeviceThumbnailRequest> {
    private static final SdkField<String> INPUT_DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputDeviceId").getter(getter(DescribeInputDeviceThumbnailRequest::inputDeviceId))
            .setter(setter(Builder::inputDeviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputDeviceId").build()).build();

    private static final SdkField<String> ACCEPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Accept")
            .getter(getter(DescribeInputDeviceThumbnailRequest::acceptAsString)).setter(setter(Builder::accept))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("accept").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_DEVICE_ID_FIELD,
            ACCEPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String inputDeviceId;

    private final String accept;

    private DescribeInputDeviceThumbnailRequest(BuilderImpl builder) {
        super(builder);
        this.inputDeviceId = builder.inputDeviceId;
        this.accept = builder.accept;
    }

    /**
     * The unique ID of this input device. For example, hd-123456789abcdef.
     * 
     * @return The unique ID of this input device. For example, hd-123456789abcdef.
     */
    public final String inputDeviceId() {
        return inputDeviceId;
    }

    /**
     * The HTTP Accept header. Indicates the requested type for the thumbnail.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accept} will
     * return {@link AcceptHeader#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #acceptAsString}.
     * </p>
     * 
     * @return The HTTP Accept header. Indicates the requested type for the thumbnail.
     * @see AcceptHeader
     */
    public final AcceptHeader accept() {
        return AcceptHeader.fromValue(accept);
    }

    /**
     * The HTTP Accept header. Indicates the requested type for the thumbnail.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accept} will
     * return {@link AcceptHeader#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #acceptAsString}.
     * </p>
     * 
     * @return The HTTP Accept header. Indicates the requested type for the thumbnail.
     * @see AcceptHeader
     */
    public final String acceptAsString() {
        return accept;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inputDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(acceptAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInputDeviceThumbnailRequest)) {
            return false;
        }
        DescribeInputDeviceThumbnailRequest other = (DescribeInputDeviceThumbnailRequest) obj;
        return Objects.equals(inputDeviceId(), other.inputDeviceId()) && Objects.equals(acceptAsString(), other.acceptAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInputDeviceThumbnailRequest").add("InputDeviceId", inputDeviceId())
                .add("Accept", acceptAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputDeviceId":
            return Optional.ofNullable(clazz.cast(inputDeviceId()));
        case "Accept":
            return Optional.ofNullable(clazz.cast(acceptAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputDeviceId", INPUT_DEVICE_ID_FIELD);
        map.put("accept", ACCEPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInputDeviceThumbnailRequest, T> g) {
        return obj -> g.apply((DescribeInputDeviceThumbnailRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInputDeviceThumbnailRequest> {
        /**
         * The unique ID of this input device. For example, hd-123456789abcdef.
         * 
         * @param inputDeviceId
         *        The unique ID of this input device. For example, hd-123456789abcdef.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDeviceId(String inputDeviceId);

        /**
         * The HTTP Accept header. Indicates the requested type for the thumbnail.
         * 
         * @param accept
         *        The HTTP Accept header. Indicates the requested type for the thumbnail.
         * @see AcceptHeader
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptHeader
         */
        Builder accept(String accept);

        /**
         * The HTTP Accept header. Indicates the requested type for the thumbnail.
         * 
         * @param accept
         *        The HTTP Accept header. Indicates the requested type for the thumbnail.
         * @see AcceptHeader
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptHeader
         */
        Builder accept(AcceptHeader accept);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String inputDeviceId;

        private String accept;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInputDeviceThumbnailRequest model) {
            super(model);
            inputDeviceId(model.inputDeviceId);
            accept(model.accept);
        }

        public final String getInputDeviceId() {
            return inputDeviceId;
        }

        public final void setInputDeviceId(String inputDeviceId) {
            this.inputDeviceId = inputDeviceId;
        }

        @Override
        public final Builder inputDeviceId(String inputDeviceId) {
            this.inputDeviceId = inputDeviceId;
            return this;
        }

        public final String getAccept() {
            return accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        @Override
        public final Builder accept(AcceptHeader accept) {
            this.accept(accept == null ? null : accept.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInputDeviceThumbnailRequest build() {
            return new DescribeInputDeviceThumbnailRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
