/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Feature Activations
 */
@Generated("software.amazon.awssdk:codegen")
public final class FeatureActivations implements SdkPojo, Serializable,
        ToCopyableBuilder<FeatureActivations.Builder, FeatureActivations> {
    private static final SdkField<String> INPUT_PREPARE_SCHEDULE_ACTIONS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InputPrepareScheduleActions")
            .getter(getter(FeatureActivations::inputPrepareScheduleActionsAsString))
            .setter(setter(Builder::inputPrepareScheduleActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputPrepareScheduleActions")
                    .build()).build();

    private static final SdkField<String> OUTPUT_STATIC_IMAGE_OVERLAY_SCHEDULE_ACTIONS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutputStaticImageOverlayScheduleActions")
            .getter(getter(FeatureActivations::outputStaticImageOverlayScheduleActionsAsString))
            .setter(setter(Builder::outputStaticImageOverlayScheduleActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("outputStaticImageOverlayScheduleActions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INPUT_PREPARE_SCHEDULE_ACTIONS_FIELD, OUTPUT_STATIC_IMAGE_OVERLAY_SCHEDULE_ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inputPrepareScheduleActions;

    private final String outputStaticImageOverlayScheduleActions;

    private FeatureActivations(BuilderImpl builder) {
        this.inputPrepareScheduleActions = builder.inputPrepareScheduleActions;
        this.outputStaticImageOverlayScheduleActions = builder.outputStaticImageOverlayScheduleActions;
    }

    /**
     * Enables the Input Prepare feature. You can create Input Prepare actions in the schedule only if this feature is
     * enabled. If you disable the feature on an existing schedule, make sure that you first delete all input prepare
     * actions from the schedule.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inputPrepareScheduleActions} will return
     * {@link FeatureActivationsInputPrepareScheduleActions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #inputPrepareScheduleActionsAsString}.
     * </p>
     * 
     * @return Enables the Input Prepare feature. You can create Input Prepare actions in the schedule only if this
     *         feature is enabled. If you disable the feature on an existing schedule, make sure that you first delete
     *         all input prepare actions from the schedule.
     * @see FeatureActivationsInputPrepareScheduleActions
     */
    public final FeatureActivationsInputPrepareScheduleActions inputPrepareScheduleActions() {
        return FeatureActivationsInputPrepareScheduleActions.fromValue(inputPrepareScheduleActions);
    }

    /**
     * Enables the Input Prepare feature. You can create Input Prepare actions in the schedule only if this feature is
     * enabled. If you disable the feature on an existing schedule, make sure that you first delete all input prepare
     * actions from the schedule.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inputPrepareScheduleActions} will return
     * {@link FeatureActivationsInputPrepareScheduleActions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #inputPrepareScheduleActionsAsString}.
     * </p>
     * 
     * @return Enables the Input Prepare feature. You can create Input Prepare actions in the schedule only if this
     *         feature is enabled. If you disable the feature on an existing schedule, make sure that you first delete
     *         all input prepare actions from the schedule.
     * @see FeatureActivationsInputPrepareScheduleActions
     */
    public final String inputPrepareScheduleActionsAsString() {
        return inputPrepareScheduleActions;
    }

    /**
     * Enables the output static image overlay feature. Enabling this feature allows you to send channel schedule
     * updates to display/clear/modify image overlays on an output-by-output bases.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outputStaticImageOverlayScheduleActions} will return
     * {@link FeatureActivationsOutputStaticImageOverlayScheduleActions#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #outputStaticImageOverlayScheduleActionsAsString}.
     * </p>
     * 
     * @return Enables the output static image overlay feature. Enabling this feature allows you to send channel
     *         schedule updates to display/clear/modify image overlays on an output-by-output bases.
     * @see FeatureActivationsOutputStaticImageOverlayScheduleActions
     */
    public final FeatureActivationsOutputStaticImageOverlayScheduleActions outputStaticImageOverlayScheduleActions() {
        return FeatureActivationsOutputStaticImageOverlayScheduleActions.fromValue(outputStaticImageOverlayScheduleActions);
    }

    /**
     * Enables the output static image overlay feature. Enabling this feature allows you to send channel schedule
     * updates to display/clear/modify image overlays on an output-by-output bases.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outputStaticImageOverlayScheduleActions} will return
     * {@link FeatureActivationsOutputStaticImageOverlayScheduleActions#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #outputStaticImageOverlayScheduleActionsAsString}.
     * </p>
     * 
     * @return Enables the output static image overlay feature. Enabling this feature allows you to send channel
     *         schedule updates to display/clear/modify image overlays on an output-by-output bases.
     * @see FeatureActivationsOutputStaticImageOverlayScheduleActions
     */
    public final String outputStaticImageOverlayScheduleActionsAsString() {
        return outputStaticImageOverlayScheduleActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputPrepareScheduleActionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputStaticImageOverlayScheduleActionsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeatureActivations)) {
            return false;
        }
        FeatureActivations other = (FeatureActivations) obj;
        return Objects.equals(inputPrepareScheduleActionsAsString(), other.inputPrepareScheduleActionsAsString())
                && Objects.equals(outputStaticImageOverlayScheduleActionsAsString(),
                        other.outputStaticImageOverlayScheduleActionsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FeatureActivations").add("InputPrepareScheduleActions", inputPrepareScheduleActionsAsString())
                .add("OutputStaticImageOverlayScheduleActions", outputStaticImageOverlayScheduleActionsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputPrepareScheduleActions":
            return Optional.ofNullable(clazz.cast(inputPrepareScheduleActionsAsString()));
        case "OutputStaticImageOverlayScheduleActions":
            return Optional.ofNullable(clazz.cast(outputStaticImageOverlayScheduleActionsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputPrepareScheduleActions", INPUT_PREPARE_SCHEDULE_ACTIONS_FIELD);
        map.put("outputStaticImageOverlayScheduleActions", OUTPUT_STATIC_IMAGE_OVERLAY_SCHEDULE_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FeatureActivations, T> g) {
        return obj -> g.apply((FeatureActivations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FeatureActivations> {
        /**
         * Enables the Input Prepare feature. You can create Input Prepare actions in the schedule only if this feature
         * is enabled. If you disable the feature on an existing schedule, make sure that you first delete all input
         * prepare actions from the schedule.
         * 
         * @param inputPrepareScheduleActions
         *        Enables the Input Prepare feature. You can create Input Prepare actions in the schedule only if this
         *        feature is enabled. If you disable the feature on an existing schedule, make sure that you first
         *        delete all input prepare actions from the schedule.
         * @see FeatureActivationsInputPrepareScheduleActions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureActivationsInputPrepareScheduleActions
         */
        Builder inputPrepareScheduleActions(String inputPrepareScheduleActions);

        /**
         * Enables the Input Prepare feature. You can create Input Prepare actions in the schedule only if this feature
         * is enabled. If you disable the feature on an existing schedule, make sure that you first delete all input
         * prepare actions from the schedule.
         * 
         * @param inputPrepareScheduleActions
         *        Enables the Input Prepare feature. You can create Input Prepare actions in the schedule only if this
         *        feature is enabled. If you disable the feature on an existing schedule, make sure that you first
         *        delete all input prepare actions from the schedule.
         * @see FeatureActivationsInputPrepareScheduleActions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureActivationsInputPrepareScheduleActions
         */
        Builder inputPrepareScheduleActions(FeatureActivationsInputPrepareScheduleActions inputPrepareScheduleActions);

        /**
         * Enables the output static image overlay feature. Enabling this feature allows you to send channel schedule
         * updates to display/clear/modify image overlays on an output-by-output bases.
         * 
         * @param outputStaticImageOverlayScheduleActions
         *        Enables the output static image overlay feature. Enabling this feature allows you to send channel
         *        schedule updates to display/clear/modify image overlays on an output-by-output bases.
         * @see FeatureActivationsOutputStaticImageOverlayScheduleActions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureActivationsOutputStaticImageOverlayScheduleActions
         */
        Builder outputStaticImageOverlayScheduleActions(String outputStaticImageOverlayScheduleActions);

        /**
         * Enables the output static image overlay feature. Enabling this feature allows you to send channel schedule
         * updates to display/clear/modify image overlays on an output-by-output bases.
         * 
         * @param outputStaticImageOverlayScheduleActions
         *        Enables the output static image overlay feature. Enabling this feature allows you to send channel
         *        schedule updates to display/clear/modify image overlays on an output-by-output bases.
         * @see FeatureActivationsOutputStaticImageOverlayScheduleActions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureActivationsOutputStaticImageOverlayScheduleActions
         */
        Builder outputStaticImageOverlayScheduleActions(
                FeatureActivationsOutputStaticImageOverlayScheduleActions outputStaticImageOverlayScheduleActions);
    }

    static final class BuilderImpl implements Builder {
        private String inputPrepareScheduleActions;

        private String outputStaticImageOverlayScheduleActions;

        private BuilderImpl() {
        }

        private BuilderImpl(FeatureActivations model) {
            inputPrepareScheduleActions(model.inputPrepareScheduleActions);
            outputStaticImageOverlayScheduleActions(model.outputStaticImageOverlayScheduleActions);
        }

        public final String getInputPrepareScheduleActions() {
            return inputPrepareScheduleActions;
        }

        public final void setInputPrepareScheduleActions(String inputPrepareScheduleActions) {
            this.inputPrepareScheduleActions = inputPrepareScheduleActions;
        }

        @Override
        public final Builder inputPrepareScheduleActions(String inputPrepareScheduleActions) {
            this.inputPrepareScheduleActions = inputPrepareScheduleActions;
            return this;
        }

        @Override
        public final Builder inputPrepareScheduleActions(FeatureActivationsInputPrepareScheduleActions inputPrepareScheduleActions) {
            this.inputPrepareScheduleActions(inputPrepareScheduleActions == null ? null : inputPrepareScheduleActions.toString());
            return this;
        }

        public final String getOutputStaticImageOverlayScheduleActions() {
            return outputStaticImageOverlayScheduleActions;
        }

        public final void setOutputStaticImageOverlayScheduleActions(String outputStaticImageOverlayScheduleActions) {
            this.outputStaticImageOverlayScheduleActions = outputStaticImageOverlayScheduleActions;
        }

        @Override
        public final Builder outputStaticImageOverlayScheduleActions(String outputStaticImageOverlayScheduleActions) {
            this.outputStaticImageOverlayScheduleActions = outputStaticImageOverlayScheduleActions;
            return this;
        }

        @Override
        public final Builder outputStaticImageOverlayScheduleActions(
                FeatureActivationsOutputStaticImageOverlayScheduleActions outputStaticImageOverlayScheduleActions) {
            this.outputStaticImageOverlayScheduleActions(outputStaticImageOverlayScheduleActions == null ? null
                    : outputStaticImageOverlayScheduleActions.toString());
            return this;
        }

        @Override
        public FeatureActivations build() {
            return new FeatureActivations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
