/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * H265 Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class H265Settings implements SdkPojo, Serializable, ToCopyableBuilder<H265Settings.Builder, H265Settings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdaptiveQuantization").getter(getter(H265Settings::adaptiveQuantizationAsString))
            .setter(setter(Builder::adaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build())
            .build();

    private static final SdkField<String> AFD_SIGNALING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AfdSignaling").getter(getter(H265Settings::afdSignalingAsString)).setter(setter(Builder::afdSignaling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afdSignaling").build()).build();

    private static final SdkField<String> ALTERNATIVE_TRANSFER_FUNCTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AlternativeTransferFunction")
            .getter(getter(H265Settings::alternativeTransferFunctionAsString))
            .setter(setter(Builder::alternativeTransferFunction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alternativeTransferFunction")
                    .build()).build();

    private static final SdkField<Integer> BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Bitrate").getter(getter(H265Settings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<Integer> BUF_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BufSize").getter(getter(H265Settings::bufSize)).setter(setter(Builder::bufSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bufSize").build()).build();

    private static final SdkField<String> COLOR_METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColorMetadata").getter(getter(H265Settings::colorMetadataAsString))
            .setter(setter(Builder::colorMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorMetadata").build()).build();

    private static final SdkField<H265ColorSpaceSettings> COLOR_SPACE_SETTINGS_FIELD = SdkField
            .<H265ColorSpaceSettings> builder(MarshallingType.SDK_POJO).memberName("ColorSpaceSettings")
            .getter(getter(H265Settings::colorSpaceSettings)).setter(setter(Builder::colorSpaceSettings))
            .constructor(H265ColorSpaceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpaceSettings").build())
            .build();

    private static final SdkField<H265FilterSettings> FILTER_SETTINGS_FIELD = SdkField
            .<H265FilterSettings> builder(MarshallingType.SDK_POJO).memberName("FilterSettings")
            .getter(getter(H265Settings::filterSettings)).setter(setter(Builder::filterSettings))
            .constructor(H265FilterSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterSettings").build()).build();

    private static final SdkField<String> FIXED_AFD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FixedAfd").getter(getter(H265Settings::fixedAfdAsString)).setter(setter(Builder::fixedAfd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedAfd").build()).build();

    private static final SdkField<String> FLICKER_AQ_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlickerAq").getter(getter(H265Settings::flickerAqAsString)).setter(setter(Builder::flickerAq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flickerAq").build()).build();

    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateDenominator").getter(getter(H265Settings::framerateDenominator))
            .setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateNumerator").getter(getter(H265Settings::framerateNumerator))
            .setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GopClosedCadence").getter(getter(H265Settings::gopClosedCadence))
            .setter(setter(Builder::gopClosedCadence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()).build();

    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("GopSize").getter(getter(H265Settings::gopSize)).setter(setter(Builder::gopSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()).build();

    private static final SdkField<String> GOP_SIZE_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GopSizeUnits").getter(getter(H265Settings::gopSizeUnitsAsString)).setter(setter(Builder::gopSizeUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSizeUnits").build()).build();

    private static final SdkField<String> LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Level")
            .getter(getter(H265Settings::levelAsString)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()).build();

    private static final SdkField<String> LOOK_AHEAD_RATE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LookAheadRateControl").getter(getter(H265Settings::lookAheadRateControlAsString))
            .setter(setter(Builder::lookAheadRateControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookAheadRateControl").build())
            .build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxBitrate").getter(getter(H265Settings::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<Integer> MIN_I_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinIInterval").getter(getter(H265Settings::minIInterval)).setter(setter(Builder::minIInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minIInterval").build()).build();

    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParDenominator").getter(getter(H265Settings::parDenominator)).setter(setter(Builder::parDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()).build();

    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParNumerator").getter(getter(H265Settings::parNumerator)).setter(setter(Builder::parNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()).build();

    private static final SdkField<String> PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Profile")
            .getter(getter(H265Settings::profileAsString)).setter(setter(Builder::profile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()).build();

    private static final SdkField<Integer> QVBR_QUALITY_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("QvbrQualityLevel").getter(getter(H265Settings::qvbrQualityLevel))
            .setter(setter(Builder::qvbrQualityLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrQualityLevel").build()).build();

    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RateControlMode").getter(getter(H265Settings::rateControlModeAsString))
            .setter(setter(Builder::rateControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()).build();

    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanType").getter(getter(H265Settings::scanTypeAsString)).setter(setter(Builder::scanType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()).build();

    private static final SdkField<String> SCENE_CHANGE_DETECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SceneChangeDetect").getter(getter(H265Settings::sceneChangeDetectAsString))
            .setter(setter(Builder::sceneChangeDetect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneChangeDetect").build()).build();

    private static final SdkField<Integer> SLICES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Slices").getter(getter(H265Settings::slices)).setter(setter(Builder::slices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slices").build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tier")
            .getter(getter(H265Settings::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()).build();

    private static final SdkField<String> TIMECODE_INSERTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimecodeInsertion").getter(getter(H265Settings::timecodeInsertionAsString))
            .setter(setter(Builder::timecodeInsertion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeInsertion").build()).build();

    private static final SdkField<TimecodeBurninSettings> TIMECODE_BURNIN_SETTINGS_FIELD = SdkField
            .<TimecodeBurninSettings> builder(MarshallingType.SDK_POJO).memberName("TimecodeBurninSettings")
            .getter(getter(H265Settings::timecodeBurninSettings)).setter(setter(Builder::timecodeBurninSettings))
            .constructor(TimecodeBurninSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeBurninSettings").build())
            .build();

    private static final SdkField<String> MV_OVER_PICTURE_BOUNDARIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MvOverPictureBoundaries").getter(getter(H265Settings::mvOverPictureBoundariesAsString))
            .setter(setter(Builder::mvOverPictureBoundaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mvOverPictureBoundaries").build())
            .build();

    private static final SdkField<String> MV_TEMPORAL_PREDICTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MvTemporalPredictor").getter(getter(H265Settings::mvTemporalPredictorAsString))
            .setter(setter(Builder::mvTemporalPredictor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mvTemporalPredictor").build())
            .build();

    private static final SdkField<Integer> TILE_HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TileHeight").getter(getter(H265Settings::tileHeight)).setter(setter(Builder::tileHeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tileHeight").build()).build();

    private static final SdkField<String> TILE_PADDING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TilePadding").getter(getter(H265Settings::tilePaddingAsString)).setter(setter(Builder::tilePadding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tilePadding").build()).build();

    private static final SdkField<Integer> TILE_WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TileWidth").getter(getter(H265Settings::tileWidth)).setter(setter(Builder::tileWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tileWidth").build()).build();

    private static final SdkField<String> TREEBLOCK_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TreeblockSize").getter(getter(H265Settings::treeblockSizeAsString))
            .setter(setter(Builder::treeblockSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treeblockSize").build()).build();

    private static final SdkField<Integer> MIN_QP_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("MinQp")
            .getter(getter(H265Settings::minQp)).setter(setter(Builder::minQp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minQp").build()).build();

    private static final SdkField<String> DEBLOCKING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Deblocking").getter(getter(H265Settings::deblockingAsString)).setter(setter(Builder::deblocking))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deblocking").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD,
            AFD_SIGNALING_FIELD, ALTERNATIVE_TRANSFER_FUNCTION_FIELD, BITRATE_FIELD, BUF_SIZE_FIELD, COLOR_METADATA_FIELD,
            COLOR_SPACE_SETTINGS_FIELD, FILTER_SETTINGS_FIELD, FIXED_AFD_FIELD, FLICKER_AQ_FIELD, FRAMERATE_DENOMINATOR_FIELD,
            FRAMERATE_NUMERATOR_FIELD, GOP_CLOSED_CADENCE_FIELD, GOP_SIZE_FIELD, GOP_SIZE_UNITS_FIELD, LEVEL_FIELD,
            LOOK_AHEAD_RATE_CONTROL_FIELD, MAX_BITRATE_FIELD, MIN_I_INTERVAL_FIELD, PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD,
            PROFILE_FIELD, QVBR_QUALITY_LEVEL_FIELD, RATE_CONTROL_MODE_FIELD, SCAN_TYPE_FIELD, SCENE_CHANGE_DETECT_FIELD,
            SLICES_FIELD, TIER_FIELD, TIMECODE_INSERTION_FIELD, TIMECODE_BURNIN_SETTINGS_FIELD, MV_OVER_PICTURE_BOUNDARIES_FIELD,
            MV_TEMPORAL_PREDICTOR_FIELD, TILE_HEIGHT_FIELD, TILE_PADDING_FIELD, TILE_WIDTH_FIELD, TREEBLOCK_SIZE_FIELD,
            MIN_QP_FIELD, DEBLOCKING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String adaptiveQuantization;

    private final String afdSignaling;

    private final String alternativeTransferFunction;

    private final Integer bitrate;

    private final Integer bufSize;

    private final String colorMetadata;

    private final H265ColorSpaceSettings colorSpaceSettings;

    private final H265FilterSettings filterSettings;

    private final String fixedAfd;

    private final String flickerAq;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private final Integer gopClosedCadence;

    private final Double gopSize;

    private final String gopSizeUnits;

    private final String level;

    private final String lookAheadRateControl;

    private final Integer maxBitrate;

    private final Integer minIInterval;

    private final Integer parDenominator;

    private final Integer parNumerator;

    private final String profile;

    private final Integer qvbrQualityLevel;

    private final String rateControlMode;

    private final String scanType;

    private final String sceneChangeDetect;

    private final Integer slices;

    private final String tier;

    private final String timecodeInsertion;

    private final TimecodeBurninSettings timecodeBurninSettings;

    private final String mvOverPictureBoundaries;

    private final String mvTemporalPredictor;

    private final Integer tileHeight;

    private final String tilePadding;

    private final Integer tileWidth;

    private final String treeblockSize;

    private final Integer minQp;

    private final String deblocking;

    private H265Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.afdSignaling = builder.afdSignaling;
        this.alternativeTransferFunction = builder.alternativeTransferFunction;
        this.bitrate = builder.bitrate;
        this.bufSize = builder.bufSize;
        this.colorMetadata = builder.colorMetadata;
        this.colorSpaceSettings = builder.colorSpaceSettings;
        this.filterSettings = builder.filterSettings;
        this.fixedAfd = builder.fixedAfd;
        this.flickerAq = builder.flickerAq;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.level = builder.level;
        this.lookAheadRateControl = builder.lookAheadRateControl;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.profile = builder.profile;
        this.qvbrQualityLevel = builder.qvbrQualityLevel;
        this.rateControlMode = builder.rateControlMode;
        this.scanType = builder.scanType;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.slices = builder.slices;
        this.tier = builder.tier;
        this.timecodeInsertion = builder.timecodeInsertion;
        this.timecodeBurninSettings = builder.timecodeBurninSettings;
        this.mvOverPictureBoundaries = builder.mvOverPictureBoundaries;
        this.mvTemporalPredictor = builder.mvTemporalPredictor;
        this.tileHeight = builder.tileHeight;
        this.tilePadding = builder.tilePadding;
        this.tileWidth = builder.tileWidth;
        this.treeblockSize = builder.treeblockSize;
        this.minQp = builder.minQp;
        this.deblocking = builder.deblocking;
    }

    /**
     * Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link H265AdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
     * @see H265AdaptiveQuantization
     */
    public final H265AdaptiveQuantization adaptiveQuantization() {
        return H265AdaptiveQuantization.fromValue(adaptiveQuantization);
    }

    /**
     * Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link H265AdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
     * @see H265AdaptiveQuantization
     */
    public final String adaptiveQuantizationAsString() {
        return adaptiveQuantization;
    }

    /**
     * Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system will try
     * to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the AFD value
     * will be the value configured in the fixedAfd parameter.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #afdSignaling} will
     * return {@link AfdSignaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #afdSignalingAsString}.
     * </p>
     * 
     * @return Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system
     *         will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to
     *         "fixed", the AFD value will be the value configured in the fixedAfd parameter.
     * @see AfdSignaling
     */
    public final AfdSignaling afdSignaling() {
        return AfdSignaling.fromValue(afdSignaling);
    }

    /**
     * Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system will try
     * to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the AFD value
     * will be the value configured in the fixedAfd parameter.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #afdSignaling} will
     * return {@link AfdSignaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #afdSignalingAsString}.
     * </p>
     * 
     * @return Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system
     *         will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to
     *         "fixed", the AFD value will be the value configured in the fixedAfd parameter.
     * @see AfdSignaling
     */
    public final String afdSignalingAsString() {
        return afdSignaling;
    }

    /**
     * Whether or not EML should insert an Alternative Transfer Function SEI message to support backwards compatibility
     * with non-HDR decoders and displays.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #alternativeTransferFunction} will return {@link H265AlternativeTransferFunction#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #alternativeTransferFunctionAsString}.
     * </p>
     * 
     * @return Whether or not EML should insert an Alternative Transfer Function SEI message to support backwards
     *         compatibility with non-HDR decoders and displays.
     * @see H265AlternativeTransferFunction
     */
    public final H265AlternativeTransferFunction alternativeTransferFunction() {
        return H265AlternativeTransferFunction.fromValue(alternativeTransferFunction);
    }

    /**
     * Whether or not EML should insert an Alternative Transfer Function SEI message to support backwards compatibility
     * with non-HDR decoders and displays.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #alternativeTransferFunction} will return {@link H265AlternativeTransferFunction#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #alternativeTransferFunctionAsString}.
     * </p>
     * 
     * @return Whether or not EML should insert an Alternative Transfer Function SEI message to support backwards
     *         compatibility with non-HDR decoders and displays.
     * @see H265AlternativeTransferFunction
     */
    public final String alternativeTransferFunctionAsString() {
        return alternativeTransferFunction;
    }

    /**
     * Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In an MS
     * Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest
     * multiple of 1000.
     * 
     * @return Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In
     *         an MS Smooth output group, each output must have a unique value when its bitrate is rounded down to the
     *         nearest multiple of 1000.
     */
    public final Integer bitrate() {
        return bitrate;
    }

    /**
     * Size of buffer (HRD buffer model) in bits.
     * 
     * @return Size of buffer (HRD buffer model) in bits.
     */
    public final Integer bufSize() {
        return bufSize;
    }

    /**
     * Includes colorspace metadata in the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorMetadata}
     * will return {@link H265ColorMetadata#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #colorMetadataAsString}.
     * </p>
     * 
     * @return Includes colorspace metadata in the output.
     * @see H265ColorMetadata
     */
    public final H265ColorMetadata colorMetadata() {
        return H265ColorMetadata.fromValue(colorMetadata);
    }

    /**
     * Includes colorspace metadata in the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorMetadata}
     * will return {@link H265ColorMetadata#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #colorMetadataAsString}.
     * </p>
     * 
     * @return Includes colorspace metadata in the output.
     * @see H265ColorMetadata
     */
    public final String colorMetadataAsString() {
        return colorMetadata;
    }

    /**
     * Color Space settings
     * 
     * @return Color Space settings
     */
    public final H265ColorSpaceSettings colorSpaceSettings() {
        return colorSpaceSettings;
    }

    /**
     * Optional. Both filters reduce bandwidth by removing imperceptible details. You can enable one of the filters. We
     * recommend that you try both filters and observe the results to decide which one to use.
     *
     * The Temporal Filter reduces bandwidth by removing imperceptible details in the content. It combines perceptual
     * filtering and motion compensated temporal filtering (MCTF). It operates independently of the compression level.
     *
     * The Bandwidth Reduction filter is a perceptual filter located within the encoding loop. It adapts to the current
     * compression level to filter imperceptible signals. This filter works only when the resolution is 1080p or lower.
     * 
     * @return Optional. Both filters reduce bandwidth by removing imperceptible details. You can enable one of the
     *         filters. We recommend that you try both filters and observe the results to decide which one to use.
     *
     *         The Temporal Filter reduces bandwidth by removing imperceptible details in the content. It combines
     *         perceptual filtering and motion compensated temporal filtering (MCTF). It operates independently of the
     *         compression level.
     *
     *         The Bandwidth Reduction filter is a perceptual filter located within the encoding loop. It adapts to the
     *         current compression level to filter imperceptible signals. This filter works only when the resolution is
     *         1080p or lower.
     */
    public final H265FilterSettings filterSettings() {
        return filterSettings;
    }

    /**
     * Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set to
     * 'Fixed'.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fixedAfd} will
     * return {@link FixedAfd#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fixedAfdAsString}.
     * </p>
     * 
     * @return Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is
     *         set to 'Fixed'.
     * @see FixedAfd
     */
    public final FixedAfd fixedAfd() {
        return FixedAfd.fromValue(fixedAfd);
    }

    /**
     * Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set to
     * 'Fixed'.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fixedAfd} will
     * return {@link FixedAfd#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fixedAfdAsString}.
     * </p>
     * 
     * @return Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is
     *         set to 'Fixed'.
     * @see FixedAfd
     */
    public final String fixedAfdAsString() {
        return fixedAfd;
    }

    /**
     * If set to enabled, adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flickerAq} will
     * return {@link H265FlickerAq#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flickerAqAsString}.
     * </p>
     * 
     * @return If set to enabled, adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
     * @see H265FlickerAq
     */
    public final H265FlickerAq flickerAq() {
        return H265FlickerAq.fromValue(flickerAq);
    }

    /**
     * If set to enabled, adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #flickerAq} will
     * return {@link H265FlickerAq#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #flickerAqAsString}.
     * </p>
     * 
     * @return If set to enabled, adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
     * @see H265FlickerAq
     */
    public final String flickerAqAsString() {
        return flickerAq;
    }

    /**
     * Framerate denominator.
     * 
     * @return Framerate denominator.
     */
    public final Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
     * 
     * @return Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
     */
    public final Integer framerateNumerator() {
        return framerateNumerator;
    }

    /**
     * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining
     * mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output
     * segmenting.
     * 
     * @return Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder
     *         joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break
     *         output segmenting.
     */
    public final Integer gopClosedCadence() {
        return gopClosedCadence;
    }

    /**
     * GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits. If gopSizeUnits is frames,
     * gopSize must be an integer and must be greater than or equal to 1. If gopSizeUnits is seconds, gopSize must be
     * greater than 0, but need not be an integer.
     * 
     * @return GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits. If gopSizeUnits is
     *         frames, gopSize must be an integer and must be greater than or equal to 1. If gopSizeUnits is seconds,
     *         gopSize must be greater than 0, but need not be an integer.
     */
    public final Double gopSize() {
        return gopSize;
    }

    /**
     * Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize into a
     * frame count at run time.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopSizeUnits} will
     * return {@link H265GopSizeUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gopSizeUnitsAsString}.
     * </p>
     * 
     * @return Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the
     *         gopSize into a frame count at run time.
     * @see H265GopSizeUnits
     */
    public final H265GopSizeUnits gopSizeUnits() {
        return H265GopSizeUnits.fromValue(gopSizeUnits);
    }

    /**
     * Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize into a
     * frame count at run time.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopSizeUnits} will
     * return {@link H265GopSizeUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gopSizeUnitsAsString}.
     * </p>
     * 
     * @return Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the
     *         gopSize into a frame count at run time.
     * @see H265GopSizeUnits
     */
    public final String gopSizeUnitsAsString() {
        return gopSizeUnits;
    }

    /**
     * H.265 Level.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link H265Level#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return H.265 Level.
     * @see H265Level
     */
    public final H265Level level() {
        return H265Level.fromValue(level);
    }

    /**
     * H.265 Level.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link H265Level#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return H.265 Level.
     * @see H265Level
     */
    public final String levelAsString() {
        return level;
    }

    /**
     * Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better quality
     * for certain content.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookAheadRateControl} will return {@link H265LookAheadRateControl#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookAheadRateControlAsString}.
     * </p>
     * 
     * @return Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better
     *         quality for certain content.
     * @see H265LookAheadRateControl
     */
    public final H265LookAheadRateControl lookAheadRateControl() {
        return H265LookAheadRateControl.fromValue(lookAheadRateControl);
    }

    /**
     * Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better quality
     * for certain content.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookAheadRateControl} will return {@link H265LookAheadRateControl#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookAheadRateControlAsString}.
     * </p>
     * 
     * @return Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better
     *         quality for certain content.
     * @see H265LookAheadRateControl
     */
    public final String lookAheadRateControlAsString() {
        return lookAheadRateControl;
    }

    /**
     * For QVBR: See the tooltip for Quality level
     * 
     * @return For QVBR: See the tooltip for Quality level
     */
    public final Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if multiplex rate control is used. Enforces
     * separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change
     * I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change
     * I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for
     * the next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
     * 
     * @return Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if multiplex rate control is used.
     *         Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection.
     *         If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or
     *         stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting
     *         I-interval. The normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP size +
     *         Min-I-interval - 1
     */
    public final Integer minIInterval() {
        return minIInterval;
    }

    /**
     * Pixel Aspect Ratio denominator.
     * 
     * @return Pixel Aspect Ratio denominator.
     */
    public final Integer parDenominator() {
        return parDenominator;
    }

    /**
     * Pixel Aspect Ratio numerator.
     * 
     * @return Pixel Aspect Ratio numerator.
     */
    public final Integer parNumerator() {
        return parNumerator;
    }

    /**
     * H.265 Profile.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link H265Profile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return H.265 Profile.
     * @see H265Profile
     */
    public final H265Profile profile() {
        return H265Profile.fromValue(profile);
    }

    /**
     * H.265 Profile.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link H265Profile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return H.265 Profile.
     * @see H265Profile
     */
    public final String profileAsString() {
        return profile;
    }

    /**
     * Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. Set values for
     * the QVBR quality level field and Max bitrate field that suit your most important viewing devices. Recommended
     * values are: - Primary screen: Quality level: 8 to 10. Max bitrate: 4M - PC or tablet: Quality level: 7. Max
     * bitrate: 1.5M to 3M - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M
     * 
     * @return Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. Set
     *         values for the QVBR quality level field and Max bitrate field that suit your most important viewing
     *         devices. Recommended values are: - Primary screen: Quality level: 8 to 10. Max bitrate: 4M - PC or
     *         tablet: Quality level: 7. Max bitrate: 1.5M to 3M - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M
     */
    public final Integer qvbrQualityLevel() {
        return qvbrQualityLevel;
    }

    /**
     * Rate control mode.
     *
     * QVBR: Quality will match the specified quality level except when it is constrained by the maximum bitrate.
     * Recommended if you or your viewers pay for bandwidth.
     *
     * CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets to devices
     * that cannot handle variable bitrates.
     *
     * Multiplex: This rate control mode is only supported (and is required) when the video is being delivered to a
     * MediaLive Multiplex in which case the rate control configuration is controlled by the properties within the
     * Multiplex Program.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link H265RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Rate control mode.
     *
     *         QVBR: Quality will match the specified quality level except when it is constrained by the maximum
     *         bitrate. Recommended if you or your viewers pay for bandwidth.
     *
     *         CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets to
     *         devices that cannot handle variable bitrates.
     *
     *         Multiplex: This rate control mode is only supported (and is required) when the video is being delivered
     *         to a MediaLive Multiplex in which case the rate control configuration is controlled by the properties
     *         within the Multiplex Program.
     * @see H265RateControlMode
     */
    public final H265RateControlMode rateControlMode() {
        return H265RateControlMode.fromValue(rateControlMode);
    }

    /**
     * Rate control mode.
     *
     * QVBR: Quality will match the specified quality level except when it is constrained by the maximum bitrate.
     * Recommended if you or your viewers pay for bandwidth.
     *
     * CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets to devices
     * that cannot handle variable bitrates.
     *
     * Multiplex: This rate control mode is only supported (and is required) when the video is being delivered to a
     * MediaLive Multiplex in which case the rate control configuration is controlled by the properties within the
     * Multiplex Program.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link H265RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Rate control mode.
     *
     *         QVBR: Quality will match the specified quality level except when it is constrained by the maximum
     *         bitrate. Recommended if you or your viewers pay for bandwidth.
     *
     *         CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets to
     *         devices that cannot handle variable bitrates.
     *
     *         Multiplex: This rate control mode is only supported (and is required) when the video is being delivered
     *         to a MediaLive Multiplex in which case the rate control configuration is controlled by the properties
     *         within the Multiplex Program.
     * @see H265RateControlMode
     */
    public final String rateControlModeAsString() {
        return rateControlMode;
    }

    /**
     * Sets the scan type of the output to progressive or top-field-first interlaced.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanType} will
     * return {@link H265ScanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanTypeAsString}.
     * </p>
     * 
     * @return Sets the scan type of the output to progressive or top-field-first interlaced.
     * @see H265ScanType
     */
    public final H265ScanType scanType() {
        return H265ScanType.fromValue(scanType);
    }

    /**
     * Sets the scan type of the output to progressive or top-field-first interlaced.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanType} will
     * return {@link H265ScanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanTypeAsString}.
     * </p>
     * 
     * @return Sets the scan type of the output to progressive or top-field-first interlaced.
     * @see H265ScanType
     */
    public final String scanTypeAsString() {
        return scanType;
    }

    /**
     * Scene change detection.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sceneChangeDetect}
     * will return {@link H265SceneChangeDetect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sceneChangeDetectAsString}.
     * </p>
     * 
     * @return Scene change detection.
     * @see H265SceneChangeDetect
     */
    public final H265SceneChangeDetect sceneChangeDetect() {
        return H265SceneChangeDetect.fromValue(sceneChangeDetect);
    }

    /**
     * Scene change detection.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sceneChangeDetect}
     * will return {@link H265SceneChangeDetect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sceneChangeDetectAsString}.
     * </p>
     * 
     * @return Scene change detection.
     * @see H265SceneChangeDetect
     */
    public final String sceneChangeDetectAsString() {
        return sceneChangeDetect;
    }

    /**
     * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
     * pictures, and less than or equal to half the number of macroblock rows for interlaced pictures. This field is
     * optional; when no value is specified the encoder will choose the number of slices based on encode resolution.
     * 
     * @return Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
     *         pictures, and less than or equal to half the number of macroblock rows for interlaced pictures. This
     *         field is optional; when no value is specified the encoder will choose the number of slices based on
     *         encode resolution.
     */
    public final Integer slices() {
        return slices;
    }

    /**
     * H.265 Tier.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link H265Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return H.265 Tier.
     * @see H265Tier
     */
    public final H265Tier tier() {
        return H265Tier.fromValue(tier);
    }

    /**
     * H.265 Tier.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link H265Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return H.265 Tier.
     * @see H265Tier
     */
    public final String tierAsString() {
        return tier;
    }

    /**
     * Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not include
     * timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode Config
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timecodeInsertion}
     * will return {@link H265TimecodeInsertionBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #timecodeInsertionAsString}.
     * </p>
     * 
     * @return Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not
     *         include timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified in
     *         Timecode Config
     * @see H265TimecodeInsertionBehavior
     */
    public final H265TimecodeInsertionBehavior timecodeInsertion() {
        return H265TimecodeInsertionBehavior.fromValue(timecodeInsertion);
    }

    /**
     * Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not include
     * timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode Config
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timecodeInsertion}
     * will return {@link H265TimecodeInsertionBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #timecodeInsertionAsString}.
     * </p>
     * 
     * @return Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not
     *         include timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified in
     *         Timecode Config
     * @see H265TimecodeInsertionBehavior
     */
    public final String timecodeInsertionAsString() {
        return timecodeInsertion;
    }

    /**
     * Timecode burn-in settings
     * 
     * @return Timecode burn-in settings
     */
    public final TimecodeBurninSettings timecodeBurninSettings() {
        return timecodeBurninSettings;
    }

    /**
     * If you are setting up the picture as a tile, you must set this to "disabled". In all other configurations, you
     * typically enter "enabled".
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mvOverPictureBoundaries} will return {@link H265MvOverPictureBoundaries#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #mvOverPictureBoundariesAsString}.
     * </p>
     * 
     * @return If you are setting up the picture as a tile, you must set this to "disabled". In all other
     *         configurations, you typically enter "enabled".
     * @see H265MvOverPictureBoundaries
     */
    public final H265MvOverPictureBoundaries mvOverPictureBoundaries() {
        return H265MvOverPictureBoundaries.fromValue(mvOverPictureBoundaries);
    }

    /**
     * If you are setting up the picture as a tile, you must set this to "disabled". In all other configurations, you
     * typically enter "enabled".
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mvOverPictureBoundaries} will return {@link H265MvOverPictureBoundaries#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #mvOverPictureBoundariesAsString}.
     * </p>
     * 
     * @return If you are setting up the picture as a tile, you must set this to "disabled". In all other
     *         configurations, you typically enter "enabled".
     * @see H265MvOverPictureBoundaries
     */
    public final String mvOverPictureBoundariesAsString() {
        return mvOverPictureBoundaries;
    }

    /**
     * If you are setting up the picture as a tile, you must set this to "disabled". In other configurations, you
     * typically enter "enabled".
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mvTemporalPredictor} will return {@link H265MvTemporalPredictor#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mvTemporalPredictorAsString}.
     * </p>
     * 
     * @return If you are setting up the picture as a tile, you must set this to "disabled". In other configurations,
     *         you typically enter "enabled".
     * @see H265MvTemporalPredictor
     */
    public final H265MvTemporalPredictor mvTemporalPredictor() {
        return H265MvTemporalPredictor.fromValue(mvTemporalPredictor);
    }

    /**
     * If you are setting up the picture as a tile, you must set this to "disabled". In other configurations, you
     * typically enter "enabled".
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mvTemporalPredictor} will return {@link H265MvTemporalPredictor#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mvTemporalPredictorAsString}.
     * </p>
     * 
     * @return If you are setting up the picture as a tile, you must set this to "disabled". In other configurations,
     *         you typically enter "enabled".
     * @see H265MvTemporalPredictor
     */
    public final String mvTemporalPredictorAsString() {
        return mvTemporalPredictor;
    }

    /**
     * Set this field to set up the picture as a tile. You must also set tileWidth. The tile height must result in 22 or
     * fewer rows in the frame. The tile width must result in 20 or fewer columns in the frame. And finally, the product
     * of the column count and row count must be 64 of less. If the tile width and height are specified, MediaLive will
     * override the video codec slices field with a value that MediaLive calculates
     * 
     * @return Set this field to set up the picture as a tile. You must also set tileWidth. The tile height must result
     *         in 22 or fewer rows in the frame. The tile width must result in 20 or fewer columns in the frame. And
     *         finally, the product of the column count and row count must be 64 of less. If the tile width and height
     *         are specified, MediaLive will override the video codec slices field with a value that MediaLive
     *         calculates
     */
    public final Integer tileHeight() {
        return tileHeight;
    }

    /**
     * Set to "padded" to force MediaLive to add padding to the frame, to obtain a frame that is a whole multiple of the
     * tile size. If you are setting up the picture as a tile, you must enter "padded". In all other configurations, you
     * typically enter "none".
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tilePadding} will
     * return {@link H265TilePadding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tilePaddingAsString}.
     * </p>
     * 
     * @return Set to "padded" to force MediaLive to add padding to the frame, to obtain a frame that is a whole
     *         multiple of the tile size. If you are setting up the picture as a tile, you must enter "padded". In all
     *         other configurations, you typically enter "none".
     * @see H265TilePadding
     */
    public final H265TilePadding tilePadding() {
        return H265TilePadding.fromValue(tilePadding);
    }

    /**
     * Set to "padded" to force MediaLive to add padding to the frame, to obtain a frame that is a whole multiple of the
     * tile size. If you are setting up the picture as a tile, you must enter "padded". In all other configurations, you
     * typically enter "none".
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tilePadding} will
     * return {@link H265TilePadding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tilePaddingAsString}.
     * </p>
     * 
     * @return Set to "padded" to force MediaLive to add padding to the frame, to obtain a frame that is a whole
     *         multiple of the tile size. If you are setting up the picture as a tile, you must enter "padded". In all
     *         other configurations, you typically enter "none".
     * @see H265TilePadding
     */
    public final String tilePaddingAsString() {
        return tilePadding;
    }

    /**
     * Set this field to set up the picture as a tile. See tileHeight for more information.
     * 
     * @return Set this field to set up the picture as a tile. See tileHeight for more information.
     */
    public final Integer tileWidth() {
        return tileWidth;
    }

    /**
     * Select the tree block size used for encoding. If you enter "auto", the encoder will pick the best size. If you
     * are setting up the picture as a tile, you must set this to 32x32. In all other configurations, you typically
     * enter "auto".
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #treeblockSize}
     * will return {@link H265TreeblockSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #treeblockSizeAsString}.
     * </p>
     * 
     * @return Select the tree block size used for encoding. If you enter "auto", the encoder will pick the best size.
     *         If you are setting up the picture as a tile, you must set this to 32x32. In all other configurations, you
     *         typically enter "auto".
     * @see H265TreeblockSize
     */
    public final H265TreeblockSize treeblockSize() {
        return H265TreeblockSize.fromValue(treeblockSize);
    }

    /**
     * Select the tree block size used for encoding. If you enter "auto", the encoder will pick the best size. If you
     * are setting up the picture as a tile, you must set this to 32x32. In all other configurations, you typically
     * enter "auto".
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #treeblockSize}
     * will return {@link H265TreeblockSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #treeblockSizeAsString}.
     * </p>
     * 
     * @return Select the tree block size used for encoding. If you enter "auto", the encoder will pick the best size.
     *         If you are setting up the picture as a tile, you must set this to 32x32. In all other configurations, you
     *         typically enter "auto".
     * @see H265TreeblockSize
     */
    public final String treeblockSizeAsString() {
        return treeblockSize;
    }

    /**
     * Sets the minimum QP. If you aren't familiar with quantization adjustment, leave the field empty. MediaLive will
     * apply an appropriate value.
     * 
     * @return Sets the minimum QP. If you aren't familiar with quantization adjustment, leave the field empty.
     *         MediaLive will apply an appropriate value.
     */
    public final Integer minQp() {
        return minQp;
    }

    /**
     * Enable or disable the deblocking filter for this codec. The filter reduces blocking artifacts at block
     * boundaries, which improves overall video quality. If the filter is disabled, visible block edges might appear in
     * the output, especially at lower bitrates.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deblocking} will
     * return {@link H265Deblocking#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deblockingAsString}.
     * </p>
     * 
     * @return Enable or disable the deblocking filter for this codec. The filter reduces blocking artifacts at block
     *         boundaries, which improves overall video quality. If the filter is disabled, visible block edges might
     *         appear in the output, especially at lower bitrates.
     * @see H265Deblocking
     */
    public final H265Deblocking deblocking() {
        return H265Deblocking.fromValue(deblocking);
    }

    /**
     * Enable or disable the deblocking filter for this codec. The filter reduces blocking artifacts at block
     * boundaries, which improves overall video quality. If the filter is disabled, visible block edges might appear in
     * the output, especially at lower bitrates.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deblocking} will
     * return {@link H265Deblocking#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deblockingAsString}.
     * </p>
     * 
     * @return Enable or disable the deblocking filter for this codec. The filter reduces blocking artifacts at block
     *         boundaries, which improves overall video quality. If the filter is disabled, visible block edges might
     *         appear in the output, especially at lower bitrates.
     * @see H265Deblocking
     */
    public final String deblockingAsString() {
        return deblocking;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(afdSignalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(alternativeTransferFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(bufSize());
        hashCode = 31 * hashCode + Objects.hashCode(colorMetadataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(colorSpaceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(filterSettings());
        hashCode = 31 * hashCode + Objects.hashCode(fixedAfdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(flickerAqAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lookAheadRateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(profileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(qvbrQualityLevel());
        hashCode = 31 * hashCode + Objects.hashCode(rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sceneChangeDetectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slices());
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timecodeInsertionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timecodeBurninSettings());
        hashCode = 31 * hashCode + Objects.hashCode(mvOverPictureBoundariesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mvTemporalPredictorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tileHeight());
        hashCode = 31 * hashCode + Objects.hashCode(tilePaddingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tileWidth());
        hashCode = 31 * hashCode + Objects.hashCode(treeblockSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minQp());
        hashCode = 31 * hashCode + Objects.hashCode(deblockingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H265Settings)) {
            return false;
        }
        H265Settings other = (H265Settings) obj;
        return Objects.equals(adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString())
                && Objects.equals(afdSignalingAsString(), other.afdSignalingAsString())
                && Objects.equals(alternativeTransferFunctionAsString(), other.alternativeTransferFunctionAsString())
                && Objects.equals(bitrate(), other.bitrate()) && Objects.equals(bufSize(), other.bufSize())
                && Objects.equals(colorMetadataAsString(), other.colorMetadataAsString())
                && Objects.equals(colorSpaceSettings(), other.colorSpaceSettings())
                && Objects.equals(filterSettings(), other.filterSettings())
                && Objects.equals(fixedAfdAsString(), other.fixedAfdAsString())
                && Objects.equals(flickerAqAsString(), other.flickerAqAsString())
                && Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator())
                && Objects.equals(gopClosedCadence(), other.gopClosedCadence()) && Objects.equals(gopSize(), other.gopSize())
                && Objects.equals(gopSizeUnitsAsString(), other.gopSizeUnitsAsString())
                && Objects.equals(levelAsString(), other.levelAsString())
                && Objects.equals(lookAheadRateControlAsString(), other.lookAheadRateControlAsString())
                && Objects.equals(maxBitrate(), other.maxBitrate()) && Objects.equals(minIInterval(), other.minIInterval())
                && Objects.equals(parDenominator(), other.parDenominator())
                && Objects.equals(parNumerator(), other.parNumerator())
                && Objects.equals(profileAsString(), other.profileAsString())
                && Objects.equals(qvbrQualityLevel(), other.qvbrQualityLevel())
                && Objects.equals(rateControlModeAsString(), other.rateControlModeAsString())
                && Objects.equals(scanTypeAsString(), other.scanTypeAsString())
                && Objects.equals(sceneChangeDetectAsString(), other.sceneChangeDetectAsString())
                && Objects.equals(slices(), other.slices()) && Objects.equals(tierAsString(), other.tierAsString())
                && Objects.equals(timecodeInsertionAsString(), other.timecodeInsertionAsString())
                && Objects.equals(timecodeBurninSettings(), other.timecodeBurninSettings())
                && Objects.equals(mvOverPictureBoundariesAsString(), other.mvOverPictureBoundariesAsString())
                && Objects.equals(mvTemporalPredictorAsString(), other.mvTemporalPredictorAsString())
                && Objects.equals(tileHeight(), other.tileHeight())
                && Objects.equals(tilePaddingAsString(), other.tilePaddingAsString())
                && Objects.equals(tileWidth(), other.tileWidth())
                && Objects.equals(treeblockSizeAsString(), other.treeblockSizeAsString())
                && Objects.equals(minQp(), other.minQp()) && Objects.equals(deblockingAsString(), other.deblockingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("H265Settings").add("AdaptiveQuantization", adaptiveQuantizationAsString())
                .add("AfdSignaling", afdSignalingAsString())
                .add("AlternativeTransferFunction", alternativeTransferFunctionAsString()).add("Bitrate", bitrate())
                .add("BufSize", bufSize()).add("ColorMetadata", colorMetadataAsString())
                .add("ColorSpaceSettings", colorSpaceSettings()).add("FilterSettings", filterSettings())
                .add("FixedAfd", fixedAfdAsString()).add("FlickerAq", flickerAqAsString())
                .add("FramerateDenominator", framerateDenominator()).add("FramerateNumerator", framerateNumerator())
                .add("GopClosedCadence", gopClosedCadence()).add("GopSize", gopSize())
                .add("GopSizeUnits", gopSizeUnitsAsString()).add("Level", levelAsString())
                .add("LookAheadRateControl", lookAheadRateControlAsString()).add("MaxBitrate", maxBitrate())
                .add("MinIInterval", minIInterval()).add("ParDenominator", parDenominator()).add("ParNumerator", parNumerator())
                .add("Profile", profileAsString()).add("QvbrQualityLevel", qvbrQualityLevel())
                .add("RateControlMode", rateControlModeAsString()).add("ScanType", scanTypeAsString())
                .add("SceneChangeDetect", sceneChangeDetectAsString()).add("Slices", slices()).add("Tier", tierAsString())
                .add("TimecodeInsertion", timecodeInsertionAsString()).add("TimecodeBurninSettings", timecodeBurninSettings())
                .add("MvOverPictureBoundaries", mvOverPictureBoundariesAsString())
                .add("MvTemporalPredictor", mvTemporalPredictorAsString()).add("TileHeight", tileHeight())
                .add("TilePadding", tilePaddingAsString()).add("TileWidth", tileWidth())
                .add("TreeblockSize", treeblockSizeAsString()).add("MinQp", minQp()).add("Deblocking", deblockingAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(adaptiveQuantizationAsString()));
        case "AfdSignaling":
            return Optional.ofNullable(clazz.cast(afdSignalingAsString()));
        case "AlternativeTransferFunction":
            return Optional.ofNullable(clazz.cast(alternativeTransferFunctionAsString()));
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "BufSize":
            return Optional.ofNullable(clazz.cast(bufSize()));
        case "ColorMetadata":
            return Optional.ofNullable(clazz.cast(colorMetadataAsString()));
        case "ColorSpaceSettings":
            return Optional.ofNullable(clazz.cast(colorSpaceSettings()));
        case "FilterSettings":
            return Optional.ofNullable(clazz.cast(filterSettings()));
        case "FixedAfd":
            return Optional.ofNullable(clazz.cast(fixedAfdAsString()));
        case "FlickerAq":
            return Optional.ofNullable(clazz.cast(flickerAqAsString()));
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        case "GopClosedCadence":
            return Optional.ofNullable(clazz.cast(gopClosedCadence()));
        case "GopSize":
            return Optional.ofNullable(clazz.cast(gopSize()));
        case "GopSizeUnits":
            return Optional.ofNullable(clazz.cast(gopSizeUnitsAsString()));
        case "Level":
            return Optional.ofNullable(clazz.cast(levelAsString()));
        case "LookAheadRateControl":
            return Optional.ofNullable(clazz.cast(lookAheadRateControlAsString()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "MinIInterval":
            return Optional.ofNullable(clazz.cast(minIInterval()));
        case "ParDenominator":
            return Optional.ofNullable(clazz.cast(parDenominator()));
        case "ParNumerator":
            return Optional.ofNullable(clazz.cast(parNumerator()));
        case "Profile":
            return Optional.ofNullable(clazz.cast(profileAsString()));
        case "QvbrQualityLevel":
            return Optional.ofNullable(clazz.cast(qvbrQualityLevel()));
        case "RateControlMode":
            return Optional.ofNullable(clazz.cast(rateControlModeAsString()));
        case "ScanType":
            return Optional.ofNullable(clazz.cast(scanTypeAsString()));
        case "SceneChangeDetect":
            return Optional.ofNullable(clazz.cast(sceneChangeDetectAsString()));
        case "Slices":
            return Optional.ofNullable(clazz.cast(slices()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        case "TimecodeInsertion":
            return Optional.ofNullable(clazz.cast(timecodeInsertionAsString()));
        case "TimecodeBurninSettings":
            return Optional.ofNullable(clazz.cast(timecodeBurninSettings()));
        case "MvOverPictureBoundaries":
            return Optional.ofNullable(clazz.cast(mvOverPictureBoundariesAsString()));
        case "MvTemporalPredictor":
            return Optional.ofNullable(clazz.cast(mvTemporalPredictorAsString()));
        case "TileHeight":
            return Optional.ofNullable(clazz.cast(tileHeight()));
        case "TilePadding":
            return Optional.ofNullable(clazz.cast(tilePaddingAsString()));
        case "TileWidth":
            return Optional.ofNullable(clazz.cast(tileWidth()));
        case "TreeblockSize":
            return Optional.ofNullable(clazz.cast(treeblockSizeAsString()));
        case "MinQp":
            return Optional.ofNullable(clazz.cast(minQp()));
        case "Deblocking":
            return Optional.ofNullable(clazz.cast(deblockingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("adaptiveQuantization", ADAPTIVE_QUANTIZATION_FIELD);
        map.put("afdSignaling", AFD_SIGNALING_FIELD);
        map.put("alternativeTransferFunction", ALTERNATIVE_TRANSFER_FUNCTION_FIELD);
        map.put("bitrate", BITRATE_FIELD);
        map.put("bufSize", BUF_SIZE_FIELD);
        map.put("colorMetadata", COLOR_METADATA_FIELD);
        map.put("colorSpaceSettings", COLOR_SPACE_SETTINGS_FIELD);
        map.put("filterSettings", FILTER_SETTINGS_FIELD);
        map.put("fixedAfd", FIXED_AFD_FIELD);
        map.put("flickerAq", FLICKER_AQ_FIELD);
        map.put("framerateDenominator", FRAMERATE_DENOMINATOR_FIELD);
        map.put("framerateNumerator", FRAMERATE_NUMERATOR_FIELD);
        map.put("gopClosedCadence", GOP_CLOSED_CADENCE_FIELD);
        map.put("gopSize", GOP_SIZE_FIELD);
        map.put("gopSizeUnits", GOP_SIZE_UNITS_FIELD);
        map.put("level", LEVEL_FIELD);
        map.put("lookAheadRateControl", LOOK_AHEAD_RATE_CONTROL_FIELD);
        map.put("maxBitrate", MAX_BITRATE_FIELD);
        map.put("minIInterval", MIN_I_INTERVAL_FIELD);
        map.put("parDenominator", PAR_DENOMINATOR_FIELD);
        map.put("parNumerator", PAR_NUMERATOR_FIELD);
        map.put("profile", PROFILE_FIELD);
        map.put("qvbrQualityLevel", QVBR_QUALITY_LEVEL_FIELD);
        map.put("rateControlMode", RATE_CONTROL_MODE_FIELD);
        map.put("scanType", SCAN_TYPE_FIELD);
        map.put("sceneChangeDetect", SCENE_CHANGE_DETECT_FIELD);
        map.put("slices", SLICES_FIELD);
        map.put("tier", TIER_FIELD);
        map.put("timecodeInsertion", TIMECODE_INSERTION_FIELD);
        map.put("timecodeBurninSettings", TIMECODE_BURNIN_SETTINGS_FIELD);
        map.put("mvOverPictureBoundaries", MV_OVER_PICTURE_BOUNDARIES_FIELD);
        map.put("mvTemporalPredictor", MV_TEMPORAL_PREDICTOR_FIELD);
        map.put("tileHeight", TILE_HEIGHT_FIELD);
        map.put("tilePadding", TILE_PADDING_FIELD);
        map.put("tileWidth", TILE_WIDTH_FIELD);
        map.put("treeblockSize", TREEBLOCK_SIZE_FIELD);
        map.put("minQp", MIN_QP_FIELD);
        map.put("deblocking", DEBLOCKING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<H265Settings, T> g) {
        return obj -> g.apply((H265Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, H265Settings> {
        /**
         * Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
         * 
         * @param adaptiveQuantization
         *        Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
         * @see H265AdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265AdaptiveQuantization
         */
        Builder adaptiveQuantization(String adaptiveQuantization);

        /**
         * Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
         * 
         * @param adaptiveQuantization
         *        Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
         * @see H265AdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265AdaptiveQuantization
         */
        Builder adaptiveQuantization(H265AdaptiveQuantization adaptiveQuantization);

        /**
         * Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system will
         * try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the
         * AFD value will be the value configured in the fixedAfd parameter.
         * 
         * @param afdSignaling
         *        Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the
         *        system will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set
         *        to "fixed", the AFD value will be the value configured in the fixedAfd parameter.
         * @see AfdSignaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AfdSignaling
         */
        Builder afdSignaling(String afdSignaling);

        /**
         * Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system will
         * try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the
         * AFD value will be the value configured in the fixedAfd parameter.
         * 
         * @param afdSignaling
         *        Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the
         *        system will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set
         *        to "fixed", the AFD value will be the value configured in the fixedAfd parameter.
         * @see AfdSignaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AfdSignaling
         */
        Builder afdSignaling(AfdSignaling afdSignaling);

        /**
         * Whether or not EML should insert an Alternative Transfer Function SEI message to support backwards
         * compatibility with non-HDR decoders and displays.
         * 
         * @param alternativeTransferFunction
         *        Whether or not EML should insert an Alternative Transfer Function SEI message to support backwards
         *        compatibility with non-HDR decoders and displays.
         * @see H265AlternativeTransferFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265AlternativeTransferFunction
         */
        Builder alternativeTransferFunction(String alternativeTransferFunction);

        /**
         * Whether or not EML should insert an Alternative Transfer Function SEI message to support backwards
         * compatibility with non-HDR decoders and displays.
         * 
         * @param alternativeTransferFunction
         *        Whether or not EML should insert an Alternative Transfer Function SEI message to support backwards
         *        compatibility with non-HDR decoders and displays.
         * @see H265AlternativeTransferFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265AlternativeTransferFunction
         */
        Builder alternativeTransferFunction(H265AlternativeTransferFunction alternativeTransferFunction);

        /**
         * Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In an
         * MS Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest
         * multiple of 1000.
         * 
         * @param bitrate
         *        Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR.
         *        In an MS Smooth output group, each output must have a unique value when its bitrate is rounded down to
         *        the nearest multiple of 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Integer bitrate);

        /**
         * Size of buffer (HRD buffer model) in bits.
         * 
         * @param bufSize
         *        Size of buffer (HRD buffer model) in bits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufSize(Integer bufSize);

        /**
         * Includes colorspace metadata in the output.
         * 
         * @param colorMetadata
         *        Includes colorspace metadata in the output.
         * @see H265ColorMetadata
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265ColorMetadata
         */
        Builder colorMetadata(String colorMetadata);

        /**
         * Includes colorspace metadata in the output.
         * 
         * @param colorMetadata
         *        Includes colorspace metadata in the output.
         * @see H265ColorMetadata
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265ColorMetadata
         */
        Builder colorMetadata(H265ColorMetadata colorMetadata);

        /**
         * Color Space settings
         * 
         * @param colorSpaceSettings
         *        Color Space settings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorSpaceSettings(H265ColorSpaceSettings colorSpaceSettings);

        /**
         * Color Space settings This is a convenience method that creates an instance of the
         * {@link H265ColorSpaceSettings.Builder} avoiding the need to create one manually via
         * {@link H265ColorSpaceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link H265ColorSpaceSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #colorSpaceSettings(H265ColorSpaceSettings)}.
         * 
         * @param colorSpaceSettings
         *        a consumer that will call methods on {@link H265ColorSpaceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorSpaceSettings(H265ColorSpaceSettings)
         */
        default Builder colorSpaceSettings(Consumer<H265ColorSpaceSettings.Builder> colorSpaceSettings) {
            return colorSpaceSettings(H265ColorSpaceSettings.builder().applyMutation(colorSpaceSettings).build());
        }

        /**
         * Optional. Both filters reduce bandwidth by removing imperceptible details. You can enable one of the filters.
         * We recommend that you try both filters and observe the results to decide which one to use.
         *
         * The Temporal Filter reduces bandwidth by removing imperceptible details in the content. It combines
         * perceptual filtering and motion compensated temporal filtering (MCTF). It operates independently of the
         * compression level.
         *
         * The Bandwidth Reduction filter is a perceptual filter located within the encoding loop. It adapts to the
         * current compression level to filter imperceptible signals. This filter works only when the resolution is
         * 1080p or lower.
         * 
         * @param filterSettings
         *        Optional. Both filters reduce bandwidth by removing imperceptible details. You can enable one of the
         *        filters. We recommend that you try both filters and observe the results to decide which one to use.
         *
         *        The Temporal Filter reduces bandwidth by removing imperceptible details in the content. It combines
         *        perceptual filtering and motion compensated temporal filtering (MCTF). It operates independently of
         *        the compression level.
         *
         *        The Bandwidth Reduction filter is a perceptual filter located within the encoding loop. It adapts to
         *        the current compression level to filter imperceptible signals. This filter works only when the
         *        resolution is 1080p or lower.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterSettings(H265FilterSettings filterSettings);

        /**
         * Optional. Both filters reduce bandwidth by removing imperceptible details. You can enable one of the filters.
         * We recommend that you try both filters and observe the results to decide which one to use.
         *
         * The Temporal Filter reduces bandwidth by removing imperceptible details in the content. It combines
         * perceptual filtering and motion compensated temporal filtering (MCTF). It operates independently of the
         * compression level.
         *
         * The Bandwidth Reduction filter is a perceptual filter located within the encoding loop. It adapts to the
         * current compression level to filter imperceptible signals. This filter works only when the resolution is
         * 1080p or lower. This is a convenience method that creates an instance of the
         * {@link H265FilterSettings.Builder} avoiding the need to create one manually via
         * {@link H265FilterSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link H265FilterSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #filterSettings(H265FilterSettings)}.
         * 
         * @param filterSettings
         *        a consumer that will call methods on {@link H265FilterSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterSettings(H265FilterSettings)
         */
        default Builder filterSettings(Consumer<H265FilterSettings.Builder> filterSettings) {
            return filterSettings(H265FilterSettings.builder().applyMutation(filterSettings).build());
        }

        /**
         * Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set
         * to 'Fixed'.
         * 
         * @param fixedAfd
         *        Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling
         *        is set to 'Fixed'.
         * @see FixedAfd
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FixedAfd
         */
        Builder fixedAfd(String fixedAfd);

        /**
         * Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set
         * to 'Fixed'.
         * 
         * @param fixedAfd
         *        Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling
         *        is set to 'Fixed'.
         * @see FixedAfd
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FixedAfd
         */
        Builder fixedAfd(FixedAfd fixedAfd);

        /**
         * If set to enabled, adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
         * 
         * @param flickerAq
         *        If set to enabled, adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
         * @see H265FlickerAq
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265FlickerAq
         */
        Builder flickerAq(String flickerAq);

        /**
         * If set to enabled, adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
         * 
         * @param flickerAq
         *        If set to enabled, adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
         * @see H265FlickerAq
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265FlickerAq
         */
        Builder flickerAq(H265FlickerAq flickerAq);

        /**
         * Framerate denominator.
         * 
         * @param framerateDenominator
         *        Framerate denominator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
         * 
         * @param framerateNumerator
         *        Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);

        /**
         * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder
         * joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break
         * output segmenting.
         * 
         * @param gopClosedCadence
         *        Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a
         *        decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0
         *        will break output segmenting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopClosedCadence(Integer gopClosedCadence);

        /**
         * GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits. If gopSizeUnits is
         * frames, gopSize must be an integer and must be greater than or equal to 1. If gopSizeUnits is seconds,
         * gopSize must be greater than 0, but need not be an integer.
         * 
         * @param gopSize
         *        GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits. If gopSizeUnits is
         *        frames, gopSize must be an integer and must be greater than or equal to 1. If gopSizeUnits is seconds,
         *        gopSize must be greater than 0, but need not be an integer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopSize(Double gopSize);

        /**
         * Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize
         * into a frame count at run time.
         * 
         * @param gopSizeUnits
         *        Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the
         *        gopSize into a frame count at run time.
         * @see H265GopSizeUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265GopSizeUnits
         */
        Builder gopSizeUnits(String gopSizeUnits);

        /**
         * Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize
         * into a frame count at run time.
         * 
         * @param gopSizeUnits
         *        Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the
         *        gopSize into a frame count at run time.
         * @see H265GopSizeUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265GopSizeUnits
         */
        Builder gopSizeUnits(H265GopSizeUnits gopSizeUnits);

        /**
         * H.265 Level.
         * 
         * @param level
         *        H.265 Level.
         * @see H265Level
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265Level
         */
        Builder level(String level);

        /**
         * H.265 Level.
         * 
         * @param level
         *        H.265 Level.
         * @see H265Level
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265Level
         */
        Builder level(H265Level level);

        /**
         * Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better
         * quality for certain content.
         * 
         * @param lookAheadRateControl
         *        Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce
         *        better quality for certain content.
         * @see H265LookAheadRateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265LookAheadRateControl
         */
        Builder lookAheadRateControl(String lookAheadRateControl);

        /**
         * Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better
         * quality for certain content.
         * 
         * @param lookAheadRateControl
         *        Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce
         *        better quality for certain content.
         * @see H265LookAheadRateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265LookAheadRateControl
         */
        Builder lookAheadRateControl(H265LookAheadRateControl lookAheadRateControl);

        /**
         * For QVBR: See the tooltip for Quality level
         * 
         * @param maxBitrate
         *        For QVBR: See the tooltip for Quality level
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if multiplex rate control is used.
         * Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a
         * scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to
         * the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal
         * cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
         * 
         * @param minIInterval
         *        Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if multiplex rate control is
         *        used. Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change
         *        Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is
         *        shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well
         *        as setting I-interval. The normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP
         *        size + Min-I-interval - 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minIInterval(Integer minIInterval);

        /**
         * Pixel Aspect Ratio denominator.
         * 
         * @param parDenominator
         *        Pixel Aspect Ratio denominator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parDenominator(Integer parDenominator);

        /**
         * Pixel Aspect Ratio numerator.
         * 
         * @param parNumerator
         *        Pixel Aspect Ratio numerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parNumerator(Integer parNumerator);

        /**
         * H.265 Profile.
         * 
         * @param profile
         *        H.265 Profile.
         * @see H265Profile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265Profile
         */
        Builder profile(String profile);

        /**
         * H.265 Profile.
         * 
         * @param profile
         *        H.265 Profile.
         * @see H265Profile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265Profile
         */
        Builder profile(H265Profile profile);

        /**
         * Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. Set values
         * for the QVBR quality level field and Max bitrate field that suit your most important viewing devices.
         * Recommended values are: - Primary screen: Quality level: 8 to 10. Max bitrate: 4M - PC or tablet: Quality
         * level: 7. Max bitrate: 1.5M to 3M - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M
         * 
         * @param qvbrQualityLevel
         *        Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. Set
         *        values for the QVBR quality level field and Max bitrate field that suit your most important viewing
         *        devices. Recommended values are: - Primary screen: Quality level: 8 to 10. Max bitrate: 4M - PC or
         *        tablet: Quality level: 7. Max bitrate: 1.5M to 3M - Smartphone: Quality level: 6. Max bitrate: 1M to
         *        1.5M
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qvbrQualityLevel(Integer qvbrQualityLevel);

        /**
         * Rate control mode.
         *
         * QVBR: Quality will match the specified quality level except when it is constrained by the maximum bitrate.
         * Recommended if you or your viewers pay for bandwidth.
         *
         * CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets to
         * devices that cannot handle variable bitrates.
         *
         * Multiplex: This rate control mode is only supported (and is required) when the video is being delivered to a
         * MediaLive Multiplex in which case the rate control configuration is controlled by the properties within the
         * Multiplex Program.
         * 
         * @param rateControlMode
         *        Rate control mode.
         *
         *        QVBR: Quality will match the specified quality level except when it is constrained by the maximum
         *        bitrate. Recommended if you or your viewers pay for bandwidth.
         *
         *        CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets
         *        to devices that cannot handle variable bitrates.
         *
         *        Multiplex: This rate control mode is only supported (and is required) when the video is being
         *        delivered to a MediaLive Multiplex in which case the rate control configuration is controlled by the
         *        properties within the Multiplex Program.
         * @see H265RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265RateControlMode
         */
        Builder rateControlMode(String rateControlMode);

        /**
         * Rate control mode.
         *
         * QVBR: Quality will match the specified quality level except when it is constrained by the maximum bitrate.
         * Recommended if you or your viewers pay for bandwidth.
         *
         * CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets to
         * devices that cannot handle variable bitrates.
         *
         * Multiplex: This rate control mode is only supported (and is required) when the video is being delivered to a
         * MediaLive Multiplex in which case the rate control configuration is controlled by the properties within the
         * Multiplex Program.
         * 
         * @param rateControlMode
         *        Rate control mode.
         *
         *        QVBR: Quality will match the specified quality level except when it is constrained by the maximum
         *        bitrate. Recommended if you or your viewers pay for bandwidth.
         *
         *        CBR: Quality varies, depending on the video complexity. Recommended only if you distribute your assets
         *        to devices that cannot handle variable bitrates.
         *
         *        Multiplex: This rate control mode is only supported (and is required) when the video is being
         *        delivered to a MediaLive Multiplex in which case the rate control configuration is controlled by the
         *        properties within the Multiplex Program.
         * @see H265RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265RateControlMode
         */
        Builder rateControlMode(H265RateControlMode rateControlMode);

        /**
         * Sets the scan type of the output to progressive or top-field-first interlaced.
         * 
         * @param scanType
         *        Sets the scan type of the output to progressive or top-field-first interlaced.
         * @see H265ScanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265ScanType
         */
        Builder scanType(String scanType);

        /**
         * Sets the scan type of the output to progressive or top-field-first interlaced.
         * 
         * @param scanType
         *        Sets the scan type of the output to progressive or top-field-first interlaced.
         * @see H265ScanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265ScanType
         */
        Builder scanType(H265ScanType scanType);

        /**
         * Scene change detection.
         * 
         * @param sceneChangeDetect
         *        Scene change detection.
         * @see H265SceneChangeDetect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265SceneChangeDetect
         */
        Builder sceneChangeDetect(String sceneChangeDetect);

        /**
         * Scene change detection.
         * 
         * @param sceneChangeDetect
         *        Scene change detection.
         * @see H265SceneChangeDetect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265SceneChangeDetect
         */
        Builder sceneChangeDetect(H265SceneChangeDetect sceneChangeDetect);

        /**
         * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
         * pictures, and less than or equal to half the number of macroblock rows for interlaced pictures. This field is
         * optional; when no value is specified the encoder will choose the number of slices based on encode resolution.
         * 
         * @param slices
         *        Number of slices per picture. Must be less than or equal to the number of macroblock rows for
         *        progressive pictures, and less than or equal to half the number of macroblock rows for interlaced
         *        pictures. This field is optional; when no value is specified the encoder will choose the number of
         *        slices based on encode resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slices(Integer slices);

        /**
         * H.265 Tier.
         * 
         * @param tier
         *        H.265 Tier.
         * @see H265Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265Tier
         */
        Builder tier(String tier);

        /**
         * H.265 Tier.
         * 
         * @param tier
         *        H.265 Tier.
         * @see H265Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265Tier
         */
        Builder tier(H265Tier tier);

        /**
         * Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not include
         * timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode
         * Config
         * 
         * @param timecodeInsertion
         *        Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not
         *        include timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified
         *        in Timecode Config
         * @see H265TimecodeInsertionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265TimecodeInsertionBehavior
         */
        Builder timecodeInsertion(String timecodeInsertion);

        /**
         * Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not include
         * timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode
         * Config
         * 
         * @param timecodeInsertion
         *        Determines how timecodes should be inserted into the video elementary stream. - 'disabled': Do not
         *        include timecodes - 'picTimingSei': Pass through picture timing SEI messages from the source specified
         *        in Timecode Config
         * @see H265TimecodeInsertionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265TimecodeInsertionBehavior
         */
        Builder timecodeInsertion(H265TimecodeInsertionBehavior timecodeInsertion);

        /**
         * Timecode burn-in settings
         * 
         * @param timecodeBurninSettings
         *        Timecode burn-in settings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timecodeBurninSettings(TimecodeBurninSettings timecodeBurninSettings);

        /**
         * Timecode burn-in settings This is a convenience method that creates an instance of the
         * {@link TimecodeBurninSettings.Builder} avoiding the need to create one manually via
         * {@link TimecodeBurninSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimecodeBurninSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #timecodeBurninSettings(TimecodeBurninSettings)}.
         * 
         * @param timecodeBurninSettings
         *        a consumer that will call methods on {@link TimecodeBurninSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timecodeBurninSettings(TimecodeBurninSettings)
         */
        default Builder timecodeBurninSettings(Consumer<TimecodeBurninSettings.Builder> timecodeBurninSettings) {
            return timecodeBurninSettings(TimecodeBurninSettings.builder().applyMutation(timecodeBurninSettings).build());
        }

        /**
         * If you are setting up the picture as a tile, you must set this to "disabled". In all other configurations,
         * you typically enter "enabled".
         * 
         * @param mvOverPictureBoundaries
         *        If you are setting up the picture as a tile, you must set this to "disabled". In all other
         *        configurations, you typically enter "enabled".
         * @see H265MvOverPictureBoundaries
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265MvOverPictureBoundaries
         */
        Builder mvOverPictureBoundaries(String mvOverPictureBoundaries);

        /**
         * If you are setting up the picture as a tile, you must set this to "disabled". In all other configurations,
         * you typically enter "enabled".
         * 
         * @param mvOverPictureBoundaries
         *        If you are setting up the picture as a tile, you must set this to "disabled". In all other
         *        configurations, you typically enter "enabled".
         * @see H265MvOverPictureBoundaries
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265MvOverPictureBoundaries
         */
        Builder mvOverPictureBoundaries(H265MvOverPictureBoundaries mvOverPictureBoundaries);

        /**
         * If you are setting up the picture as a tile, you must set this to "disabled". In other configurations, you
         * typically enter "enabled".
         * 
         * @param mvTemporalPredictor
         *        If you are setting up the picture as a tile, you must set this to "disabled". In other configurations,
         *        you typically enter "enabled".
         * @see H265MvTemporalPredictor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265MvTemporalPredictor
         */
        Builder mvTemporalPredictor(String mvTemporalPredictor);

        /**
         * If you are setting up the picture as a tile, you must set this to "disabled". In other configurations, you
         * typically enter "enabled".
         * 
         * @param mvTemporalPredictor
         *        If you are setting up the picture as a tile, you must set this to "disabled". In other configurations,
         *        you typically enter "enabled".
         * @see H265MvTemporalPredictor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265MvTemporalPredictor
         */
        Builder mvTemporalPredictor(H265MvTemporalPredictor mvTemporalPredictor);

        /**
         * Set this field to set up the picture as a tile. You must also set tileWidth. The tile height must result in
         * 22 or fewer rows in the frame. The tile width must result in 20 or fewer columns in the frame. And finally,
         * the product of the column count and row count must be 64 of less. If the tile width and height are specified,
         * MediaLive will override the video codec slices field with a value that MediaLive calculates
         * 
         * @param tileHeight
         *        Set this field to set up the picture as a tile. You must also set tileWidth. The tile height must
         *        result in 22 or fewer rows in the frame. The tile width must result in 20 or fewer columns in the
         *        frame. And finally, the product of the column count and row count must be 64 of less. If the tile
         *        width and height are specified, MediaLive will override the video codec slices field with a value that
         *        MediaLive calculates
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tileHeight(Integer tileHeight);

        /**
         * Set to "padded" to force MediaLive to add padding to the frame, to obtain a frame that is a whole multiple of
         * the tile size. If you are setting up the picture as a tile, you must enter "padded". In all other
         * configurations, you typically enter "none".
         * 
         * @param tilePadding
         *        Set to "padded" to force MediaLive to add padding to the frame, to obtain a frame that is a whole
         *        multiple of the tile size. If you are setting up the picture as a tile, you must enter "padded". In
         *        all other configurations, you typically enter "none".
         * @see H265TilePadding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265TilePadding
         */
        Builder tilePadding(String tilePadding);

        /**
         * Set to "padded" to force MediaLive to add padding to the frame, to obtain a frame that is a whole multiple of
         * the tile size. If you are setting up the picture as a tile, you must enter "padded". In all other
         * configurations, you typically enter "none".
         * 
         * @param tilePadding
         *        Set to "padded" to force MediaLive to add padding to the frame, to obtain a frame that is a whole
         *        multiple of the tile size. If you are setting up the picture as a tile, you must enter "padded". In
         *        all other configurations, you typically enter "none".
         * @see H265TilePadding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265TilePadding
         */
        Builder tilePadding(H265TilePadding tilePadding);

        /**
         * Set this field to set up the picture as a tile. See tileHeight for more information.
         * 
         * @param tileWidth
         *        Set this field to set up the picture as a tile. See tileHeight for more information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tileWidth(Integer tileWidth);

        /**
         * Select the tree block size used for encoding. If you enter "auto", the encoder will pick the best size. If
         * you are setting up the picture as a tile, you must set this to 32x32. In all other configurations, you
         * typically enter "auto".
         * 
         * @param treeblockSize
         *        Select the tree block size used for encoding. If you enter "auto", the encoder will pick the best
         *        size. If you are setting up the picture as a tile, you must set this to 32x32. In all other
         *        configurations, you typically enter "auto".
         * @see H265TreeblockSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265TreeblockSize
         */
        Builder treeblockSize(String treeblockSize);

        /**
         * Select the tree block size used for encoding. If you enter "auto", the encoder will pick the best size. If
         * you are setting up the picture as a tile, you must set this to 32x32. In all other configurations, you
         * typically enter "auto".
         * 
         * @param treeblockSize
         *        Select the tree block size used for encoding. If you enter "auto", the encoder will pick the best
         *        size. If you are setting up the picture as a tile, you must set this to 32x32. In all other
         *        configurations, you typically enter "auto".
         * @see H265TreeblockSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265TreeblockSize
         */
        Builder treeblockSize(H265TreeblockSize treeblockSize);

        /**
         * Sets the minimum QP. If you aren't familiar with quantization adjustment, leave the field empty. MediaLive
         * will apply an appropriate value.
         * 
         * @param minQp
         *        Sets the minimum QP. If you aren't familiar with quantization adjustment, leave the field empty.
         *        MediaLive will apply an appropriate value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minQp(Integer minQp);

        /**
         * Enable or disable the deblocking filter for this codec. The filter reduces blocking artifacts at block
         * boundaries, which improves overall video quality. If the filter is disabled, visible block edges might appear
         * in the output, especially at lower bitrates.
         * 
         * @param deblocking
         *        Enable or disable the deblocking filter for this codec. The filter reduces blocking artifacts at block
         *        boundaries, which improves overall video quality. If the filter is disabled, visible block edges might
         *        appear in the output, especially at lower bitrates.
         * @see H265Deblocking
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265Deblocking
         */
        Builder deblocking(String deblocking);

        /**
         * Enable or disable the deblocking filter for this codec. The filter reduces blocking artifacts at block
         * boundaries, which improves overall video quality. If the filter is disabled, visible block edges might appear
         * in the output, especially at lower bitrates.
         * 
         * @param deblocking
         *        Enable or disable the deblocking filter for this codec. The filter reduces blocking artifacts at block
         *        boundaries, which improves overall video quality. If the filter is disabled, visible block edges might
         *        appear in the output, especially at lower bitrates.
         * @see H265Deblocking
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H265Deblocking
         */
        Builder deblocking(H265Deblocking deblocking);
    }

    static final class BuilderImpl implements Builder {
        private String adaptiveQuantization;

        private String afdSignaling;

        private String alternativeTransferFunction;

        private Integer bitrate;

        private Integer bufSize;

        private String colorMetadata;

        private H265ColorSpaceSettings colorSpaceSettings;

        private H265FilterSettings filterSettings;

        private String fixedAfd;

        private String flickerAq;

        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private Integer gopClosedCadence;

        private Double gopSize;

        private String gopSizeUnits;

        private String level;

        private String lookAheadRateControl;

        private Integer maxBitrate;

        private Integer minIInterval;

        private Integer parDenominator;

        private Integer parNumerator;

        private String profile;

        private Integer qvbrQualityLevel;

        private String rateControlMode;

        private String scanType;

        private String sceneChangeDetect;

        private Integer slices;

        private String tier;

        private String timecodeInsertion;

        private TimecodeBurninSettings timecodeBurninSettings;

        private String mvOverPictureBoundaries;

        private String mvTemporalPredictor;

        private Integer tileHeight;

        private String tilePadding;

        private Integer tileWidth;

        private String treeblockSize;

        private Integer minQp;

        private String deblocking;

        private BuilderImpl() {
        }

        private BuilderImpl(H265Settings model) {
            adaptiveQuantization(model.adaptiveQuantization);
            afdSignaling(model.afdSignaling);
            alternativeTransferFunction(model.alternativeTransferFunction);
            bitrate(model.bitrate);
            bufSize(model.bufSize);
            colorMetadata(model.colorMetadata);
            colorSpaceSettings(model.colorSpaceSettings);
            filterSettings(model.filterSettings);
            fixedAfd(model.fixedAfd);
            flickerAq(model.flickerAq);
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
            gopClosedCadence(model.gopClosedCadence);
            gopSize(model.gopSize);
            gopSizeUnits(model.gopSizeUnits);
            level(model.level);
            lookAheadRateControl(model.lookAheadRateControl);
            maxBitrate(model.maxBitrate);
            minIInterval(model.minIInterval);
            parDenominator(model.parDenominator);
            parNumerator(model.parNumerator);
            profile(model.profile);
            qvbrQualityLevel(model.qvbrQualityLevel);
            rateControlMode(model.rateControlMode);
            scanType(model.scanType);
            sceneChangeDetect(model.sceneChangeDetect);
            slices(model.slices);
            tier(model.tier);
            timecodeInsertion(model.timecodeInsertion);
            timecodeBurninSettings(model.timecodeBurninSettings);
            mvOverPictureBoundaries(model.mvOverPictureBoundaries);
            mvTemporalPredictor(model.mvTemporalPredictor);
            tileHeight(model.tileHeight);
            tilePadding(model.tilePadding);
            tileWidth(model.tileWidth);
            treeblockSize(model.treeblockSize);
            minQp(model.minQp);
            deblocking(model.deblocking);
        }

        public final String getAdaptiveQuantization() {
            return adaptiveQuantization;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(H265AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final String getAfdSignaling() {
            return afdSignaling;
        }

        public final void setAfdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
        }

        @Override
        public final Builder afdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
            return this;
        }

        @Override
        public final Builder afdSignaling(AfdSignaling afdSignaling) {
            this.afdSignaling(afdSignaling == null ? null : afdSignaling.toString());
            return this;
        }

        public final String getAlternativeTransferFunction() {
            return alternativeTransferFunction;
        }

        public final void setAlternativeTransferFunction(String alternativeTransferFunction) {
            this.alternativeTransferFunction = alternativeTransferFunction;
        }

        @Override
        public final Builder alternativeTransferFunction(String alternativeTransferFunction) {
            this.alternativeTransferFunction = alternativeTransferFunction;
            return this;
        }

        @Override
        public final Builder alternativeTransferFunction(H265AlternativeTransferFunction alternativeTransferFunction) {
            this.alternativeTransferFunction(alternativeTransferFunction == null ? null : alternativeTransferFunction.toString());
            return this;
        }

        public final Integer getBitrate() {
            return bitrate;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final Integer getBufSize() {
            return bufSize;
        }

        public final void setBufSize(Integer bufSize) {
            this.bufSize = bufSize;
        }

        @Override
        public final Builder bufSize(Integer bufSize) {
            this.bufSize = bufSize;
            return this;
        }

        public final String getColorMetadata() {
            return colorMetadata;
        }

        public final void setColorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
        }

        @Override
        public final Builder colorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
            return this;
        }

        @Override
        public final Builder colorMetadata(H265ColorMetadata colorMetadata) {
            this.colorMetadata(colorMetadata == null ? null : colorMetadata.toString());
            return this;
        }

        public final H265ColorSpaceSettings.Builder getColorSpaceSettings() {
            return colorSpaceSettings != null ? colorSpaceSettings.toBuilder() : null;
        }

        public final void setColorSpaceSettings(H265ColorSpaceSettings.BuilderImpl colorSpaceSettings) {
            this.colorSpaceSettings = colorSpaceSettings != null ? colorSpaceSettings.build() : null;
        }

        @Override
        public final Builder colorSpaceSettings(H265ColorSpaceSettings colorSpaceSettings) {
            this.colorSpaceSettings = colorSpaceSettings;
            return this;
        }

        public final H265FilterSettings.Builder getFilterSettings() {
            return filterSettings != null ? filterSettings.toBuilder() : null;
        }

        public final void setFilterSettings(H265FilterSettings.BuilderImpl filterSettings) {
            this.filterSettings = filterSettings != null ? filterSettings.build() : null;
        }

        @Override
        public final Builder filterSettings(H265FilterSettings filterSettings) {
            this.filterSettings = filterSettings;
            return this;
        }

        public final String getFixedAfd() {
            return fixedAfd;
        }

        public final void setFixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
        }

        @Override
        public final Builder fixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
            return this;
        }

        @Override
        public final Builder fixedAfd(FixedAfd fixedAfd) {
            this.fixedAfd(fixedAfd == null ? null : fixedAfd.toString());
            return this;
        }

        public final String getFlickerAq() {
            return flickerAq;
        }

        public final void setFlickerAq(String flickerAq) {
            this.flickerAq = flickerAq;
        }

        @Override
        public final Builder flickerAq(String flickerAq) {
            this.flickerAq = flickerAq;
            return this;
        }

        @Override
        public final Builder flickerAq(H265FlickerAq flickerAq) {
            this.flickerAq(flickerAq == null ? null : flickerAq.toString());
            return this;
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final Integer getGopClosedCadence() {
            return gopClosedCadence;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final Double getGopSize() {
            return gopSize;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final String getGopSizeUnits() {
            return gopSizeUnits;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(H265GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits == null ? null : gopSizeUnits.toString());
            return this;
        }

        public final String getLevel() {
            return level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(H265Level level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final String getLookAheadRateControl() {
            return lookAheadRateControl;
        }

        public final void setLookAheadRateControl(String lookAheadRateControl) {
            this.lookAheadRateControl = lookAheadRateControl;
        }

        @Override
        public final Builder lookAheadRateControl(String lookAheadRateControl) {
            this.lookAheadRateControl = lookAheadRateControl;
            return this;
        }

        @Override
        public final Builder lookAheadRateControl(H265LookAheadRateControl lookAheadRateControl) {
            this.lookAheadRateControl(lookAheadRateControl == null ? null : lookAheadRateControl.toString());
            return this;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final Integer getMinIInterval() {
            return minIInterval;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        @Override
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final Integer getParDenominator() {
            return parDenominator;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final Integer getParNumerator() {
            return parNumerator;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final String getProfile() {
            return profile;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(H265Profile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        public final Integer getQvbrQualityLevel() {
            return qvbrQualityLevel;
        }

        public final void setQvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
        }

        @Override
        public final Builder qvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
            return this;
        }

        public final String getRateControlMode() {
            return rateControlMode;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(H265RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final String getScanType() {
            return scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(H265ScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public final String getSceneChangeDetect() {
            return sceneChangeDetect;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        @Override
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        public final Builder sceneChangeDetect(H265SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect == null ? null : sceneChangeDetect.toString());
            return this;
        }

        public final Integer getSlices() {
            return slices;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        @Override
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(H265Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final String getTimecodeInsertion() {
            return timecodeInsertion;
        }

        public final void setTimecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
        }

        @Override
        public final Builder timecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
            return this;
        }

        @Override
        public final Builder timecodeInsertion(H265TimecodeInsertionBehavior timecodeInsertion) {
            this.timecodeInsertion(timecodeInsertion == null ? null : timecodeInsertion.toString());
            return this;
        }

        public final TimecodeBurninSettings.Builder getTimecodeBurninSettings() {
            return timecodeBurninSettings != null ? timecodeBurninSettings.toBuilder() : null;
        }

        public final void setTimecodeBurninSettings(TimecodeBurninSettings.BuilderImpl timecodeBurninSettings) {
            this.timecodeBurninSettings = timecodeBurninSettings != null ? timecodeBurninSettings.build() : null;
        }

        @Override
        public final Builder timecodeBurninSettings(TimecodeBurninSettings timecodeBurninSettings) {
            this.timecodeBurninSettings = timecodeBurninSettings;
            return this;
        }

        public final String getMvOverPictureBoundaries() {
            return mvOverPictureBoundaries;
        }

        public final void setMvOverPictureBoundaries(String mvOverPictureBoundaries) {
            this.mvOverPictureBoundaries = mvOverPictureBoundaries;
        }

        @Override
        public final Builder mvOverPictureBoundaries(String mvOverPictureBoundaries) {
            this.mvOverPictureBoundaries = mvOverPictureBoundaries;
            return this;
        }

        @Override
        public final Builder mvOverPictureBoundaries(H265MvOverPictureBoundaries mvOverPictureBoundaries) {
            this.mvOverPictureBoundaries(mvOverPictureBoundaries == null ? null : mvOverPictureBoundaries.toString());
            return this;
        }

        public final String getMvTemporalPredictor() {
            return mvTemporalPredictor;
        }

        public final void setMvTemporalPredictor(String mvTemporalPredictor) {
            this.mvTemporalPredictor = mvTemporalPredictor;
        }

        @Override
        public final Builder mvTemporalPredictor(String mvTemporalPredictor) {
            this.mvTemporalPredictor = mvTemporalPredictor;
            return this;
        }

        @Override
        public final Builder mvTemporalPredictor(H265MvTemporalPredictor mvTemporalPredictor) {
            this.mvTemporalPredictor(mvTemporalPredictor == null ? null : mvTemporalPredictor.toString());
            return this;
        }

        public final Integer getTileHeight() {
            return tileHeight;
        }

        public final void setTileHeight(Integer tileHeight) {
            this.tileHeight = tileHeight;
        }

        @Override
        public final Builder tileHeight(Integer tileHeight) {
            this.tileHeight = tileHeight;
            return this;
        }

        public final String getTilePadding() {
            return tilePadding;
        }

        public final void setTilePadding(String tilePadding) {
            this.tilePadding = tilePadding;
        }

        @Override
        public final Builder tilePadding(String tilePadding) {
            this.tilePadding = tilePadding;
            return this;
        }

        @Override
        public final Builder tilePadding(H265TilePadding tilePadding) {
            this.tilePadding(tilePadding == null ? null : tilePadding.toString());
            return this;
        }

        public final Integer getTileWidth() {
            return tileWidth;
        }

        public final void setTileWidth(Integer tileWidth) {
            this.tileWidth = tileWidth;
        }

        @Override
        public final Builder tileWidth(Integer tileWidth) {
            this.tileWidth = tileWidth;
            return this;
        }

        public final String getTreeblockSize() {
            return treeblockSize;
        }

        public final void setTreeblockSize(String treeblockSize) {
            this.treeblockSize = treeblockSize;
        }

        @Override
        public final Builder treeblockSize(String treeblockSize) {
            this.treeblockSize = treeblockSize;
            return this;
        }

        @Override
        public final Builder treeblockSize(H265TreeblockSize treeblockSize) {
            this.treeblockSize(treeblockSize == null ? null : treeblockSize.toString());
            return this;
        }

        public final Integer getMinQp() {
            return minQp;
        }

        public final void setMinQp(Integer minQp) {
            this.minQp = minQp;
        }

        @Override
        public final Builder minQp(Integer minQp) {
            this.minQp = minQp;
            return this;
        }

        public final String getDeblocking() {
            return deblocking;
        }

        public final void setDeblocking(String deblocking) {
            this.deblocking = deblocking;
        }

        @Override
        public final Builder deblocking(String deblocking) {
            this.deblocking = deblocking;
            return this;
        }

        @Override
        public final Builder deblocking(H265Deblocking deblocking) {
            this.deblocking(deblocking == null ? null : deblocking.toString());
            return this;
        }

        @Override
        public H265Settings build() {
            return new H265Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
