/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A network route configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDestinationRoute implements SdkPojo, Serializable,
        ToCopyableBuilder<InputDestinationRoute.Builder, InputDestinationRoute> {
    private static final SdkField<String> CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Cidr")
            .getter(getter(InputDestinationRoute::cidr)).setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidr").build()).build();

    private static final SdkField<String> GATEWAY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Gateway")
            .getter(getter(InputDestinationRoute::gateway)).setter(setter(Builder::gateway))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gateway").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, GATEWAY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cidr;

    private final String gateway;

    private InputDestinationRoute(BuilderImpl builder) {
        this.cidr = builder.cidr;
        this.gateway = builder.gateway;
    }

    /**
     * The CIDR of the route.
     * 
     * @return The CIDR of the route.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * An optional gateway for the route.
     * 
     * @return An optional gateway for the route.
     */
    public final String gateway() {
        return gateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(gateway());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDestinationRoute)) {
            return false;
        }
        InputDestinationRoute other = (InputDestinationRoute) obj;
        return Objects.equals(cidr(), other.cidr()) && Objects.equals(gateway(), other.gateway());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDestinationRoute").add("Cidr", cidr()).add("Gateway", gateway()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "Gateway":
            return Optional.ofNullable(clazz.cast(gateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cidr", CIDR_FIELD);
        map.put("gateway", GATEWAY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputDestinationRoute, T> g) {
        return obj -> g.apply((InputDestinationRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDestinationRoute> {
        /**
         * The CIDR of the route.
         * 
         * @param cidr
         *        The CIDR of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * An optional gateway for the route.
         * 
         * @param gateway
         *        An optional gateway for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gateway(String gateway);
    }

    static final class BuilderImpl implements Builder {
        private String cidr;

        private String gateway;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDestinationRoute model) {
            cidr(model.cidr);
            gateway(model.gateway);
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getGateway() {
            return gateway;
        }

        public final void setGateway(String gateway) {
            this.gateway = gateway;
        }

        @Override
        public final Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        @Override
        public InputDestinationRoute build() {
            return new InputDestinationRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
