/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings that describe the active source from the input device, and the video characteristics of that source.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDeviceUhdSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<InputDeviceUhdSettings.Builder, InputDeviceUhdSettings> {
    private static final SdkField<String> ACTIVE_INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveInput").getter(getter(InputDeviceUhdSettings::activeInputAsString))
            .setter(setter(Builder::activeInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeInput").build()).build();

    private static final SdkField<String> CONFIGURED_INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfiguredInput").getter(getter(InputDeviceUhdSettings::configuredInputAsString))
            .setter(setter(Builder::configuredInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredInput").build()).build();

    private static final SdkField<String> DEVICE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceState").getter(getter(InputDeviceUhdSettings::deviceStateAsString))
            .setter(setter(Builder::deviceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceState").build()).build();

    private static final SdkField<Double> FRAMERATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Framerate").getter(getter(InputDeviceUhdSettings::framerate)).setter(setter(Builder::framerate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerate").build()).build();

    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Height").getter(getter(InputDeviceUhdSettings::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()).build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxBitrate").getter(getter(InputDeviceUhdSettings::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanType").getter(getter(InputDeviceUhdSettings::scanTypeAsString)).setter(setter(Builder::scanType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()).build();

    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Width")
            .getter(getter(InputDeviceUhdSettings::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()).build();

    private static final SdkField<Integer> LATENCY_MS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LatencyMs").getter(getter(InputDeviceUhdSettings::latencyMs)).setter(setter(Builder::latencyMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMs").build()).build();

    private static final SdkField<String> CODEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Codec")
            .getter(getter(InputDeviceUhdSettings::codecAsString)).setter(setter(Builder::codec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()).build();

    private static final SdkField<InputDeviceMediaConnectSettings> MEDIACONNECT_SETTINGS_FIELD = SdkField
            .<InputDeviceMediaConnectSettings> builder(MarshallingType.SDK_POJO).memberName("MediaconnectSettings")
            .getter(getter(InputDeviceUhdSettings::mediaconnectSettings)).setter(setter(Builder::mediaconnectSettings))
            .constructor(InputDeviceMediaConnectSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaconnectSettings").build())
            .build();

    private static final SdkField<List<InputDeviceUhdAudioChannelPairConfig>> AUDIO_CHANNEL_PAIRS_FIELD = SdkField
            .<List<InputDeviceUhdAudioChannelPairConfig>> builder(MarshallingType.LIST)
            .memberName("AudioChannelPairs")
            .getter(getter(InputDeviceUhdSettings::audioChannelPairs))
            .setter(setter(Builder::audioChannelPairs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioChannelPairs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputDeviceUhdAudioChannelPairConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputDeviceUhdAudioChannelPairConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_INPUT_FIELD,
            CONFIGURED_INPUT_FIELD, DEVICE_STATE_FIELD, FRAMERATE_FIELD, HEIGHT_FIELD, MAX_BITRATE_FIELD, SCAN_TYPE_FIELD,
            WIDTH_FIELD, LATENCY_MS_FIELD, CODEC_FIELD, MEDIACONNECT_SETTINGS_FIELD, AUDIO_CHANNEL_PAIRS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String activeInput;

    private final String configuredInput;

    private final String deviceState;

    private final Double framerate;

    private final Integer height;

    private final Integer maxBitrate;

    private final String scanType;

    private final Integer width;

    private final Integer latencyMs;

    private final String codec;

    private final InputDeviceMediaConnectSettings mediaconnectSettings;

    private final List<InputDeviceUhdAudioChannelPairConfig> audioChannelPairs;

    private InputDeviceUhdSettings(BuilderImpl builder) {
        this.activeInput = builder.activeInput;
        this.configuredInput = builder.configuredInput;
        this.deviceState = builder.deviceState;
        this.framerate = builder.framerate;
        this.height = builder.height;
        this.maxBitrate = builder.maxBitrate;
        this.scanType = builder.scanType;
        this.width = builder.width;
        this.latencyMs = builder.latencyMs;
        this.codec = builder.codec;
        this.mediaconnectSettings = builder.mediaconnectSettings;
        this.audioChannelPairs = builder.audioChannelPairs;
    }

    /**
     * If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or HDMI).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activeInput} will
     * return {@link InputDeviceActiveInput#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #activeInputAsString}.
     * </p>
     * 
     * @return If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or
     *         HDMI).
     * @see InputDeviceActiveInput
     */
    public final InputDeviceActiveInput activeInput() {
        return InputDeviceActiveInput.fromValue(activeInput);
    }

    /**
     * If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or HDMI).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activeInput} will
     * return {@link InputDeviceActiveInput#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #activeInputAsString}.
     * </p>
     * 
     * @return If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or
     *         HDMI).
     * @see InputDeviceActiveInput
     */
    public final String activeInputAsString() {
        return activeInput;
    }

    /**
     * The source at the input device that is currently active. You can specify this source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configuredInput}
     * will return {@link InputDeviceConfiguredInput#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #configuredInputAsString}.
     * </p>
     * 
     * @return The source at the input device that is currently active. You can specify this source.
     * @see InputDeviceConfiguredInput
     */
    public final InputDeviceConfiguredInput configuredInput() {
        return InputDeviceConfiguredInput.fromValue(configuredInput);
    }

    /**
     * The source at the input device that is currently active. You can specify this source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #configuredInput}
     * will return {@link InputDeviceConfiguredInput#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #configuredInputAsString}.
     * </p>
     * 
     * @return The source at the input device that is currently active. You can specify this source.
     * @see InputDeviceConfiguredInput
     */
    public final String configuredInputAsString() {
        return configuredInput;
    }

    /**
     * The state of the input device.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceState} will
     * return {@link InputDeviceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStateAsString}.
     * </p>
     * 
     * @return The state of the input device.
     * @see InputDeviceState
     */
    public final InputDeviceState deviceState() {
        return InputDeviceState.fromValue(deviceState);
    }

    /**
     * The state of the input device.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceState} will
     * return {@link InputDeviceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceStateAsString}.
     * </p>
     * 
     * @return The state of the input device.
     * @see InputDeviceState
     */
    public final String deviceStateAsString() {
        return deviceState;
    }

    /**
     * The frame rate of the video source.
     * 
     * @return The frame rate of the video source.
     */
    public final Double framerate() {
        return framerate;
    }

    /**
     * The height of the video source, in pixels.
     * 
     * @return The height of the video source, in pixels.
     */
    public final Integer height() {
        return height;
    }

    /**
     * The current maximum bitrate for ingesting this source, in bits per second. You can specify this maximum.
     * 
     * @return The current maximum bitrate for ingesting this source, in bits per second. You can specify this maximum.
     */
    public final Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * The scan type of the video source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanType} will
     * return {@link InputDeviceScanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scanTypeAsString}.
     * </p>
     * 
     * @return The scan type of the video source.
     * @see InputDeviceScanType
     */
    public final InputDeviceScanType scanType() {
        return InputDeviceScanType.fromValue(scanType);
    }

    /**
     * The scan type of the video source.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanType} will
     * return {@link InputDeviceScanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scanTypeAsString}.
     * </p>
     * 
     * @return The scan type of the video source.
     * @see InputDeviceScanType
     */
    public final String scanTypeAsString() {
        return scanType;
    }

    /**
     * The width of the video source, in pixels.
     * 
     * @return The width of the video source, in pixels.
     */
    public final Integer width() {
        return width;
    }

    /**
     * The Link device's buffer size (latency) in milliseconds (ms). You can specify this value.
     * 
     * @return The Link device's buffer size (latency) in milliseconds (ms). You can specify this value.
     */
    public final Integer latencyMs() {
        return latencyMs;
    }

    /**
     * The codec for the video that the device produces.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codec} will return
     * {@link InputDeviceCodec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecAsString}.
     * </p>
     * 
     * @return The codec for the video that the device produces.
     * @see InputDeviceCodec
     */
    public final InputDeviceCodec codec() {
        return InputDeviceCodec.fromValue(codec);
    }

    /**
     * The codec for the video that the device produces.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codec} will return
     * {@link InputDeviceCodec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecAsString}.
     * </p>
     * 
     * @return The codec for the video that the device produces.
     * @see InputDeviceCodec
     */
    public final String codecAsString() {
        return codec;
    }

    /**
     * Information about the MediaConnect flow attached to the device. Returned only if the outputType is
     * MEDIACONNECT_FLOW.
     * 
     * @return Information about the MediaConnect flow attached to the device. Returned only if the outputType is
     *         MEDIACONNECT_FLOW.
     */
    public final InputDeviceMediaConnectSettings mediaconnectSettings() {
        return mediaconnectSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the AudioChannelPairs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAudioChannelPairs() {
        return audioChannelPairs != null && !(audioChannelPairs instanceof SdkAutoConstructList);
    }

    /**
     * An array of eight audio configurations, one for each audio pair in the source. Each audio configuration specifies
     * either to exclude the pair, or to format it and include it in the output from the UHD device. Applies only when
     * the device is configured as the source for a MediaConnect flow.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudioChannelPairs} method.
     * </p>
     * 
     * @return An array of eight audio configurations, one for each audio pair in the source. Each audio configuration
     *         specifies either to exclude the pair, or to format it and include it in the output from the UHD device.
     *         Applies only when the device is configured as the source for a MediaConnect flow.
     */
    public final List<InputDeviceUhdAudioChannelPairConfig> audioChannelPairs() {
        return audioChannelPairs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeInputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configuredInputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerate());
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(scanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        hashCode = 31 * hashCode + Objects.hashCode(latencyMs());
        hashCode = 31 * hashCode + Objects.hashCode(codecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mediaconnectSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasAudioChannelPairs() ? audioChannelPairs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceUhdSettings)) {
            return false;
        }
        InputDeviceUhdSettings other = (InputDeviceUhdSettings) obj;
        return Objects.equals(activeInputAsString(), other.activeInputAsString())
                && Objects.equals(configuredInputAsString(), other.configuredInputAsString())
                && Objects.equals(deviceStateAsString(), other.deviceStateAsString())
                && Objects.equals(framerate(), other.framerate()) && Objects.equals(height(), other.height())
                && Objects.equals(maxBitrate(), other.maxBitrate())
                && Objects.equals(scanTypeAsString(), other.scanTypeAsString()) && Objects.equals(width(), other.width())
                && Objects.equals(latencyMs(), other.latencyMs()) && Objects.equals(codecAsString(), other.codecAsString())
                && Objects.equals(mediaconnectSettings(), other.mediaconnectSettings())
                && hasAudioChannelPairs() == other.hasAudioChannelPairs()
                && Objects.equals(audioChannelPairs(), other.audioChannelPairs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDeviceUhdSettings").add("ActiveInput", activeInputAsString())
                .add("ConfiguredInput", configuredInputAsString()).add("DeviceState", deviceStateAsString())
                .add("Framerate", framerate()).add("Height", height()).add("MaxBitrate", maxBitrate())
                .add("ScanType", scanTypeAsString()).add("Width", width()).add("LatencyMs", latencyMs())
                .add("Codec", codecAsString()).add("MediaconnectSettings", mediaconnectSettings())
                .add("AudioChannelPairs", hasAudioChannelPairs() ? audioChannelPairs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveInput":
            return Optional.ofNullable(clazz.cast(activeInputAsString()));
        case "ConfiguredInput":
            return Optional.ofNullable(clazz.cast(configuredInputAsString()));
        case "DeviceState":
            return Optional.ofNullable(clazz.cast(deviceStateAsString()));
        case "Framerate":
            return Optional.ofNullable(clazz.cast(framerate()));
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "ScanType":
            return Optional.ofNullable(clazz.cast(scanTypeAsString()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        case "LatencyMs":
            return Optional.ofNullable(clazz.cast(latencyMs()));
        case "Codec":
            return Optional.ofNullable(clazz.cast(codecAsString()));
        case "MediaconnectSettings":
            return Optional.ofNullable(clazz.cast(mediaconnectSettings()));
        case "AudioChannelPairs":
            return Optional.ofNullable(clazz.cast(audioChannelPairs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("activeInput", ACTIVE_INPUT_FIELD);
        map.put("configuredInput", CONFIGURED_INPUT_FIELD);
        map.put("deviceState", DEVICE_STATE_FIELD);
        map.put("framerate", FRAMERATE_FIELD);
        map.put("height", HEIGHT_FIELD);
        map.put("maxBitrate", MAX_BITRATE_FIELD);
        map.put("scanType", SCAN_TYPE_FIELD);
        map.put("width", WIDTH_FIELD);
        map.put("latencyMs", LATENCY_MS_FIELD);
        map.put("codec", CODEC_FIELD);
        map.put("mediaconnectSettings", MEDIACONNECT_SETTINGS_FIELD);
        map.put("audioChannelPairs", AUDIO_CHANNEL_PAIRS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputDeviceUhdSettings, T> g) {
        return obj -> g.apply((InputDeviceUhdSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDeviceUhdSettings> {
        /**
         * If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or
         * HDMI).
         * 
         * @param activeInput
         *        If you specified Auto as the configured input, specifies which of the sources is currently active (SDI
         *        or HDMI).
         * @see InputDeviceActiveInput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceActiveInput
         */
        Builder activeInput(String activeInput);

        /**
         * If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or
         * HDMI).
         * 
         * @param activeInput
         *        If you specified Auto as the configured input, specifies which of the sources is currently active (SDI
         *        or HDMI).
         * @see InputDeviceActiveInput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceActiveInput
         */
        Builder activeInput(InputDeviceActiveInput activeInput);

        /**
         * The source at the input device that is currently active. You can specify this source.
         * 
         * @param configuredInput
         *        The source at the input device that is currently active. You can specify this source.
         * @see InputDeviceConfiguredInput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceConfiguredInput
         */
        Builder configuredInput(String configuredInput);

        /**
         * The source at the input device that is currently active. You can specify this source.
         * 
         * @param configuredInput
         *        The source at the input device that is currently active. You can specify this source.
         * @see InputDeviceConfiguredInput
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceConfiguredInput
         */
        Builder configuredInput(InputDeviceConfiguredInput configuredInput);

        /**
         * The state of the input device.
         * 
         * @param deviceState
         *        The state of the input device.
         * @see InputDeviceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceState
         */
        Builder deviceState(String deviceState);

        /**
         * The state of the input device.
         * 
         * @param deviceState
         *        The state of the input device.
         * @see InputDeviceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceState
         */
        Builder deviceState(InputDeviceState deviceState);

        /**
         * The frame rate of the video source.
         * 
         * @param framerate
         *        The frame rate of the video source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerate(Double framerate);

        /**
         * The height of the video source, in pixels.
         * 
         * @param height
         *        The height of the video source, in pixels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);

        /**
         * The current maximum bitrate for ingesting this source, in bits per second. You can specify this maximum.
         * 
         * @param maxBitrate
         *        The current maximum bitrate for ingesting this source, in bits per second. You can specify this
         *        maximum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * The scan type of the video source.
         * 
         * @param scanType
         *        The scan type of the video source.
         * @see InputDeviceScanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceScanType
         */
        Builder scanType(String scanType);

        /**
         * The scan type of the video source.
         * 
         * @param scanType
         *        The scan type of the video source.
         * @see InputDeviceScanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceScanType
         */
        Builder scanType(InputDeviceScanType scanType);

        /**
         * The width of the video source, in pixels.
         * 
         * @param width
         *        The width of the video source, in pixels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);

        /**
         * The Link device's buffer size (latency) in milliseconds (ms). You can specify this value.
         * 
         * @param latencyMs
         *        The Link device's buffer size (latency) in milliseconds (ms). You can specify this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latencyMs(Integer latencyMs);

        /**
         * The codec for the video that the device produces.
         * 
         * @param codec
         *        The codec for the video that the device produces.
         * @see InputDeviceCodec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceCodec
         */
        Builder codec(String codec);

        /**
         * The codec for the video that the device produces.
         * 
         * @param codec
         *        The codec for the video that the device produces.
         * @see InputDeviceCodec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeviceCodec
         */
        Builder codec(InputDeviceCodec codec);

        /**
         * Information about the MediaConnect flow attached to the device. Returned only if the outputType is
         * MEDIACONNECT_FLOW.
         * 
         * @param mediaconnectSettings
         *        Information about the MediaConnect flow attached to the device. Returned only if the outputType is
         *        MEDIACONNECT_FLOW.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaconnectSettings(InputDeviceMediaConnectSettings mediaconnectSettings);

        /**
         * Information about the MediaConnect flow attached to the device. Returned only if the outputType is
         * MEDIACONNECT_FLOW. This is a convenience method that creates an instance of the
         * {@link InputDeviceMediaConnectSettings.Builder} avoiding the need to create one manually via
         * {@link InputDeviceMediaConnectSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputDeviceMediaConnectSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #mediaconnectSettings(InputDeviceMediaConnectSettings)}.
         * 
         * @param mediaconnectSettings
         *        a consumer that will call methods on {@link InputDeviceMediaConnectSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaconnectSettings(InputDeviceMediaConnectSettings)
         */
        default Builder mediaconnectSettings(Consumer<InputDeviceMediaConnectSettings.Builder> mediaconnectSettings) {
            return mediaconnectSettings(InputDeviceMediaConnectSettings.builder().applyMutation(mediaconnectSettings).build());
        }

        /**
         * An array of eight audio configurations, one for each audio pair in the source. Each audio configuration
         * specifies either to exclude the pair, or to format it and include it in the output from the UHD device.
         * Applies only when the device is configured as the source for a MediaConnect flow.
         * 
         * @param audioChannelPairs
         *        An array of eight audio configurations, one for each audio pair in the source. Each audio
         *        configuration specifies either to exclude the pair, or to format it and include it in the output from
         *        the UHD device. Applies only when the device is configured as the source for a MediaConnect flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioChannelPairs(Collection<InputDeviceUhdAudioChannelPairConfig> audioChannelPairs);

        /**
         * An array of eight audio configurations, one for each audio pair in the source. Each audio configuration
         * specifies either to exclude the pair, or to format it and include it in the output from the UHD device.
         * Applies only when the device is configured as the source for a MediaConnect flow.
         * 
         * @param audioChannelPairs
         *        An array of eight audio configurations, one for each audio pair in the source. Each audio
         *        configuration specifies either to exclude the pair, or to format it and include it in the output from
         *        the UHD device. Applies only when the device is configured as the source for a MediaConnect flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioChannelPairs(InputDeviceUhdAudioChannelPairConfig... audioChannelPairs);

        /**
         * An array of eight audio configurations, one for each audio pair in the source. Each audio configuration
         * specifies either to exclude the pair, or to format it and include it in the output from the UHD device.
         * Applies only when the device is configured as the source for a MediaConnect flow. This is a convenience
         * method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.InputDeviceUhdAudioChannelPairConfig.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.InputDeviceUhdAudioChannelPairConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.InputDeviceUhdAudioChannelPairConfig.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #audioChannelPairs(List<InputDeviceUhdAudioChannelPairConfig>)}.
         * 
         * @param audioChannelPairs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.InputDeviceUhdAudioChannelPairConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioChannelPairs(java.util.Collection<InputDeviceUhdAudioChannelPairConfig>)
         */
        Builder audioChannelPairs(Consumer<InputDeviceUhdAudioChannelPairConfig.Builder>... audioChannelPairs);
    }

    static final class BuilderImpl implements Builder {
        private String activeInput;

        private String configuredInput;

        private String deviceState;

        private Double framerate;

        private Integer height;

        private Integer maxBitrate;

        private String scanType;

        private Integer width;

        private Integer latencyMs;

        private String codec;

        private InputDeviceMediaConnectSettings mediaconnectSettings;

        private List<InputDeviceUhdAudioChannelPairConfig> audioChannelPairs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InputDeviceUhdSettings model) {
            activeInput(model.activeInput);
            configuredInput(model.configuredInput);
            deviceState(model.deviceState);
            framerate(model.framerate);
            height(model.height);
            maxBitrate(model.maxBitrate);
            scanType(model.scanType);
            width(model.width);
            latencyMs(model.latencyMs);
            codec(model.codec);
            mediaconnectSettings(model.mediaconnectSettings);
            audioChannelPairs(model.audioChannelPairs);
        }

        public final String getActiveInput() {
            return activeInput;
        }

        public final void setActiveInput(String activeInput) {
            this.activeInput = activeInput;
        }

        @Override
        public final Builder activeInput(String activeInput) {
            this.activeInput = activeInput;
            return this;
        }

        @Override
        public final Builder activeInput(InputDeviceActiveInput activeInput) {
            this.activeInput(activeInput == null ? null : activeInput.toString());
            return this;
        }

        public final String getConfiguredInput() {
            return configuredInput;
        }

        public final void setConfiguredInput(String configuredInput) {
            this.configuredInput = configuredInput;
        }

        @Override
        public final Builder configuredInput(String configuredInput) {
            this.configuredInput = configuredInput;
            return this;
        }

        @Override
        public final Builder configuredInput(InputDeviceConfiguredInput configuredInput) {
            this.configuredInput(configuredInput == null ? null : configuredInput.toString());
            return this;
        }

        public final String getDeviceState() {
            return deviceState;
        }

        public final void setDeviceState(String deviceState) {
            this.deviceState = deviceState;
        }

        @Override
        public final Builder deviceState(String deviceState) {
            this.deviceState = deviceState;
            return this;
        }

        @Override
        public final Builder deviceState(InputDeviceState deviceState) {
            this.deviceState(deviceState == null ? null : deviceState.toString());
            return this;
        }

        public final Double getFramerate() {
            return framerate;
        }

        public final void setFramerate(Double framerate) {
            this.framerate = framerate;
        }

        @Override
        public final Builder framerate(Double framerate) {
            this.framerate = framerate;
            return this;
        }

        public final Integer getHeight() {
            return height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final String getScanType() {
            return scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(InputDeviceScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public final Integer getWidth() {
            return width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final Integer getLatencyMs() {
            return latencyMs;
        }

        public final void setLatencyMs(Integer latencyMs) {
            this.latencyMs = latencyMs;
        }

        @Override
        public final Builder latencyMs(Integer latencyMs) {
            this.latencyMs = latencyMs;
            return this;
        }

        public final String getCodec() {
            return codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        public final Builder codec(InputDeviceCodec codec) {
            this.codec(codec == null ? null : codec.toString());
            return this;
        }

        public final InputDeviceMediaConnectSettings.Builder getMediaconnectSettings() {
            return mediaconnectSettings != null ? mediaconnectSettings.toBuilder() : null;
        }

        public final void setMediaconnectSettings(InputDeviceMediaConnectSettings.BuilderImpl mediaconnectSettings) {
            this.mediaconnectSettings = mediaconnectSettings != null ? mediaconnectSettings.build() : null;
        }

        @Override
        public final Builder mediaconnectSettings(InputDeviceMediaConnectSettings mediaconnectSettings) {
            this.mediaconnectSettings = mediaconnectSettings;
            return this;
        }

        public final List<InputDeviceUhdAudioChannelPairConfig.Builder> getAudioChannelPairs() {
            List<InputDeviceUhdAudioChannelPairConfig.Builder> result = ___listOfInputDeviceUhdAudioChannelPairConfigCopier
                    .copyToBuilder(this.audioChannelPairs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudioChannelPairs(Collection<InputDeviceUhdAudioChannelPairConfig.BuilderImpl> audioChannelPairs) {
            this.audioChannelPairs = ___listOfInputDeviceUhdAudioChannelPairConfigCopier.copyFromBuilder(audioChannelPairs);
        }

        @Override
        public final Builder audioChannelPairs(Collection<InputDeviceUhdAudioChannelPairConfig> audioChannelPairs) {
            this.audioChannelPairs = ___listOfInputDeviceUhdAudioChannelPairConfigCopier.copy(audioChannelPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioChannelPairs(InputDeviceUhdAudioChannelPairConfig... audioChannelPairs) {
            audioChannelPairs(Arrays.asList(audioChannelPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioChannelPairs(Consumer<InputDeviceUhdAudioChannelPairConfig.Builder>... audioChannelPairs) {
            audioChannelPairs(Stream.of(audioChannelPairs)
                    .map(c -> InputDeviceUhdAudioChannelPairConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public InputDeviceUhdSettings build() {
            return new InputDeviceUhdSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
