/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for ListCloudWatchAlarmTemplatesResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCloudWatchAlarmTemplatesResponse extends MediaLiveResponse implements
        ToCopyableBuilder<ListCloudWatchAlarmTemplatesResponse.Builder, ListCloudWatchAlarmTemplatesResponse> {
    private static final SdkField<List<CloudWatchAlarmTemplateSummary>> CLOUD_WATCH_ALARM_TEMPLATES_FIELD = SdkField
            .<List<CloudWatchAlarmTemplateSummary>> builder(MarshallingType.LIST)
            .memberName("CloudWatchAlarmTemplates")
            .getter(getter(ListCloudWatchAlarmTemplatesResponse::cloudWatchAlarmTemplates))
            .setter(setter(Builder::cloudWatchAlarmTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchAlarmTemplates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudWatchAlarmTemplateSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudWatchAlarmTemplateSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCloudWatchAlarmTemplatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_ALARM_TEMPLATES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CloudWatchAlarmTemplateSummary> cloudWatchAlarmTemplates;

    private final String nextToken;

    private ListCloudWatchAlarmTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.cloudWatchAlarmTemplates = builder.cloudWatchAlarmTemplates;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CloudWatchAlarmTemplates property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCloudWatchAlarmTemplates() {
        return cloudWatchAlarmTemplates != null && !(cloudWatchAlarmTemplates instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the CloudWatchAlarmTemplates property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCloudWatchAlarmTemplates} method.
     * </p>
     * 
     * @return The value of the CloudWatchAlarmTemplates property for this object.
     */
    public final List<CloudWatchAlarmTemplateSummary> cloudWatchAlarmTemplates() {
        return cloudWatchAlarmTemplates;
    }

    /**
     * A token used to retrieve the next set of results in paginated list responses.
     * 
     * @return A token used to retrieve the next set of results in paginated list responses.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCloudWatchAlarmTemplates() ? cloudWatchAlarmTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCloudWatchAlarmTemplatesResponse)) {
            return false;
        }
        ListCloudWatchAlarmTemplatesResponse other = (ListCloudWatchAlarmTemplatesResponse) obj;
        return hasCloudWatchAlarmTemplates() == other.hasCloudWatchAlarmTemplates()
                && Objects.equals(cloudWatchAlarmTemplates(), other.cloudWatchAlarmTemplates())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCloudWatchAlarmTemplatesResponse")
                .add("CloudWatchAlarmTemplates", hasCloudWatchAlarmTemplates() ? cloudWatchAlarmTemplates() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchAlarmTemplates":
            return Optional.ofNullable(clazz.cast(cloudWatchAlarmTemplates()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudWatchAlarmTemplates", CLOUD_WATCH_ALARM_TEMPLATES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCloudWatchAlarmTemplatesResponse, T> g) {
        return obj -> g.apply((ListCloudWatchAlarmTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCloudWatchAlarmTemplatesResponse> {
        /**
         * Sets the value of the CloudWatchAlarmTemplates property for this object.
         *
         * @param cloudWatchAlarmTemplates
         *        The new value for the CloudWatchAlarmTemplates property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchAlarmTemplates(Collection<CloudWatchAlarmTemplateSummary> cloudWatchAlarmTemplates);

        /**
         * Sets the value of the CloudWatchAlarmTemplates property for this object.
         *
         * @param cloudWatchAlarmTemplates
         *        The new value for the CloudWatchAlarmTemplates property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchAlarmTemplates(CloudWatchAlarmTemplateSummary... cloudWatchAlarmTemplates);

        /**
         * Sets the value of the CloudWatchAlarmTemplates property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #cloudWatchAlarmTemplates(List<CloudWatchAlarmTemplateSummary>)}.
         * 
         * @param cloudWatchAlarmTemplates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchAlarmTemplates(java.util.Collection<CloudWatchAlarmTemplateSummary>)
         */
        Builder cloudWatchAlarmTemplates(Consumer<CloudWatchAlarmTemplateSummary.Builder>... cloudWatchAlarmTemplates);

        /**
         * A token used to retrieve the next set of results in paginated list responses.
         * 
         * @param nextToken
         *        A token used to retrieve the next set of results in paginated list responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private List<CloudWatchAlarmTemplateSummary> cloudWatchAlarmTemplates = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCloudWatchAlarmTemplatesResponse model) {
            super(model);
            cloudWatchAlarmTemplates(model.cloudWatchAlarmTemplates);
            nextToken(model.nextToken);
        }

        public final List<CloudWatchAlarmTemplateSummary.Builder> getCloudWatchAlarmTemplates() {
            List<CloudWatchAlarmTemplateSummary.Builder> result = ___listOfCloudWatchAlarmTemplateSummaryCopier
                    .copyToBuilder(this.cloudWatchAlarmTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudWatchAlarmTemplates(
                Collection<CloudWatchAlarmTemplateSummary.BuilderImpl> cloudWatchAlarmTemplates) {
            this.cloudWatchAlarmTemplates = ___listOfCloudWatchAlarmTemplateSummaryCopier
                    .copyFromBuilder(cloudWatchAlarmTemplates);
        }

        @Override
        public final Builder cloudWatchAlarmTemplates(Collection<CloudWatchAlarmTemplateSummary> cloudWatchAlarmTemplates) {
            this.cloudWatchAlarmTemplates = ___listOfCloudWatchAlarmTemplateSummaryCopier.copy(cloudWatchAlarmTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchAlarmTemplates(CloudWatchAlarmTemplateSummary... cloudWatchAlarmTemplates) {
            cloudWatchAlarmTemplates(Arrays.asList(cloudWatchAlarmTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchAlarmTemplates(
                Consumer<CloudWatchAlarmTemplateSummary.Builder>... cloudWatchAlarmTemplates) {
            cloudWatchAlarmTemplates(Stream.of(cloudWatchAlarmTemplates)
                    .map(c -> CloudWatchAlarmTemplateSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCloudWatchAlarmTemplatesResponse build() {
            return new ListCloudWatchAlarmTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
