/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Reference to an OutputDestination ID defined in the channel
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputLocationRef implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputLocationRef.Builder, OutputLocationRef> {
    private static final SdkField<String> DESTINATION_REF_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationRefId").getter(getter(OutputLocationRef::destinationRefId))
            .setter(setter(Builder::destinationRefId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationRefId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_REF_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationRefId;

    private OutputLocationRef(BuilderImpl builder) {
        this.destinationRefId = builder.destinationRefId;
    }

    /**
     * Returns the value of the DestinationRefId property for this object.
     * 
     * @return The value of the DestinationRefId property for this object.
     */
    public final String destinationRefId() {
        return destinationRefId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationRefId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputLocationRef)) {
            return false;
        }
        OutputLocationRef other = (OutputLocationRef) obj;
        return Objects.equals(destinationRefId(), other.destinationRefId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputLocationRef").add("DestinationRefId", destinationRefId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationRefId":
            return Optional.ofNullable(clazz.cast(destinationRefId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinationRefId", DESTINATION_REF_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutputLocationRef, T> g) {
        return obj -> g.apply((OutputLocationRef) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputLocationRef> {
        /**
         * Sets the value of the DestinationRefId property for this object.
         *
         * @param destinationRefId
         *        The new value for the DestinationRefId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationRefId(String destinationRefId);
    }

    static final class BuilderImpl implements Builder {
        private String destinationRefId;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputLocationRef model) {
            destinationRefId(model.destinationRefId);
        }

        public final String getDestinationRefId() {
            return destinationRefId;
        }

        public final void setDestinationRefId(String destinationRefId) {
            this.destinationRefId = destinationRefId;
        }

        @Override
        public final Builder destinationRefId(String destinationRefId) {
            this.destinationRefId = destinationRefId;
            return this;
        }

        @Override
        public OutputLocationRef build() {
            return new OutputLocationRef(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
