/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Configures the connection for a source that uses SRT as the connection protocol. In terms of establishing the
 * connection, MediaLive is always the caller and the upstream system is always the listener. In terms of transmission
 * of the source content, MediaLive is always the receiver and the upstream system is always the sender.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SrtCallerSourceRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<SrtCallerSourceRequest.Builder, SrtCallerSourceRequest> {
    private static final SdkField<SrtCallerDecryptionRequest> DECRYPTION_FIELD = SdkField
            .<SrtCallerDecryptionRequest> builder(MarshallingType.SDK_POJO).memberName("Decryption")
            .getter(getter(SrtCallerSourceRequest::decryption)).setter(setter(Builder::decryption))
            .constructor(SrtCallerDecryptionRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryption").build()).build();

    private static final SdkField<Integer> MINIMUM_LATENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumLatency").getter(getter(SrtCallerSourceRequest::minimumLatency))
            .setter(setter(Builder::minimumLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLatency").build()).build();

    private static final SdkField<String> SRT_LISTENER_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SrtListenerAddress").getter(getter(SrtCallerSourceRequest::srtListenerAddress))
            .setter(setter(Builder::srtListenerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtListenerAddress").build())
            .build();

    private static final SdkField<String> SRT_LISTENER_PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SrtListenerPort").getter(getter(SrtCallerSourceRequest::srtListenerPort))
            .setter(setter(Builder::srtListenerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtListenerPort").build()).build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamId").getter(getter(SrtCallerSourceRequest::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECRYPTION_FIELD,
            MINIMUM_LATENCY_FIELD, SRT_LISTENER_ADDRESS_FIELD, SRT_LISTENER_PORT_FIELD, STREAM_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SrtCallerDecryptionRequest decryption;

    private final Integer minimumLatency;

    private final String srtListenerAddress;

    private final String srtListenerPort;

    private final String streamId;

    private SrtCallerSourceRequest(BuilderImpl builder) {
        this.decryption = builder.decryption;
        this.minimumLatency = builder.minimumLatency;
        this.srtListenerAddress = builder.srtListenerAddress;
        this.srtListenerPort = builder.srtListenerPort;
        this.streamId = builder.streamId;
    }

    /**
     * Returns the value of the Decryption property for this object.
     * 
     * @return The value of the Decryption property for this object.
     */
    public final SrtCallerDecryptionRequest decryption() {
        return decryption;
    }

    /**
     * The preferred latency (in milliseconds) for implementing packet loss and recovery. Packet recovery is a key
     * feature of SRT. Obtain this value from the operator at the upstream system.
     * 
     * @return The preferred latency (in milliseconds) for implementing packet loss and recovery. Packet recovery is a
     *         key feature of SRT. Obtain this value from the operator at the upstream system.
     */
    public final Integer minimumLatency() {
        return minimumLatency;
    }

    /**
     * The IP address at the upstream system (the listener) that MediaLive (the caller) will connect to.
     * 
     * @return The IP address at the upstream system (the listener) that MediaLive (the caller) will connect to.
     */
    public final String srtListenerAddress() {
        return srtListenerAddress;
    }

    /**
     * The port at the upstream system (the listener) that MediaLive (the caller) will connect to.
     * 
     * @return The port at the upstream system (the listener) that MediaLive (the caller) will connect to.
     */
    public final String srtListenerPort() {
        return srtListenerPort;
    }

    /**
     * This value is required if the upstream system uses this identifier because without it, the SRT handshake between
     * MediaLive (the caller) and the upstream system (the listener) might fail.
     * 
     * @return This value is required if the upstream system uses this identifier because without it, the SRT handshake
     *         between MediaLive (the caller) and the upstream system (the listener) might fail.
     */
    public final String streamId() {
        return streamId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(decryption());
        hashCode = 31 * hashCode + Objects.hashCode(minimumLatency());
        hashCode = 31 * hashCode + Objects.hashCode(srtListenerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(srtListenerPort());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtCallerSourceRequest)) {
            return false;
        }
        SrtCallerSourceRequest other = (SrtCallerSourceRequest) obj;
        return Objects.equals(decryption(), other.decryption()) && Objects.equals(minimumLatency(), other.minimumLatency())
                && Objects.equals(srtListenerAddress(), other.srtListenerAddress())
                && Objects.equals(srtListenerPort(), other.srtListenerPort()) && Objects.equals(streamId(), other.streamId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SrtCallerSourceRequest").add("Decryption", decryption()).add("MinimumLatency", minimumLatency())
                .add("SrtListenerAddress", srtListenerAddress()).add("SrtListenerPort", srtListenerPort())
                .add("StreamId", streamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Decryption":
            return Optional.ofNullable(clazz.cast(decryption()));
        case "MinimumLatency":
            return Optional.ofNullable(clazz.cast(minimumLatency()));
        case "SrtListenerAddress":
            return Optional.ofNullable(clazz.cast(srtListenerAddress()));
        case "SrtListenerPort":
            return Optional.ofNullable(clazz.cast(srtListenerPort()));
        case "StreamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("decryption", DECRYPTION_FIELD);
        map.put("minimumLatency", MINIMUM_LATENCY_FIELD);
        map.put("srtListenerAddress", SRT_LISTENER_ADDRESS_FIELD);
        map.put("srtListenerPort", SRT_LISTENER_PORT_FIELD);
        map.put("streamId", STREAM_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SrtCallerSourceRequest, T> g) {
        return obj -> g.apply((SrtCallerSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SrtCallerSourceRequest> {
        /**
         * Sets the value of the Decryption property for this object.
         *
         * @param decryption
         *        The new value for the Decryption property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decryption(SrtCallerDecryptionRequest decryption);

        /**
         * Sets the value of the Decryption property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SrtCallerDecryptionRequest.Builder}
         * avoiding the need to create one manually via {@link SrtCallerDecryptionRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SrtCallerDecryptionRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #decryption(SrtCallerDecryptionRequest)}.
         * 
         * @param decryption
         *        a consumer that will call methods on {@link SrtCallerDecryptionRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decryption(SrtCallerDecryptionRequest)
         */
        default Builder decryption(Consumer<SrtCallerDecryptionRequest.Builder> decryption) {
            return decryption(SrtCallerDecryptionRequest.builder().applyMutation(decryption).build());
        }

        /**
         * The preferred latency (in milliseconds) for implementing packet loss and recovery. Packet recovery is a key
         * feature of SRT. Obtain this value from the operator at the upstream system.
         * 
         * @param minimumLatency
         *        The preferred latency (in milliseconds) for implementing packet loss and recovery. Packet recovery is
         *        a key feature of SRT. Obtain this value from the operator at the upstream system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumLatency(Integer minimumLatency);

        /**
         * The IP address at the upstream system (the listener) that MediaLive (the caller) will connect to.
         * 
         * @param srtListenerAddress
         *        The IP address at the upstream system (the listener) that MediaLive (the caller) will connect to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder srtListenerAddress(String srtListenerAddress);

        /**
         * The port at the upstream system (the listener) that MediaLive (the caller) will connect to.
         * 
         * @param srtListenerPort
         *        The port at the upstream system (the listener) that MediaLive (the caller) will connect to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder srtListenerPort(String srtListenerPort);

        /**
         * This value is required if the upstream system uses this identifier because without it, the SRT handshake
         * between MediaLive (the caller) and the upstream system (the listener) might fail.
         * 
         * @param streamId
         *        This value is required if the upstream system uses this identifier because without it, the SRT
         *        handshake between MediaLive (the caller) and the upstream system (the listener) might fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);
    }

    static final class BuilderImpl implements Builder {
        private SrtCallerDecryptionRequest decryption;

        private Integer minimumLatency;

        private String srtListenerAddress;

        private String srtListenerPort;

        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtCallerSourceRequest model) {
            decryption(model.decryption);
            minimumLatency(model.minimumLatency);
            srtListenerAddress(model.srtListenerAddress);
            srtListenerPort(model.srtListenerPort);
            streamId(model.streamId);
        }

        public final SrtCallerDecryptionRequest.Builder getDecryption() {
            return decryption != null ? decryption.toBuilder() : null;
        }

        public final void setDecryption(SrtCallerDecryptionRequest.BuilderImpl decryption) {
            this.decryption = decryption != null ? decryption.build() : null;
        }

        @Override
        public final Builder decryption(SrtCallerDecryptionRequest decryption) {
            this.decryption = decryption;
            return this;
        }

        public final Integer getMinimumLatency() {
            return minimumLatency;
        }

        public final void setMinimumLatency(Integer minimumLatency) {
            this.minimumLatency = minimumLatency;
        }

        @Override
        public final Builder minimumLatency(Integer minimumLatency) {
            this.minimumLatency = minimumLatency;
            return this;
        }

        public final String getSrtListenerAddress() {
            return srtListenerAddress;
        }

        public final void setSrtListenerAddress(String srtListenerAddress) {
            this.srtListenerAddress = srtListenerAddress;
        }

        @Override
        public final Builder srtListenerAddress(String srtListenerAddress) {
            this.srtListenerAddress = srtListenerAddress;
            return this;
        }

        public final String getSrtListenerPort() {
            return srtListenerPort;
        }

        public final void setSrtListenerPort(String srtListenerPort) {
            this.srtListenerPort = srtListenerPort;
        }

        @Override
        public final Builder srtListenerPort(String srtListenerPort) {
            this.srtListenerPort = srtListenerPort;
            return this;
        }

        public final String getStreamId() {
            return streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        @Override
        public SrtCallerSourceRequest build() {
            return new SrtCallerSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
