/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Teletext Source Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class TeletextSourceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<TeletextSourceSettings.Builder, TeletextSourceSettings> {
    private static final SdkField<CaptionRectangle> OUTPUT_RECTANGLE_FIELD = SdkField
            .<CaptionRectangle> builder(MarshallingType.SDK_POJO).memberName("OutputRectangle")
            .getter(getter(TeletextSourceSettings::outputRectangle)).setter(setter(Builder::outputRectangle))
            .constructor(CaptionRectangle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputRectangle").build()).build();

    private static final SdkField<String> PAGE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageNumber").getter(getter(TeletextSourceSettings::pageNumber)).setter(setter(Builder::pageNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_RECTANGLE_FIELD,
            PAGE_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CaptionRectangle outputRectangle;

    private final String pageNumber;

    private TeletextSourceSettings(BuilderImpl builder) {
        this.outputRectangle = builder.outputRectangle;
        this.pageNumber = builder.pageNumber;
    }

    /**
     * Optionally defines a region where TTML style captions will be displayed
     * 
     * @return Optionally defines a region where TTML style captions will be displayed
     */
    public final CaptionRectangle outputRectangle() {
        return outputRectangle;
    }

    /**
     * Specifies the teletext page number within the data stream from which to extract captions. Range of 0x100 (256) to
     * 0x8FF (2303). Unused for passthrough. Should be specified as a hexadecimal string with no "0x" prefix.
     * 
     * @return Specifies the teletext page number within the data stream from which to extract captions. Range of 0x100
     *         (256) to 0x8FF (2303). Unused for passthrough. Should be specified as a hexadecimal string with no "0x"
     *         prefix.
     */
    public final String pageNumber() {
        return pageNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputRectangle());
        hashCode = 31 * hashCode + Objects.hashCode(pageNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TeletextSourceSettings)) {
            return false;
        }
        TeletextSourceSettings other = (TeletextSourceSettings) obj;
        return Objects.equals(outputRectangle(), other.outputRectangle()) && Objects.equals(pageNumber(), other.pageNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TeletextSourceSettings").add("OutputRectangle", outputRectangle())
                .add("PageNumber", pageNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputRectangle":
            return Optional.ofNullable(clazz.cast(outputRectangle()));
        case "PageNumber":
            return Optional.ofNullable(clazz.cast(pageNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("outputRectangle", OUTPUT_RECTANGLE_FIELD);
        map.put("pageNumber", PAGE_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TeletextSourceSettings, T> g) {
        return obj -> g.apply((TeletextSourceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TeletextSourceSettings> {
        /**
         * Optionally defines a region where TTML style captions will be displayed
         * 
         * @param outputRectangle
         *        Optionally defines a region where TTML style captions will be displayed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputRectangle(CaptionRectangle outputRectangle);

        /**
         * Optionally defines a region where TTML style captions will be displayed This is a convenience method that
         * creates an instance of the {@link CaptionRectangle.Builder} avoiding the need to create one manually via
         * {@link CaptionRectangle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CaptionRectangle.Builder#build()} is called immediately and its
         * result is passed to {@link #outputRectangle(CaptionRectangle)}.
         * 
         * @param outputRectangle
         *        a consumer that will call methods on {@link CaptionRectangle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputRectangle(CaptionRectangle)
         */
        default Builder outputRectangle(Consumer<CaptionRectangle.Builder> outputRectangle) {
            return outputRectangle(CaptionRectangle.builder().applyMutation(outputRectangle).build());
        }

        /**
         * Specifies the teletext page number within the data stream from which to extract captions. Range of 0x100
         * (256) to 0x8FF (2303). Unused for passthrough. Should be specified as a hexadecimal string with no "0x"
         * prefix.
         * 
         * @param pageNumber
         *        Specifies the teletext page number within the data stream from which to extract captions. Range of
         *        0x100 (256) to 0x8FF (2303). Unused for passthrough. Should be specified as a hexadecimal string with
         *        no "0x" prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageNumber(String pageNumber);
    }

    static final class BuilderImpl implements Builder {
        private CaptionRectangle outputRectangle;

        private String pageNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(TeletextSourceSettings model) {
            outputRectangle(model.outputRectangle);
            pageNumber(model.pageNumber);
        }

        public final CaptionRectangle.Builder getOutputRectangle() {
            return outputRectangle != null ? outputRectangle.toBuilder() : null;
        }

        public final void setOutputRectangle(CaptionRectangle.BuilderImpl outputRectangle) {
            this.outputRectangle = outputRectangle != null ? outputRectangle.build() : null;
        }

        @Override
        public final Builder outputRectangle(CaptionRectangle outputRectangle) {
            this.outputRectangle = outputRectangle;
            return this;
        }

        public final String getPageNumber() {
            return pageNumber;
        }

        public final void setPageNumber(String pageNumber) {
            this.pageNumber = pageNumber;
        }

        @Override
        public final Builder pageNumber(String pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        @Override
        public TeletextSourceSettings build() {
            return new TeletextSourceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
