/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Details of a single thumbnail
 */
@Generated("software.amazon.awssdk:codegen")
public final class Thumbnail implements SdkPojo, Serializable, ToCopyableBuilder<Thumbnail.Builder, Thumbnail> {
    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Body")
            .getter(getter(Thumbnail::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(Thumbnail::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<String> THUMBNAIL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThumbnailType").getter(getter(Thumbnail::thumbnailTypeAsString)).setter(setter(Builder::thumbnailType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailType").build()).build();

    private static final SdkField<Instant> TIME_STAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("TimeStamp")
            .getter(getter(Thumbnail::timeStamp))
            .setter(setter(Builder::timeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeStamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD,
            CONTENT_TYPE_FIELD, THUMBNAIL_TYPE_FIELD, TIME_STAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String body;

    private final String contentType;

    private final String thumbnailType;

    private final Instant timeStamp;

    private Thumbnail(BuilderImpl builder) {
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.thumbnailType = builder.thumbnailType;
        this.timeStamp = builder.timeStamp;
    }

    /**
     * The binary data for the latest thumbnail.
     * 
     * @return The binary data for the latest thumbnail.
     */
    public final String body() {
        return body;
    }

    /**
     * The content type for the latest thumbnail.
     * 
     * @return The content type for the latest thumbnail.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * Thumbnail Type
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #thumbnailType}
     * will return {@link ThumbnailType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #thumbnailTypeAsString}.
     * </p>
     * 
     * @return Thumbnail Type
     * @see ThumbnailType
     */
    public final ThumbnailType thumbnailType() {
        return ThumbnailType.fromValue(thumbnailType);
    }

    /**
     * Thumbnail Type
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #thumbnailType}
     * will return {@link ThumbnailType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #thumbnailTypeAsString}.
     * </p>
     * 
     * @return Thumbnail Type
     * @see ThumbnailType
     */
    public final String thumbnailTypeAsString() {
        return thumbnailType;
    }

    /**
     * Time stamp for the latest thumbnail.
     * 
     * @return Time stamp for the latest thumbnail.
     */
    public final Instant timeStamp() {
        return timeStamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timeStamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Thumbnail)) {
            return false;
        }
        Thumbnail other = (Thumbnail) obj;
        return Objects.equals(body(), other.body()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(thumbnailTypeAsString(), other.thumbnailTypeAsString())
                && Objects.equals(timeStamp(), other.timeStamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Thumbnail").add("Body", body()).add("ContentType", contentType())
                .add("ThumbnailType", thumbnailTypeAsString()).add("TimeStamp", timeStamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "ThumbnailType":
            return Optional.ofNullable(clazz.cast(thumbnailTypeAsString()));
        case "TimeStamp":
            return Optional.ofNullable(clazz.cast(timeStamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("body", BODY_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        map.put("thumbnailType", THUMBNAIL_TYPE_FIELD);
        map.put("timeStamp", TIME_STAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Thumbnail, T> g) {
        return obj -> g.apply((Thumbnail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Thumbnail> {
        /**
         * The binary data for the latest thumbnail.
         * 
         * @param body
         *        The binary data for the latest thumbnail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * The content type for the latest thumbnail.
         * 
         * @param contentType
         *        The content type for the latest thumbnail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * Thumbnail Type
         * 
         * @param thumbnailType
         *        Thumbnail Type
         * @see ThumbnailType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThumbnailType
         */
        Builder thumbnailType(String thumbnailType);

        /**
         * Thumbnail Type
         * 
         * @param thumbnailType
         *        Thumbnail Type
         * @see ThumbnailType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThumbnailType
         */
        Builder thumbnailType(ThumbnailType thumbnailType);

        /**
         * Time stamp for the latest thumbnail.
         * 
         * @param timeStamp
         *        Time stamp for the latest thumbnail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeStamp(Instant timeStamp);
    }

    static final class BuilderImpl implements Builder {
        private String body;

        private String contentType;

        private String thumbnailType;

        private Instant timeStamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Thumbnail model) {
            body(model.body);
            contentType(model.contentType);
            thumbnailType(model.thumbnailType);
            timeStamp(model.timeStamp);
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getThumbnailType() {
            return thumbnailType;
        }

        public final void setThumbnailType(String thumbnailType) {
            this.thumbnailType = thumbnailType;
        }

        @Override
        public final Builder thumbnailType(String thumbnailType) {
            this.thumbnailType = thumbnailType;
            return this;
        }

        @Override
        public final Builder thumbnailType(ThumbnailType thumbnailType) {
            this.thumbnailType(thumbnailType == null ? null : thumbnailType.toString());
            return this;
        }

        public final Instant getTimeStamp() {
            return timeStamp;
        }

        public final void setTimeStamp(Instant timeStamp) {
            this.timeStamp = timeStamp;
        }

        @Override
        public final Builder timeStamp(Instant timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        @Override
        public Thumbnail build() {
            return new Thumbnail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
