/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for UpdateCloudWatchAlarmTemplateRequest
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCloudWatchAlarmTemplateRequest extends MediaLiveRequest implements
        ToCopyableBuilder<UpdateCloudWatchAlarmTemplateRequest.Builder, UpdateCloudWatchAlarmTemplateRequest> {
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComparisonOperator").getter(getter(UpdateCloudWatchAlarmTemplateRequest::comparisonOperatorAsString))
            .setter(setter(Builder::comparisonOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparisonOperator").build())
            .build();

    private static final SdkField<Integer> DATAPOINTS_TO_ALARM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DatapointsToAlarm").getter(getter(UpdateCloudWatchAlarmTemplateRequest::datapointsToAlarm))
            .setter(setter(Builder::datapointsToAlarm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datapointsToAlarm").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateCloudWatchAlarmTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Integer> EVALUATION_PERIODS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EvaluationPeriods").getter(getter(UpdateCloudWatchAlarmTemplateRequest::evaluationPeriods))
            .setter(setter(Builder::evaluationPeriods))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationPeriods").build()).build();

    private static final SdkField<String> GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupIdentifier").getter(getter(UpdateCloudWatchAlarmTemplateRequest::groupIdentifier))
            .setter(setter(Builder::groupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupIdentifier").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(UpdateCloudWatchAlarmTemplateRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(UpdateCloudWatchAlarmTemplateRequest::metricName))
            .setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateCloudWatchAlarmTemplateRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Period").getter(getter(UpdateCloudWatchAlarmTemplateRequest::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()).build();

    private static final SdkField<String> STATISTIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Statistic").getter(getter(UpdateCloudWatchAlarmTemplateRequest::statisticAsString))
            .setter(setter(Builder::statistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistic").build()).build();

    private static final SdkField<String> TARGET_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetResourceType").getter(getter(UpdateCloudWatchAlarmTemplateRequest::targetResourceTypeAsString))
            .setter(setter(Builder::targetResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceType").build())
            .build();

    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Threshold").getter(getter(UpdateCloudWatchAlarmTemplateRequest::threshold))
            .setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()).build();

    private static final SdkField<String> TREAT_MISSING_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TreatMissingData").getter(getter(UpdateCloudWatchAlarmTemplateRequest::treatMissingDataAsString))
            .setter(setter(Builder::treatMissingData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatMissingData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARISON_OPERATOR_FIELD,
            DATAPOINTS_TO_ALARM_FIELD, DESCRIPTION_FIELD, EVALUATION_PERIODS_FIELD, GROUP_IDENTIFIER_FIELD, IDENTIFIER_FIELD,
            METRIC_NAME_FIELD, NAME_FIELD, PERIOD_FIELD, STATISTIC_FIELD, TARGET_RESOURCE_TYPE_FIELD, THRESHOLD_FIELD,
            TREAT_MISSING_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String comparisonOperator;

    private final Integer datapointsToAlarm;

    private final String description;

    private final Integer evaluationPeriods;

    private final String groupIdentifier;

    private final String identifier;

    private final String metricName;

    private final String name;

    private final Integer period;

    private final String statistic;

    private final String targetResourceType;

    private final Double threshold;

    private final String treatMissingData;

    private UpdateCloudWatchAlarmTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.comparisonOperator = builder.comparisonOperator;
        this.datapointsToAlarm = builder.datapointsToAlarm;
        this.description = builder.description;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.groupIdentifier = builder.groupIdentifier;
        this.identifier = builder.identifier;
        this.metricName = builder.metricName;
        this.name = builder.name;
        this.period = builder.period;
        this.statistic = builder.statistic;
        this.targetResourceType = builder.targetResourceType;
        this.threshold = builder.threshold;
        this.treatMissingData = builder.treatMissingData;
    }

    /**
     * Returns the value of the ComparisonOperator property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link CloudWatchAlarmTemplateComparisonOperator#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The value of the ComparisonOperator property for this object.
     * @see CloudWatchAlarmTemplateComparisonOperator
     */
    public final CloudWatchAlarmTemplateComparisonOperator comparisonOperator() {
        return CloudWatchAlarmTemplateComparisonOperator.fromValue(comparisonOperator);
    }

    /**
     * Returns the value of the ComparisonOperator property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link CloudWatchAlarmTemplateComparisonOperator#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The value of the ComparisonOperator property for this object.
     * @see CloudWatchAlarmTemplateComparisonOperator
     */
    public final String comparisonOperatorAsString() {
        return comparisonOperator;
    }

    /**
     * The number of datapoints within the evaluation period that must be breaching to trigger the alarm.
     * 
     * @return The number of datapoints within the evaluation period that must be breaching to trigger the alarm.
     */
    public final Integer datapointsToAlarm() {
        return datapointsToAlarm;
    }

    /**
     * A resource's optional description.
     * 
     * @return A resource's optional description.
     */
    public final String description() {
        return description;
    }

    /**
     * The number of periods over which data is compared to the specified threshold.
     * 
     * @return The number of periods over which data is compared to the specified threshold.
     */
    public final Integer evaluationPeriods() {
        return evaluationPeriods;
    }

    /**
     * A cloudwatch alarm template group's identifier. Can be either be its id or current name.
     * 
     * @return A cloudwatch alarm template group's identifier. Can be either be its id or current name.
     */
    public final String groupIdentifier() {
        return groupIdentifier;
    }

    /**
     * A cloudwatch alarm template's identifier. Can be either be its id or current name.
     * 
     * @return A cloudwatch alarm template's identifier. Can be either be its id or current name.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * The name of the metric associated with the alarm. Must be compatible with targetResourceType.
     * 
     * @return The name of the metric associated with the alarm. Must be compatible with targetResourceType.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * A resource's name. Names must be unique within the scope of a resource type in a specific region.
     * 
     * @return A resource's name. Names must be unique within the scope of a resource type in a specific region.
     */
    public final String name() {
        return name;
    }

    /**
     * The period, in seconds, over which the specified statistic is applied.
     * 
     * @return The period, in seconds, over which the specified statistic is applied.
     */
    public final Integer period() {
        return period;
    }

    /**
     * Returns the value of the Statistic property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link CloudWatchAlarmTemplateStatistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statisticAsString}.
     * </p>
     * 
     * @return The value of the Statistic property for this object.
     * @see CloudWatchAlarmTemplateStatistic
     */
    public final CloudWatchAlarmTemplateStatistic statistic() {
        return CloudWatchAlarmTemplateStatistic.fromValue(statistic);
    }

    /**
     * Returns the value of the Statistic property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link CloudWatchAlarmTemplateStatistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statisticAsString}.
     * </p>
     * 
     * @return The value of the Statistic property for this object.
     * @see CloudWatchAlarmTemplateStatistic
     */
    public final String statisticAsString() {
        return statistic;
    }

    /**
     * Returns the value of the TargetResourceType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetResourceType} will return {@link CloudWatchAlarmTemplateTargetResourceType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #targetResourceTypeAsString}.
     * </p>
     * 
     * @return The value of the TargetResourceType property for this object.
     * @see CloudWatchAlarmTemplateTargetResourceType
     */
    public final CloudWatchAlarmTemplateTargetResourceType targetResourceType() {
        return CloudWatchAlarmTemplateTargetResourceType.fromValue(targetResourceType);
    }

    /**
     * Returns the value of the TargetResourceType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetResourceType} will return {@link CloudWatchAlarmTemplateTargetResourceType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #targetResourceTypeAsString}.
     * </p>
     * 
     * @return The value of the TargetResourceType property for this object.
     * @see CloudWatchAlarmTemplateTargetResourceType
     */
    public final String targetResourceTypeAsString() {
        return targetResourceType;
    }

    /**
     * The threshold value to compare with the specified statistic.
     * 
     * @return The threshold value to compare with the specified statistic.
     */
    public final Double threshold() {
        return threshold;
    }

    /**
     * Returns the value of the TreatMissingData property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #treatMissingData}
     * will return {@link CloudWatchAlarmTemplateTreatMissingData#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #treatMissingDataAsString}.
     * </p>
     * 
     * @return The value of the TreatMissingData property for this object.
     * @see CloudWatchAlarmTemplateTreatMissingData
     */
    public final CloudWatchAlarmTemplateTreatMissingData treatMissingData() {
        return CloudWatchAlarmTemplateTreatMissingData.fromValue(treatMissingData);
    }

    /**
     * Returns the value of the TreatMissingData property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #treatMissingData}
     * will return {@link CloudWatchAlarmTemplateTreatMissingData#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #treatMissingDataAsString}.
     * </p>
     * 
     * @return The value of the TreatMissingData property for this object.
     * @see CloudWatchAlarmTemplateTreatMissingData
     */
    public final String treatMissingDataAsString() {
        return treatMissingData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datapointsToAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(groupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        hashCode = 31 * hashCode + Objects.hashCode(treatMissingDataAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCloudWatchAlarmTemplateRequest)) {
            return false;
        }
        UpdateCloudWatchAlarmTemplateRequest other = (UpdateCloudWatchAlarmTemplateRequest) obj;
        return Objects.equals(comparisonOperatorAsString(), other.comparisonOperatorAsString())
                && Objects.equals(datapointsToAlarm(), other.datapointsToAlarm())
                && Objects.equals(description(), other.description())
                && Objects.equals(evaluationPeriods(), other.evaluationPeriods())
                && Objects.equals(groupIdentifier(), other.groupIdentifier()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(metricName(), other.metricName()) && Objects.equals(name(), other.name())
                && Objects.equals(period(), other.period()) && Objects.equals(statisticAsString(), other.statisticAsString())
                && Objects.equals(targetResourceTypeAsString(), other.targetResourceTypeAsString())
                && Objects.equals(threshold(), other.threshold())
                && Objects.equals(treatMissingDataAsString(), other.treatMissingDataAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCloudWatchAlarmTemplateRequest").add("ComparisonOperator", comparisonOperatorAsString())
                .add("DatapointsToAlarm", datapointsToAlarm()).add("Description", description())
                .add("EvaluationPeriods", evaluationPeriods()).add("GroupIdentifier", groupIdentifier())
                .add("Identifier", identifier()).add("MetricName", metricName()).add("Name", name()).add("Period", period())
                .add("Statistic", statisticAsString()).add("TargetResourceType", targetResourceTypeAsString())
                .add("Threshold", threshold()).add("TreatMissingData", treatMissingDataAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComparisonOperator":
            return Optional.ofNullable(clazz.cast(comparisonOperatorAsString()));
        case "DatapointsToAlarm":
            return Optional.ofNullable(clazz.cast(datapointsToAlarm()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EvaluationPeriods":
            return Optional.ofNullable(clazz.cast(evaluationPeriods()));
        case "GroupIdentifier":
            return Optional.ofNullable(clazz.cast(groupIdentifier()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        case "Statistic":
            return Optional.ofNullable(clazz.cast(statisticAsString()));
        case "TargetResourceType":
            return Optional.ofNullable(clazz.cast(targetResourceTypeAsString()));
        case "Threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        case "TreatMissingData":
            return Optional.ofNullable(clazz.cast(treatMissingDataAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("comparisonOperator", COMPARISON_OPERATOR_FIELD);
        map.put("datapointsToAlarm", DATAPOINTS_TO_ALARM_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("evaluationPeriods", EVALUATION_PERIODS_FIELD);
        map.put("groupIdentifier", GROUP_IDENTIFIER_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("metricName", METRIC_NAME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("period", PERIOD_FIELD);
        map.put("statistic", STATISTIC_FIELD);
        map.put("targetResourceType", TARGET_RESOURCE_TYPE_FIELD);
        map.put("threshold", THRESHOLD_FIELD);
        map.put("treatMissingData", TREAT_MISSING_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCloudWatchAlarmTemplateRequest, T> g) {
        return obj -> g.apply((UpdateCloudWatchAlarmTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateCloudWatchAlarmTemplateRequest> {
        /**
         * Sets the value of the ComparisonOperator property for this object.
         *
         * @param comparisonOperator
         *        The new value for the ComparisonOperator property for this object.
         * @see CloudWatchAlarmTemplateComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchAlarmTemplateComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * Sets the value of the ComparisonOperator property for this object.
         *
         * @param comparisonOperator
         *        The new value for the ComparisonOperator property for this object.
         * @see CloudWatchAlarmTemplateComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchAlarmTemplateComparisonOperator
         */
        Builder comparisonOperator(CloudWatchAlarmTemplateComparisonOperator comparisonOperator);

        /**
         * The number of datapoints within the evaluation period that must be breaching to trigger the alarm.
         * 
         * @param datapointsToAlarm
         *        The number of datapoints within the evaluation period that must be breaching to trigger the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datapointsToAlarm(Integer datapointsToAlarm);

        /**
         * A resource's optional description.
         * 
         * @param description
         *        A resource's optional description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The number of periods over which data is compared to the specified threshold.
         * 
         * @param evaluationPeriods
         *        The number of periods over which data is compared to the specified threshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationPeriods(Integer evaluationPeriods);

        /**
         * A cloudwatch alarm template group's identifier. Can be either be its id or current name.
         * 
         * @param groupIdentifier
         *        A cloudwatch alarm template group's identifier. Can be either be its id or current name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIdentifier(String groupIdentifier);

        /**
         * A cloudwatch alarm template's identifier. Can be either be its id or current name.
         * 
         * @param identifier
         *        A cloudwatch alarm template's identifier. Can be either be its id or current name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * The name of the metric associated with the alarm. Must be compatible with targetResourceType.
         * 
         * @param metricName
         *        The name of the metric associated with the alarm. Must be compatible with targetResourceType.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * A resource's name. Names must be unique within the scope of a resource type in a specific region.
         * 
         * @param name
         *        A resource's name. Names must be unique within the scope of a resource type in a specific region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The period, in seconds, over which the specified statistic is applied.
         * 
         * @param period
         *        The period, in seconds, over which the specified statistic is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * Sets the value of the Statistic property for this object.
         *
         * @param statistic
         *        The new value for the Statistic property for this object.
         * @see CloudWatchAlarmTemplateStatistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchAlarmTemplateStatistic
         */
        Builder statistic(String statistic);

        /**
         * Sets the value of the Statistic property for this object.
         *
         * @param statistic
         *        The new value for the Statistic property for this object.
         * @see CloudWatchAlarmTemplateStatistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchAlarmTemplateStatistic
         */
        Builder statistic(CloudWatchAlarmTemplateStatistic statistic);

        /**
         * Sets the value of the TargetResourceType property for this object.
         *
         * @param targetResourceType
         *        The new value for the TargetResourceType property for this object.
         * @see CloudWatchAlarmTemplateTargetResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchAlarmTemplateTargetResourceType
         */
        Builder targetResourceType(String targetResourceType);

        /**
         * Sets the value of the TargetResourceType property for this object.
         *
         * @param targetResourceType
         *        The new value for the TargetResourceType property for this object.
         * @see CloudWatchAlarmTemplateTargetResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchAlarmTemplateTargetResourceType
         */
        Builder targetResourceType(CloudWatchAlarmTemplateTargetResourceType targetResourceType);

        /**
         * The threshold value to compare with the specified statistic.
         * 
         * @param threshold
         *        The threshold value to compare with the specified statistic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Double threshold);

        /**
         * Sets the value of the TreatMissingData property for this object.
         *
         * @param treatMissingData
         *        The new value for the TreatMissingData property for this object.
         * @see CloudWatchAlarmTemplateTreatMissingData
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchAlarmTemplateTreatMissingData
         */
        Builder treatMissingData(String treatMissingData);

        /**
         * Sets the value of the TreatMissingData property for this object.
         *
         * @param treatMissingData
         *        The new value for the TreatMissingData property for this object.
         * @see CloudWatchAlarmTemplateTreatMissingData
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchAlarmTemplateTreatMissingData
         */
        Builder treatMissingData(CloudWatchAlarmTemplateTreatMissingData treatMissingData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String comparisonOperator;

        private Integer datapointsToAlarm;

        private String description;

        private Integer evaluationPeriods;

        private String groupIdentifier;

        private String identifier;

        private String metricName;

        private String name;

        private Integer period;

        private String statistic;

        private String targetResourceType;

        private Double threshold;

        private String treatMissingData;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCloudWatchAlarmTemplateRequest model) {
            super(model);
            comparisonOperator(model.comparisonOperator);
            datapointsToAlarm(model.datapointsToAlarm);
            description(model.description);
            evaluationPeriods(model.evaluationPeriods);
            groupIdentifier(model.groupIdentifier);
            identifier(model.identifier);
            metricName(model.metricName);
            name(model.name);
            period(model.period);
            statistic(model.statistic);
            targetResourceType(model.targetResourceType);
            threshold(model.threshold);
            treatMissingData(model.treatMissingData);
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(CloudWatchAlarmTemplateComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final Integer getDatapointsToAlarm() {
            return datapointsToAlarm;
        }

        public final void setDatapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
        }

        @Override
        public final Builder datapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getEvaluationPeriods() {
            return evaluationPeriods;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final String getGroupIdentifier() {
            return groupIdentifier;
        }

        public final void setGroupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
        }

        @Override
        public final Builder groupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPeriod() {
            return period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getStatistic() {
            return statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(CloudWatchAlarmTemplateStatistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final String getTargetResourceType() {
            return targetResourceType;
        }

        public final void setTargetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
        }

        @Override
        public final Builder targetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
            return this;
        }

        @Override
        public final Builder targetResourceType(CloudWatchAlarmTemplateTargetResourceType targetResourceType) {
            this.targetResourceType(targetResourceType == null ? null : targetResourceType.toString());
            return this;
        }

        public final Double getThreshold() {
            return threshold;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getTreatMissingData() {
            return treatMissingData;
        }

        public final void setTreatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
        }

        @Override
        public final Builder treatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        @Override
        public final Builder treatMissingData(CloudWatchAlarmTemplateTreatMissingData treatMissingData) {
            this.treatMissingData(treatMissingData == null ? null : treatMissingData.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCloudWatchAlarmTemplateRequest build() {
            return new UpdateCloudWatchAlarmTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
