/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to update the state of a node.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNodeStateRequest extends MediaLiveRequest implements
        ToCopyableBuilder<UpdateNodeStateRequest.Builder, UpdateNodeStateRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(UpdateNodeStateRequest::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterId").build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(UpdateNodeStateRequest::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("nodeId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(UpdateNodeStateRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            NODE_ID_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterId;

    private final String nodeId;

    private final String state;

    private UpdateNodeStateRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.nodeId = builder.nodeId;
        this.state = builder.state;
    }

    /**
     * The ID of the cluster
     * 
     * @return The ID of the cluster
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * The ID of the node.
     * 
     * @return The ID of the node.
     */
    public final String nodeId() {
        return nodeId;
    }

    /**
     * The state to apply to the Node. Set to ACTIVE (COMMISSIONED) to indicate that the Node is deployable. MediaLive
     * Anywhere will consider this node it needs a Node to run a Channel on, or when it needs a Node to promote from a
     * backup node to an active node. Set to DRAINING to isolate the Node so that MediaLive Anywhere won't use it.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link UpdateNodeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state to apply to the Node. Set to ACTIVE (COMMISSIONED) to indicate that the Node is deployable.
     *         MediaLive Anywhere will consider this node it needs a Node to run a Channel on, or when it needs a Node
     *         to promote from a backup node to an active node. Set to DRAINING to isolate the Node so that MediaLive
     *         Anywhere won't use it.
     * @see UpdateNodeState
     */
    public final UpdateNodeState state() {
        return UpdateNodeState.fromValue(state);
    }

    /**
     * The state to apply to the Node. Set to ACTIVE (COMMISSIONED) to indicate that the Node is deployable. MediaLive
     * Anywhere will consider this node it needs a Node to run a Channel on, or when it needs a Node to promote from a
     * backup node to an active node. Set to DRAINING to isolate the Node so that MediaLive Anywhere won't use it.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link UpdateNodeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state to apply to the Node. Set to ACTIVE (COMMISSIONED) to indicate that the Node is deployable.
     *         MediaLive Anywhere will consider this node it needs a Node to run a Channel on, or when it needs a Node
     *         to promote from a backup node to an active node. Set to DRAINING to isolate the Node so that MediaLive
     *         Anywhere won't use it.
     * @see UpdateNodeState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNodeStateRequest)) {
            return false;
        }
        UpdateNodeStateRequest other = (UpdateNodeStateRequest) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(nodeId(), other.nodeId())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateNodeStateRequest").add("ClusterId", clusterId()).add("NodeId", nodeId())
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterId", CLUSTER_ID_FIELD);
        map.put("nodeId", NODE_ID_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateNodeStateRequest, T> g) {
        return obj -> g.apply((UpdateNodeStateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateNodeStateRequest> {
        /**
         * The ID of the cluster
         * 
         * @param clusterId
         *        The ID of the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * The ID of the node.
         * 
         * @param nodeId
         *        The ID of the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * The state to apply to the Node. Set to ACTIVE (COMMISSIONED) to indicate that the Node is deployable.
         * MediaLive Anywhere will consider this node it needs a Node to run a Channel on, or when it needs a Node to
         * promote from a backup node to an active node. Set to DRAINING to isolate the Node so that MediaLive Anywhere
         * won't use it.
         * 
         * @param state
         *        The state to apply to the Node. Set to ACTIVE (COMMISSIONED) to indicate that the Node is deployable.
         *        MediaLive Anywhere will consider this node it needs a Node to run a Channel on, or when it needs a
         *        Node to promote from a backup node to an active node. Set to DRAINING to isolate the Node so that
         *        MediaLive Anywhere won't use it.
         * @see UpdateNodeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateNodeState
         */
        Builder state(String state);

        /**
         * The state to apply to the Node. Set to ACTIVE (COMMISSIONED) to indicate that the Node is deployable.
         * MediaLive Anywhere will consider this node it needs a Node to run a Channel on, or when it needs a Node to
         * promote from a backup node to an active node. Set to DRAINING to isolate the Node so that MediaLive Anywhere
         * won't use it.
         * 
         * @param state
         *        The state to apply to the Node. Set to ACTIVE (COMMISSIONED) to indicate that the Node is deployable.
         *        MediaLive Anywhere will consider this node it needs a Node to run a Channel on, or when it needs a
         *        Node to promote from a backup node to an active node. Set to DRAINING to isolate the Node so that
         *        MediaLive Anywhere won't use it.
         * @see UpdateNodeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateNodeState
         */
        Builder state(UpdateNodeState state);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String clusterId;

        private String nodeId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNodeStateRequest model) {
            super(model);
            clusterId(model.clusterId);
            nodeId(model.nodeId);
            state(model.state);
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(UpdateNodeState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNodeStateRequest build() {
            return new UpdateNodeStateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
