/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfCloudWatchAlarmTemplateSummaryCopier {
    static List<CloudWatchAlarmTemplateSummary> copy(
            Collection<? extends CloudWatchAlarmTemplateSummary> __listOfCloudWatchAlarmTemplateSummaryParam) {
        List<CloudWatchAlarmTemplateSummary> list;
        if (__listOfCloudWatchAlarmTemplateSummaryParam == null
                || __listOfCloudWatchAlarmTemplateSummaryParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CloudWatchAlarmTemplateSummary> modifiableList = new ArrayList<>(
                    __listOfCloudWatchAlarmTemplateSummaryParam.size());
            __listOfCloudWatchAlarmTemplateSummaryParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CloudWatchAlarmTemplateSummary> copyFromBuilder(
            Collection<? extends CloudWatchAlarmTemplateSummary.Builder> __listOfCloudWatchAlarmTemplateSummaryParam) {
        List<CloudWatchAlarmTemplateSummary> list;
        if (__listOfCloudWatchAlarmTemplateSummaryParam == null
                || __listOfCloudWatchAlarmTemplateSummaryParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CloudWatchAlarmTemplateSummary> modifiableList = new ArrayList<>(
                    __listOfCloudWatchAlarmTemplateSummaryParam.size());
            __listOfCloudWatchAlarmTemplateSummaryParam.forEach(entry -> {
                CloudWatchAlarmTemplateSummary member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CloudWatchAlarmTemplateSummary.Builder> copyToBuilder(
            Collection<? extends CloudWatchAlarmTemplateSummary> __listOfCloudWatchAlarmTemplateSummaryParam) {
        List<CloudWatchAlarmTemplateSummary.Builder> list;
        if (__listOfCloudWatchAlarmTemplateSummaryParam == null
                || __listOfCloudWatchAlarmTemplateSummaryParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CloudWatchAlarmTemplateSummary.Builder> modifiableList = new ArrayList<>(
                    __listOfCloudWatchAlarmTemplateSummaryParam.size());
            __listOfCloudWatchAlarmTemplateSummaryParam.forEach(entry -> {
                CloudWatchAlarmTemplateSummary.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
