/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfEventBridgeRuleTemplateTargetCopier {
    static List<EventBridgeRuleTemplateTarget> copy(
            Collection<? extends EventBridgeRuleTemplateTarget> __listOfEventBridgeRuleTemplateTargetParam) {
        List<EventBridgeRuleTemplateTarget> list;
        if (__listOfEventBridgeRuleTemplateTargetParam == null
                || __listOfEventBridgeRuleTemplateTargetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EventBridgeRuleTemplateTarget> modifiableList = new ArrayList<>(
                    __listOfEventBridgeRuleTemplateTargetParam.size());
            __listOfEventBridgeRuleTemplateTargetParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EventBridgeRuleTemplateTarget> copyFromBuilder(
            Collection<? extends EventBridgeRuleTemplateTarget.Builder> __listOfEventBridgeRuleTemplateTargetParam) {
        List<EventBridgeRuleTemplateTarget> list;
        if (__listOfEventBridgeRuleTemplateTargetParam == null
                || __listOfEventBridgeRuleTemplateTargetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EventBridgeRuleTemplateTarget> modifiableList = new ArrayList<>(
                    __listOfEventBridgeRuleTemplateTargetParam.size());
            __listOfEventBridgeRuleTemplateTargetParam.forEach(entry -> {
                EventBridgeRuleTemplateTarget member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EventBridgeRuleTemplateTarget.Builder> copyToBuilder(
            Collection<? extends EventBridgeRuleTemplateTarget> __listOfEventBridgeRuleTemplateTargetParam) {
        List<EventBridgeRuleTemplateTarget.Builder> list;
        if (__listOfEventBridgeRuleTemplateTargetParam == null
                || __listOfEventBridgeRuleTemplateTargetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EventBridgeRuleTemplateTarget.Builder> modifiableList = new ArrayList<>(
                    __listOfEventBridgeRuleTemplateTargetParam.size());
            __listOfEventBridgeRuleTemplateTargetParam.forEach(entry -> {
                EventBridgeRuleTemplateTarget.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
