/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive;

import static software.amazon.awssdk.utils.FunctionalUtils.runAndLogError;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.AsyncResponseTransformerUtils;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.medialive.internal.MediaLiveServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.medialive.model.AcceptInputDeviceTransferRequest;
import software.amazon.awssdk.services.medialive.model.AcceptInputDeviceTransferResponse;
import software.amazon.awssdk.services.medialive.model.BadGatewayException;
import software.amazon.awssdk.services.medialive.model.BadRequestException;
import software.amazon.awssdk.services.medialive.model.BatchDeleteRequest;
import software.amazon.awssdk.services.medialive.model.BatchDeleteResponse;
import software.amazon.awssdk.services.medialive.model.BatchStartRequest;
import software.amazon.awssdk.services.medialive.model.BatchStartResponse;
import software.amazon.awssdk.services.medialive.model.BatchStopRequest;
import software.amazon.awssdk.services.medialive.model.BatchStopResponse;
import software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleRequest;
import software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleResponse;
import software.amazon.awssdk.services.medialive.model.CancelInputDeviceTransferRequest;
import software.amazon.awssdk.services.medialive.model.CancelInputDeviceTransferResponse;
import software.amazon.awssdk.services.medialive.model.ClaimDeviceRequest;
import software.amazon.awssdk.services.medialive.model.ClaimDeviceResponse;
import software.amazon.awssdk.services.medialive.model.ConflictException;
import software.amazon.awssdk.services.medialive.model.CreateChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateChannelRequest;
import software.amazon.awssdk.services.medialive.model.CreateChannelResponse;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.CreateClusterRequest;
import software.amazon.awssdk.services.medialive.model.CreateClusterResponse;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.CreateNetworkRequest;
import software.amazon.awssdk.services.medialive.model.CreateNetworkResponse;
import software.amazon.awssdk.services.medialive.model.CreateNodeRegistrationScriptRequest;
import software.amazon.awssdk.services.medialive.model.CreateNodeRegistrationScriptResponse;
import software.amazon.awssdk.services.medialive.model.CreateNodeRequest;
import software.amazon.awssdk.services.medialive.model.CreateNodeResponse;
import software.amazon.awssdk.services.medialive.model.CreatePartnerInputRequest;
import software.amazon.awssdk.services.medialive.model.CreatePartnerInputResponse;
import software.amazon.awssdk.services.medialive.model.CreateSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.CreateSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.CreateTagsRequest;
import software.amazon.awssdk.services.medialive.model.CreateTagsResponse;
import software.amazon.awssdk.services.medialive.model.DeleteChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteChannelRequest;
import software.amazon.awssdk.services.medialive.model.DeleteChannelResponse;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.DeleteClusterRequest;
import software.amazon.awssdk.services.medialive.model.DeleteClusterResponse;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.DeleteNetworkRequest;
import software.amazon.awssdk.services.medialive.model.DeleteNetworkResponse;
import software.amazon.awssdk.services.medialive.model.DeleteNodeRequest;
import software.amazon.awssdk.services.medialive.model.DeleteNodeResponse;
import software.amazon.awssdk.services.medialive.model.DeleteReservationRequest;
import software.amazon.awssdk.services.medialive.model.DeleteReservationResponse;
import software.amazon.awssdk.services.medialive.model.DeleteScheduleRequest;
import software.amazon.awssdk.services.medialive.model.DeleteScheduleResponse;
import software.amazon.awssdk.services.medialive.model.DeleteSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.DeleteSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.DeleteTagsRequest;
import software.amazon.awssdk.services.medialive.model.DeleteTagsResponse;
import software.amazon.awssdk.services.medialive.model.DescribeAccountConfigurationRequest;
import software.amazon.awssdk.services.medialive.model.DescribeAccountConfigurationResponse;
import software.amazon.awssdk.services.medialive.model.DescribeChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.DescribeChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.DescribeChannelRequest;
import software.amazon.awssdk.services.medialive.model.DescribeChannelResponse;
import software.amazon.awssdk.services.medialive.model.DescribeClusterRequest;
import software.amazon.awssdk.services.medialive.model.DescribeClusterResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.DescribeNetworkRequest;
import software.amazon.awssdk.services.medialive.model.DescribeNetworkResponse;
import software.amazon.awssdk.services.medialive.model.DescribeNodeRequest;
import software.amazon.awssdk.services.medialive.model.DescribeNodeResponse;
import software.amazon.awssdk.services.medialive.model.DescribeOfferingRequest;
import software.amazon.awssdk.services.medialive.model.DescribeOfferingResponse;
import software.amazon.awssdk.services.medialive.model.DescribeReservationRequest;
import software.amazon.awssdk.services.medialive.model.DescribeReservationResponse;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse;
import software.amazon.awssdk.services.medialive.model.DescribeThumbnailsRequest;
import software.amazon.awssdk.services.medialive.model.DescribeThumbnailsResponse;
import software.amazon.awssdk.services.medialive.model.ForbiddenException;
import software.amazon.awssdk.services.medialive.model.GatewayTimeoutException;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.GetSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.GetSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.InternalServerErrorException;
import software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListChannelsRequest;
import software.amazon.awssdk.services.medialive.model.ListChannelsResponse;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesResponse;
import software.amazon.awssdk.services.medialive.model.ListClustersRequest;
import software.amazon.awssdk.services.medialive.model.ListClustersResponse;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesResponse;
import software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest;
import software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListInputsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputsResponse;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse;
import software.amazon.awssdk.services.medialive.model.ListNetworksRequest;
import software.amazon.awssdk.services.medialive.model.ListNetworksResponse;
import software.amazon.awssdk.services.medialive.model.ListNodesRequest;
import software.amazon.awssdk.services.medialive.model.ListNodesResponse;
import software.amazon.awssdk.services.medialive.model.ListOfferingsRequest;
import software.amazon.awssdk.services.medialive.model.ListOfferingsResponse;
import software.amazon.awssdk.services.medialive.model.ListReservationsRequest;
import software.amazon.awssdk.services.medialive.model.ListReservationsResponse;
import software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest;
import software.amazon.awssdk.services.medialive.model.ListSignalMapsResponse;
import software.amazon.awssdk.services.medialive.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.medialive.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.medialive.model.ListVersionsRequest;
import software.amazon.awssdk.services.medialive.model.ListVersionsResponse;
import software.amazon.awssdk.services.medialive.model.MediaLiveException;
import software.amazon.awssdk.services.medialive.model.NotFoundException;
import software.amazon.awssdk.services.medialive.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.medialive.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.medialive.model.RebootInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.RebootInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.RejectInputDeviceTransferRequest;
import software.amazon.awssdk.services.medialive.model.RejectInputDeviceTransferResponse;
import software.amazon.awssdk.services.medialive.model.RestartChannelPipelinesRequest;
import software.amazon.awssdk.services.medialive.model.RestartChannelPipelinesResponse;
import software.amazon.awssdk.services.medialive.model.StartChannelRequest;
import software.amazon.awssdk.services.medialive.model.StartChannelResponse;
import software.amazon.awssdk.services.medialive.model.StartDeleteMonitorDeploymentRequest;
import software.amazon.awssdk.services.medialive.model.StartDeleteMonitorDeploymentResponse;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceMaintenanceWindowRequest;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceMaintenanceWindowResponse;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.StartMonitorDeploymentRequest;
import software.amazon.awssdk.services.medialive.model.StartMonitorDeploymentResponse;
import software.amazon.awssdk.services.medialive.model.StartMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.StartMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.StartUpdateSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.StartUpdateSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.StopChannelRequest;
import software.amazon.awssdk.services.medialive.model.StopChannelResponse;
import software.amazon.awssdk.services.medialive.model.StopInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.StopInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.StopMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.StopMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.TooManyRequestsException;
import software.amazon.awssdk.services.medialive.model.TransferInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.TransferInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.UnprocessableEntityException;
import software.amazon.awssdk.services.medialive.model.UpdateAccountConfigurationRequest;
import software.amazon.awssdk.services.medialive.model.UpdateAccountConfigurationResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelClassRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelClassResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelResponse;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.UpdateClusterRequest;
import software.amazon.awssdk.services.medialive.model.UpdateClusterResponse;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.UpdateNetworkRequest;
import software.amazon.awssdk.services.medialive.model.UpdateNetworkResponse;
import software.amazon.awssdk.services.medialive.model.UpdateNodeRequest;
import software.amazon.awssdk.services.medialive.model.UpdateNodeResponse;
import software.amazon.awssdk.services.medialive.model.UpdateNodeStateRequest;
import software.amazon.awssdk.services.medialive.model.UpdateNodeStateResponse;
import software.amazon.awssdk.services.medialive.model.UpdateReservationRequest;
import software.amazon.awssdk.services.medialive.model.UpdateReservationResponse;
import software.amazon.awssdk.services.medialive.transform.AcceptInputDeviceTransferRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.BatchDeleteRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.BatchStartRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.BatchStopRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.BatchUpdateScheduleRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CancelInputDeviceTransferRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ClaimDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateChannelPlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateCloudWatchAlarmTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateCloudWatchAlarmTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateEventBridgeRuleTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateEventBridgeRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateInputSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateMultiplexProgramRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateNetworkRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateNodeRegistrationScriptRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateNodeRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreatePartnerInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateSignalMapRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteChannelPlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteCloudWatchAlarmTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteCloudWatchAlarmTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteEventBridgeRuleTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteEventBridgeRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteInputSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteMultiplexProgramRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteNetworkRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteNodeRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteReservationRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteScheduleRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteSignalMapRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeAccountConfigurationRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeChannelPlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeClusterRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeInputDeviceThumbnailRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeInputSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeMultiplexProgramRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeNetworkRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeNodeRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeOfferingRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeReservationRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeScheduleRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeThumbnailsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.GetCloudWatchAlarmTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.GetCloudWatchAlarmTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.GetEventBridgeRuleTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.GetEventBridgeRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.GetSignalMapRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListChannelPlacementGroupsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListChannelsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListCloudWatchAlarmTemplateGroupsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListCloudWatchAlarmTemplatesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListClustersRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListEventBridgeRuleTemplateGroupsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListEventBridgeRuleTemplatesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListInputDeviceTransfersRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListInputDevicesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListInputSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListInputsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListMultiplexProgramsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListMultiplexesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListNetworksRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListNodesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListOfferingsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListReservationsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListSignalMapsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListVersionsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.PurchaseOfferingRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.RebootInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.RejectInputDeviceTransferRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.RestartChannelPipelinesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartDeleteMonitorDeploymentRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartInputDeviceMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartMonitorDeploymentRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartUpdateSignalMapRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StopChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StopInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StopMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.TransferInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateAccountConfigurationRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateChannelClassRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateChannelPlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateCloudWatchAlarmTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateCloudWatchAlarmTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateEventBridgeRuleTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateEventBridgeRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateInputSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateMultiplexProgramRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateNetworkRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateNodeRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateNodeStateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateReservationRequestMarshaller;
import software.amazon.awssdk.services.medialive.waiters.MediaLiveAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Pair;

/**
 * Internal implementation of {@link MediaLiveAsyncClient}.
 *
 * @see MediaLiveAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultMediaLiveAsyncClient implements MediaLiveAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultMediaLiveAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultMediaLiveAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * Accept an incoming input device transfer. The ownership of the device will transfer to your AWS account.
     *
     * @param acceptInputDeviceTransferRequest
     *        Placeholder documentation for AcceptInputDeviceTransferRequest
     * @return A Java Future containing the result of the AcceptInputDeviceTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to accept input device transfers.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on transfer device calls to the input device service.
     *         </li>
     *         <li>ConflictException Input device transfer could not be accepted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.AcceptInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AcceptInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptInputDeviceTransferResponse> acceptInputDeviceTransfer(
            AcceptInputDeviceTransferRequest acceptInputDeviceTransferRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptInputDeviceTransferRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptInputDeviceTransferRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptInputDeviceTransfer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptInputDeviceTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AcceptInputDeviceTransferResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AcceptInputDeviceTransferResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptInputDeviceTransferRequest, AcceptInputDeviceTransferResponse>()
                            .withOperationName("AcceptInputDeviceTransfer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptInputDeviceTransferRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptInputDeviceTransferRequest));
            CompletableFuture<AcceptInputDeviceTransferResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Starts delete of resources.
     *
     * @param batchDeleteRequest
     *        A request to delete resources
     * @return A Java Future containing the result of the BatchDelete operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to delete the resources.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The resources you're requesting to delete do not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete resources calls.</li>
     *         <li>ConflictException The resources are unable to delete.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.BatchDelete
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchDelete" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteResponse> batchDelete(BatchDeleteRequest batchDeleteRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDelete");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDeleteResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    BatchDeleteResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDeleteResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteRequest, BatchDeleteResponse>()
                            .withOperationName("BatchDelete").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDeleteRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchDeleteRequest));
            CompletableFuture<BatchDeleteResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Starts existing resources
     *
     * @param batchStartRequest
     *        A request to start resources
     * @return A Java Future containing the result of the BatchStart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to start the resources.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The resources you're requesting to start do not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on start resources calls to resource service.</li>
     *         <li>ConflictException The resources are unable to start.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.BatchStart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchStart" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BatchStartResponse> batchStart(BatchStartRequest batchStartRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchStartRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchStartRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchStart");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchStartResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    BatchStartResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchStartResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchStartRequest, BatchStartResponse>().withOperationName("BatchStart")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchStartRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchStartRequest));
            CompletableFuture<BatchStartResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Stops running resources
     *
     * @param batchStopRequest
     *        A request to stop resources
     * @return A Java Future containing the result of the BatchStop operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to stop the resources.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The resources you're requesting to stop do not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on stop resources.</li>
     *         <li>ConflictException The resources are unable to stop.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.BatchStop
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchStop" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BatchStopResponse> batchStop(BatchStopRequest batchStopRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchStopRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchStopRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchStop");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchStopResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    BatchStopResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchStopResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchStopRequest, BatchStopResponse>().withOperationName("BatchStop")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchStopRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchStopRequest));
            CompletableFuture<BatchStopResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Update a channel schedule
     *
     * @param batchUpdateScheduleRequest
     *        List of actions to create and list of actions to delete.
     * @return A Java Future containing the result of the BatchUpdateSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The update schedule request failed validation.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to update the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The specified channel id does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on update schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.BatchUpdateSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchUpdateSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchUpdateScheduleResponse> batchUpdateSchedule(
            BatchUpdateScheduleRequest batchUpdateScheduleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchUpdateScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchUpdateScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchUpdateScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchUpdateScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchUpdateScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchUpdateScheduleRequest, BatchUpdateScheduleResponse>()
                            .withOperationName("BatchUpdateSchedule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchUpdateScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchUpdateScheduleRequest));
            CompletableFuture<BatchUpdateScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Cancel an input device transfer that you have requested.
     *
     * @param cancelInputDeviceTransferRequest
     *        Placeholder documentation for CancelInputDeviceTransferRequest
     * @return A Java Future containing the result of the CancelInputDeviceTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to cancel input device transfers.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on transfer device calls to the input device service.
     *         </li>
     *         <li>ConflictException Input device transfer could not be canceled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CancelInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CancelInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelInputDeviceTransferResponse> cancelInputDeviceTransfer(
            CancelInputDeviceTransferRequest cancelInputDeviceTransferRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelInputDeviceTransferRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelInputDeviceTransferRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelInputDeviceTransfer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelInputDeviceTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelInputDeviceTransferResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelInputDeviceTransferResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelInputDeviceTransferRequest, CancelInputDeviceTransferResponse>()
                            .withOperationName("CancelInputDeviceTransfer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelInputDeviceTransferRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelInputDeviceTransferRequest));
            CompletableFuture<CancelInputDeviceTransferResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Send a request to claim an AWS Elemental device that you have purchased from a third-party vendor. After the
     * request succeeds, you will own the device.
     *
     * @param claimDeviceRequest
     *        A request to claim an AWS Elemental device that you have purchased from a third-party vendor.
     * @return A Java Future containing the result of the ClaimDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Claim operation failed, device id could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have the IAM access permissions to claim this device. You must have
     *         permission for the WriteClaim operation.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Device not found or you called an unsupported region.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded. Your have sent this request too many times. There
     *         might be a bug in your API client.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ClaimDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ClaimDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ClaimDeviceResponse> claimDevice(ClaimDeviceRequest claimDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(claimDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, claimDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ClaimDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ClaimDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ClaimDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ClaimDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ClaimDeviceRequest, ClaimDeviceResponse>()
                            .withOperationName("ClaimDevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ClaimDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(claimDeviceRequest));
            CompletableFuture<ClaimDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a new channel
     *
     * @param createChannelRequest
     *        A request to create a channel
     * @return A Java Future containing the result of the CreateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The Channel failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to create the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on create channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to create due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateChannelResponse> createChannel(CreateChannelRequest createChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateChannelRequest, CreateChannelResponse>()
                            .withOperationName("CreateChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createChannelRequest));
            CompletableFuture<CreateChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Create a ChannelPlacementGroup in the specified Cluster. As part of the create operation, you specify the Nodes
     * to attach the group to.After you create a ChannelPlacementGroup, you add Channels to the group (you do this by
     * modifying the Channels to add them to a specific group). You now have an association of Channels to
     * ChannelPlacementGroup, and ChannelPlacementGroup to Nodes. This association means that all the Channels in the
     * group are able to run on any of the Nodes associated with the group.
     *
     * @param createChannelPlacementGroupRequest
     *        A request to create a channel placement group.
     * @return A Java Future containing the result of the CreateChannelPlacementGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The channel placement group failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to create a channel placement group in this cluster.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded in createNode calls to the cluster service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateChannelPlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannelPlacementGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateChannelPlacementGroupResponse> createChannelPlacementGroup(
            CreateChannelPlacementGroupRequest createChannelPlacementGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createChannelPlacementGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createChannelPlacementGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateChannelPlacementGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateChannelPlacementGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateChannelPlacementGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateChannelPlacementGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateChannelPlacementGroupRequest, CreateChannelPlacementGroupResponse>()
                            .withOperationName("CreateChannelPlacementGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateChannelPlacementGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createChannelPlacementGroupRequest));
            CompletableFuture<CreateChannelPlacementGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a cloudwatch alarm template to dynamically generate cloudwatch metric alarms on targeted resource types.
     *
     * @param createCloudWatchAlarmTemplateRequest
     *        Placeholder documentation for CreateCloudWatchAlarmTemplateRequest
     * @return A Java Future containing the result of the CreateCloudWatchAlarmTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCloudWatchAlarmTemplateResponse> createCloudWatchAlarmTemplate(
            CreateCloudWatchAlarmTemplateRequest createCloudWatchAlarmTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCloudWatchAlarmTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCloudWatchAlarmTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCloudWatchAlarmTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCloudWatchAlarmTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCloudWatchAlarmTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCloudWatchAlarmTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCloudWatchAlarmTemplateRequest, CreateCloudWatchAlarmTemplateResponse>()
                            .withOperationName("CreateCloudWatchAlarmTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCloudWatchAlarmTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCloudWatchAlarmTemplateRequest));
            CompletableFuture<CreateCloudWatchAlarmTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a cloudwatch alarm template group to group your cloudwatch alarm templates and to attach to signal maps
     * for dynamically creating alarms.
     *
     * @param createCloudWatchAlarmTemplateGroupRequest
     *        Placeholder documentation for CreateCloudWatchAlarmTemplateGroupRequest
     * @return A Java Future containing the result of the CreateCloudWatchAlarmTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCloudWatchAlarmTemplateGroupResponse> createCloudWatchAlarmTemplateGroup(
            CreateCloudWatchAlarmTemplateGroupRequest createCloudWatchAlarmTemplateGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCloudWatchAlarmTemplateGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCloudWatchAlarmTemplateGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCloudWatchAlarmTemplateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCloudWatchAlarmTemplateGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateCloudWatchAlarmTemplateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCloudWatchAlarmTemplateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCloudWatchAlarmTemplateGroupRequest, CreateCloudWatchAlarmTemplateGroupResponse>()
                            .withOperationName("CreateCloudWatchAlarmTemplateGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCloudWatchAlarmTemplateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCloudWatchAlarmTemplateGroupRequest));
            CompletableFuture<CreateCloudWatchAlarmTemplateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Create a new Cluster.
     *
     * @param createClusterRequest
     *        Create as many Clusters as you want, but create at least one. Each Cluster groups together Nodes that you
     *        want to treat as a collection. Within the Cluster, you will set up some Nodes as active Nodes, and some as
     *        backup Nodes, for Node failover purposes. Each Node can belong to only one Cluster.
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to create the Cluster.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on create Cluster calls to service.</li>
     *         <li>ConflictException The Cluster is unable to create due to an issue with cluster resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateClusterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateClusterRequest, CreateClusterResponse>()
                            .withOperationName("CreateCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createClusterRequest));
            CompletableFuture<CreateClusterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates an eventbridge rule template to monitor events and send notifications to your targeted resources.
     *
     * @param createEventBridgeRuleTemplateRequest
     *        Placeholder documentation for CreateEventBridgeRuleTemplateRequest
     * @return A Java Future containing the result of the CreateEventBridgeRuleTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEventBridgeRuleTemplateResponse> createEventBridgeRuleTemplate(
            CreateEventBridgeRuleTemplateRequest createEventBridgeRuleTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEventBridgeRuleTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createEventBridgeRuleTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventBridgeRuleTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEventBridgeRuleTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEventBridgeRuleTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEventBridgeRuleTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEventBridgeRuleTemplateRequest, CreateEventBridgeRuleTemplateResponse>()
                            .withOperationName("CreateEventBridgeRuleTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEventBridgeRuleTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEventBridgeRuleTemplateRequest));
            CompletableFuture<CreateEventBridgeRuleTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates an eventbridge rule template group to group your eventbridge rule templates and to attach to signal maps
     * for dynamically creating notification rules.
     *
     * @param createEventBridgeRuleTemplateGroupRequest
     *        Placeholder documentation for CreateEventBridgeRuleTemplateGroupRequest
     * @return A Java Future containing the result of the CreateEventBridgeRuleTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEventBridgeRuleTemplateGroupResponse> createEventBridgeRuleTemplateGroup(
            CreateEventBridgeRuleTemplateGroupRequest createEventBridgeRuleTemplateGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEventBridgeRuleTemplateGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createEventBridgeRuleTemplateGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventBridgeRuleTemplateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEventBridgeRuleTemplateGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateEventBridgeRuleTemplateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEventBridgeRuleTemplateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEventBridgeRuleTemplateGroupRequest, CreateEventBridgeRuleTemplateGroupResponse>()
                            .withOperationName("CreateEventBridgeRuleTemplateGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateEventBridgeRuleTemplateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createEventBridgeRuleTemplateGroupRequest));
            CompletableFuture<CreateEventBridgeRuleTemplateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Create an input
     *
     * @param createInputRequest
     *        The name of the input
     * @return A Java Future containing the result of the CreateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInput" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInputResponse> createInput(CreateInputRequest createInputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateInputResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInputRequest, CreateInputResponse>()
                            .withOperationName("CreateInput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateInputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createInputRequest));
            CompletableFuture<CreateInputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a Input Security Group
     *
     * @param createInputSecurityGroupRequest
     *        The IPv4 CIDRs to whitelist for this Input Security Group
     * @return A Java Future containing the result of the CreateInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to create an Input Security Group was Invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to create an Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInputSecurityGroupResponse> createInputSecurityGroup(
            CreateInputSecurityGroupRequest createInputSecurityGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInputSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInputSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInputSecurityGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInputSecurityGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateInputSecurityGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInputSecurityGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInputSecurityGroupRequest, CreateInputSecurityGroupResponse>()
                            .withOperationName("CreateInputSecurityGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateInputSecurityGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createInputSecurityGroupRequest));
            CompletableFuture<CreateInputSecurityGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Create a new multiplex.
     *
     * @param createMultiplexRequest
     *        A request to create a multiplex.
     * @return A Java Future containing the result of the CreateMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The Multiplex failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to create the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on create multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to create due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMultiplexResponse> createMultiplex(CreateMultiplexRequest createMultiplexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMultiplexRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMultiplexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMultiplex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMultiplexResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMultiplexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMultiplexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMultiplexRequest, CreateMultiplexResponse>()
                            .withOperationName("CreateMultiplex").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMultiplexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMultiplexRequest));
            CompletableFuture<CreateMultiplexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Create a new program in the multiplex.
     *
     * @param createMultiplexProgramRequest
     *        A request to create a program in a multiplex.
     * @return A Java Future containing the result of the CreateMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The Multiplex program failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to create a program.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on create multiplex program calls to multiplex
     *         service.</li>
     *         <li>ConflictException The multiplex program is unable to create due to an issue with multiplex resources.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMultiplexProgramResponse> createMultiplexProgram(
            CreateMultiplexProgramRequest createMultiplexProgramRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMultiplexProgramRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMultiplexProgramRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMultiplexProgram");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMultiplexProgramResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMultiplexProgramResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMultiplexProgramResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMultiplexProgramRequest, CreateMultiplexProgramResponse>()
                            .withOperationName("CreateMultiplexProgram").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMultiplexProgramRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMultiplexProgramRequest));
            CompletableFuture<CreateMultiplexProgramResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Create as many Networks as you need. You will associate one or more Clusters with each Network.Each Network
     * provides MediaLive Anywhere with required information about the network in your organization that you are using
     * for video encoding using MediaLive.
     *
     * @param createNetworkRequest
     *        A request to create a Network.
     * @return A Java Future containing the result of the CreateNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to create the Network.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on create Network calls to service.</li>
     *         <li>ConflictException The Network is unable to create due to an issue with network resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkResponse> createNetwork(CreateNetworkRequest createNetworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNetworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetwork");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateNetworkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateNetworkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateNetworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkRequest, CreateNetworkResponse>()
                            .withOperationName("CreateNetwork").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateNetworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNetworkRequest));
            CompletableFuture<CreateNetworkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Create a Node in the specified Cluster. You can also create Nodes using the CreateNodeRegistrationScript. Note
     * that you can't move a Node to another Cluster.
     *
     * @param createNodeRequest
     *        A request to create a node
     * @return A Java Future containing the result of the CreateNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The node failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to create a node in this cluster.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded in createNode calls to the cluster service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateNode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNodeResponse> createNode(CreateNodeRequest createNodeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateNodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateNodeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateNodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNodeRequest, CreateNodeResponse>().withOperationName("CreateNode")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateNodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNodeRequest));
            CompletableFuture<CreateNodeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Create the Register Node script for all the nodes intended for a specific Cluster. You will then run the script
     * on each hardware unit that is intended for that Cluster. The script creates a Node in the specified Cluster. It
     * then binds the Node to this hardware unit, and activates the node hardware for use with MediaLive Anywhere.
     *
     * @param createNodeRegistrationScriptRequest
     *        A request to create a new node registration script.
     * @return A Java Future containing the result of the CreateNodeRegistrationScript operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to create a node registration script for this cluster.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on create node registration script calls to service.</li>
     *         <li>ConflictException The node registration script is unable to be created due to an issue with cluster
     *         resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateNodeRegistrationScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateNodeRegistrationScript"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNodeRegistrationScriptResponse> createNodeRegistrationScript(
            CreateNodeRegistrationScriptRequest createNodeRegistrationScriptRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNodeRegistrationScriptRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNodeRegistrationScriptRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNodeRegistrationScript");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateNodeRegistrationScriptResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateNodeRegistrationScriptResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateNodeRegistrationScriptResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNodeRegistrationScriptRequest, CreateNodeRegistrationScriptResponse>()
                            .withOperationName("CreateNodeRegistrationScript").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateNodeRegistrationScriptRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createNodeRegistrationScriptRequest));
            CompletableFuture<CreateNodeRegistrationScriptResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Create a partner input
     *
     * @param createPartnerInputRequest
     *        A request to create a partner input
     * @return A Java Future containing the result of the CreatePartnerInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreatePartnerInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreatePartnerInput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePartnerInputResponse> createPartnerInput(CreatePartnerInputRequest createPartnerInputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPartnerInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPartnerInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePartnerInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePartnerInputResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreatePartnerInputResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePartnerInputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePartnerInputRequest, CreatePartnerInputResponse>()
                            .withOperationName("CreatePartnerInput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreatePartnerInputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPartnerInputRequest));
            CompletableFuture<CreatePartnerInputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Initiates the creation of a new signal map. Will discover a new mediaResourceMap based on the provided
     * discoveryEntryPointArn.
     *
     * @param createSignalMapRequest
     *        Placeholder documentation for CreateSignalMapRequest
     * @return A Java Future containing the result of the CreateSignalMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSignalMapResponse> createSignalMap(CreateSignalMapRequest createSignalMapRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSignalMapRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSignalMapRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSignalMap");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSignalMapResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSignalMapResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSignalMapResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSignalMapRequest, CreateSignalMapResponse>()
                            .withOperationName("CreateSignalMap").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSignalMapRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSignalMapRequest));
            CompletableFuture<CreateSignalMapResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Create tags for a resource
     *
     * @param createTagsRequest
     *        Placeholder documentation for CreateTagsRequest
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The arn was not found.</li>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTagsResponse> createTags(CreateTagsRequest createTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTagsRequest, CreateTagsResponse>().withOperationName("CreateTags")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTagsRequest));
            CompletableFuture<CreateTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Starts deletion of channel. The associated outputs are also deleted.
     *
     * @param deleteChannelRequest
     *        Placeholder documentation for DeleteChannelRequest
     * @return A Java Future containing the result of the DeleteChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to delete the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to delete does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to delete due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteChannelResponse> deleteChannel(DeleteChannelRequest deleteChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteChannelRequest, DeleteChannelResponse>()
                            .withOperationName("DeleteChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteChannelRequest));
            CompletableFuture<DeleteChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Delete the specified ChannelPlacementGroup that exists in the specified Cluster.
     *
     * @param deleteChannelPlacementGroupRequest
     *        Placeholder documentation for DeleteChannelPlacementGroupRequest
     * @return A Java Future containing the result of the DeleteChannelPlacementGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to delete the channel placement group.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The channel placement group that you are trying to delete does not exist. Check the
     *         ID and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete channel placement group calls to the
     *         cluster service.</li>
     *         <li>ConflictException The channel placement group is unable to delete due to an issue with channel
     *         placement group resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteChannelPlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannelPlacementGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteChannelPlacementGroupResponse> deleteChannelPlacementGroup(
            DeleteChannelPlacementGroupRequest deleteChannelPlacementGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteChannelPlacementGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteChannelPlacementGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteChannelPlacementGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteChannelPlacementGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteChannelPlacementGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteChannelPlacementGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteChannelPlacementGroupRequest, DeleteChannelPlacementGroupResponse>()
                            .withOperationName("DeleteChannelPlacementGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteChannelPlacementGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteChannelPlacementGroupRequest));
            CompletableFuture<DeleteChannelPlacementGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a cloudwatch alarm template.
     *
     * @param deleteCloudWatchAlarmTemplateRequest
     *        Placeholder documentation for DeleteCloudWatchAlarmTemplateRequest
     * @return A Java Future containing the result of the DeleteCloudWatchAlarmTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCloudWatchAlarmTemplateResponse> deleteCloudWatchAlarmTemplate(
            DeleteCloudWatchAlarmTemplateRequest deleteCloudWatchAlarmTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCloudWatchAlarmTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCloudWatchAlarmTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCloudWatchAlarmTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCloudWatchAlarmTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCloudWatchAlarmTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCloudWatchAlarmTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCloudWatchAlarmTemplateRequest, DeleteCloudWatchAlarmTemplateResponse>()
                            .withOperationName("DeleteCloudWatchAlarmTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCloudWatchAlarmTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCloudWatchAlarmTemplateRequest));
            CompletableFuture<DeleteCloudWatchAlarmTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a cloudwatch alarm template group. You must detach this group from all signal maps and ensure its
     * existing templates are moved to another group or deleted.
     *
     * @param deleteCloudWatchAlarmTemplateGroupRequest
     *        Placeholder documentation for DeleteCloudWatchAlarmTemplateGroupRequest
     * @return A Java Future containing the result of the DeleteCloudWatchAlarmTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCloudWatchAlarmTemplateGroupResponse> deleteCloudWatchAlarmTemplateGroup(
            DeleteCloudWatchAlarmTemplateGroupRequest deleteCloudWatchAlarmTemplateGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCloudWatchAlarmTemplateGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCloudWatchAlarmTemplateGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCloudWatchAlarmTemplateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCloudWatchAlarmTemplateGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteCloudWatchAlarmTemplateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCloudWatchAlarmTemplateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCloudWatchAlarmTemplateGroupRequest, DeleteCloudWatchAlarmTemplateGroupResponse>()
                            .withOperationName("DeleteCloudWatchAlarmTemplateGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCloudWatchAlarmTemplateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCloudWatchAlarmTemplateGroupRequest));
            CompletableFuture<DeleteCloudWatchAlarmTemplateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Delete a Cluster. The Cluster must be idle.
     *
     * @param deleteClusterRequest
     *        Placeholder documentation for DeleteClusterRequest
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to delete the cluster.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The cluster that you are trying to delete doesn't exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete cluster calls to cluster service.</li>
     *         <li>ConflictException The cluster is unable to delete due to an issue with cluster resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteClusterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteClusterRequest, DeleteClusterResponse>()
                            .withOperationName("DeleteCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteClusterRequest));
            CompletableFuture<DeleteClusterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes an eventbridge rule template.
     *
     * @param deleteEventBridgeRuleTemplateRequest
     *        Placeholder documentation for DeleteEventBridgeRuleTemplateRequest
     * @return A Java Future containing the result of the DeleteEventBridgeRuleTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEventBridgeRuleTemplateResponse> deleteEventBridgeRuleTemplate(
            DeleteEventBridgeRuleTemplateRequest deleteEventBridgeRuleTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventBridgeRuleTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteEventBridgeRuleTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventBridgeRuleTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEventBridgeRuleTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEventBridgeRuleTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEventBridgeRuleTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEventBridgeRuleTemplateRequest, DeleteEventBridgeRuleTemplateResponse>()
                            .withOperationName("DeleteEventBridgeRuleTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEventBridgeRuleTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEventBridgeRuleTemplateRequest));
            CompletableFuture<DeleteEventBridgeRuleTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes an eventbridge rule template group. You must detach this group from all signal maps and ensure its
     * existing templates are moved to another group or deleted.
     *
     * @param deleteEventBridgeRuleTemplateGroupRequest
     *        Placeholder documentation for DeleteEventBridgeRuleTemplateGroupRequest
     * @return A Java Future containing the result of the DeleteEventBridgeRuleTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEventBridgeRuleTemplateGroupResponse> deleteEventBridgeRuleTemplateGroup(
            DeleteEventBridgeRuleTemplateGroupRequest deleteEventBridgeRuleTemplateGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventBridgeRuleTemplateGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteEventBridgeRuleTemplateGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventBridgeRuleTemplateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEventBridgeRuleTemplateGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteEventBridgeRuleTemplateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEventBridgeRuleTemplateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEventBridgeRuleTemplateGroupRequest, DeleteEventBridgeRuleTemplateGroupResponse>()
                            .withOperationName("DeleteEventBridgeRuleTemplateGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEventBridgeRuleTemplateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEventBridgeRuleTemplateGroupRequest));
            CompletableFuture<DeleteEventBridgeRuleTemplateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes the input end point
     *
     * @param deleteInputRequest
     *        Placeholder documentation for DeleteInputRequest
     * @return A Java Future containing the result of the DeleteInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>ConflictException Resource conflict</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInput" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInputResponse> deleteInput(DeleteInputRequest deleteInputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteInputResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInputRequest, DeleteInputResponse>()
                            .withOperationName("DeleteInput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteInputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInputRequest));
            CompletableFuture<DeleteInputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes an Input Security Group
     *
     * @param deleteInputSecurityGroupRequest
     *        Placeholder documentation for DeleteInputSecurityGroupRequest
     * @return A Java Future containing the result of the DeleteInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to delete the Input Security Group was Invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to delete this Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input Security Group not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInputSecurityGroupResponse> deleteInputSecurityGroup(
            DeleteInputSecurityGroupRequest deleteInputSecurityGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInputSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInputSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInputSecurityGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInputSecurityGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteInputSecurityGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInputSecurityGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInputSecurityGroupRequest, DeleteInputSecurityGroupResponse>()
                            .withOperationName("DeleteInputSecurityGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteInputSecurityGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInputSecurityGroupRequest));
            CompletableFuture<DeleteInputSecurityGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Delete a multiplex. The multiplex must be idle.
     *
     * @param deleteMultiplexRequest
     *        Placeholder documentation for DeleteMultiplexRequest
     * @return A Java Future containing the result of the DeleteMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to delete the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The multiplex that you are trying to delete doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to delete due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMultiplexResponse> deleteMultiplex(DeleteMultiplexRequest deleteMultiplexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMultiplexRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMultiplexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMultiplex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMultiplexResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMultiplexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMultiplexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMultiplexRequest, DeleteMultiplexResponse>()
                            .withOperationName("DeleteMultiplex").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMultiplexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMultiplexRequest));
            CompletableFuture<DeleteMultiplexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Delete a program from a multiplex.
     *
     * @param deleteMultiplexProgramRequest
     *        Placeholder documentation for DeleteMultiplexProgramRequest
     * @return A Java Future containing the result of the DeleteMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to delete the multiplex program.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The program that you are trying to delete doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete multiplex program calls to multiplex
     *         service.</li>
     *         <li>ConflictException The multiplex program is unable to delete due to an issue with multiplex resources.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMultiplexProgramResponse> deleteMultiplexProgram(
            DeleteMultiplexProgramRequest deleteMultiplexProgramRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMultiplexProgramRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMultiplexProgramRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMultiplexProgram");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMultiplexProgramResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMultiplexProgramResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMultiplexProgramResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMultiplexProgramRequest, DeleteMultiplexProgramResponse>()
                            .withOperationName("DeleteMultiplexProgram").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMultiplexProgramRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMultiplexProgramRequest));
            CompletableFuture<DeleteMultiplexProgramResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Delete a Network. The Network must have no resources associated with it.
     *
     * @param deleteNetworkRequest
     *        Placeholder documentation for DeleteNetworkRequest
     * @return A Java Future containing the result of the DeleteNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to delete the network.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The network that you are trying to delete doesnâ€™t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete network calls to network service.</li>
     *         <li>ConflictException The network is unable to delete due to an issue with network resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkResponse> deleteNetwork(DeleteNetworkRequest deleteNetworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNetworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetwork");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteNetworkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteNetworkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteNetworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkRequest, DeleteNetworkResponse>()
                            .withOperationName("DeleteNetwork").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNetworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNetworkRequest));
            CompletableFuture<DeleteNetworkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Delete a Node. The Node must be IDLE.
     *
     * @param deleteNodeRequest
     *        Placeholder documentation for DeleteNodeRequest
     * @return A Java Future containing the result of the DeleteNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to delete the node.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The node that you are trying to delete doesnâ€™t exist. Check the ID and try again.
     *         </li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete node calls to the cluster service.</li>
     *         <li>ConflictException The node is unable to delete due to an issue with node resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteNode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNodeResponse> deleteNode(DeleteNodeRequest deleteNodeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteNodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteNodeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteNodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNodeRequest, DeleteNodeResponse>().withOperationName("DeleteNode")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteNodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteNodeRequest));
            CompletableFuture<DeleteNodeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Delete an expired reservation.
     *
     * @param deleteReservationRequest
     *        Placeholder documentation for DeleteReservationRequest
     * @return A Java Future containing the result of the DeleteReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to delete reservation</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Reservation you're attempting to delete does not exist</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete reservation request</li>
     *         <li>ConflictException The reservation could not be deleted because it is currently active.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteReservation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteReservationResponse> deleteReservation(DeleteReservationRequest deleteReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteReservationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteReservationRequest, DeleteReservationResponse>()
                            .withOperationName("DeleteReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteReservationRequest));
            CompletableFuture<DeleteReservationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Delete all schedule actions on a channel.
     *
     * @param deleteScheduleRequest
     *        Placeholder documentation for DeleteScheduleRequest
     * @return A Java Future containing the result of the DeleteSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request to delete the schedule on this channel was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to delete the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The specified channel does not exist to have its schedule deleted.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteScheduleResponse> deleteSchedule(DeleteScheduleRequest deleteScheduleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteScheduleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteScheduleRequest, DeleteScheduleResponse>()
                            .withOperationName("DeleteSchedule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteScheduleRequest));
            CompletableFuture<DeleteScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes the specified signal map.
     *
     * @param deleteSignalMapRequest
     *        Placeholder documentation for DeleteSignalMapRequest
     * @return A Java Future containing the result of the DeleteSignalMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSignalMapResponse> deleteSignalMap(DeleteSignalMapRequest deleteSignalMapRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSignalMapRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSignalMapRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSignalMap");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSignalMapResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSignalMapResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSignalMapResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSignalMapRequest, DeleteSignalMapResponse>()
                            .withOperationName("DeleteSignalMap").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSignalMapRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSignalMapRequest));
            CompletableFuture<DeleteSignalMapResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Removes tags for a resource
     *
     * @param deleteTagsRequest
     *        Placeholder documentation for DeleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The arn was not found.</li>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTagsRequest, DeleteTagsResponse>().withOperationName("DeleteTags")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTagsRequest));
            CompletableFuture<DeleteTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Describe account configuration
     *
     * @param describeAccountConfigurationRequest
     *        Placeholder documentation for DescribeAccountConfigurationRequest
     * @return A Java Future containing the result of the DescribeAccountConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to describe the account configuration.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe account configuration calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeAccountConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeAccountConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountConfigurationResponse> describeAccountConfiguration(
            DescribeAccountConfigurationRequest describeAccountConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAccountConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAccountConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAccountConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountConfigurationRequest, DescribeAccountConfigurationResponse>()
                            .withOperationName("DescribeAccountConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAccountConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAccountConfigurationRequest));
            CompletableFuture<DescribeAccountConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Gets details about a channel
     *
     * @param describeChannelRequest
     *        Placeholder documentation for DescribeChannelRequest
     * @return A Java Future containing the result of the DescribeChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to describe the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to describe does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeChannelResponse> describeChannel(DescribeChannelRequest describeChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeChannelRequest, DescribeChannelResponse>()
                            .withOperationName("DescribeChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeChannelRequest));
            CompletableFuture<DescribeChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Get details about a ChannelPlacementGroup.
     *
     * @param describeChannelPlacementGroupRequest
     *        Placeholder documentation for DescribeChannelPlacementGroupRequest
     * @return A Java Future containing the result of the DescribeChannelPlacementGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You do not have permission to describe the channel placement group.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The channel placement group that you are trying to describe does not exist. Check
     *         the ID and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe channel placement group calls to the
     *         cluster service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeChannelPlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannelPlacementGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeChannelPlacementGroupResponse> describeChannelPlacementGroup(
            DescribeChannelPlacementGroupRequest describeChannelPlacementGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeChannelPlacementGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeChannelPlacementGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeChannelPlacementGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeChannelPlacementGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeChannelPlacementGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeChannelPlacementGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeChannelPlacementGroupRequest, DescribeChannelPlacementGroupResponse>()
                            .withOperationName("DescribeChannelPlacementGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeChannelPlacementGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeChannelPlacementGroupRequest));
            CompletableFuture<DescribeChannelPlacementGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Get details about a Cluster.
     *
     * @param describeClusterRequest
     *        Placeholder documentation for DescribeClusterRequest
     * @return A Java Future containing the result of the DescribeCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to describe the cluster.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The cluster that you are trying to describe does not exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe cluster calls to cluster service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClusterResponse> describeCluster(DescribeClusterRequest describeClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeClusterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClusterRequest, DescribeClusterResponse>()
                            .withOperationName("DescribeCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeClusterRequest));
            CompletableFuture<DescribeClusterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Produces details about an input
     *
     * @param describeInputRequest
     *        Placeholder documentation for DescribeInputRequest
     * @return A Java Future containing the result of the DescribeInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInput" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInputResponse> describeInput(DescribeInputRequest describeInputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeInputResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInputRequest, DescribeInputResponse>()
                            .withOperationName("DescribeInput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeInputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeInputRequest));
            CompletableFuture<DescribeInputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Gets the details for the input device
     *
     * @param describeInputDeviceRequest
     *        Placeholder documentation for DescribeInputDeviceRequest
     * @return A Java Future containing the result of the DescribeInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe the input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException The input device you're requesting to describe does not exist. Check the ID.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInputDeviceResponse> describeInputDevice(
            DescribeInputDeviceRequest describeInputDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInputDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInputDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInputDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInputDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeInputDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInputDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInputDeviceRequest, DescribeInputDeviceResponse>()
                            .withOperationName("DescribeInputDevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeInputDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeInputDeviceRequest));
            CompletableFuture<DescribeInputDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Get the latest thumbnail data for the input device.
     *
     * @param describeInputDeviceThumbnailRequest
     *        Placeholder documentation for DescribeInputDeviceThumbnailRequest
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows 'The binary data for the thumbnail that the Link device has most
     *        recently sent to MediaLive.'.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe input device thumbnail.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on get thumbnail calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInputDeviceThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public <ReturnT> CompletableFuture<ReturnT> describeInputDeviceThumbnail(
            DescribeInputDeviceThumbnailRequest describeInputDeviceThumbnailRequest,
            AsyncResponseTransformer<DescribeInputDeviceThumbnailResponse, ReturnT> asyncResponseTransformer) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInputDeviceThumbnailRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInputDeviceThumbnailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInputDeviceThumbnail");
            Pair<AsyncResponseTransformer<DescribeInputDeviceThumbnailResponse, ReturnT>, CompletableFuture<Void>> pair = AsyncResponseTransformerUtils
                    .wrapWithEndOfStreamFuture(asyncResponseTransformer);
            asyncResponseTransformer = pair.left();
            CompletableFuture<Void> endOfStreamFuture = pair.right();
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true)
                    .isPayloadJson(false).build();

            HttpResponseHandler<DescribeInputDeviceThumbnailResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeInputDeviceThumbnailResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ReturnT> executeFuture = clientHandler.execute(
                    new ClientExecutionParams<DescribeInputDeviceThumbnailRequest, DescribeInputDeviceThumbnailResponse>()
                            .withOperationName("DescribeInputDeviceThumbnail").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeInputDeviceThumbnailRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeInputDeviceThumbnailRequest), asyncResponseTransformer);
            AsyncResponseTransformer<DescribeInputDeviceThumbnailResponse, ReturnT> finalAsyncResponseTransformer = asyncResponseTransformer;
            CompletableFuture<ReturnT> whenCompleted = executeFuture.whenComplete((r, e) -> {
                if (e != null) {
                    runAndLogError(log, "Exception thrown in exceptionOccurred callback, ignoring",
                            () -> finalAsyncResponseTransformer.exceptionOccurred(e));
                }
                endOfStreamFuture.whenComplete((r2, e2) -> {
                    metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                });
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            AsyncResponseTransformer<DescribeInputDeviceThumbnailResponse, ReturnT> finalAsyncResponseTransformer = asyncResponseTransformer;
            runAndLogError(log, "Exception thrown in exceptionOccurred callback, ignoring",
                    () -> finalAsyncResponseTransformer.exceptionOccurred(t));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Produces a summary of an Input Security Group
     *
     * @param describeInputSecurityGroupRequest
     *        Placeholder documentation for DescribeInputSecurityGroupRequest
     * @return A Java Future containing the result of the DescribeInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to describe an Input Security Group was Invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to describe this Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input Security Group not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInputSecurityGroupResponse> describeInputSecurityGroup(
            DescribeInputSecurityGroupRequest describeInputSecurityGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInputSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInputSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInputSecurityGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInputSecurityGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeInputSecurityGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInputSecurityGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInputSecurityGroupRequest, DescribeInputSecurityGroupResponse>()
                            .withOperationName("DescribeInputSecurityGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeInputSecurityGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeInputSecurityGroupRequest));
            CompletableFuture<DescribeInputSecurityGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Gets details about a multiplex.
     *
     * @param describeMultiplexRequest
     *        Placeholder documentation for DescribeMultiplexRequest
     * @return A Java Future containing the result of the DescribeMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to describe the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The multiplex that you are trying to describe doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplex" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMultiplexResponse> describeMultiplex(DescribeMultiplexRequest describeMultiplexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMultiplexRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMultiplexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMultiplex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMultiplexResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMultiplexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMultiplexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMultiplexRequest, DescribeMultiplexResponse>()
                            .withOperationName("DescribeMultiplex").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMultiplexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMultiplexRequest));
            CompletableFuture<DescribeMultiplexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Get the details for a program in a multiplex.
     *
     * @param describeMultiplexProgramRequest
     *        Placeholder documentation for DescribeMultiplexProgramRequest
     * @return A Java Future containing the result of the DescribeMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to describe the multiplex program.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException MediaLive can't describe the program. The multiplex or the program that you
     *         specified doesn’t exist. Check the IDs and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe multiplex program calls to multiplex
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMultiplexProgramResponse> describeMultiplexProgram(
            DescribeMultiplexProgramRequest describeMultiplexProgramRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMultiplexProgramRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMultiplexProgramRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMultiplexProgram");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMultiplexProgramResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMultiplexProgramResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMultiplexProgramResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMultiplexProgramRequest, DescribeMultiplexProgramResponse>()
                            .withOperationName("DescribeMultiplexProgram").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMultiplexProgramRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMultiplexProgramRequest));
            CompletableFuture<DescribeMultiplexProgramResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Get details about a Network.
     *
     * @param describeNetworkRequest
     *        Placeholder documentation for DescribeNetworkRequest
     * @return A Java Future containing the result of the DescribeNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to describe the network.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The network that you are trying to describe does not exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe network calls to network service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNetworkResponse> describeNetwork(DescribeNetworkRequest describeNetworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeNetworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeNetworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeNetwork");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeNetworkResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeNetworkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeNetworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeNetworkRequest, DescribeNetworkResponse>()
                            .withOperationName("DescribeNetwork").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeNetworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeNetworkRequest));
            CompletableFuture<DescribeNetworkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Get details about a Node in the specified Cluster.
     *
     * @param describeNodeRequest
     *        Placeholder documentation for DescribeNodeRequest
     * @return A Java Future containing the result of the DescribeNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to describe the node.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The node that you are trying to describe doesnâ€™t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe node calls to the cluster service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeNode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNodeResponse> describeNode(DescribeNodeRequest describeNodeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeNode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeNodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeNodeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeNodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeNodeRequest, DescribeNodeResponse>()
                            .withOperationName("DescribeNode").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeNodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeNodeRequest));
            CompletableFuture<DescribeNodeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Get details for an offering.
     *
     * @param describeOfferingRequest
     *        Placeholder documentation for DescribeOfferingRequest
     * @return A Java Future containing the result of the DescribeOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to describe offering</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Offering you're attempting to describe does not exist</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe offering request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeOffering" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOfferingResponse> describeOffering(DescribeOfferingRequest describeOfferingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOfferingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOfferingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOffering");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOfferingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeOfferingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOfferingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOfferingRequest, DescribeOfferingResponse>()
                            .withOperationName("DescribeOffering").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeOfferingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeOfferingRequest));
            CompletableFuture<DescribeOfferingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Get details for a reservation.
     *
     * @param describeReservationRequest
     *        Placeholder documentation for DescribeReservationRequest
     * @return A Java Future containing the result of the DescribeReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to describe reservation</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Reservation you're attempting to describe does not exist</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe reservation request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeReservation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeReservationResponse> describeReservation(
            DescribeReservationRequest describeReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeReservationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservationRequest, DescribeReservationResponse>()
                            .withOperationName("DescribeReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReservationRequest));
            CompletableFuture<DescribeReservationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Get a channel schedule
     *
     * @param describeScheduleRequest
     *        Placeholder documentation for DescribeScheduleRequest
     * @return A Java Future containing the result of the DescribeSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to describe the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting a schedule describe for does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeScheduleResponse> describeSchedule(DescribeScheduleRequest describeScheduleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSchedule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeScheduleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeScheduleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeScheduleRequest, DescribeScheduleResponse>()
                            .withOperationName("DescribeSchedule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeScheduleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeScheduleRequest));
            CompletableFuture<DescribeScheduleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Describe the latest thumbnails data.
     *
     * @param describeThumbnailsRequest
     *        Placeholder documentation for DescribeThumbnailsRequest
     * @return A Java Future containing the result of the DescribeThumbnails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe thumbnails.</li>
     *         <li>BadGatewayException Bad Gateway error.</li>
     *         <li>NotFoundException There are no thumbnails for this channel.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe thumbnails calls to channel service.</li>
     *         <li>ConflictException Service do not have permission to customer's KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeThumbnails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeThumbnails" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeThumbnailsResponse> describeThumbnails(DescribeThumbnailsRequest describeThumbnailsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeThumbnailsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeThumbnailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeThumbnails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeThumbnailsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeThumbnailsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeThumbnailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeThumbnailsRequest, DescribeThumbnailsResponse>()
                            .withOperationName("DescribeThumbnails").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeThumbnailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeThumbnailsRequest));
            CompletableFuture<DescribeThumbnailsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves the specified cloudwatch alarm template.
     *
     * @param getCloudWatchAlarmTemplateRequest
     *        Placeholder documentation for GetCloudWatchAlarmTemplateRequest
     * @return A Java Future containing the result of the GetCloudWatchAlarmTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.GetCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCloudWatchAlarmTemplateResponse> getCloudWatchAlarmTemplate(
            GetCloudWatchAlarmTemplateRequest getCloudWatchAlarmTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCloudWatchAlarmTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCloudWatchAlarmTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudWatchAlarmTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCloudWatchAlarmTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCloudWatchAlarmTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCloudWatchAlarmTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCloudWatchAlarmTemplateRequest, GetCloudWatchAlarmTemplateResponse>()
                            .withOperationName("GetCloudWatchAlarmTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCloudWatchAlarmTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCloudWatchAlarmTemplateRequest));
            CompletableFuture<GetCloudWatchAlarmTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves the specified cloudwatch alarm template group.
     *
     * @param getCloudWatchAlarmTemplateGroupRequest
     *        Placeholder documentation for GetCloudWatchAlarmTemplateGroupRequest
     * @return A Java Future containing the result of the GetCloudWatchAlarmTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.GetCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCloudWatchAlarmTemplateGroupResponse> getCloudWatchAlarmTemplateGroup(
            GetCloudWatchAlarmTemplateGroupRequest getCloudWatchAlarmTemplateGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCloudWatchAlarmTemplateGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCloudWatchAlarmTemplateGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudWatchAlarmTemplateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCloudWatchAlarmTemplateGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCloudWatchAlarmTemplateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCloudWatchAlarmTemplateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCloudWatchAlarmTemplateGroupRequest, GetCloudWatchAlarmTemplateGroupResponse>()
                            .withOperationName("GetCloudWatchAlarmTemplateGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCloudWatchAlarmTemplateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCloudWatchAlarmTemplateGroupRequest));
            CompletableFuture<GetCloudWatchAlarmTemplateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves the specified eventbridge rule template.
     *
     * @param getEventBridgeRuleTemplateRequest
     *        Placeholder documentation for GetEventBridgeRuleTemplateRequest
     * @return A Java Future containing the result of the GetEventBridgeRuleTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.GetEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEventBridgeRuleTemplateResponse> getEventBridgeRuleTemplate(
            GetEventBridgeRuleTemplateRequest getEventBridgeRuleTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventBridgeRuleTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventBridgeRuleTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventBridgeRuleTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEventBridgeRuleTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEventBridgeRuleTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEventBridgeRuleTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEventBridgeRuleTemplateRequest, GetEventBridgeRuleTemplateResponse>()
                            .withOperationName("GetEventBridgeRuleTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEventBridgeRuleTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEventBridgeRuleTemplateRequest));
            CompletableFuture<GetEventBridgeRuleTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves the specified eventbridge rule template group.
     *
     * @param getEventBridgeRuleTemplateGroupRequest
     *        Placeholder documentation for GetEventBridgeRuleTemplateGroupRequest
     * @return A Java Future containing the result of the GetEventBridgeRuleTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.GetEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetEventBridgeRuleTemplateGroupResponse> getEventBridgeRuleTemplateGroup(
            GetEventBridgeRuleTemplateGroupRequest getEventBridgeRuleTemplateGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventBridgeRuleTemplateGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getEventBridgeRuleTemplateGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventBridgeRuleTemplateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEventBridgeRuleTemplateGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetEventBridgeRuleTemplateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEventBridgeRuleTemplateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEventBridgeRuleTemplateGroupRequest, GetEventBridgeRuleTemplateGroupResponse>()
                            .withOperationName("GetEventBridgeRuleTemplateGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetEventBridgeRuleTemplateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getEventBridgeRuleTemplateGroupRequest));
            CompletableFuture<GetEventBridgeRuleTemplateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves the specified signal map.
     *
     * @param getSignalMapRequest
     *        Placeholder documentation for GetSignalMapRequest
     * @return A Java Future containing the result of the GetSignalMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.GetSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSignalMapResponse> getSignalMap(GetSignalMapRequest getSignalMapRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSignalMapRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSignalMapRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSignalMap");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSignalMapResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetSignalMapResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSignalMapResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSignalMapRequest, GetSignalMapResponse>()
                            .withOperationName("GetSignalMap").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSignalMapRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSignalMapRequest));
            CompletableFuture<GetSignalMapResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieve the list of ChannelPlacementGroups in the specified Cluster.
     *
     * @param listChannelPlacementGroupsRequest
     *        Placeholder documentation for ListChannelPlacementGroupsRequest
     * @return A Java Future containing the result of the ListChannelPlacementGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to list channel placement groups.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on list channel placement group calls to the cluster
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListChannelPlacementGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannelPlacementGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListChannelPlacementGroupsResponse> listChannelPlacementGroups(
            ListChannelPlacementGroupsRequest listChannelPlacementGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listChannelPlacementGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listChannelPlacementGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListChannelPlacementGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListChannelPlacementGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListChannelPlacementGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListChannelPlacementGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListChannelPlacementGroupsRequest, ListChannelPlacementGroupsResponse>()
                            .withOperationName("ListChannelPlacementGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListChannelPlacementGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listChannelPlacementGroupsRequest));
            CompletableFuture<ListChannelPlacementGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Produces list of channels that have been created
     *
     * @param listChannelsRequest
     *        Placeholder documentation for ListChannelsRequest
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to list channels.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListChannelsResponse> listChannels(ListChannelsRequest listChannelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listChannelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listChannelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListChannels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListChannelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListChannelsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListChannelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListChannelsRequest, ListChannelsResponse>()
                            .withOperationName("ListChannels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListChannelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listChannelsRequest));
            CompletableFuture<ListChannelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists cloudwatch alarm template groups.
     *
     * @param listCloudWatchAlarmTemplateGroupsRequest
     *        Placeholder documentation for ListCloudWatchAlarmTemplateGroupsRequest
     * @return A Java Future containing the result of the ListCloudWatchAlarmTemplateGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListCloudWatchAlarmTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCloudWatchAlarmTemplateGroupsResponse> listCloudWatchAlarmTemplateGroups(
            ListCloudWatchAlarmTemplateGroupsRequest listCloudWatchAlarmTemplateGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCloudWatchAlarmTemplateGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCloudWatchAlarmTemplateGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCloudWatchAlarmTemplateGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCloudWatchAlarmTemplateGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListCloudWatchAlarmTemplateGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCloudWatchAlarmTemplateGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCloudWatchAlarmTemplateGroupsRequest, ListCloudWatchAlarmTemplateGroupsResponse>()
                            .withOperationName("ListCloudWatchAlarmTemplateGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCloudWatchAlarmTemplateGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCloudWatchAlarmTemplateGroupsRequest));
            CompletableFuture<ListCloudWatchAlarmTemplateGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists cloudwatch alarm templates.
     *
     * @param listCloudWatchAlarmTemplatesRequest
     *        Placeholder documentation for ListCloudWatchAlarmTemplatesRequest
     * @return A Java Future containing the result of the ListCloudWatchAlarmTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListCloudWatchAlarmTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCloudWatchAlarmTemplatesResponse> listCloudWatchAlarmTemplates(
            ListCloudWatchAlarmTemplatesRequest listCloudWatchAlarmTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCloudWatchAlarmTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCloudWatchAlarmTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCloudWatchAlarmTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCloudWatchAlarmTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCloudWatchAlarmTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCloudWatchAlarmTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCloudWatchAlarmTemplatesRequest, ListCloudWatchAlarmTemplatesResponse>()
                            .withOperationName("ListCloudWatchAlarmTemplates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCloudWatchAlarmTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCloudWatchAlarmTemplatesRequest));
            CompletableFuture<ListCloudWatchAlarmTemplatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieve the list of Clusters.
     *
     * @param listClustersRequest
     *        Placeholder documentation for ListClustersRequest
     * @return A Java Future containing the result of the ListClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to list clusters.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on list cluster calls to cluster service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListClustersResponse> listClusters(ListClustersRequest listClustersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listClustersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListClusters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListClustersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListClustersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListClustersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListClustersRequest, ListClustersResponse>()
                            .withOperationName("ListClusters").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListClustersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listClustersRequest));
            CompletableFuture<ListClustersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists eventbridge rule template groups.
     *
     * @param listEventBridgeRuleTemplateGroupsRequest
     *        Placeholder documentation for ListEventBridgeRuleTemplateGroupsRequest
     * @return A Java Future containing the result of the ListEventBridgeRuleTemplateGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListEventBridgeRuleTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEventBridgeRuleTemplateGroupsResponse> listEventBridgeRuleTemplateGroups(
            ListEventBridgeRuleTemplateGroupsRequest listEventBridgeRuleTemplateGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEventBridgeRuleTemplateGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listEventBridgeRuleTemplateGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEventBridgeRuleTemplateGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEventBridgeRuleTemplateGroupsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListEventBridgeRuleTemplateGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEventBridgeRuleTemplateGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEventBridgeRuleTemplateGroupsRequest, ListEventBridgeRuleTemplateGroupsResponse>()
                            .withOperationName("ListEventBridgeRuleTemplateGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEventBridgeRuleTemplateGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEventBridgeRuleTemplateGroupsRequest));
            CompletableFuture<ListEventBridgeRuleTemplateGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists eventbridge rule templates.
     *
     * @param listEventBridgeRuleTemplatesRequest
     *        Placeholder documentation for ListEventBridgeRuleTemplatesRequest
     * @return A Java Future containing the result of the ListEventBridgeRuleTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListEventBridgeRuleTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEventBridgeRuleTemplatesResponse> listEventBridgeRuleTemplates(
            ListEventBridgeRuleTemplatesRequest listEventBridgeRuleTemplatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEventBridgeRuleTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEventBridgeRuleTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEventBridgeRuleTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEventBridgeRuleTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEventBridgeRuleTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEventBridgeRuleTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEventBridgeRuleTemplatesRequest, ListEventBridgeRuleTemplatesResponse>()
                            .withOperationName("ListEventBridgeRuleTemplates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListEventBridgeRuleTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listEventBridgeRuleTemplatesRequest));
            CompletableFuture<ListEventBridgeRuleTemplatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * List input devices that are currently being transferred. List input devices that you are transferring from your
     * AWS account or input devices that another AWS account is transferring to you.
     *
     * @param listInputDeviceTransfersRequest
     *        Placeholder documentation for ListInputDeviceTransfersRequest
     * @return A Java Future containing the result of the ListInputDeviceTransfers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list transferring devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list devices calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputDeviceTransfers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDeviceTransfers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListInputDeviceTransfersResponse> listInputDeviceTransfers(
            ListInputDeviceTransfersRequest listInputDeviceTransfersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInputDeviceTransfersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInputDeviceTransfersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInputDeviceTransfers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListInputDeviceTransfersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListInputDeviceTransfersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListInputDeviceTransfersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInputDeviceTransfersRequest, ListInputDeviceTransfersResponse>()
                            .withOperationName("ListInputDeviceTransfers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListInputDeviceTransfersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listInputDeviceTransfersRequest));
            CompletableFuture<ListInputDeviceTransfersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * List input devices
     *
     * @param listInputDevicesRequest
     *        Placeholder documentation for ListInputDevicesRequest
     * @return A Java Future containing the result of the ListInputDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list input devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list devices calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListInputDevicesResponse> listInputDevices(ListInputDevicesRequest listInputDevicesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInputDevicesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInputDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInputDevices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListInputDevicesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListInputDevicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListInputDevicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInputDevicesRequest, ListInputDevicesResponse>()
                            .withOperationName("ListInputDevices").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListInputDevicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listInputDevicesRequest));
            CompletableFuture<ListInputDevicesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Produces a list of Input Security Groups for an account
     *
     * @param listInputSecurityGroupsRequest
     *        Placeholder documentation for ListInputSecurityGroupsRequest
     * @return A Java Future containing the result of the ListInputSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to list Input Security Groups was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to call ListInputSecurityGroups</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListInputSecurityGroupsResponse> listInputSecurityGroups(
            ListInputSecurityGroupsRequest listInputSecurityGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInputSecurityGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInputSecurityGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInputSecurityGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListInputSecurityGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListInputSecurityGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListInputSecurityGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInputSecurityGroupsRequest, ListInputSecurityGroupsResponse>()
                            .withOperationName("ListInputSecurityGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListInputSecurityGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listInputSecurityGroupsRequest));
            CompletableFuture<ListInputSecurityGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Produces list of inputs that have been created
     *
     * @param listInputsRequest
     *        Placeholder documentation for ListInputsRequest
     * @return A Java Future containing the result of the ListInputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListInputsResponse> listInputs(ListInputsRequest listInputsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInputsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInputsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInputs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListInputsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListInputsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListInputsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInputsRequest, ListInputsResponse>().withOperationName("ListInputs")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListInputsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listInputsRequest));
            CompletableFuture<ListInputsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * List the programs that currently exist for a specific multiplex.
     *
     * @param listMultiplexProgramsRequest
     *        Placeholder documentation for ListMultiplexProgramsRequest
     * @return A Java Future containing the result of the ListMultiplexPrograms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to list multiplex programs.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException MediaLive can't provide the list of programs. The multiplex that you specified
     *         doesn’t exist. Check the ID and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexPrograms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMultiplexProgramsResponse> listMultiplexPrograms(
            ListMultiplexProgramsRequest listMultiplexProgramsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMultiplexProgramsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMultiplexProgramsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMultiplexPrograms");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMultiplexProgramsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMultiplexProgramsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMultiplexProgramsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMultiplexProgramsRequest, ListMultiplexProgramsResponse>()
                            .withOperationName("ListMultiplexPrograms").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMultiplexProgramsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMultiplexProgramsRequest));
            CompletableFuture<ListMultiplexProgramsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieve a list of the existing multiplexes.
     *
     * @param listMultiplexesRequest
     *        Placeholder documentation for ListMultiplexesRequest
     * @return A Java Future containing the result of the ListMultiplexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to list multiplexes.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListMultiplexesResponse> listMultiplexes(ListMultiplexesRequest listMultiplexesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMultiplexesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMultiplexesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMultiplexes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMultiplexesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMultiplexesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMultiplexesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMultiplexesRequest, ListMultiplexesResponse>()
                            .withOperationName("ListMultiplexes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMultiplexesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMultiplexesRequest));
            CompletableFuture<ListMultiplexesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieve the list of Networks.
     *
     * @param listNetworksRequest
     *        Placeholder documentation for ListNetworksRequest
     * @return A Java Future containing the result of the ListNetworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to list clusters.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on list cluster calls to cluster service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListNetworks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListNetworksResponse> listNetworks(ListNetworksRequest listNetworksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listNetworksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNetworksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNetworks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListNetworksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListNetworksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListNetworksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListNetworksRequest, ListNetworksResponse>()
                            .withOperationName("ListNetworks").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListNetworksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listNetworksRequest));
            CompletableFuture<ListNetworksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieve the list of Nodes.
     *
     * @param listNodesRequest
     *        Placeholder documentation for ListNodesRequest
     * @return A Java Future containing the result of the ListNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to list nodes.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on list node calls to the cluster service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListNodesResponse> listNodes(ListNodesRequest listNodesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listNodesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNodesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNodes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListNodesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListNodesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListNodesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListNodesRequest, ListNodesResponse>().withOperationName("ListNodes")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListNodesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(listNodesRequest));
            CompletableFuture<ListNodesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * List offerings available for purchase.
     *
     * @param listOfferingsRequest
     *        Placeholder documentation for ListOfferingsRequest
     * @return A Java Future containing the result of the ListOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list offerings</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list offerings request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListOfferingsResponse> listOfferings(ListOfferingsRequest listOfferingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOfferingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOfferingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOfferings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOfferingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListOfferingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListOfferingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOfferingsRequest, ListOfferingsResponse>()
                            .withOperationName("ListOfferings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListOfferingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOfferingsRequest));
            CompletableFuture<ListOfferingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * List purchased reservations.
     *
     * @param listReservationsRequest
     *        Placeholder documentation for ListReservationsRequest
     * @return A Java Future containing the result of the ListReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list reservations</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on list reservations request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListReservationsResponse> listReservations(ListReservationsRequest listReservationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReservationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReservationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReservations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReservationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListReservationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListReservationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReservationsRequest, ListReservationsResponse>()
                            .withOperationName("ListReservations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReservationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listReservationsRequest));
            CompletableFuture<ListReservationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists signal maps.
     *
     * @param listSignalMapsRequest
     *        Placeholder documentation for ListSignalMapsRequest
     * @return A Java Future containing the result of the ListSignalMaps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListSignalMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListSignalMaps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSignalMapsResponse> listSignalMaps(ListSignalMapsRequest listSignalMapsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSignalMapsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSignalMapsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSignalMaps");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSignalMapsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSignalMapsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSignalMapsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSignalMapsRequest, ListSignalMapsResponse>()
                            .withOperationName("ListSignalMaps").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSignalMapsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSignalMapsRequest));
            CompletableFuture<ListSignalMapsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Produces list of tags that have been created for a resource
     *
     * @param listTagsForResourceRequest
     *        Placeholder documentation for ListTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The arn was not found</li>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves an array of all the encoder engine versions that are available in this AWS account.
     *
     * @param listVersionsRequest
     *        Placeholder documentation for ListVersionsRequest
     * @return A Java Future containing the result of the ListVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Verify that the syntax is correct.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials that you sent.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The service could not complete your request.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service could not complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListVersionsResponse> listVersions(ListVersionsRequest listVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVersionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVersionsRequest, ListVersionsResponse>()
                            .withOperationName("ListVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listVersionsRequest));
            CompletableFuture<ListVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Purchase an offering and create a reservation.
     *
     * @param purchaseOfferingRequest
     *        Placeholder documentation for PurchaseOfferingRequest
     * @return A Java Future containing the result of the PurchaseOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to purchase the offering</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Offering you're attempting to purchase does not exist</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on purchase offering request</li>
     *         <li>ConflictException Offering purchase prevented by service resource issue</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.PurchaseOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PurchaseOfferingResponse> purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(purchaseOfferingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, purchaseOfferingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PurchaseOffering");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PurchaseOfferingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PurchaseOfferingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PurchaseOfferingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PurchaseOfferingRequest, PurchaseOfferingResponse>()
                            .withOperationName("PurchaseOffering").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PurchaseOfferingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(purchaseOfferingRequest));
            CompletableFuture<PurchaseOfferingResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Send a reboot command to the specified input device. The device will begin rebooting within a few seconds of
     * sending the command. When the reboot is complete, the device’s connection status will change to connected.
     *
     * @param rebootInputDeviceRequest
     *        A request to reboot an AWS Elemental device.
     * @return A Java Future containing the result of the RebootInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Reboot operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to reboot input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on reboot device calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.RebootInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RebootInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RebootInputDeviceResponse> rebootInputDevice(RebootInputDeviceRequest rebootInputDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rebootInputDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootInputDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootInputDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RebootInputDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RebootInputDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RebootInputDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RebootInputDeviceRequest, RebootInputDeviceResponse>()
                            .withOperationName("RebootInputDevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RebootInputDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(rebootInputDeviceRequest));
            CompletableFuture<RebootInputDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Reject the transfer of the specified input device to your AWS account.
     *
     * @param rejectInputDeviceTransferRequest
     *        Placeholder documentation for RejectInputDeviceTransferRequest
     * @return A Java Future containing the result of the RejectInputDeviceTransfer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to reject input device transfers.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on transfer device calls to the input device service.
     *         </li>
     *         <li>ConflictException Input device transfer could not be rejected.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.RejectInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RejectInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RejectInputDeviceTransferResponse> rejectInputDeviceTransfer(
            RejectInputDeviceTransferRequest rejectInputDeviceTransferRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rejectInputDeviceTransferRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rejectInputDeviceTransferRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectInputDeviceTransfer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RejectInputDeviceTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RejectInputDeviceTransferResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RejectInputDeviceTransferResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RejectInputDeviceTransferRequest, RejectInputDeviceTransferResponse>()
                            .withOperationName("RejectInputDeviceTransfer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RejectInputDeviceTransferRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(rejectInputDeviceTransferRequest));
            CompletableFuture<RejectInputDeviceTransferResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Restart pipelines in one channel that is currently running.
     *
     * @param restartChannelPipelinesRequest
     *        Pipelines to restart.
     * @return A Java Future containing the result of the RestartChannelPipelines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The service can't process your request because of a problem in the request.
     *         Verify that the syntax is correct.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permissions for this action with the credentials that you sent.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel or pipeline you specified doesn't exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Too many requests have been sent in too short of a time. The service limits
     *         the rate at which it will accept requests.</li>
     *         <li>ConflictException The service could not complete your request because there is a conflict with the
     *         current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.RestartChannelPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RestartChannelPipelines"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RestartChannelPipelinesResponse> restartChannelPipelines(
            RestartChannelPipelinesRequest restartChannelPipelinesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restartChannelPipelinesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restartChannelPipelinesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestartChannelPipelines");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RestartChannelPipelinesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RestartChannelPipelinesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RestartChannelPipelinesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestartChannelPipelinesRequest, RestartChannelPipelinesResponse>()
                            .withOperationName("RestartChannelPipelines").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RestartChannelPipelinesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(restartChannelPipelinesRequest));
            CompletableFuture<RestartChannelPipelinesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Starts an existing channel
     *
     * @param startChannelRequest
     *        Placeholder documentation for StartChannelRequest
     * @return A Java Future containing the result of the StartChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to start the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to start does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on start channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to start due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartChannelResponse> startChannel(StartChannelRequest startChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartChannelRequest, StartChannelResponse>()
                            .withOperationName("StartChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startChannelRequest));
            CompletableFuture<StartChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Initiates a deployment to delete the monitor of the specified signal map.
     *
     * @param startDeleteMonitorDeploymentRequest
     *        Placeholder documentation for StartDeleteMonitorDeploymentRequest
     * @return A Java Future containing the result of the StartDeleteMonitorDeployment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartDeleteMonitorDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartDeleteMonitorDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartDeleteMonitorDeploymentResponse> startDeleteMonitorDeployment(
            StartDeleteMonitorDeploymentRequest startDeleteMonitorDeploymentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startDeleteMonitorDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startDeleteMonitorDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDeleteMonitorDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartDeleteMonitorDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartDeleteMonitorDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartDeleteMonitorDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartDeleteMonitorDeploymentRequest, StartDeleteMonitorDeploymentResponse>()
                            .withOperationName("StartDeleteMonitorDeployment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartDeleteMonitorDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startDeleteMonitorDeploymentRequest));
            CompletableFuture<StartDeleteMonitorDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Start an input device that is attached to a MediaConnect flow. (There is no need to start a device that is
     * attached to a MediaLive input; MediaLive starts the device when the channel starts.)
     *
     * @param startInputDeviceRequest
     *        Placeholder documentation for StartInputDeviceRequest
     * @return A Java Future containing the result of the StartInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Start operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to start the input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on start device calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartInputDeviceResponse> startInputDevice(StartInputDeviceRequest startInputDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startInputDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startInputDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartInputDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartInputDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartInputDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartInputDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartInputDeviceRequest, StartInputDeviceResponse>()
                            .withOperationName("StartInputDevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartInputDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startInputDeviceRequest));
            CompletableFuture<StartInputDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Start a maintenance window for the specified input device. Starting a maintenance window will give the device up
     * to two hours to install software. If the device was streaming prior to the maintenance, it will resume streaming
     * when the software is fully installed. Devices automatically install updates while they are powered on and their
     * MediaLive channels are stopped. A maintenance window allows you to update a device without having to stop
     * MediaLive channels that use the device. The device must remain powered on and connected to the internet for the
     * duration of the maintenance.
     *
     * @param startInputDeviceMaintenanceWindowRequest
     *        Placeholder documentation for StartInputDeviceMaintenanceWindowRequest
     * @return A Java Future containing the result of the StartInputDeviceMaintenanceWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Start maintenance window operation failed, input could not be validated.
     *         </li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to start a maintenance window for this input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on start maintenance window calls to the input device
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartInputDeviceMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartInputDeviceMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartInputDeviceMaintenanceWindowResponse> startInputDeviceMaintenanceWindow(
            StartInputDeviceMaintenanceWindowRequest startInputDeviceMaintenanceWindowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startInputDeviceMaintenanceWindowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startInputDeviceMaintenanceWindowRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartInputDeviceMaintenanceWindow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartInputDeviceMaintenanceWindowResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StartInputDeviceMaintenanceWindowResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartInputDeviceMaintenanceWindowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartInputDeviceMaintenanceWindowRequest, StartInputDeviceMaintenanceWindowResponse>()
                            .withOperationName("StartInputDeviceMaintenanceWindow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartInputDeviceMaintenanceWindowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startInputDeviceMaintenanceWindowRequest));
            CompletableFuture<StartInputDeviceMaintenanceWindowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Initiates a deployment to deploy the latest monitor of the specified signal map.
     *
     * @param startMonitorDeploymentRequest
     *        Placeholder documentation for StartMonitorDeploymentRequest
     * @return A Java Future containing the result of the StartMonitorDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartMonitorDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMonitorDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartMonitorDeploymentResponse> startMonitorDeployment(
            StartMonitorDeploymentRequest startMonitorDeploymentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startMonitorDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMonitorDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMonitorDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartMonitorDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartMonitorDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartMonitorDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartMonitorDeploymentRequest, StartMonitorDeploymentResponse>()
                            .withOperationName("StartMonitorDeployment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartMonitorDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startMonitorDeploymentRequest));
            CompletableFuture<StartMonitorDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Start (run) the multiplex. Starting the multiplex does not start the channels. You must explicitly start each
     * channel.
     *
     * @param startMultiplexRequest
     *        Placeholder documentation for StartMultiplexRequest
     * @return A Java Future containing the result of the StartMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to start the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The multiplex that you are trying to start doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on start multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to start due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartMultiplexResponse> startMultiplex(StartMultiplexRequest startMultiplexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startMultiplexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMultiplexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMultiplex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartMultiplexResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartMultiplexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartMultiplexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartMultiplexRequest, StartMultiplexResponse>()
                            .withOperationName("StartMultiplex").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartMultiplexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startMultiplexRequest));
            CompletableFuture<StartMultiplexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Initiates an update for the specified signal map. Will discover a new signal map if a changed
     * discoveryEntryPointArn is provided.
     *
     * @param startUpdateSignalMapRequest
     *        Placeholder documentation for StartUpdateSignalMapRequest
     * @return A Java Future containing the result of the StartUpdateSignalMap operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartUpdateSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartUpdateSignalMap"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartUpdateSignalMapResponse> startUpdateSignalMap(
            StartUpdateSignalMapRequest startUpdateSignalMapRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startUpdateSignalMapRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startUpdateSignalMapRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartUpdateSignalMap");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartUpdateSignalMapResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartUpdateSignalMapResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartUpdateSignalMapResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartUpdateSignalMapRequest, StartUpdateSignalMapResponse>()
                            .withOperationName("StartUpdateSignalMap").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartUpdateSignalMapRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startUpdateSignalMapRequest));
            CompletableFuture<StartUpdateSignalMapResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Stops a running channel
     *
     * @param stopChannelRequest
     *        Placeholder documentation for StopChannelRequest
     * @return A Java Future containing the result of the StopChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to stop the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to stop does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on stop channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to stop due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StopChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopChannelResponse> stopChannel(StopChannelRequest stopChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StopChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopChannelRequest, StopChannelResponse>()
                            .withOperationName("StopChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopChannelRequest));
            CompletableFuture<StopChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Stop an input device that is attached to a MediaConnect flow. (There is no need to stop a device that is attached
     * to a MediaLive input; MediaLive automatically stops the device when the channel stops.)
     *
     * @param stopInputDeviceRequest
     *        Placeholder documentation for StopInputDeviceRequest
     * @return A Java Future containing the result of the StopInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Start operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to stop the input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on stop device calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StopInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopInputDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopInputDeviceResponse> stopInputDevice(StopInputDeviceRequest stopInputDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopInputDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopInputDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopInputDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopInputDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopInputDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopInputDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopInputDeviceRequest, StopInputDeviceResponse>()
                            .withOperationName("StopInputDevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopInputDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopInputDeviceRequest));
            CompletableFuture<StopInputDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Stops a running multiplex. If the multiplex isn't running, this action has no effect.
     *
     * @param stopMultiplexRequest
     *        Placeholder documentation for StopMultiplexRequest
     * @return A Java Future containing the result of the StopMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to stop the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The multiplex that you are trying to stop doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on stop multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to stop due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StopMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopMultiplexResponse> stopMultiplex(StopMultiplexRequest stopMultiplexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopMultiplexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopMultiplexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopMultiplex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopMultiplexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StopMultiplexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopMultiplexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopMultiplexRequest, StopMultiplexResponse>()
                            .withOperationName("StopMultiplex").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopMultiplexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopMultiplexRequest));
            CompletableFuture<StopMultiplexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Start an input device transfer to another AWS account. After you make the request, the other account must accept
     * or reject the transfer.
     *
     * @param transferInputDeviceRequest
     *        A request to transfer an input device.
     * @return A Java Future containing the result of the TransferInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Transfer operation failed, input could not be validated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to transfer input devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException Input device not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on transfer device calls to the input device service.
     *         </li>
     *         <li>ConflictException Input device could not be transferred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.TransferInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/TransferInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<TransferInputDeviceResponse> transferInputDevice(
            TransferInputDeviceRequest transferInputDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(transferInputDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, transferInputDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TransferInputDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TransferInputDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TransferInputDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TransferInputDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TransferInputDeviceRequest, TransferInputDeviceResponse>()
                            .withOperationName("TransferInputDevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TransferInputDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(transferInputDeviceRequest));
            CompletableFuture<TransferInputDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Update account configuration
     *
     * @param updateAccountConfigurationRequest
     *        List of account configuration parameters to update.
     * @return A Java Future containing the result of the UpdateAccountConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The update account configuration request failed validation.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to update the account's configuration.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on update account configuration calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateAccountConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateAccountConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAccountConfigurationResponse> updateAccountConfiguration(
            UpdateAccountConfigurationRequest updateAccountConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAccountConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccountConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccountConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAccountConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAccountConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAccountConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAccountConfigurationRequest, UpdateAccountConfigurationResponse>()
                            .withOperationName("UpdateAccountConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAccountConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAccountConfigurationRequest));
            CompletableFuture<UpdateAccountConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a channel.
     *
     * @param updateChannelRequest
     *        A request to update a channel.
     * @return A Java Future containing the result of the UpdateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The channel configuration failed validation and could not be updated.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to update the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>ConflictException The channel is unable to update due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateChannelResponse> updateChannel(UpdateChannelRequest updateChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateChannelResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateChannelRequest, UpdateChannelResponse>()
                            .withOperationName("UpdateChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateChannelRequest));
            CompletableFuture<UpdateChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Changes the class of the channel.
     *
     * @param updateChannelClassRequest
     *        Channel class that the channel should be updated to.
     * @return A Java Future containing the result of the UpdateChannelClass operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request to update the channel class was invalid.</li>
     *         <li>UnprocessableEntityException The channel configuration failed validation when attempting to update
     *         the channel class.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You do not have permission to update the class of this channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're trying to update the class on does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on update channel class calls.</li>
     *         <li>ConflictException The channel class cannot be updated due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateChannelClass
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelClass" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateChannelClassResponse> updateChannelClass(UpdateChannelClassRequest updateChannelClassRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateChannelClassRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateChannelClassRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateChannelClass");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateChannelClassResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateChannelClassResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateChannelClassResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateChannelClassRequest, UpdateChannelClassResponse>()
                            .withOperationName("UpdateChannelClass").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateChannelClassRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateChannelClassRequest));
            CompletableFuture<UpdateChannelClassResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Change the settings for a ChannelPlacementGroup.
     *
     * @param updateChannelPlacementGroupRequest
     *        A request to update the channel placement group
     * @return A Java Future containing the result of the UpdateChannelPlacementGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>UnprocessableEntityException The channel placement group failed validation and could not be updated.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to update the channel placement group.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on update channel placement group calls to service.</li>
     *         <li>ConflictException The channel placement group is unable to update due to an issue with channel
     *         placement group resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateChannelPlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelPlacementGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateChannelPlacementGroupResponse> updateChannelPlacementGroup(
            UpdateChannelPlacementGroupRequest updateChannelPlacementGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateChannelPlacementGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateChannelPlacementGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateChannelPlacementGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateChannelPlacementGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateChannelPlacementGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateChannelPlacementGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateChannelPlacementGroupRequest, UpdateChannelPlacementGroupResponse>()
                            .withOperationName("UpdateChannelPlacementGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateChannelPlacementGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateChannelPlacementGroupRequest));
            CompletableFuture<UpdateChannelPlacementGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates the specified cloudwatch alarm template.
     *
     * @param updateCloudWatchAlarmTemplateRequest
     *        Placeholder documentation for UpdateCloudWatchAlarmTemplateRequest
     * @return A Java Future containing the result of the UpdateCloudWatchAlarmTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCloudWatchAlarmTemplateResponse> updateCloudWatchAlarmTemplate(
            UpdateCloudWatchAlarmTemplateRequest updateCloudWatchAlarmTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCloudWatchAlarmTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCloudWatchAlarmTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCloudWatchAlarmTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCloudWatchAlarmTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCloudWatchAlarmTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCloudWatchAlarmTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCloudWatchAlarmTemplateRequest, UpdateCloudWatchAlarmTemplateResponse>()
                            .withOperationName("UpdateCloudWatchAlarmTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCloudWatchAlarmTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCloudWatchAlarmTemplateRequest));
            CompletableFuture<UpdateCloudWatchAlarmTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates the specified cloudwatch alarm template group.
     *
     * @param updateCloudWatchAlarmTemplateGroupRequest
     *        Placeholder documentation for UpdateCloudWatchAlarmTemplateGroupRequest
     * @return A Java Future containing the result of the UpdateCloudWatchAlarmTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCloudWatchAlarmTemplateGroupResponse> updateCloudWatchAlarmTemplateGroup(
            UpdateCloudWatchAlarmTemplateGroupRequest updateCloudWatchAlarmTemplateGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCloudWatchAlarmTemplateGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCloudWatchAlarmTemplateGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCloudWatchAlarmTemplateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCloudWatchAlarmTemplateGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateCloudWatchAlarmTemplateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCloudWatchAlarmTemplateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCloudWatchAlarmTemplateGroupRequest, UpdateCloudWatchAlarmTemplateGroupResponse>()
                            .withOperationName("UpdateCloudWatchAlarmTemplateGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCloudWatchAlarmTemplateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCloudWatchAlarmTemplateGroupRequest));
            CompletableFuture<UpdateCloudWatchAlarmTemplateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Change the settings for a Cluster.
     *
     * @param updateClusterRequest
     *        A request to update the cluster.
     * @return A Java Future containing the result of the UpdateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to update the Cluster.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on update Cluster calls to service.</li>
     *         <li>ConflictException The Cluster is unable to update due to an issue with cluster resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateClusterResponse> updateCluster(UpdateClusterRequest updateClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateClusterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateClusterResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateClusterRequest, UpdateClusterResponse>()
                            .withOperationName("UpdateCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateClusterRequest));
            CompletableFuture<UpdateClusterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates the specified eventbridge rule template.
     *
     * @param updateEventBridgeRuleTemplateRequest
     *        Placeholder documentation for UpdateEventBridgeRuleTemplateRequest
     * @return A Java Future containing the result of the UpdateEventBridgeRuleTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEventBridgeRuleTemplateResponse> updateEventBridgeRuleTemplate(
            UpdateEventBridgeRuleTemplateRequest updateEventBridgeRuleTemplateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEventBridgeRuleTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateEventBridgeRuleTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEventBridgeRuleTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEventBridgeRuleTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEventBridgeRuleTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEventBridgeRuleTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEventBridgeRuleTemplateRequest, UpdateEventBridgeRuleTemplateResponse>()
                            .withOperationName("UpdateEventBridgeRuleTemplate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateEventBridgeRuleTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEventBridgeRuleTemplateRequest));
            CompletableFuture<UpdateEventBridgeRuleTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates the specified eventbridge rule template group.
     *
     * @param updateEventBridgeRuleTemplateGroupRequest
     *        Placeholder documentation for UpdateEventBridgeRuleTemplateGroupRequest
     * @return A Java Future containing the result of the UpdateEventBridgeRuleTemplateGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException BadRequestException 400 response</li>
     *         <li>InternalServerErrorException InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException ForbiddenException 403 response</li>
     *         <li>NotFoundException NotFoundException 404 response</li>
     *         <li>TooManyRequestsException TooManyRequestsException 429 response</li>
     *         <li>ConflictException ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEventBridgeRuleTemplateGroupResponse> updateEventBridgeRuleTemplateGroup(
            UpdateEventBridgeRuleTemplateGroupRequest updateEventBridgeRuleTemplateGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEventBridgeRuleTemplateGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateEventBridgeRuleTemplateGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEventBridgeRuleTemplateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEventBridgeRuleTemplateGroupResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateEventBridgeRuleTemplateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEventBridgeRuleTemplateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEventBridgeRuleTemplateGroupRequest, UpdateEventBridgeRuleTemplateGroupResponse>()
                            .withOperationName("UpdateEventBridgeRuleTemplateGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateEventBridgeRuleTemplateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateEventBridgeRuleTemplateGroupRequest));
            CompletableFuture<UpdateEventBridgeRuleTemplateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates an input.
     *
     * @param updateInputRequest
     *        A request to update an input.
     * @return A Java Future containing the result of the UpdateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request to update the input was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException The requester does not have permission to update an input.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The input was not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>ConflictException The input was unable to be updated at this time due to an issue with input
     *         resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInput" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateInputResponse> updateInput(UpdateInputRequest updateInputRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateInputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateInputResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateInputResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateInputRequest, UpdateInputResponse>()
                            .withOperationName("UpdateInput").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateInputRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateInputRequest));
            CompletableFuture<UpdateInputResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates the parameters for the input device.
     *
     * @param updateInputDeviceRequest
     *        A request to update an input device.
     * @return A Java Future containing the result of the UpdateInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Input device failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to update the input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException The input device you're requesting to does not exist. Check the ID.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded on update calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateInputDeviceResponse> updateInputDevice(UpdateInputDeviceRequest updateInputDeviceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateInputDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateInputDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInputDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateInputDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateInputDeviceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateInputDeviceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateInputDeviceRequest, UpdateInputDeviceResponse>()
                            .withOperationName("UpdateInputDevice").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateInputDeviceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateInputDeviceRequest));
            CompletableFuture<UpdateInputDeviceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Update an Input Security Group's Whilelists.
     *
     * @param updateInputSecurityGroupRequest
     *        The request to update some combination of the Input Security Group name and the IPv4 CIDRs the Input
     *        Security Group should allow.
     * @return A Java Future containing the result of the UpdateInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException The request to update the Input Security Group was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to update an Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The Input Security Group was not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>ConflictException The Input Security Group was unable to be updated due to an issue with input
     *         security group resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateInputSecurityGroupResponse> updateInputSecurityGroup(
            UpdateInputSecurityGroupRequest updateInputSecurityGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateInputSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateInputSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInputSecurityGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateInputSecurityGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateInputSecurityGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateInputSecurityGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateInputSecurityGroupRequest, UpdateInputSecurityGroupResponse>()
                            .withOperationName("UpdateInputSecurityGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateInputSecurityGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateInputSecurityGroupRequest));
            CompletableFuture<UpdateInputSecurityGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a multiplex.
     *
     * @param updateMultiplexRequest
     *        A request to update a multiplex.
     * @return A Java Future containing the result of the UpdateMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The multiplex configuration failed validation and could not be updated.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to update the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The multiplex that you are trying to update doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>ConflictException The multiplex is unable to update due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMultiplexResponse> updateMultiplex(UpdateMultiplexRequest updateMultiplexRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMultiplexRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMultiplexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMultiplex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMultiplexResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMultiplexResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMultiplexResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMultiplexRequest, UpdateMultiplexResponse>()
                            .withOperationName("UpdateMultiplex").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateMultiplexRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateMultiplexRequest));
            CompletableFuture<UpdateMultiplexResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Update a program in a multiplex.
     *
     * @param updateMultiplexProgramRequest
     *        A request to update a program in a multiplex.
     * @return A Java Future containing the result of the UpdateMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The multiplex program failed validation and could not be updated.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException You don't have permission to update the multiplex program.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException MediaLive can't update the program. The multiplex or the program that you specified
     *         doesn’t exist. Check the IDs and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>ConflictException The multiplex program is unable to update due to an issue with multiplex resources.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMultiplexProgramResponse> updateMultiplexProgram(
            UpdateMultiplexProgramRequest updateMultiplexProgramRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMultiplexProgramRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMultiplexProgramRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMultiplexProgram");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMultiplexProgramResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMultiplexProgramResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMultiplexProgramResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMultiplexProgramRequest, UpdateMultiplexProgramResponse>()
                            .withOperationName("UpdateMultiplexProgram").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateMultiplexProgramRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateMultiplexProgramRequest));
            CompletableFuture<UpdateMultiplexProgramResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Change the settings for a Network.
     *
     * @param updateNetworkRequest
     *        A request to update the network.
     * @return A Java Future containing the result of the UpdateNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to update the Network.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on update Network calls to service.</li>
     *         <li>ConflictException The Network is unable to update due to an issue with network resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateNetworkResponse> updateNetwork(UpdateNetworkRequest updateNetworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNetworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNetwork");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateNetworkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateNetworkResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateNetworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateNetworkRequest, UpdateNetworkResponse>()
                            .withOperationName("UpdateNetwork").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateNetworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateNetworkRequest));
            CompletableFuture<UpdateNetworkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Change the settings for a Node.
     *
     * @param updateNodeRequest
     *        A request to update the node.
     * @return A Java Future containing the result of the UpdateNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to update the node.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on update node calls to the service.</li>
     *         <li>ConflictException The node is unable to update due to an issue with node resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateNode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateNodeResponse> updateNode(UpdateNodeRequest updateNodeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateNodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateNodeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateNodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateNodeRequest, UpdateNodeResponse>().withOperationName("UpdateNode")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateNodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateNodeRequest));
            CompletableFuture<UpdateNodeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Update the state of a node.
     *
     * @param updateNodeStateRequest
     *        A request to update the state of a node.
     * @return A Java Future containing the result of the UpdateNodeState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The node failed validation and the state could not be updated.</li>
     *         <li>InternalServerErrorException Internal Service Error.</li>
     *         <li>ForbiddenException You don't have permission to update the state of the node.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout.</li>
     *         <li>TooManyRequestsException Request limit exceeded on node calls to service.</li>
     *         <li>ConflictException The node state is unable to updated due to an issue with node resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateNodeState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateNodeState" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateNodeStateResponse> updateNodeState(UpdateNodeStateRequest updateNodeStateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNodeStateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNodeStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNodeState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateNodeStateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateNodeStateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateNodeStateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateNodeStateRequest, UpdateNodeStateResponse>()
                            .withOperationName("UpdateNodeState").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateNodeStateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateNodeStateRequest));
            CompletableFuture<UpdateNodeStateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Update reservation.
     *
     * @param updateReservationRequest
     *        Request to update a reservation
     * @return A Java Future containing the result of the UpdateReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to update reservation</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Reservation not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout</li>
     *         <li>TooManyRequestsException Request limit exceeded</li>
     *         <li>ConflictException The reservation could not be updated</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateReservation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateReservationResponse> updateReservation(UpdateReservationRequest updateReservationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateReservationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateReservationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateReservationRequest, UpdateReservationResponse>()
                            .withOperationName("UpdateReservation").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateReservationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateReservationRequest));
            CompletableFuture<UpdateReservationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public MediaLiveAsyncWaiter waiter() {
        return MediaLiveAsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }

    @Override
    public final MediaLiveServiceClientConfiguration serviceClientConfiguration() {
        return new MediaLiveServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(MediaLiveException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ForbiddenException")
                                .exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadGatewayException")
                                .exceptionBuilderSupplier(BadGatewayException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GatewayTimeoutException")
                                .exceptionBuilderSupplier(GatewayTimeoutException::builder).httpStatusCode(504).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnprocessableEntityException")
                                .exceptionBuilderSupplier(UnprocessableEntityException::builder).httpStatusCode(422).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerErrorException")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        MediaLiveServiceClientConfigurationBuilder serviceConfigBuilder = new MediaLiveServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
