/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.medialive.internal.MediaLiveServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.medialive.model.AcceptInputDeviceTransferRequest;
import software.amazon.awssdk.services.medialive.model.AcceptInputDeviceTransferResponse;
import software.amazon.awssdk.services.medialive.model.BadGatewayException;
import software.amazon.awssdk.services.medialive.model.BadRequestException;
import software.amazon.awssdk.services.medialive.model.BatchDeleteRequest;
import software.amazon.awssdk.services.medialive.model.BatchDeleteResponse;
import software.amazon.awssdk.services.medialive.model.BatchStartRequest;
import software.amazon.awssdk.services.medialive.model.BatchStartResponse;
import software.amazon.awssdk.services.medialive.model.BatchStopRequest;
import software.amazon.awssdk.services.medialive.model.BatchStopResponse;
import software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleRequest;
import software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleResponse;
import software.amazon.awssdk.services.medialive.model.CancelInputDeviceTransferRequest;
import software.amazon.awssdk.services.medialive.model.CancelInputDeviceTransferResponse;
import software.amazon.awssdk.services.medialive.model.ClaimDeviceRequest;
import software.amazon.awssdk.services.medialive.model.ClaimDeviceResponse;
import software.amazon.awssdk.services.medialive.model.ConflictException;
import software.amazon.awssdk.services.medialive.model.CreateChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateChannelRequest;
import software.amazon.awssdk.services.medialive.model.CreateChannelResponse;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.CreateClusterRequest;
import software.amazon.awssdk.services.medialive.model.CreateClusterResponse;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.CreateNetworkRequest;
import software.amazon.awssdk.services.medialive.model.CreateNetworkResponse;
import software.amazon.awssdk.services.medialive.model.CreateNodeRegistrationScriptRequest;
import software.amazon.awssdk.services.medialive.model.CreateNodeRegistrationScriptResponse;
import software.amazon.awssdk.services.medialive.model.CreateNodeRequest;
import software.amazon.awssdk.services.medialive.model.CreateNodeResponse;
import software.amazon.awssdk.services.medialive.model.CreatePartnerInputRequest;
import software.amazon.awssdk.services.medialive.model.CreatePartnerInputResponse;
import software.amazon.awssdk.services.medialive.model.CreateSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.CreateSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.CreateTagsRequest;
import software.amazon.awssdk.services.medialive.model.CreateTagsResponse;
import software.amazon.awssdk.services.medialive.model.DeleteChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteChannelRequest;
import software.amazon.awssdk.services.medialive.model.DeleteChannelResponse;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.DeleteClusterRequest;
import software.amazon.awssdk.services.medialive.model.DeleteClusterResponse;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.DeleteNetworkRequest;
import software.amazon.awssdk.services.medialive.model.DeleteNetworkResponse;
import software.amazon.awssdk.services.medialive.model.DeleteNodeRequest;
import software.amazon.awssdk.services.medialive.model.DeleteNodeResponse;
import software.amazon.awssdk.services.medialive.model.DeleteReservationRequest;
import software.amazon.awssdk.services.medialive.model.DeleteReservationResponse;
import software.amazon.awssdk.services.medialive.model.DeleteScheduleRequest;
import software.amazon.awssdk.services.medialive.model.DeleteScheduleResponse;
import software.amazon.awssdk.services.medialive.model.DeleteSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.DeleteSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.DeleteTagsRequest;
import software.amazon.awssdk.services.medialive.model.DeleteTagsResponse;
import software.amazon.awssdk.services.medialive.model.DescribeAccountConfigurationRequest;
import software.amazon.awssdk.services.medialive.model.DescribeAccountConfigurationResponse;
import software.amazon.awssdk.services.medialive.model.DescribeChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.DescribeChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.DescribeChannelRequest;
import software.amazon.awssdk.services.medialive.model.DescribeChannelResponse;
import software.amazon.awssdk.services.medialive.model.DescribeClusterRequest;
import software.amazon.awssdk.services.medialive.model.DescribeClusterResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.DescribeNetworkRequest;
import software.amazon.awssdk.services.medialive.model.DescribeNetworkResponse;
import software.amazon.awssdk.services.medialive.model.DescribeNodeRequest;
import software.amazon.awssdk.services.medialive.model.DescribeNodeResponse;
import software.amazon.awssdk.services.medialive.model.DescribeOfferingRequest;
import software.amazon.awssdk.services.medialive.model.DescribeOfferingResponse;
import software.amazon.awssdk.services.medialive.model.DescribeReservationRequest;
import software.amazon.awssdk.services.medialive.model.DescribeReservationResponse;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse;
import software.amazon.awssdk.services.medialive.model.DescribeThumbnailsRequest;
import software.amazon.awssdk.services.medialive.model.DescribeThumbnailsResponse;
import software.amazon.awssdk.services.medialive.model.ForbiddenException;
import software.amazon.awssdk.services.medialive.model.GatewayTimeoutException;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.GetSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.GetSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.InternalServerErrorException;
import software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListChannelsRequest;
import software.amazon.awssdk.services.medialive.model.ListChannelsResponse;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesResponse;
import software.amazon.awssdk.services.medialive.model.ListClustersRequest;
import software.amazon.awssdk.services.medialive.model.ListClustersResponse;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesResponse;
import software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest;
import software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListInputsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputsResponse;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse;
import software.amazon.awssdk.services.medialive.model.ListNetworksRequest;
import software.amazon.awssdk.services.medialive.model.ListNetworksResponse;
import software.amazon.awssdk.services.medialive.model.ListNodesRequest;
import software.amazon.awssdk.services.medialive.model.ListNodesResponse;
import software.amazon.awssdk.services.medialive.model.ListOfferingsRequest;
import software.amazon.awssdk.services.medialive.model.ListOfferingsResponse;
import software.amazon.awssdk.services.medialive.model.ListReservationsRequest;
import software.amazon.awssdk.services.medialive.model.ListReservationsResponse;
import software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest;
import software.amazon.awssdk.services.medialive.model.ListSignalMapsResponse;
import software.amazon.awssdk.services.medialive.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.medialive.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.medialive.model.ListVersionsRequest;
import software.amazon.awssdk.services.medialive.model.ListVersionsResponse;
import software.amazon.awssdk.services.medialive.model.MediaLiveException;
import software.amazon.awssdk.services.medialive.model.NotFoundException;
import software.amazon.awssdk.services.medialive.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.medialive.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.medialive.model.RebootInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.RebootInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.RejectInputDeviceTransferRequest;
import software.amazon.awssdk.services.medialive.model.RejectInputDeviceTransferResponse;
import software.amazon.awssdk.services.medialive.model.RestartChannelPipelinesRequest;
import software.amazon.awssdk.services.medialive.model.RestartChannelPipelinesResponse;
import software.amazon.awssdk.services.medialive.model.StartChannelRequest;
import software.amazon.awssdk.services.medialive.model.StartChannelResponse;
import software.amazon.awssdk.services.medialive.model.StartDeleteMonitorDeploymentRequest;
import software.amazon.awssdk.services.medialive.model.StartDeleteMonitorDeploymentResponse;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceMaintenanceWindowRequest;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceMaintenanceWindowResponse;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.StartMonitorDeploymentRequest;
import software.amazon.awssdk.services.medialive.model.StartMonitorDeploymentResponse;
import software.amazon.awssdk.services.medialive.model.StartMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.StartMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.StartUpdateSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.StartUpdateSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.StopChannelRequest;
import software.amazon.awssdk.services.medialive.model.StopChannelResponse;
import software.amazon.awssdk.services.medialive.model.StopInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.StopInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.StopMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.StopMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.TooManyRequestsException;
import software.amazon.awssdk.services.medialive.model.TransferInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.TransferInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.UnprocessableEntityException;
import software.amazon.awssdk.services.medialive.model.UpdateAccountConfigurationRequest;
import software.amazon.awssdk.services.medialive.model.UpdateAccountConfigurationResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelClassRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelClassResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelResponse;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.UpdateClusterRequest;
import software.amazon.awssdk.services.medialive.model.UpdateClusterResponse;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.UpdateNetworkRequest;
import software.amazon.awssdk.services.medialive.model.UpdateNetworkResponse;
import software.amazon.awssdk.services.medialive.model.UpdateNodeRequest;
import software.amazon.awssdk.services.medialive.model.UpdateNodeResponse;
import software.amazon.awssdk.services.medialive.model.UpdateNodeStateRequest;
import software.amazon.awssdk.services.medialive.model.UpdateNodeStateResponse;
import software.amazon.awssdk.services.medialive.model.UpdateReservationRequest;
import software.amazon.awssdk.services.medialive.model.UpdateReservationResponse;
import software.amazon.awssdk.services.medialive.transform.AcceptInputDeviceTransferRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.BatchDeleteRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.BatchStartRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.BatchStopRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.BatchUpdateScheduleRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CancelInputDeviceTransferRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ClaimDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateChannelPlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateCloudWatchAlarmTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateCloudWatchAlarmTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateEventBridgeRuleTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateEventBridgeRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateInputSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateMultiplexProgramRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateNetworkRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateNodeRegistrationScriptRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateNodeRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreatePartnerInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateSignalMapRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteChannelPlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteCloudWatchAlarmTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteCloudWatchAlarmTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteEventBridgeRuleTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteEventBridgeRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteInputSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteMultiplexProgramRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteNetworkRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteNodeRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteReservationRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteScheduleRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteSignalMapRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeAccountConfigurationRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeChannelPlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeClusterRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeInputDeviceThumbnailRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeInputSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeMultiplexProgramRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeNetworkRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeNodeRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeOfferingRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeReservationRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeScheduleRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeThumbnailsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.GetCloudWatchAlarmTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.GetCloudWatchAlarmTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.GetEventBridgeRuleTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.GetEventBridgeRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.GetSignalMapRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListChannelPlacementGroupsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListChannelsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListCloudWatchAlarmTemplateGroupsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListCloudWatchAlarmTemplatesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListClustersRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListEventBridgeRuleTemplateGroupsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListEventBridgeRuleTemplatesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListInputDeviceTransfersRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListInputDevicesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListInputSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListInputsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListMultiplexProgramsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListMultiplexesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListNetworksRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListNodesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListOfferingsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListReservationsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListSignalMapsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListVersionsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.PurchaseOfferingRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.RebootInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.RejectInputDeviceTransferRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.RestartChannelPipelinesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartDeleteMonitorDeploymentRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartInputDeviceMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartMonitorDeploymentRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartUpdateSignalMapRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StopChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StopInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StopMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.TransferInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateAccountConfigurationRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateChannelClassRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateChannelPlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateCloudWatchAlarmTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateCloudWatchAlarmTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateEventBridgeRuleTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateEventBridgeRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateInputSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateMultiplexProgramRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateNetworkRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateNodeRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateNodeStateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateReservationRequestMarshaller;
import software.amazon.awssdk.services.medialive.waiters.MediaLiveWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link MediaLiveClient}.
 *
 * @see MediaLiveClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultMediaLiveClient implements MediaLiveClient {
    private static final Logger log = Logger.loggerFor(DefaultMediaLiveClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMediaLiveClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * Accept an incoming input device transfer. The ownership of the device will transfer to your AWS account.
     *
     * @param acceptInputDeviceTransferRequest
     *        Placeholder documentation for AcceptInputDeviceTransferRequest
     * @return Result of the AcceptInputDeviceTransfer operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to accept input device transfers.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on transfer device calls to the input device service.
     * @throws ConflictException
     *         Input device transfer could not be accepted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.AcceptInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/AcceptInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AcceptInputDeviceTransferResponse acceptInputDeviceTransfer(
            AcceptInputDeviceTransferRequest acceptInputDeviceTransferRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AcceptInputDeviceTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AcceptInputDeviceTransferResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptInputDeviceTransferRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptInputDeviceTransferRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptInputDeviceTransfer");

            return clientHandler
                    .execute(new ClientExecutionParams<AcceptInputDeviceTransferRequest, AcceptInputDeviceTransferResponse>()
                            .withOperationName("AcceptInputDeviceTransfer").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(acceptInputDeviceTransferRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AcceptInputDeviceTransferRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Starts delete of resources.
     *
     * @param batchDeleteRequest
     *        A request to delete resources
     * @return Result of the BatchDelete operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to delete the resources.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The resources you're requesting to delete do not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete resources calls.
     * @throws ConflictException
     *         The resources are unable to delete.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.BatchDelete
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchDelete" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchDeleteResponse batchDelete(BatchDeleteRequest batchDeleteRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchDeleteResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDelete");

            return clientHandler.execute(new ClientExecutionParams<BatchDeleteRequest, BatchDeleteResponse>()
                    .withOperationName("BatchDelete").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(batchDeleteRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchDeleteRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Starts existing resources
     *
     * @param batchStartRequest
     *        A request to start resources
     * @return Result of the BatchStart operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to start the resources.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The resources you're requesting to start do not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on start resources calls to resource service.
     * @throws ConflictException
     *         The resources are unable to start.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.BatchStart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchStart" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchStartResponse batchStart(BatchStartRequest batchStartRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchStartResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchStartResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchStartRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchStartRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchStart");

            return clientHandler.execute(new ClientExecutionParams<BatchStartRequest, BatchStartResponse>()
                    .withOperationName("BatchStart").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(batchStartRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchStartRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Stops running resources
     *
     * @param batchStopRequest
     *        A request to stop resources
     * @return Result of the BatchStop operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to stop the resources.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The resources you're requesting to stop do not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on stop resources.
     * @throws ConflictException
     *         The resources are unable to stop.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.BatchStop
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchStop" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchStopResponse batchStop(BatchStopRequest batchStopRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchStopResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchStopResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchStopRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchStopRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchStop");

            return clientHandler.execute(new ClientExecutionParams<BatchStopRequest, BatchStopResponse>()
                    .withOperationName("BatchStop").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(batchStopRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchStopRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Update a channel schedule
     *
     * @param batchUpdateScheduleRequest
     *        List of actions to create and list of actions to delete.
     * @return Result of the BatchUpdateSchedule operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The update schedule request failed validation.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to update the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The specified channel id does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on update schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.BatchUpdateSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchUpdateSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public BatchUpdateScheduleResponse batchUpdateSchedule(BatchUpdateScheduleRequest batchUpdateScheduleRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchUpdateScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchUpdateScheduleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchUpdateScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchUpdateScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateSchedule");

            return clientHandler.execute(new ClientExecutionParams<BatchUpdateScheduleRequest, BatchUpdateScheduleResponse>()
                    .withOperationName("BatchUpdateSchedule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchUpdateScheduleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchUpdateScheduleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Cancel an input device transfer that you have requested.
     *
     * @param cancelInputDeviceTransferRequest
     *        Placeholder documentation for CancelInputDeviceTransferRequest
     * @return Result of the CancelInputDeviceTransfer operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to cancel input device transfers.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on transfer device calls to the input device service.
     * @throws ConflictException
     *         Input device transfer could not be canceled.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CancelInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CancelInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelInputDeviceTransferResponse cancelInputDeviceTransfer(
            CancelInputDeviceTransferRequest cancelInputDeviceTransferRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelInputDeviceTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelInputDeviceTransferResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelInputDeviceTransferRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelInputDeviceTransferRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelInputDeviceTransfer");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelInputDeviceTransferRequest, CancelInputDeviceTransferResponse>()
                            .withOperationName("CancelInputDeviceTransfer").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelInputDeviceTransferRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelInputDeviceTransferRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Send a request to claim an AWS Elemental device that you have purchased from a third-party vendor. After the
     * request succeeds, you will own the device.
     *
     * @param claimDeviceRequest
     *        A request to claim an AWS Elemental device that you have purchased from a third-party vendor.
     * @return Result of the ClaimDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Claim operation failed, device id could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have the IAM access permissions to claim this device. You must have permission for the
     *         WriteClaim operation.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Device not found or you called an unsupported region.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded. Your have sent this request too many times. There might be a bug in your API
     *         client.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ClaimDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ClaimDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ClaimDeviceResponse claimDevice(ClaimDeviceRequest claimDeviceRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException,
            MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ClaimDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ClaimDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(claimDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, claimDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ClaimDevice");

            return clientHandler.execute(new ClientExecutionParams<ClaimDeviceRequest, ClaimDeviceResponse>()
                    .withOperationName("ClaimDevice").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(claimDeviceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ClaimDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Creates a new channel
     *
     * @param createChannelRequest
     *        A request to create a channel
     * @return Result of the CreateChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The Channel failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to create the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on create channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to create due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateChannelResponse createChannel(CreateChannelRequest createChannelRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateChannel");

            return clientHandler.execute(new ClientExecutionParams<CreateChannelRequest, CreateChannelResponse>()
                    .withOperationName("CreateChannel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createChannelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create a ChannelPlacementGroup in the specified Cluster. As part of the create operation, you specify the Nodes
     * to attach the group to.After you create a ChannelPlacementGroup, you add Channels to the group (you do this by
     * modifying the Channels to add them to a specific group). You now have an association of Channels to
     * ChannelPlacementGroup, and ChannelPlacementGroup to Nodes. This association means that all the Channels in the
     * group are able to run on any of the Nodes associated with the group.
     *
     * @param createChannelPlacementGroupRequest
     *        A request to create a channel placement group.
     * @return Result of the CreateChannelPlacementGroup operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The channel placement group failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to create a channel placement group in this cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded in createNode calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateChannelPlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannelPlacementGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateChannelPlacementGroupResponse createChannelPlacementGroup(
            CreateChannelPlacementGroupRequest createChannelPlacementGroupRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateChannelPlacementGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateChannelPlacementGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createChannelPlacementGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createChannelPlacementGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateChannelPlacementGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateChannelPlacementGroupRequest, CreateChannelPlacementGroupResponse>()
                            .withOperationName("CreateChannelPlacementGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createChannelPlacementGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateChannelPlacementGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Creates a cloudwatch alarm template to dynamically generate cloudwatch metric alarms on targeted resource types.
     *
     * @param createCloudWatchAlarmTemplateRequest
     *        Placeholder documentation for CreateCloudWatchAlarmTemplateRequest
     * @return Result of the CreateCloudWatchAlarmTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCloudWatchAlarmTemplateResponse createCloudWatchAlarmTemplate(
            CreateCloudWatchAlarmTemplateRequest createCloudWatchAlarmTemplateRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCloudWatchAlarmTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCloudWatchAlarmTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCloudWatchAlarmTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCloudWatchAlarmTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCloudWatchAlarmTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCloudWatchAlarmTemplateRequest, CreateCloudWatchAlarmTemplateResponse>()
                            .withOperationName("CreateCloudWatchAlarmTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCloudWatchAlarmTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCloudWatchAlarmTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Creates a cloudwatch alarm template group to group your cloudwatch alarm templates and to attach to signal maps
     * for dynamically creating alarms.
     *
     * @param createCloudWatchAlarmTemplateGroupRequest
     *        Placeholder documentation for CreateCloudWatchAlarmTemplateGroupRequest
     * @return Result of the CreateCloudWatchAlarmTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCloudWatchAlarmTemplateGroupResponse createCloudWatchAlarmTemplateGroup(
            CreateCloudWatchAlarmTemplateGroupRequest createCloudWatchAlarmTemplateGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCloudWatchAlarmTemplateGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCloudWatchAlarmTemplateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCloudWatchAlarmTemplateGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCloudWatchAlarmTemplateGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCloudWatchAlarmTemplateGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCloudWatchAlarmTemplateGroupRequest, CreateCloudWatchAlarmTemplateGroupResponse>()
                            .withOperationName("CreateCloudWatchAlarmTemplateGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCloudWatchAlarmTemplateGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCloudWatchAlarmTemplateGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create a new Cluster.
     *
     * @param createClusterRequest
     *        Create as many Clusters as you want, but create at least one. Each Cluster groups together Nodes that you
     *        want to treat as a collection. Within the Cluster, you will set up some Nodes as active Nodes, and some as
     *        backup Nodes, for Node failover purposes. Each Node can belong to only one Cluster.
     * @return Result of the CreateCluster operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to create the Cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on create Cluster calls to service.
     * @throws ConflictException
     *         The Cluster is unable to create due to an issue with cluster resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateClusterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCluster");

            return clientHandler.execute(new ClientExecutionParams<CreateClusterRequest, CreateClusterResponse>()
                    .withOperationName("CreateCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Creates an eventbridge rule template to monitor events and send notifications to your targeted resources.
     *
     * @param createEventBridgeRuleTemplateRequest
     *        Placeholder documentation for CreateEventBridgeRuleTemplateRequest
     * @return Result of the CreateEventBridgeRuleTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEventBridgeRuleTemplateResponse createEventBridgeRuleTemplate(
            CreateEventBridgeRuleTemplateRequest createEventBridgeRuleTemplateRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEventBridgeRuleTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEventBridgeRuleTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEventBridgeRuleTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createEventBridgeRuleTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventBridgeRuleTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateEventBridgeRuleTemplateRequest, CreateEventBridgeRuleTemplateResponse>()
                            .withOperationName("CreateEventBridgeRuleTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createEventBridgeRuleTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateEventBridgeRuleTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Creates an eventbridge rule template group to group your eventbridge rule templates and to attach to signal maps
     * for dynamically creating notification rules.
     *
     * @param createEventBridgeRuleTemplateGroupRequest
     *        Placeholder documentation for CreateEventBridgeRuleTemplateGroupRequest
     * @return Result of the CreateEventBridgeRuleTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEventBridgeRuleTemplateGroupResponse createEventBridgeRuleTemplateGroup(
            CreateEventBridgeRuleTemplateGroupRequest createEventBridgeRuleTemplateGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEventBridgeRuleTemplateGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEventBridgeRuleTemplateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEventBridgeRuleTemplateGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createEventBridgeRuleTemplateGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventBridgeRuleTemplateGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateEventBridgeRuleTemplateGroupRequest, CreateEventBridgeRuleTemplateGroupResponse>()
                            .withOperationName("CreateEventBridgeRuleTemplateGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createEventBridgeRuleTemplateGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateEventBridgeRuleTemplateGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create an input
     *
     * @param createInputRequest
     *        The name of the input
     * @return Result of the CreateInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInput" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateInputResponse createInput(CreateInputRequest createInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateInputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateInputResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInput");

            return clientHandler.execute(new ClientExecutionParams<CreateInputRequest, CreateInputResponse>()
                    .withOperationName("CreateInput").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createInputRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateInputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Creates a Input Security Group
     *
     * @param createInputSecurityGroupRequest
     *        The IPv4 CIDRs to whitelist for this Input Security Group
     * @return Result of the CreateInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to create an Input Security Group was Invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to create an Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateInputSecurityGroupResponse createInputSecurityGroup(
            CreateInputSecurityGroupRequest createInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateInputSecurityGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateInputSecurityGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInputSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInputSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInputSecurityGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateInputSecurityGroupRequest, CreateInputSecurityGroupResponse>()
                            .withOperationName("CreateInputSecurityGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createInputSecurityGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateInputSecurityGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create a new multiplex.
     *
     * @param createMultiplexRequest
     *        A request to create a multiplex.
     * @return Result of the CreateMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The Multiplex failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to create the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on create multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to create due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateMultiplexResponse createMultiplex(CreateMultiplexRequest createMultiplexRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMultiplexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateMultiplexResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMultiplexRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMultiplexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMultiplex");

            return clientHandler.execute(new ClientExecutionParams<CreateMultiplexRequest, CreateMultiplexResponse>()
                    .withOperationName("CreateMultiplex").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createMultiplexRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateMultiplexRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create a new program in the multiplex.
     *
     * @param createMultiplexProgramRequest
     *        A request to create a program in a multiplex.
     * @return Result of the CreateMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The Multiplex program failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to create a program.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on create multiplex program calls to multiplex service.
     * @throws ConflictException
     *         The multiplex program is unable to create due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMultiplexProgramResponse createMultiplexProgram(CreateMultiplexProgramRequest createMultiplexProgramRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMultiplexProgramResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMultiplexProgramResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMultiplexProgramRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMultiplexProgramRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMultiplexProgram");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMultiplexProgramRequest, CreateMultiplexProgramResponse>()
                            .withOperationName("CreateMultiplexProgram").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createMultiplexProgramRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMultiplexProgramRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create as many Networks as you need. You will associate one or more Clusters with each Network.Each Network
     * provides MediaLive Anywhere with required information about the network in your organization that you are using
     * for video encoding using MediaLive.
     *
     * @param createNetworkRequest
     *        A request to create a Network.
     * @return Result of the CreateNetwork operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to create the Network.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on create Network calls to service.
     * @throws ConflictException
     *         The Network is unable to create due to an issue with network resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateNetworkResponse createNetwork(CreateNetworkRequest createNetworkRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateNetworkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateNetworkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNetworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetwork");

            return clientHandler.execute(new ClientExecutionParams<CreateNetworkRequest, CreateNetworkResponse>()
                    .withOperationName("CreateNetwork").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createNetworkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateNetworkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create a Node in the specified Cluster. You can also create Nodes using the CreateNodeRegistrationScript. Note
     * that you can't move a Node to another Cluster.
     *
     * @param createNodeRequest
     *        A request to create a node
     * @return Result of the CreateNode operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The node failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to create a node in this cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded in createNode calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateNode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateNodeResponse createNode(CreateNodeRequest createNodeRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateNodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateNodeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNode");

            return clientHandler.execute(new ClientExecutionParams<CreateNodeRequest, CreateNodeResponse>()
                    .withOperationName("CreateNode").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createNodeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateNodeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create the Register Node script for all the nodes intended for a specific Cluster. You will then run the script
     * on each hardware unit that is intended for that Cluster. The script creates a Node in the specified Cluster. It
     * then binds the Node to this hardware unit, and activates the node hardware for use with MediaLive Anywhere.
     *
     * @param createNodeRegistrationScriptRequest
     *        A request to create a new node registration script.
     * @return Result of the CreateNodeRegistrationScript operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to create a node registration script for this cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on create node registration script calls to service.
     * @throws ConflictException
     *         The node registration script is unable to be created due to an issue with cluster resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateNodeRegistrationScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateNodeRegistrationScript"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateNodeRegistrationScriptResponse createNodeRegistrationScript(
            CreateNodeRegistrationScriptRequest createNodeRegistrationScriptRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateNodeRegistrationScriptResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateNodeRegistrationScriptResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNodeRegistrationScriptRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNodeRegistrationScriptRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNodeRegistrationScript");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateNodeRegistrationScriptRequest, CreateNodeRegistrationScriptResponse>()
                            .withOperationName("CreateNodeRegistrationScript").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createNodeRegistrationScriptRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateNodeRegistrationScriptRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create a partner input
     *
     * @param createPartnerInputRequest
     *        A request to create a partner input
     * @return Result of the CreatePartnerInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreatePartnerInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreatePartnerInput" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreatePartnerInputResponse createPartnerInput(CreatePartnerInputRequest createPartnerInputRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePartnerInputResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePartnerInputResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPartnerInputRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPartnerInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePartnerInput");

            return clientHandler.execute(new ClientExecutionParams<CreatePartnerInputRequest, CreatePartnerInputResponse>()
                    .withOperationName("CreatePartnerInput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPartnerInputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePartnerInputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Initiates the creation of a new signal map. Will discover a new mediaResourceMap based on the provided
     * discoveryEntryPointArn.
     *
     * @param createSignalMapRequest
     *        Placeholder documentation for CreateSignalMapRequest
     * @return Result of the CreateSignalMap operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSignalMapResponse createSignalMap(CreateSignalMapRequest createSignalMapRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSignalMapResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSignalMapResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSignalMapRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSignalMapRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSignalMap");

            return clientHandler.execute(new ClientExecutionParams<CreateSignalMapRequest, CreateSignalMapResponse>()
                    .withOperationName("CreateSignalMap").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSignalMapRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSignalMapRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create tags for a resource
     *
     * @param createTagsRequest
     *        Placeholder documentation for CreateTagsRequest
     * @return Result of the CreateTags operation returned by the service.
     * @throws NotFoundException
     *         The arn was not found.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTags");

            return clientHandler.execute(new ClientExecutionParams<CreateTagsRequest, CreateTagsResponse>()
                    .withOperationName("CreateTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createTagsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Starts deletion of channel. The associated outputs are also deleted.
     *
     * @param deleteChannelRequest
     *        Placeholder documentation for DeleteChannelRequest
     * @return Result of the DeleteChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to delete the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to delete does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to delete due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteChannelResponse deleteChannel(DeleteChannelRequest deleteChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteChannel");

            return clientHandler.execute(new ClientExecutionParams<DeleteChannelRequest, DeleteChannelResponse>()
                    .withOperationName("DeleteChannel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteChannelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Delete the specified ChannelPlacementGroup that exists in the specified Cluster.
     *
     * @param deleteChannelPlacementGroupRequest
     *        Placeholder documentation for DeleteChannelPlacementGroupRequest
     * @return Result of the DeleteChannelPlacementGroup operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to delete the channel placement group.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The channel placement group that you are trying to delete does not exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete channel placement group calls to the cluster service.
     * @throws ConflictException
     *         The channel placement group is unable to delete due to an issue with channel placement group resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteChannelPlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannelPlacementGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteChannelPlacementGroupResponse deleteChannelPlacementGroup(
            DeleteChannelPlacementGroupRequest deleteChannelPlacementGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteChannelPlacementGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteChannelPlacementGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteChannelPlacementGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteChannelPlacementGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteChannelPlacementGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteChannelPlacementGroupRequest, DeleteChannelPlacementGroupResponse>()
                            .withOperationName("DeleteChannelPlacementGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteChannelPlacementGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteChannelPlacementGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Deletes a cloudwatch alarm template.
     *
     * @param deleteCloudWatchAlarmTemplateRequest
     *        Placeholder documentation for DeleteCloudWatchAlarmTemplateRequest
     * @return Result of the DeleteCloudWatchAlarmTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCloudWatchAlarmTemplateResponse deleteCloudWatchAlarmTemplate(
            DeleteCloudWatchAlarmTemplateRequest deleteCloudWatchAlarmTemplateRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCloudWatchAlarmTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCloudWatchAlarmTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCloudWatchAlarmTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCloudWatchAlarmTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCloudWatchAlarmTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCloudWatchAlarmTemplateRequest, DeleteCloudWatchAlarmTemplateResponse>()
                            .withOperationName("DeleteCloudWatchAlarmTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCloudWatchAlarmTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCloudWatchAlarmTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Deletes a cloudwatch alarm template group. You must detach this group from all signal maps and ensure its
     * existing templates are moved to another group or deleted.
     *
     * @param deleteCloudWatchAlarmTemplateGroupRequest
     *        Placeholder documentation for DeleteCloudWatchAlarmTemplateGroupRequest
     * @return Result of the DeleteCloudWatchAlarmTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCloudWatchAlarmTemplateGroupResponse deleteCloudWatchAlarmTemplateGroup(
            DeleteCloudWatchAlarmTemplateGroupRequest deleteCloudWatchAlarmTemplateGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCloudWatchAlarmTemplateGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCloudWatchAlarmTemplateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCloudWatchAlarmTemplateGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCloudWatchAlarmTemplateGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCloudWatchAlarmTemplateGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCloudWatchAlarmTemplateGroupRequest, DeleteCloudWatchAlarmTemplateGroupResponse>()
                            .withOperationName("DeleteCloudWatchAlarmTemplateGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCloudWatchAlarmTemplateGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCloudWatchAlarmTemplateGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Delete a Cluster. The Cluster must be idle.
     *
     * @param deleteClusterRequest
     *        Placeholder documentation for DeleteClusterRequest
     * @return Result of the DeleteCluster operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to delete the cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The cluster that you are trying to delete doesn't exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete cluster calls to cluster service.
     * @throws ConflictException
     *         The cluster is unable to delete due to an issue with cluster resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteClusterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCluster");

            return clientHandler.execute(new ClientExecutionParams<DeleteClusterRequest, DeleteClusterResponse>()
                    .withOperationName("DeleteCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Deletes an eventbridge rule template.
     *
     * @param deleteEventBridgeRuleTemplateRequest
     *        Placeholder documentation for DeleteEventBridgeRuleTemplateRequest
     * @return Result of the DeleteEventBridgeRuleTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEventBridgeRuleTemplateResponse deleteEventBridgeRuleTemplate(
            DeleteEventBridgeRuleTemplateRequest deleteEventBridgeRuleTemplateRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEventBridgeRuleTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEventBridgeRuleTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventBridgeRuleTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteEventBridgeRuleTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventBridgeRuleTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteEventBridgeRuleTemplateRequest, DeleteEventBridgeRuleTemplateResponse>()
                            .withOperationName("DeleteEventBridgeRuleTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteEventBridgeRuleTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteEventBridgeRuleTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Deletes an eventbridge rule template group. You must detach this group from all signal maps and ensure its
     * existing templates are moved to another group or deleted.
     *
     * @param deleteEventBridgeRuleTemplateGroupRequest
     *        Placeholder documentation for DeleteEventBridgeRuleTemplateGroupRequest
     * @return Result of the DeleteEventBridgeRuleTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEventBridgeRuleTemplateGroupResponse deleteEventBridgeRuleTemplateGroup(
            DeleteEventBridgeRuleTemplateGroupRequest deleteEventBridgeRuleTemplateGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEventBridgeRuleTemplateGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEventBridgeRuleTemplateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventBridgeRuleTemplateGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteEventBridgeRuleTemplateGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventBridgeRuleTemplateGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteEventBridgeRuleTemplateGroupRequest, DeleteEventBridgeRuleTemplateGroupResponse>()
                            .withOperationName("DeleteEventBridgeRuleTemplateGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteEventBridgeRuleTemplateGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteEventBridgeRuleTemplateGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Deletes the input end point
     *
     * @param deleteInputRequest
     *        Placeholder documentation for DeleteInputRequest
     * @return Result of the DeleteInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws ConflictException
     *         Resource conflict
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInput" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteInputResponse deleteInput(DeleteInputRequest deleteInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteInputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteInputResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInput");

            return clientHandler.execute(new ClientExecutionParams<DeleteInputRequest, DeleteInputResponse>()
                    .withOperationName("DeleteInput").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteInputRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteInputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Deletes an Input Security Group
     *
     * @param deleteInputSecurityGroupRequest
     *        Placeholder documentation for DeleteInputSecurityGroupRequest
     * @return Result of the DeleteInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to delete the Input Security Group was Invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to delete this Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input Security Group not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteInputSecurityGroupResponse deleteInputSecurityGroup(
            DeleteInputSecurityGroupRequest deleteInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteInputSecurityGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteInputSecurityGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteInputSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInputSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInputSecurityGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteInputSecurityGroupRequest, DeleteInputSecurityGroupResponse>()
                            .withOperationName("DeleteInputSecurityGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteInputSecurityGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteInputSecurityGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Delete a multiplex. The multiplex must be idle.
     *
     * @param deleteMultiplexRequest
     *        Placeholder documentation for DeleteMultiplexRequest
     * @return Result of the DeleteMultiplex operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to delete the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The multiplex that you are trying to delete doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to delete due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteMultiplexResponse deleteMultiplex(DeleteMultiplexRequest deleteMultiplexRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMultiplexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteMultiplexResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMultiplexRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMultiplexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMultiplex");

            return clientHandler.execute(new ClientExecutionParams<DeleteMultiplexRequest, DeleteMultiplexResponse>()
                    .withOperationName("DeleteMultiplex").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteMultiplexRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteMultiplexRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Delete a program from a multiplex.
     *
     * @param deleteMultiplexProgramRequest
     *        Placeholder documentation for DeleteMultiplexProgramRequest
     * @return Result of the DeleteMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to delete the multiplex program.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The program that you are trying to delete doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete multiplex program calls to multiplex service.
     * @throws ConflictException
     *         The multiplex program is unable to delete due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMultiplexProgramResponse deleteMultiplexProgram(DeleteMultiplexProgramRequest deleteMultiplexProgramRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMultiplexProgramResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMultiplexProgramResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMultiplexProgramRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMultiplexProgramRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMultiplexProgram");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteMultiplexProgramRequest, DeleteMultiplexProgramResponse>()
                            .withOperationName("DeleteMultiplexProgram").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteMultiplexProgramRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteMultiplexProgramRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Delete a Network. The Network must have no resources associated with it.
     *
     * @param deleteNetworkRequest
     *        Placeholder documentation for DeleteNetworkRequest
     * @return Result of the DeleteNetwork operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to delete the network.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The network that you are trying to delete doesnâ€™t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete network calls to network service.
     * @throws ConflictException
     *         The network is unable to delete due to an issue with network resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteNetworkResponse deleteNetwork(DeleteNetworkRequest deleteNetworkRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteNetworkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteNetworkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNetworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetwork");

            return clientHandler.execute(new ClientExecutionParams<DeleteNetworkRequest, DeleteNetworkResponse>()
                    .withOperationName("DeleteNetwork").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteNetworkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteNetworkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Delete a Node. The Node must be IDLE.
     *
     * @param deleteNodeRequest
     *        Placeholder documentation for DeleteNodeRequest
     * @return Result of the DeleteNode operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to delete the node.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The node that you are trying to delete doesnâ€™t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete node calls to the cluster service.
     * @throws ConflictException
     *         The node is unable to delete due to an issue with node resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteNode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteNodeResponse deleteNode(DeleteNodeRequest deleteNodeRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteNodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteNodeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNode");

            return clientHandler.execute(new ClientExecutionParams<DeleteNodeRequest, DeleteNodeResponse>()
                    .withOperationName("DeleteNode").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteNodeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteNodeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Delete an expired reservation.
     *
     * @param deleteReservationRequest
     *        Placeholder documentation for DeleteReservationRequest
     * @return Result of the DeleteReservation operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to delete reservation
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Reservation you're attempting to delete does not exist
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete reservation request
     * @throws ConflictException
     *         The reservation could not be deleted because it is currently active.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteReservation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteReservationResponse deleteReservation(DeleteReservationRequest deleteReservationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteReservationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteReservationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReservation");

            return clientHandler.execute(new ClientExecutionParams<DeleteReservationRequest, DeleteReservationResponse>()
                    .withOperationName("DeleteReservation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteReservationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteReservationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Delete all schedule actions on a channel.
     *
     * @param deleteScheduleRequest
     *        Placeholder documentation for DeleteScheduleRequest
     * @return Result of the DeleteSchedule operation returned by the service.
     * @throws BadRequestException
     *         This request to delete the schedule on this channel was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to delete the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The specified channel does not exist to have its schedule deleted.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteScheduleResponse deleteSchedule(DeleteScheduleRequest deleteScheduleRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteScheduleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteScheduleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteScheduleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSchedule");

            return clientHandler.execute(new ClientExecutionParams<DeleteScheduleRequest, DeleteScheduleResponse>()
                    .withOperationName("DeleteSchedule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteScheduleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteScheduleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Deletes the specified signal map.
     *
     * @param deleteSignalMapRequest
     *        Placeholder documentation for DeleteSignalMapRequest
     * @return Result of the DeleteSignalMap operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSignalMapResponse deleteSignalMap(DeleteSignalMapRequest deleteSignalMapRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSignalMapResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSignalMapResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSignalMapRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSignalMapRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSignalMap");

            return clientHandler.execute(new ClientExecutionParams<DeleteSignalMapRequest, DeleteSignalMapResponse>()
                    .withOperationName("DeleteSignalMap").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteSignalMapRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSignalMapRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Removes tags for a resource
     *
     * @param deleteTagsRequest
     *        Placeholder documentation for DeleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws NotFoundException
     *         The arn was not found.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTags");

            return clientHandler.execute(new ClientExecutionParams<DeleteTagsRequest, DeleteTagsResponse>()
                    .withOperationName("DeleteTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteTagsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Describe account configuration
     *
     * @param describeAccountConfigurationRequest
     *        Placeholder documentation for DescribeAccountConfigurationRequest
     * @return Result of the DescribeAccountConfiguration operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to describe the account configuration.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe account configuration calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeAccountConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeAccountConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountConfigurationResponse describeAccountConfiguration(
            DescribeAccountConfigurationRequest describeAccountConfigurationRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAccountConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountConfigurationRequest, DescribeAccountConfigurationResponse>()
                            .withOperationName("DescribeAccountConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAccountConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Gets details about a channel
     *
     * @param describeChannelRequest
     *        Placeholder documentation for DescribeChannelRequest
     * @return Result of the DescribeChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to describe the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to describe does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeChannelResponse describeChannel(DescribeChannelRequest describeChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeChannel");

            return clientHandler.execute(new ClientExecutionParams<DescribeChannelRequest, DescribeChannelResponse>()
                    .withOperationName("DescribeChannel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeChannelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Get details about a ChannelPlacementGroup.
     *
     * @param describeChannelPlacementGroupRequest
     *        Placeholder documentation for DescribeChannelPlacementGroupRequest
     * @return Result of the DescribeChannelPlacementGroup operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You do not have permission to describe the channel placement group.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The channel placement group that you are trying to describe does not exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe channel placement group calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeChannelPlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannelPlacementGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeChannelPlacementGroupResponse describeChannelPlacementGroup(
            DescribeChannelPlacementGroupRequest describeChannelPlacementGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeChannelPlacementGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeChannelPlacementGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeChannelPlacementGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeChannelPlacementGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeChannelPlacementGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeChannelPlacementGroupRequest, DescribeChannelPlacementGroupResponse>()
                            .withOperationName("DescribeChannelPlacementGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeChannelPlacementGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeChannelPlacementGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Get details about a Cluster.
     *
     * @param describeClusterRequest
     *        Placeholder documentation for DescribeClusterRequest
     * @return Result of the DescribeCluster operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to describe the cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The cluster that you are trying to describe does not exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe cluster calls to cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeClusterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCluster");

            return clientHandler.execute(new ClientExecutionParams<DescribeClusterRequest, DescribeClusterResponse>()
                    .withOperationName("DescribeCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Produces details about an input
     *
     * @param describeInputRequest
     *        Placeholder documentation for DescribeInputRequest
     * @return Result of the DescribeInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInput" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeInputResponse describeInput(DescribeInputRequest describeInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeInputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeInputResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInput");

            return clientHandler.execute(new ClientExecutionParams<DescribeInputRequest, DescribeInputResponse>()
                    .withOperationName("DescribeInput").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeInputRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeInputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Gets the details for the input device
     *
     * @param describeInputDeviceRequest
     *        Placeholder documentation for DescribeInputDeviceRequest
     * @return Result of the DescribeInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe the input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         The input device you're requesting to describe does not exist. Check the ID.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeInputDeviceResponse describeInputDevice(DescribeInputDeviceRequest describeInputDeviceRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeInputDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeInputDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInputDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInputDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInputDevice");

            return clientHandler.execute(new ClientExecutionParams<DescribeInputDeviceRequest, DescribeInputDeviceResponse>()
                    .withOperationName("DescribeInputDevice").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeInputDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeInputDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Get the latest thumbnail data for the input device.
     *
     * @param describeInputDeviceThumbnailRequest
     *        Placeholder documentation for DescribeInputDeviceThumbnailRequest
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled
     *        DescribeInputDeviceThumbnailResponse and an InputStream to the response content are provided as parameters
     *        to the callback. The callback may return a transformed type which will be the return value of this method.
     *        See {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this
     *        interface and for links to pre-canned implementations for common scenarios like downloading to a file. The
     *        service documentation for the response content is as follows 'The binary data for the thumbnail that the
     *        Link device has most recently sent to MediaLive.'.
     * @return The transformed result of the ResponseTransformer.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe input device thumbnail.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on get thumbnail calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputDeviceThumbnail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDeviceThumbnail"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public <ReturnT> ReturnT describeInputDeviceThumbnail(
            DescribeInputDeviceThumbnailRequest describeInputDeviceThumbnailRequest,
            ResponseTransformer<DescribeInputDeviceThumbnailResponse, ReturnT> responseTransformer) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true)
                .isPayloadJson(false).build();

        HttpResponseHandler<DescribeInputDeviceThumbnailResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeInputDeviceThumbnailResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInputDeviceThumbnailRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInputDeviceThumbnailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInputDeviceThumbnail");

            return clientHandler.execute(
                    new ClientExecutionParams<DescribeInputDeviceThumbnailRequest, DescribeInputDeviceThumbnailResponse>()
                            .withOperationName("DescribeInputDeviceThumbnail").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeInputDeviceThumbnailRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeInputDeviceThumbnailRequestMarshaller(protocolFactory)),
                    responseTransformer);
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Produces a summary of an Input Security Group
     *
     * @param describeInputSecurityGroupRequest
     *        Placeholder documentation for DescribeInputSecurityGroupRequest
     * @return Result of the DescribeInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to describe an Input Security Group was Invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to describe this Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input Security Group not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInputSecurityGroupResponse describeInputSecurityGroup(
            DescribeInputSecurityGroupRequest describeInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeInputSecurityGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeInputSecurityGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInputSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInputSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInputSecurityGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeInputSecurityGroupRequest, DescribeInputSecurityGroupResponse>()
                            .withOperationName("DescribeInputSecurityGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeInputSecurityGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeInputSecurityGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Gets details about a multiplex.
     *
     * @param describeMultiplexRequest
     *        Placeholder documentation for DescribeMultiplexRequest
     * @return Result of the DescribeMultiplex operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to describe the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The multiplex that you are trying to describe doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplex" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeMultiplexResponse describeMultiplex(DescribeMultiplexRequest describeMultiplexRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeMultiplexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeMultiplexResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMultiplexRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMultiplexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMultiplex");

            return clientHandler.execute(new ClientExecutionParams<DescribeMultiplexRequest, DescribeMultiplexResponse>()
                    .withOperationName("DescribeMultiplex").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeMultiplexRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeMultiplexRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Get the details for a program in a multiplex.
     *
     * @param describeMultiplexProgramRequest
     *        Placeholder documentation for DescribeMultiplexProgramRequest
     * @return Result of the DescribeMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to describe the multiplex program.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         MediaLive can't describe the program. The multiplex or the program that you specified doesn’t exist.
     *         Check the IDs and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe multiplex program calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMultiplexProgramResponse describeMultiplexProgram(
            DescribeMultiplexProgramRequest describeMultiplexProgramRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeMultiplexProgramResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeMultiplexProgramResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMultiplexProgramRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMultiplexProgramRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMultiplexProgram");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeMultiplexProgramRequest, DescribeMultiplexProgramResponse>()
                            .withOperationName("DescribeMultiplexProgram").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeMultiplexProgramRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeMultiplexProgramRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Get details about a Network.
     *
     * @param describeNetworkRequest
     *        Placeholder documentation for DescribeNetworkRequest
     * @return Result of the DescribeNetwork operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to describe the network.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The network that you are trying to describe does not exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe network calls to network service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeNetworkResponse describeNetwork(DescribeNetworkRequest describeNetworkRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeNetworkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeNetworkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeNetworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeNetworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeNetwork");

            return clientHandler.execute(new ClientExecutionParams<DescribeNetworkRequest, DescribeNetworkResponse>()
                    .withOperationName("DescribeNetwork").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeNetworkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeNetworkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Get details about a Node in the specified Cluster.
     *
     * @param describeNodeRequest
     *        Placeholder documentation for DescribeNodeRequest
     * @return Result of the DescribeNode operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to describe the node.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The node that you are trying to describe doesnâ€™t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe node calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeNode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeNodeResponse describeNode(DescribeNodeRequest describeNodeRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeNodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeNodeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeNode");

            return clientHandler.execute(new ClientExecutionParams<DescribeNodeRequest, DescribeNodeResponse>()
                    .withOperationName("DescribeNode").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeNodeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeNodeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Get details for an offering.
     *
     * @param describeOfferingRequest
     *        Placeholder documentation for DescribeOfferingRequest
     * @return Result of the DescribeOffering operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to describe offering
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Offering you're attempting to describe does not exist
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe offering request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeOffering" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeOfferingResponse describeOffering(DescribeOfferingRequest describeOfferingRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeOfferingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeOfferingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOfferingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOfferingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOffering");

            return clientHandler.execute(new ClientExecutionParams<DescribeOfferingRequest, DescribeOfferingResponse>()
                    .withOperationName("DescribeOffering").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeOfferingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeOfferingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Get details for a reservation.
     *
     * @param describeReservationRequest
     *        Placeholder documentation for DescribeReservationRequest
     * @return Result of the DescribeReservation operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to describe reservation
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Reservation you're attempting to describe does not exist
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe reservation request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeReservation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeReservationResponse describeReservation(DescribeReservationRequest describeReservationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeReservationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeReservationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservation");

            return clientHandler.execute(new ClientExecutionParams<DescribeReservationRequest, DescribeReservationResponse>()
                    .withOperationName("DescribeReservation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeReservationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeReservationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Get a channel schedule
     *
     * @param describeScheduleRequest
     *        Placeholder documentation for DescribeScheduleRequest
     * @return Result of the DescribeSchedule operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to describe the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting a schedule describe for does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeScheduleResponse describeSchedule(DescribeScheduleRequest describeScheduleRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeScheduleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeScheduleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSchedule");

            return clientHandler.execute(new ClientExecutionParams<DescribeScheduleRequest, DescribeScheduleResponse>()
                    .withOperationName("DescribeSchedule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeScheduleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeScheduleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Describe the latest thumbnails data.
     *
     * @param describeThumbnailsRequest
     *        Placeholder documentation for DescribeThumbnailsRequest
     * @return Result of the DescribeThumbnails operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe thumbnails.
     * @throws BadGatewayException
     *         Bad Gateway error.
     * @throws NotFoundException
     *         There are no thumbnails for this channel.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe thumbnails calls to channel service.
     * @throws ConflictException
     *         Service do not have permission to customer's KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeThumbnails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeThumbnails" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeThumbnailsResponse describeThumbnails(DescribeThumbnailsRequest describeThumbnailsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeThumbnailsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeThumbnailsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeThumbnailsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeThumbnailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeThumbnails");

            return clientHandler.execute(new ClientExecutionParams<DescribeThumbnailsRequest, DescribeThumbnailsResponse>()
                    .withOperationName("DescribeThumbnails").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeThumbnailsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeThumbnailsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Retrieves the specified cloudwatch alarm template.
     *
     * @param getCloudWatchAlarmTemplateRequest
     *        Placeholder documentation for GetCloudWatchAlarmTemplateRequest
     * @return Result of the GetCloudWatchAlarmTemplate operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.GetCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCloudWatchAlarmTemplateResponse getCloudWatchAlarmTemplate(
            GetCloudWatchAlarmTemplateRequest getCloudWatchAlarmTemplateRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCloudWatchAlarmTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCloudWatchAlarmTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCloudWatchAlarmTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCloudWatchAlarmTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudWatchAlarmTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCloudWatchAlarmTemplateRequest, GetCloudWatchAlarmTemplateResponse>()
                            .withOperationName("GetCloudWatchAlarmTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getCloudWatchAlarmTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetCloudWatchAlarmTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Retrieves the specified cloudwatch alarm template group.
     *
     * @param getCloudWatchAlarmTemplateGroupRequest
     *        Placeholder documentation for GetCloudWatchAlarmTemplateGroupRequest
     * @return Result of the GetCloudWatchAlarmTemplateGroup operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.GetCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCloudWatchAlarmTemplateGroupResponse getCloudWatchAlarmTemplateGroup(
            GetCloudWatchAlarmTemplateGroupRequest getCloudWatchAlarmTemplateGroupRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCloudWatchAlarmTemplateGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCloudWatchAlarmTemplateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCloudWatchAlarmTemplateGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCloudWatchAlarmTemplateGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudWatchAlarmTemplateGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCloudWatchAlarmTemplateGroupRequest, GetCloudWatchAlarmTemplateGroupResponse>()
                            .withOperationName("GetCloudWatchAlarmTemplateGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getCloudWatchAlarmTemplateGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetCloudWatchAlarmTemplateGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Retrieves the specified eventbridge rule template.
     *
     * @param getEventBridgeRuleTemplateRequest
     *        Placeholder documentation for GetEventBridgeRuleTemplateRequest
     * @return Result of the GetEventBridgeRuleTemplate operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.GetEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEventBridgeRuleTemplateResponse getEventBridgeRuleTemplate(
            GetEventBridgeRuleTemplateRequest getEventBridgeRuleTemplateRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEventBridgeRuleTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetEventBridgeRuleTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventBridgeRuleTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventBridgeRuleTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventBridgeRuleTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<GetEventBridgeRuleTemplateRequest, GetEventBridgeRuleTemplateResponse>()
                            .withOperationName("GetEventBridgeRuleTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getEventBridgeRuleTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetEventBridgeRuleTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Retrieves the specified eventbridge rule template group.
     *
     * @param getEventBridgeRuleTemplateGroupRequest
     *        Placeholder documentation for GetEventBridgeRuleTemplateGroupRequest
     * @return Result of the GetEventBridgeRuleTemplateGroup operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.GetEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEventBridgeRuleTemplateGroupResponse getEventBridgeRuleTemplateGroup(
            GetEventBridgeRuleTemplateGroupRequest getEventBridgeRuleTemplateGroupRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEventBridgeRuleTemplateGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetEventBridgeRuleTemplateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventBridgeRuleTemplateGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getEventBridgeRuleTemplateGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventBridgeRuleTemplateGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<GetEventBridgeRuleTemplateGroupRequest, GetEventBridgeRuleTemplateGroupResponse>()
                            .withOperationName("GetEventBridgeRuleTemplateGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getEventBridgeRuleTemplateGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetEventBridgeRuleTemplateGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Retrieves the specified signal map.
     *
     * @param getSignalMapRequest
     *        Placeholder documentation for GetSignalMapRequest
     * @return Result of the GetSignalMap operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.GetSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/GetSignalMap" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSignalMapResponse getSignalMap(GetSignalMapRequest getSignalMapRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSignalMapResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSignalMapResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSignalMapRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSignalMapRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSignalMap");

            return clientHandler.execute(new ClientExecutionParams<GetSignalMapRequest, GetSignalMapResponse>()
                    .withOperationName("GetSignalMap").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getSignalMapRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSignalMapRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Retrieve the list of ChannelPlacementGroups in the specified Cluster.
     *
     * @param listChannelPlacementGroupsRequest
     *        Placeholder documentation for ListChannelPlacementGroupsRequest
     * @return Result of the ListChannelPlacementGroups operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list channel placement groups.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel placement group calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannelPlacementGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannelPlacementGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListChannelPlacementGroupsResponse listChannelPlacementGroups(
            ListChannelPlacementGroupsRequest listChannelPlacementGroupsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListChannelPlacementGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListChannelPlacementGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listChannelPlacementGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listChannelPlacementGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListChannelPlacementGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<ListChannelPlacementGroupsRequest, ListChannelPlacementGroupsResponse>()
                            .withOperationName("ListChannelPlacementGroups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listChannelPlacementGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListChannelPlacementGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Produces list of channels that have been created
     *
     * @param listChannelsRequest
     *        Placeholder documentation for ListChannelsRequest
     * @return Result of the ListChannels operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to list channels.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListChannelsResponse listChannels(ListChannelsRequest listChannelsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListChannelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListChannelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listChannelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listChannelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListChannels");

            return clientHandler.execute(new ClientExecutionParams<ListChannelsRequest, ListChannelsResponse>()
                    .withOperationName("ListChannels").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listChannelsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListChannelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Lists cloudwatch alarm template groups.
     *
     * @param listCloudWatchAlarmTemplateGroupsRequest
     *        Placeholder documentation for ListCloudWatchAlarmTemplateGroupsRequest
     * @return Result of the ListCloudWatchAlarmTemplateGroups operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListCloudWatchAlarmTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCloudWatchAlarmTemplateGroupsResponse listCloudWatchAlarmTemplateGroups(
            ListCloudWatchAlarmTemplateGroupsRequest listCloudWatchAlarmTemplateGroupsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCloudWatchAlarmTemplateGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCloudWatchAlarmTemplateGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCloudWatchAlarmTemplateGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCloudWatchAlarmTemplateGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCloudWatchAlarmTemplateGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCloudWatchAlarmTemplateGroupsRequest, ListCloudWatchAlarmTemplateGroupsResponse>()
                            .withOperationName("ListCloudWatchAlarmTemplateGroups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listCloudWatchAlarmTemplateGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCloudWatchAlarmTemplateGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Lists cloudwatch alarm templates.
     *
     * @param listCloudWatchAlarmTemplatesRequest
     *        Placeholder documentation for ListCloudWatchAlarmTemplatesRequest
     * @return Result of the ListCloudWatchAlarmTemplates operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListCloudWatchAlarmTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListCloudWatchAlarmTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCloudWatchAlarmTemplatesResponse listCloudWatchAlarmTemplates(
            ListCloudWatchAlarmTemplatesRequest listCloudWatchAlarmTemplatesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCloudWatchAlarmTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCloudWatchAlarmTemplatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCloudWatchAlarmTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCloudWatchAlarmTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCloudWatchAlarmTemplates");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCloudWatchAlarmTemplatesRequest, ListCloudWatchAlarmTemplatesResponse>()
                            .withOperationName("ListCloudWatchAlarmTemplates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listCloudWatchAlarmTemplatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCloudWatchAlarmTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Retrieve the list of Clusters.
     *
     * @param listClustersRequest
     *        Placeholder documentation for ListClustersRequest
     * @return Result of the ListClusters operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list clusters.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list cluster calls to cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListClusters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListClustersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListClustersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listClustersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListClusters");

            return clientHandler.execute(new ClientExecutionParams<ListClustersRequest, ListClustersResponse>()
                    .withOperationName("ListClusters").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listClustersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListClustersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Lists eventbridge rule template groups.
     *
     * @param listEventBridgeRuleTemplateGroupsRequest
     *        Placeholder documentation for ListEventBridgeRuleTemplateGroupsRequest
     * @return Result of the ListEventBridgeRuleTemplateGroups operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListEventBridgeRuleTemplateGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplateGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEventBridgeRuleTemplateGroupsResponse listEventBridgeRuleTemplateGroups(
            ListEventBridgeRuleTemplateGroupsRequest listEventBridgeRuleTemplateGroupsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEventBridgeRuleTemplateGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEventBridgeRuleTemplateGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEventBridgeRuleTemplateGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listEventBridgeRuleTemplateGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEventBridgeRuleTemplateGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<ListEventBridgeRuleTemplateGroupsRequest, ListEventBridgeRuleTemplateGroupsResponse>()
                            .withOperationName("ListEventBridgeRuleTemplateGroups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listEventBridgeRuleTemplateGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListEventBridgeRuleTemplateGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Lists eventbridge rule templates.
     *
     * @param listEventBridgeRuleTemplatesRequest
     *        Placeholder documentation for ListEventBridgeRuleTemplatesRequest
     * @return Result of the ListEventBridgeRuleTemplates operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListEventBridgeRuleTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListEventBridgeRuleTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEventBridgeRuleTemplatesResponse listEventBridgeRuleTemplates(
            ListEventBridgeRuleTemplatesRequest listEventBridgeRuleTemplatesRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEventBridgeRuleTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEventBridgeRuleTemplatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEventBridgeRuleTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEventBridgeRuleTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEventBridgeRuleTemplates");

            return clientHandler
                    .execute(new ClientExecutionParams<ListEventBridgeRuleTemplatesRequest, ListEventBridgeRuleTemplatesResponse>()
                            .withOperationName("ListEventBridgeRuleTemplates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listEventBridgeRuleTemplatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListEventBridgeRuleTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * List input devices that are currently being transferred. List input devices that you are transferring from your
     * AWS account or input devices that another AWS account is transferring to you.
     *
     * @param listInputDeviceTransfersRequest
     *        Placeholder documentation for ListInputDeviceTransfersRequest
     * @return Result of the ListInputDeviceTransfers operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list transferring devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list devices calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputDeviceTransfers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDeviceTransfers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListInputDeviceTransfersResponse listInputDeviceTransfers(
            ListInputDeviceTransfersRequest listInputDeviceTransfersRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListInputDeviceTransfersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListInputDeviceTransfersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInputDeviceTransfersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInputDeviceTransfersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInputDeviceTransfers");

            return clientHandler
                    .execute(new ClientExecutionParams<ListInputDeviceTransfersRequest, ListInputDeviceTransfersResponse>()
                            .withOperationName("ListInputDeviceTransfers").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listInputDeviceTransfersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListInputDeviceTransfersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * List input devices
     *
     * @param listInputDevicesRequest
     *        Placeholder documentation for ListInputDevicesRequest
     * @return Result of the ListInputDevices operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list input devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list devices calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListInputDevicesResponse listInputDevices(ListInputDevicesRequest listInputDevicesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListInputDevicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListInputDevicesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInputDevicesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInputDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInputDevices");

            return clientHandler.execute(new ClientExecutionParams<ListInputDevicesRequest, ListInputDevicesResponse>()
                    .withOperationName("ListInputDevices").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listInputDevicesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListInputDevicesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Produces a list of Input Security Groups for an account
     *
     * @param listInputSecurityGroupsRequest
     *        Placeholder documentation for ListInputSecurityGroupsRequest
     * @return Result of the ListInputSecurityGroups operation returned by the service.
     * @throws BadRequestException
     *         The request to list Input Security Groups was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to call ListInputSecurityGroups
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListInputSecurityGroupsResponse listInputSecurityGroups(ListInputSecurityGroupsRequest listInputSecurityGroupsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListInputSecurityGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListInputSecurityGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInputSecurityGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInputSecurityGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInputSecurityGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<ListInputSecurityGroupsRequest, ListInputSecurityGroupsResponse>()
                            .withOperationName("ListInputSecurityGroups").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listInputSecurityGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListInputSecurityGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Produces list of inputs that have been created
     *
     * @param listInputsRequest
     *        Placeholder documentation for ListInputsRequest
     * @return Result of the ListInputs operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListInputsResponse listInputs(ListInputsRequest listInputsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListInputsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListInputsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInputsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInputsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInputs");

            return clientHandler.execute(new ClientExecutionParams<ListInputsRequest, ListInputsResponse>()
                    .withOperationName("ListInputs").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listInputsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListInputsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * List the programs that currently exist for a specific multiplex.
     *
     * @param listMultiplexProgramsRequest
     *        Placeholder documentation for ListMultiplexProgramsRequest
     * @return Result of the ListMultiplexPrograms operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to list multiplex programs.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         MediaLive can't provide the list of programs. The multiplex that you specified doesn’t exist. Check the
     *         ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexPrograms
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMultiplexProgramsResponse listMultiplexPrograms(ListMultiplexProgramsRequest listMultiplexProgramsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMultiplexProgramsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMultiplexProgramsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMultiplexProgramsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMultiplexProgramsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMultiplexPrograms");

            return clientHandler.execute(new ClientExecutionParams<ListMultiplexProgramsRequest, ListMultiplexProgramsResponse>()
                    .withOperationName("ListMultiplexPrograms").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listMultiplexProgramsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMultiplexProgramsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Retrieve a list of the existing multiplexes.
     *
     * @param listMultiplexesRequest
     *        Placeholder documentation for ListMultiplexesRequest
     * @return Result of the ListMultiplexes operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to list multiplexes.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListMultiplexesResponse listMultiplexes(ListMultiplexesRequest listMultiplexesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMultiplexesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListMultiplexesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMultiplexesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMultiplexesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMultiplexes");

            return clientHandler.execute(new ClientExecutionParams<ListMultiplexesRequest, ListMultiplexesResponse>()
                    .withOperationName("ListMultiplexes").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listMultiplexesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMultiplexesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Retrieve the list of Networks.
     *
     * @param listNetworksRequest
     *        Placeholder documentation for ListNetworksRequest
     * @return Result of the ListNetworks operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list clusters.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list cluster calls to cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListNetworks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListNetworksResponse listNetworks(ListNetworksRequest listNetworksRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListNetworksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListNetworksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listNetworksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNetworksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNetworks");

            return clientHandler.execute(new ClientExecutionParams<ListNetworksRequest, ListNetworksResponse>()
                    .withOperationName("ListNetworks").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listNetworksRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListNetworksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Retrieve the list of Nodes.
     *
     * @param listNodesRequest
     *        Placeholder documentation for ListNodesRequest
     * @return Result of the ListNodes operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to list nodes.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list node calls to the cluster service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListNodes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListNodesResponse listNodes(ListNodesRequest listNodesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListNodesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListNodesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listNodesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNodesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNodes");

            return clientHandler.execute(new ClientExecutionParams<ListNodesRequest, ListNodesResponse>()
                    .withOperationName("ListNodes").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listNodesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListNodesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * List offerings available for purchase.
     *
     * @param listOfferingsRequest
     *        Placeholder documentation for ListOfferingsRequest
     * @return Result of the ListOfferings operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list offerings
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list offerings request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListOfferingsResponse listOfferings(ListOfferingsRequest listOfferingsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOfferingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListOfferingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOfferingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOfferingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOfferings");

            return clientHandler.execute(new ClientExecutionParams<ListOfferingsRequest, ListOfferingsResponse>()
                    .withOperationName("ListOfferings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listOfferingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListOfferingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * List purchased reservations.
     *
     * @param listReservationsRequest
     *        Placeholder documentation for ListReservationsRequest
     * @return Result of the ListReservations operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list reservations
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on list reservations request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListReservations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListReservationsResponse listReservations(ListReservationsRequest listReservationsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReservationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListReservationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReservationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReservationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReservations");

            return clientHandler.execute(new ClientExecutionParams<ListReservationsRequest, ListReservationsResponse>()
                    .withOperationName("ListReservations").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listReservationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListReservationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Lists signal maps.
     *
     * @param listSignalMapsRequest
     *        Placeholder documentation for ListSignalMapsRequest
     * @return Result of the ListSignalMaps operation returned by the service.
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListSignalMaps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListSignalMaps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSignalMapsResponse listSignalMaps(ListSignalMapsRequest listSignalMapsRequest) throws NotFoundException,
            TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSignalMapsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSignalMapsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSignalMapsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSignalMapsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSignalMaps");

            return clientHandler.execute(new ClientExecutionParams<ListSignalMapsRequest, ListSignalMapsResponse>()
                    .withOperationName("ListSignalMaps").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listSignalMapsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSignalMapsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Produces list of tags that have been created for a resource
     *
     * @param listTagsForResourceRequest
     *        Placeholder documentation for ListTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws NotFoundException
     *         The arn was not found
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Retrieves an array of all the encoder engine versions that are available in this AWS account.
     *
     * @param listVersionsRequest
     *        Placeholder documentation for ListVersionsRequest
     * @return Result of the ListVersions operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Verify that the syntax is
     *         correct.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials that you sent.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The service could not complete your request.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service could not complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListVersionsResponse listVersions(ListVersionsRequest listVersionsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListVersionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVersions");

            return clientHandler.execute(new ClientExecutionParams<ListVersionsRequest, ListVersionsResponse>()
                    .withOperationName("ListVersions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Purchase an offering and create a reservation.
     *
     * @param purchaseOfferingRequest
     *        Placeholder documentation for PurchaseOfferingRequest
     * @return Result of the PurchaseOffering operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to purchase the offering
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Offering you're attempting to purchase does not exist
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on purchase offering request
     * @throws ConflictException
     *         Offering purchase prevented by service resource issue
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.PurchaseOffering
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PurchaseOffering" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PurchaseOfferingResponse purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PurchaseOfferingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PurchaseOfferingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(purchaseOfferingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, purchaseOfferingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PurchaseOffering");

            return clientHandler.execute(new ClientExecutionParams<PurchaseOfferingRequest, PurchaseOfferingResponse>()
                    .withOperationName("PurchaseOffering").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(purchaseOfferingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PurchaseOfferingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Send a reboot command to the specified input device. The device will begin rebooting within a few seconds of
     * sending the command. When the reboot is complete, the device’s connection status will change to connected.
     *
     * @param rebootInputDeviceRequest
     *        A request to reboot an AWS Elemental device.
     * @return Result of the RebootInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Reboot operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to reboot input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on reboot device calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.RebootInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RebootInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RebootInputDeviceResponse rebootInputDevice(RebootInputDeviceRequest rebootInputDeviceRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RebootInputDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RebootInputDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rebootInputDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootInputDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootInputDevice");

            return clientHandler.execute(new ClientExecutionParams<RebootInputDeviceRequest, RebootInputDeviceResponse>()
                    .withOperationName("RebootInputDevice").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(rebootInputDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RebootInputDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Reject the transfer of the specified input device to your AWS account.
     *
     * @param rejectInputDeviceTransferRequest
     *        Placeholder documentation for RejectInputDeviceTransferRequest
     * @return Result of the RejectInputDeviceTransfer operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to reject input device transfers.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on transfer device calls to the input device service.
     * @throws ConflictException
     *         Input device transfer could not be rejected.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.RejectInputDeviceTransfer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RejectInputDeviceTransfer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RejectInputDeviceTransferResponse rejectInputDeviceTransfer(
            RejectInputDeviceTransferRequest rejectInputDeviceTransferRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RejectInputDeviceTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RejectInputDeviceTransferResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rejectInputDeviceTransferRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rejectInputDeviceTransferRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectInputDeviceTransfer");

            return clientHandler
                    .execute(new ClientExecutionParams<RejectInputDeviceTransferRequest, RejectInputDeviceTransferResponse>()
                            .withOperationName("RejectInputDeviceTransfer").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(rejectInputDeviceTransferRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RejectInputDeviceTransferRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Restart pipelines in one channel that is currently running.
     *
     * @param restartChannelPipelinesRequest
     *        Pipelines to restart.
     * @return Result of the RestartChannelPipelines operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Verify that the syntax is
     *         correct.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials that you sent.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel or pipeline you specified doesn't exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service could not complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.RestartChannelPipelines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RestartChannelPipelines"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RestartChannelPipelinesResponse restartChannelPipelines(RestartChannelPipelinesRequest restartChannelPipelinesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RestartChannelPipelinesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RestartChannelPipelinesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restartChannelPipelinesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restartChannelPipelinesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestartChannelPipelines");

            return clientHandler
                    .execute(new ClientExecutionParams<RestartChannelPipelinesRequest, RestartChannelPipelinesResponse>()
                            .withOperationName("RestartChannelPipelines").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(restartChannelPipelinesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RestartChannelPipelinesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Starts an existing channel
     *
     * @param startChannelRequest
     *        Placeholder documentation for StartChannelRequest
     * @return Result of the StartChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to start the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to start does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on start channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to start due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartChannelResponse startChannel(StartChannelRequest startChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartChannel");

            return clientHandler.execute(new ClientExecutionParams<StartChannelRequest, StartChannelResponse>()
                    .withOperationName("StartChannel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startChannelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Initiates a deployment to delete the monitor of the specified signal map.
     *
     * @param startDeleteMonitorDeploymentRequest
     *        Placeholder documentation for StartDeleteMonitorDeploymentRequest
     * @return Result of the StartDeleteMonitorDeployment operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartDeleteMonitorDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartDeleteMonitorDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartDeleteMonitorDeploymentResponse startDeleteMonitorDeployment(
            StartDeleteMonitorDeploymentRequest startDeleteMonitorDeploymentRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartDeleteMonitorDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartDeleteMonitorDeploymentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startDeleteMonitorDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startDeleteMonitorDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDeleteMonitorDeployment");

            return clientHandler
                    .execute(new ClientExecutionParams<StartDeleteMonitorDeploymentRequest, StartDeleteMonitorDeploymentResponse>()
                            .withOperationName("StartDeleteMonitorDeployment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startDeleteMonitorDeploymentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartDeleteMonitorDeploymentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Start an input device that is attached to a MediaConnect flow. (There is no need to start a device that is
     * attached to a MediaLive input; MediaLive starts the device when the channel starts.)
     *
     * @param startInputDeviceRequest
     *        Placeholder documentation for StartInputDeviceRequest
     * @return Result of the StartInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Start operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to start the input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on start device calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartInputDeviceResponse startInputDevice(StartInputDeviceRequest startInputDeviceRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException,
            MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartInputDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartInputDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startInputDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startInputDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartInputDevice");

            return clientHandler.execute(new ClientExecutionParams<StartInputDeviceRequest, StartInputDeviceResponse>()
                    .withOperationName("StartInputDevice").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startInputDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartInputDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Start a maintenance window for the specified input device. Starting a maintenance window will give the device up
     * to two hours to install software. If the device was streaming prior to the maintenance, it will resume streaming
     * when the software is fully installed. Devices automatically install updates while they are powered on and their
     * MediaLive channels are stopped. A maintenance window allows you to update a device without having to stop
     * MediaLive channels that use the device. The device must remain powered on and connected to the internet for the
     * duration of the maintenance.
     *
     * @param startInputDeviceMaintenanceWindowRequest
     *        Placeholder documentation for StartInputDeviceMaintenanceWindowRequest
     * @return Result of the StartInputDeviceMaintenanceWindow operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Start maintenance window operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to start a maintenance window for this input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on start maintenance window calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartInputDeviceMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartInputDeviceMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartInputDeviceMaintenanceWindowResponse startInputDeviceMaintenanceWindow(
            StartInputDeviceMaintenanceWindowRequest startInputDeviceMaintenanceWindowRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException,
            MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartInputDeviceMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartInputDeviceMaintenanceWindowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startInputDeviceMaintenanceWindowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startInputDeviceMaintenanceWindowRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartInputDeviceMaintenanceWindow");

            return clientHandler
                    .execute(new ClientExecutionParams<StartInputDeviceMaintenanceWindowRequest, StartInputDeviceMaintenanceWindowResponse>()
                            .withOperationName("StartInputDeviceMaintenanceWindow").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startInputDeviceMaintenanceWindowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartInputDeviceMaintenanceWindowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Initiates a deployment to deploy the latest monitor of the specified signal map.
     *
     * @param startMonitorDeploymentRequest
     *        Placeholder documentation for StartMonitorDeploymentRequest
     * @return Result of the StartMonitorDeployment operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartMonitorDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMonitorDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartMonitorDeploymentResponse startMonitorDeployment(StartMonitorDeploymentRequest startMonitorDeploymentRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartMonitorDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartMonitorDeploymentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startMonitorDeploymentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMonitorDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMonitorDeployment");

            return clientHandler
                    .execute(new ClientExecutionParams<StartMonitorDeploymentRequest, StartMonitorDeploymentResponse>()
                            .withOperationName("StartMonitorDeployment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startMonitorDeploymentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartMonitorDeploymentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Start (run) the multiplex. Starting the multiplex does not start the channels. You must explicitly start each
     * channel.
     *
     * @param startMultiplexRequest
     *        Placeholder documentation for StartMultiplexRequest
     * @return Result of the StartMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to start the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The multiplex that you are trying to start doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on start multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to start due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartMultiplexResponse startMultiplex(StartMultiplexRequest startMultiplexRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartMultiplexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartMultiplexResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startMultiplexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMultiplexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMultiplex");

            return clientHandler.execute(new ClientExecutionParams<StartMultiplexRequest, StartMultiplexResponse>()
                    .withOperationName("StartMultiplex").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startMultiplexRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartMultiplexRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Initiates an update for the specified signal map. Will discover a new signal map if a changed
     * discoveryEntryPointArn is provided.
     *
     * @param startUpdateSignalMapRequest
     *        Placeholder documentation for StartUpdateSignalMapRequest
     * @return Result of the StartUpdateSignalMap operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartUpdateSignalMap
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartUpdateSignalMap"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartUpdateSignalMapResponse startUpdateSignalMap(StartUpdateSignalMapRequest startUpdateSignalMapRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartUpdateSignalMapResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartUpdateSignalMapResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startUpdateSignalMapRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startUpdateSignalMapRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartUpdateSignalMap");

            return clientHandler.execute(new ClientExecutionParams<StartUpdateSignalMapRequest, StartUpdateSignalMapResponse>()
                    .withOperationName("StartUpdateSignalMap").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startUpdateSignalMapRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartUpdateSignalMapRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Stops a running channel
     *
     * @param stopChannelRequest
     *        Placeholder documentation for StopChannelRequest
     * @return Result of the StopChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to stop the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to stop does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on stop channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to stop due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StopChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopChannelResponse stopChannel(StopChannelRequest stopChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopChannel");

            return clientHandler.execute(new ClientExecutionParams<StopChannelRequest, StopChannelResponse>()
                    .withOperationName("StopChannel").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(stopChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Stop an input device that is attached to a MediaConnect flow. (There is no need to stop a device that is attached
     * to a MediaLive input; MediaLive automatically stops the device when the channel stops.)
     *
     * @param stopInputDeviceRequest
     *        Placeholder documentation for StopInputDeviceRequest
     * @return Result of the StopInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Start operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to stop the input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on stop device calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StopInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopInputDevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopInputDeviceResponse stopInputDevice(StopInputDeviceRequest stopInputDeviceRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException,
            MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopInputDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopInputDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopInputDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopInputDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopInputDevice");

            return clientHandler.execute(new ClientExecutionParams<StopInputDeviceRequest, StopInputDeviceResponse>()
                    .withOperationName("StopInputDevice").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopInputDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopInputDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Stops a running multiplex. If the multiplex isn't running, this action has no effect.
     *
     * @param stopMultiplexRequest
     *        Placeholder documentation for StopMultiplexRequest
     * @return Result of the StopMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to stop the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The multiplex that you are trying to stop doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on stop multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to stop due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StopMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopMultiplexResponse stopMultiplex(StopMultiplexRequest stopMultiplexRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopMultiplexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopMultiplexResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopMultiplexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopMultiplexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopMultiplex");

            return clientHandler.execute(new ClientExecutionParams<StopMultiplexRequest, StopMultiplexResponse>()
                    .withOperationName("StopMultiplex").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopMultiplexRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopMultiplexRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Start an input device transfer to another AWS account. After you make the request, the other account must accept
     * or reject the transfer.
     *
     * @param transferInputDeviceRequest
     *        A request to transfer an input device.
     * @return Result of the TransferInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Transfer operation failed, input could not be validated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to transfer input devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         Input device not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on transfer device calls to the input device service.
     * @throws ConflictException
     *         Input device could not be transferred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.TransferInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/TransferInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public TransferInputDeviceResponse transferInputDevice(TransferInputDeviceRequest transferInputDeviceRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TransferInputDeviceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, TransferInputDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(transferInputDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, transferInputDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TransferInputDevice");

            return clientHandler.execute(new ClientExecutionParams<TransferInputDeviceRequest, TransferInputDeviceResponse>()
                    .withOperationName("TransferInputDevice").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(transferInputDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TransferInputDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Update account configuration
     *
     * @param updateAccountConfigurationRequest
     *        List of account configuration parameters to update.
     * @return Result of the UpdateAccountConfiguration operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The update account configuration request failed validation.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to update the account's configuration.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on update account configuration calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateAccountConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateAccountConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAccountConfigurationResponse updateAccountConfiguration(
            UpdateAccountConfigurationRequest updateAccountConfigurationRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAccountConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAccountConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAccountConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccountConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccountConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAccountConfigurationRequest, UpdateAccountConfigurationResponse>()
                            .withOperationName("UpdateAccountConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateAccountConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAccountConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Updates a channel.
     *
     * @param updateChannelRequest
     *        A request to update a channel.
     * @return Result of the UpdateChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The channel configuration failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to update the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws ConflictException
     *         The channel is unable to update due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateChannelResponse updateChannel(UpdateChannelRequest updateChannelRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateChannelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateChannel");

            return clientHandler.execute(new ClientExecutionParams<UpdateChannelRequest, UpdateChannelResponse>()
                    .withOperationName("UpdateChannel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateChannelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Changes the class of the channel.
     *
     * @param updateChannelClassRequest
     *        Channel class that the channel should be updated to.
     * @return Result of the UpdateChannelClass operation returned by the service.
     * @throws BadRequestException
     *         This request to update the channel class was invalid.
     * @throws UnprocessableEntityException
     *         The channel configuration failed validation when attempting to update the channel class.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You do not have permission to update the class of this channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're trying to update the class on does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on update channel class calls.
     * @throws ConflictException
     *         The channel class cannot be updated due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateChannelClass
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelClass" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateChannelClassResponse updateChannelClass(UpdateChannelClassRequest updateChannelClassRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateChannelClassResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateChannelClassResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateChannelClassRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateChannelClassRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateChannelClass");

            return clientHandler.execute(new ClientExecutionParams<UpdateChannelClassRequest, UpdateChannelClassResponse>()
                    .withOperationName("UpdateChannelClass").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateChannelClassRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateChannelClassRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Change the settings for a ChannelPlacementGroup.
     *
     * @param updateChannelPlacementGroupRequest
     *        A request to update the channel placement group
     * @return Result of the UpdateChannelPlacementGroup operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws UnprocessableEntityException
     *         The channel placement group failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to update the channel placement group.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on update channel placement group calls to service.
     * @throws ConflictException
     *         The channel placement group is unable to update due to an issue with channel placement group resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateChannelPlacementGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelPlacementGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateChannelPlacementGroupResponse updateChannelPlacementGroup(
            UpdateChannelPlacementGroupRequest updateChannelPlacementGroupRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateChannelPlacementGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateChannelPlacementGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateChannelPlacementGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateChannelPlacementGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateChannelPlacementGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateChannelPlacementGroupRequest, UpdateChannelPlacementGroupResponse>()
                            .withOperationName("UpdateChannelPlacementGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateChannelPlacementGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateChannelPlacementGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Updates the specified cloudwatch alarm template.
     *
     * @param updateCloudWatchAlarmTemplateRequest
     *        Placeholder documentation for UpdateCloudWatchAlarmTemplateRequest
     * @return Result of the UpdateCloudWatchAlarmTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateCloudWatchAlarmTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCloudWatchAlarmTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCloudWatchAlarmTemplateResponse updateCloudWatchAlarmTemplate(
            UpdateCloudWatchAlarmTemplateRequest updateCloudWatchAlarmTemplateRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCloudWatchAlarmTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCloudWatchAlarmTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCloudWatchAlarmTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCloudWatchAlarmTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCloudWatchAlarmTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateCloudWatchAlarmTemplateRequest, UpdateCloudWatchAlarmTemplateResponse>()
                            .withOperationName("UpdateCloudWatchAlarmTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateCloudWatchAlarmTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateCloudWatchAlarmTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Updates the specified cloudwatch alarm template group.
     *
     * @param updateCloudWatchAlarmTemplateGroupRequest
     *        Placeholder documentation for UpdateCloudWatchAlarmTemplateGroupRequest
     * @return Result of the UpdateCloudWatchAlarmTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateCloudWatchAlarmTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCloudWatchAlarmTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCloudWatchAlarmTemplateGroupResponse updateCloudWatchAlarmTemplateGroup(
            UpdateCloudWatchAlarmTemplateGroupRequest updateCloudWatchAlarmTemplateGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCloudWatchAlarmTemplateGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCloudWatchAlarmTemplateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCloudWatchAlarmTemplateGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCloudWatchAlarmTemplateGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCloudWatchAlarmTemplateGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateCloudWatchAlarmTemplateGroupRequest, UpdateCloudWatchAlarmTemplateGroupResponse>()
                            .withOperationName("UpdateCloudWatchAlarmTemplateGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateCloudWatchAlarmTemplateGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateCloudWatchAlarmTemplateGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Change the settings for a Cluster.
     *
     * @param updateClusterRequest
     *        A request to update the cluster.
     * @return Result of the UpdateCluster operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to update the Cluster.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on update Cluster calls to service.
     * @throws ConflictException
     *         The Cluster is unable to update due to an issue with cluster resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateClusterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateClusterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCluster");

            return clientHandler.execute(new ClientExecutionParams<UpdateClusterRequest, UpdateClusterResponse>()
                    .withOperationName("UpdateCluster").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateClusterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateClusterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Updates the specified eventbridge rule template.
     *
     * @param updateEventBridgeRuleTemplateRequest
     *        Placeholder documentation for UpdateEventBridgeRuleTemplateRequest
     * @return Result of the UpdateEventBridgeRuleTemplate operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateEventBridgeRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateEventBridgeRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateEventBridgeRuleTemplateResponse updateEventBridgeRuleTemplate(
            UpdateEventBridgeRuleTemplateRequest updateEventBridgeRuleTemplateRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEventBridgeRuleTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateEventBridgeRuleTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEventBridgeRuleTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateEventBridgeRuleTemplateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEventBridgeRuleTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateEventBridgeRuleTemplateRequest, UpdateEventBridgeRuleTemplateResponse>()
                            .withOperationName("UpdateEventBridgeRuleTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateEventBridgeRuleTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateEventBridgeRuleTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Updates the specified eventbridge rule template group.
     *
     * @param updateEventBridgeRuleTemplateGroupRequest
     *        Placeholder documentation for UpdateEventBridgeRuleTemplateGroupRequest
     * @return Result of the UpdateEventBridgeRuleTemplateGroup operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException 400 response
     * @throws InternalServerErrorException
     *         InternalServerErrorException 500 response
     * @throws ForbiddenException
     *         ForbiddenException 403 response
     * @throws NotFoundException
     *         NotFoundException 404 response
     * @throws TooManyRequestsException
     *         TooManyRequestsException 429 response
     * @throws ConflictException
     *         ConflictException 409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateEventBridgeRuleTemplateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateEventBridgeRuleTemplateGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateEventBridgeRuleTemplateGroupResponse updateEventBridgeRuleTemplateGroup(
            UpdateEventBridgeRuleTemplateGroupRequest updateEventBridgeRuleTemplateGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEventBridgeRuleTemplateGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateEventBridgeRuleTemplateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEventBridgeRuleTemplateGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateEventBridgeRuleTemplateGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEventBridgeRuleTemplateGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateEventBridgeRuleTemplateGroupRequest, UpdateEventBridgeRuleTemplateGroupResponse>()
                            .withOperationName("UpdateEventBridgeRuleTemplateGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateEventBridgeRuleTemplateGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateEventBridgeRuleTemplateGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Updates an input.
     *
     * @param updateInputRequest
     *        A request to update an input.
     * @return Result of the UpdateInput operation returned by the service.
     * @throws BadRequestException
     *         This request to update the input was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         The requester does not have permission to update an input.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The input was not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws ConflictException
     *         The input was unable to be updated at this time due to an issue with input resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInput" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateInputResponse updateInput(UpdateInputRequest updateInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateInputResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateInputResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateInputRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInput");

            return clientHandler.execute(new ClientExecutionParams<UpdateInputRequest, UpdateInputResponse>()
                    .withOperationName("UpdateInput").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateInputRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateInputRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Updates the parameters for the input device.
     *
     * @param updateInputDeviceRequest
     *        A request to update an input device.
     * @return Result of the UpdateInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Input device failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to update the input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         The input device you're requesting to does not exist. Check the ID.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded on update calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateInputDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateInputDeviceResponse updateInputDevice(UpdateInputDeviceRequest updateInputDeviceRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateInputDeviceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateInputDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateInputDeviceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateInputDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInputDevice");

            return clientHandler.execute(new ClientExecutionParams<UpdateInputDeviceRequest, UpdateInputDeviceResponse>()
                    .withOperationName("UpdateInputDevice").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateInputDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateInputDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Update an Input Security Group's Whilelists.
     *
     * @param updateInputSecurityGroupRequest
     *        The request to update some combination of the Input Security Group name and the IPv4 CIDRs the Input
     *        Security Group should allow.
     * @return Result of the UpdateInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to update the Input Security Group was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to update an Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The Input Security Group was not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws ConflictException
     *         The Input Security Group was unable to be updated due to an issue with input security group resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateInputSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateInputSecurityGroupResponse updateInputSecurityGroup(
            UpdateInputSecurityGroupRequest updateInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateInputSecurityGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateInputSecurityGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateInputSecurityGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateInputSecurityGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInputSecurityGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateInputSecurityGroupRequest, UpdateInputSecurityGroupResponse>()
                            .withOperationName("UpdateInputSecurityGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateInputSecurityGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateInputSecurityGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Updates a multiplex.
     *
     * @param updateMultiplexRequest
     *        A request to update a multiplex.
     * @return Result of the UpdateMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The multiplex configuration failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to update the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The multiplex that you are trying to update doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws ConflictException
     *         The multiplex is unable to update due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateMultiplex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateMultiplexResponse updateMultiplex(UpdateMultiplexRequest updateMultiplexRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMultiplexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateMultiplexResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMultiplexRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMultiplexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMultiplex");

            return clientHandler.execute(new ClientExecutionParams<UpdateMultiplexRequest, UpdateMultiplexResponse>()
                    .withOperationName("UpdateMultiplex").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateMultiplexRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateMultiplexRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Update a program in a multiplex.
     *
     * @param updateMultiplexProgramRequest
     *        A request to update a program in a multiplex.
     * @return Result of the UpdateMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The multiplex program failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         You don't have permission to update the multiplex program.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         MediaLive can't update the program. The multiplex or the program that you specified doesn’t exist. Check
     *         the IDs and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws ConflictException
     *         The multiplex program is unable to update due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateMultiplexProgram
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateMultiplexProgramResponse updateMultiplexProgram(UpdateMultiplexProgramRequest updateMultiplexProgramRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMultiplexProgramResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateMultiplexProgramResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMultiplexProgramRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMultiplexProgramRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMultiplexProgram");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateMultiplexProgramRequest, UpdateMultiplexProgramResponse>()
                            .withOperationName("UpdateMultiplexProgram").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateMultiplexProgramRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateMultiplexProgramRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Change the settings for a Network.
     *
     * @param updateNetworkRequest
     *        A request to update the network.
     * @return Result of the UpdateNetwork operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to update the Network.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on update Network calls to service.
     * @throws ConflictException
     *         The Network is unable to update due to an issue with network resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateNetworkResponse updateNetwork(UpdateNetworkRequest updateNetworkRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateNetworkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateNetworkResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNetworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNetwork");

            return clientHandler.execute(new ClientExecutionParams<UpdateNetworkRequest, UpdateNetworkResponse>()
                    .withOperationName("UpdateNetwork").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateNetworkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateNetworkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Change the settings for a Node.
     *
     * @param updateNodeRequest
     *        A request to update the node.
     * @return Result of the UpdateNode operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to update the node.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on update node calls to the service.
     * @throws ConflictException
     *         The node is unable to update due to an issue with node resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateNode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateNodeResponse updateNode(UpdateNodeRequest updateNodeRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateNodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateNodeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNode");

            return clientHandler.execute(new ClientExecutionParams<UpdateNodeRequest, UpdateNodeResponse>()
                    .withOperationName("UpdateNode").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateNodeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateNodeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Update the state of a node.
     *
     * @param updateNodeStateRequest
     *        A request to update the state of a node.
     * @return Result of the UpdateNodeState operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The node failed validation and the state could not be updated.
     * @throws InternalServerErrorException
     *         Internal Service Error.
     * @throws ForbiddenException
     *         You don't have permission to update the state of the node.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout.
     * @throws TooManyRequestsException
     *         Request limit exceeded on node calls to service.
     * @throws ConflictException
     *         The node state is unable to updated due to an issue with node resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateNodeState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateNodeState" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateNodeStateResponse updateNodeState(UpdateNodeStateRequest updateNodeStateRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateNodeStateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateNodeStateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNodeStateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNodeStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNodeState");

            return clientHandler.execute(new ClientExecutionParams<UpdateNodeStateRequest, UpdateNodeStateResponse>()
                    .withOperationName("UpdateNodeState").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateNodeStateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateNodeStateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Update reservation.
     *
     * @param updateReservationRequest
     *        Request to update a reservation
     * @return Result of the UpdateReservation operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to update reservation
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Reservation not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout
     * @throws TooManyRequestsException
     *         Request limit exceeded
     * @throws ConflictException
     *         The reservation could not be updated
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateReservation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateReservation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateReservationResponse updateReservation(UpdateReservationRequest updateReservationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateReservationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateReservationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateReservation");

            return clientHandler.execute(new ClientExecutionParams<UpdateReservationRequest, UpdateReservationResponse>()
                    .withOperationName("UpdateReservation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateReservationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateReservationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create an instance of {@link MediaLiveWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link MediaLiveWaiter}
     */
    @Override
    public MediaLiveWaiter waiter() {
        return MediaLiveWaiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        MediaLiveServiceClientConfigurationBuilder serviceConfigBuilder = new MediaLiveServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(MediaLiveException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ForbiddenException")
                                .exceptionBuilderSupplier(ForbiddenException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadGatewayException")
                                .exceptionBuilderSupplier(BadGatewayException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GatewayTimeoutException")
                                .exceptionBuilderSupplier(GatewayTimeoutException::builder).httpStatusCode(504).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnprocessableEntityException")
                                .exceptionBuilderSupplier(UnprocessableEntityException::builder).httpStatusCode(422).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerErrorException")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    @Override
    public final MediaLiveServiceClientConfiguration serviceClientConfiguration() {
        return new MediaLiveServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
