/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Audio Track Selection
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioTrackSelection implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioTrackSelection.Builder, AudioTrackSelection> {
    private static final SdkField<List<AudioTrack>> TRACKS_FIELD = SdkField
            .<List<AudioTrack>> builder(MarshallingType.LIST)
            .memberName("Tracks")
            .getter(getter(AudioTrackSelection::tracks))
            .setter(setter(Builder::tracks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AudioTrack> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudioTrack::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AudioDolbyEDecode> DOLBY_E_DECODE_FIELD = SdkField
            .<AudioDolbyEDecode> builder(MarshallingType.SDK_POJO).memberName("DolbyEDecode")
            .getter(getter(AudioTrackSelection::dolbyEDecode)).setter(setter(Builder::dolbyEDecode))
            .constructor(AudioDolbyEDecode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dolbyEDecode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKS_FIELD,
            DOLBY_E_DECODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AudioTrack> tracks;

    private final AudioDolbyEDecode dolbyEDecode;

    private AudioTrackSelection(BuilderImpl builder) {
        this.tracks = builder.tracks;
        this.dolbyEDecode = builder.dolbyEDecode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tracks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTracks() {
        return tracks != null && !(tracks instanceof SdkAutoConstructList);
    }

    /**
     * Selects one or more unique audio tracks from within a source.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTracks} method.
     * </p>
     * 
     * @return Selects one or more unique audio tracks from within a source.
     */
    public final List<AudioTrack> tracks() {
        return tracks;
    }

    /**
     * Configure decoding options for Dolby E streams - these should be Dolby E frames carried in PCM streams tagged
     * with SMPTE-337
     * 
     * @return Configure decoding options for Dolby E streams - these should be Dolby E frames carried in PCM streams
     *         tagged with SMPTE-337
     */
    public final AudioDolbyEDecode dolbyEDecode() {
        return dolbyEDecode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTracks() ? tracks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dolbyEDecode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioTrackSelection)) {
            return false;
        }
        AudioTrackSelection other = (AudioTrackSelection) obj;
        return hasTracks() == other.hasTracks() && Objects.equals(tracks(), other.tracks())
                && Objects.equals(dolbyEDecode(), other.dolbyEDecode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioTrackSelection").add("Tracks", hasTracks() ? tracks() : null)
                .add("DolbyEDecode", dolbyEDecode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tracks":
            return Optional.ofNullable(clazz.cast(tracks()));
        case "DolbyEDecode":
            return Optional.ofNullable(clazz.cast(dolbyEDecode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tracks", TRACKS_FIELD);
        map.put("dolbyEDecode", DOLBY_E_DECODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioTrackSelection, T> g) {
        return obj -> g.apply((AudioTrackSelection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioTrackSelection> {
        /**
         * Selects one or more unique audio tracks from within a source.
         * 
         * @param tracks
         *        Selects one or more unique audio tracks from within a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracks(Collection<AudioTrack> tracks);

        /**
         * Selects one or more unique audio tracks from within a source.
         * 
         * @param tracks
         *        Selects one or more unique audio tracks from within a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracks(AudioTrack... tracks);

        /**
         * Selects one or more unique audio tracks from within a source. This is a convenience method that creates an
         * instance of the {@link software.amazon.awssdk.services.medialive.model.AudioTrack.Builder} avoiding the need
         * to create one manually via {@link software.amazon.awssdk.services.medialive.model.AudioTrack#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.AudioTrack.Builder#build()} is called immediately and
         * its result is passed to {@link #tracks(List<AudioTrack>)}.
         * 
         * @param tracks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.AudioTrack.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tracks(java.util.Collection<AudioTrack>)
         */
        Builder tracks(Consumer<AudioTrack.Builder>... tracks);

        /**
         * Configure decoding options for Dolby E streams - these should be Dolby E frames carried in PCM streams tagged
         * with SMPTE-337
         * 
         * @param dolbyEDecode
         *        Configure decoding options for Dolby E streams - these should be Dolby E frames carried in PCM streams
         *        tagged with SMPTE-337
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dolbyEDecode(AudioDolbyEDecode dolbyEDecode);

        /**
         * Configure decoding options for Dolby E streams - these should be Dolby E frames carried in PCM streams tagged
         * with SMPTE-337 This is a convenience method that creates an instance of the {@link AudioDolbyEDecode.Builder}
         * avoiding the need to create one manually via {@link AudioDolbyEDecode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudioDolbyEDecode.Builder#build()} is called immediately and its
         * result is passed to {@link #dolbyEDecode(AudioDolbyEDecode)}.
         * 
         * @param dolbyEDecode
         *        a consumer that will call methods on {@link AudioDolbyEDecode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dolbyEDecode(AudioDolbyEDecode)
         */
        default Builder dolbyEDecode(Consumer<AudioDolbyEDecode.Builder> dolbyEDecode) {
            return dolbyEDecode(AudioDolbyEDecode.builder().applyMutation(dolbyEDecode).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<AudioTrack> tracks = DefaultSdkAutoConstructList.getInstance();

        private AudioDolbyEDecode dolbyEDecode;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioTrackSelection model) {
            tracks(model.tracks);
            dolbyEDecode(model.dolbyEDecode);
        }

        public final List<AudioTrack.Builder> getTracks() {
            List<AudioTrack.Builder> result = ___listOfAudioTrackCopier.copyToBuilder(this.tracks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTracks(Collection<AudioTrack.BuilderImpl> tracks) {
            this.tracks = ___listOfAudioTrackCopier.copyFromBuilder(tracks);
        }

        @Override
        public final Builder tracks(Collection<AudioTrack> tracks) {
            this.tracks = ___listOfAudioTrackCopier.copy(tracks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracks(AudioTrack... tracks) {
            tracks(Arrays.asList(tracks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracks(Consumer<AudioTrack.Builder>... tracks) {
            tracks(Stream.of(tracks).map(c -> AudioTrack.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final AudioDolbyEDecode.Builder getDolbyEDecode() {
            return dolbyEDecode != null ? dolbyEDecode.toBuilder() : null;
        }

        public final void setDolbyEDecode(AudioDolbyEDecode.BuilderImpl dolbyEDecode) {
            this.dolbyEDecode = dolbyEDecode != null ? dolbyEDecode.build() : null;
        }

        @Override
        public final Builder dolbyEDecode(AudioDolbyEDecode dolbyEDecode) {
            this.dolbyEDecode = dolbyEDecode;
            return this;
        }

        @Override
        public AudioTrackSelection build() {
            return new AudioTrackSelection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
