/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Avail Configuration
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AvailConfiguration.Builder, AvailConfiguration> {
    private static final SdkField<AvailSettings> AVAIL_SETTINGS_FIELD = SdkField
            .<AvailSettings> builder(MarshallingType.SDK_POJO).memberName("AvailSettings")
            .getter(getter(AvailConfiguration::availSettings)).setter(setter(Builder::availSettings))
            .constructor(AvailSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availSettings").build()).build();

    private static final SdkField<String> SCTE35_SEGMENTATION_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Scte35SegmentationScope").getter(getter(AvailConfiguration::scte35SegmentationScopeAsString))
            .setter(setter(Builder::scte35SegmentationScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35SegmentationScope").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAIL_SETTINGS_FIELD,
            SCTE35_SEGMENTATION_SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AvailSettings availSettings;

    private final String scte35SegmentationScope;

    private AvailConfiguration(BuilderImpl builder) {
        this.availSettings = builder.availSettings;
        this.scte35SegmentationScope = builder.scte35SegmentationScope;
    }

    /**
     * Controls how SCTE-35 messages create cues. Splice Insert mode treats all segmentation signals traditionally. With
     * Time Signal APOS mode only Time Signal Placement Opportunity and Break messages create segment breaks. With ESAM
     * mode, signals are forwarded to an ESAM server for possible update.
     * 
     * @return Controls how SCTE-35 messages create cues. Splice Insert mode treats all segmentation signals
     *         traditionally. With Time Signal APOS mode only Time Signal Placement Opportunity and Break messages
     *         create segment breaks. With ESAM mode, signals are forwarded to an ESAM server for possible update.
     */
    public final AvailSettings availSettings() {
        return availSettings;
    }

    /**
     * Configures whether SCTE 35 passthrough triggers segment breaks in all output groups that use segmented outputs.
     * Insertion of a SCTE 35 message typically results in a segment break, in addition to the regular cadence of
     * breaks. The segment breaks appear in video outputs, audio outputs, and captions outputs (if any).
     *
     * ALL_OUTPUT_GROUPS: Default. Insert the segment break in in all output groups that have segmented outputs. This is
     * the legacy behavior. SCTE35_ENABLED_OUTPUT_GROUPS: Insert the segment break only in output groups that have SCTE
     * 35 passthrough enabled. This is the recommended value, because it reduces unnecessary segment breaks.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #scte35SegmentationScope} will return {@link Scte35SegmentationScope#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #scte35SegmentationScopeAsString}.
     * </p>
     * 
     * @return Configures whether SCTE 35 passthrough triggers segment breaks in all output groups that use segmented
     *         outputs. Insertion of a SCTE 35 message typically results in a segment break, in addition to the regular
     *         cadence of breaks. The segment breaks appear in video outputs, audio outputs, and captions outputs (if
     *         any).
     *
     *         ALL_OUTPUT_GROUPS: Default. Insert the segment break in in all output groups that have segmented outputs.
     *         This is the legacy behavior. SCTE35_ENABLED_OUTPUT_GROUPS: Insert the segment break only in output groups
     *         that have SCTE 35 passthrough enabled. This is the recommended value, because it reduces unnecessary
     *         segment breaks.
     * @see Scte35SegmentationScope
     */
    public final Scte35SegmentationScope scte35SegmentationScope() {
        return Scte35SegmentationScope.fromValue(scte35SegmentationScope);
    }

    /**
     * Configures whether SCTE 35 passthrough triggers segment breaks in all output groups that use segmented outputs.
     * Insertion of a SCTE 35 message typically results in a segment break, in addition to the regular cadence of
     * breaks. The segment breaks appear in video outputs, audio outputs, and captions outputs (if any).
     *
     * ALL_OUTPUT_GROUPS: Default. Insert the segment break in in all output groups that have segmented outputs. This is
     * the legacy behavior. SCTE35_ENABLED_OUTPUT_GROUPS: Insert the segment break only in output groups that have SCTE
     * 35 passthrough enabled. This is the recommended value, because it reduces unnecessary segment breaks.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #scte35SegmentationScope} will return {@link Scte35SegmentationScope#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #scte35SegmentationScopeAsString}.
     * </p>
     * 
     * @return Configures whether SCTE 35 passthrough triggers segment breaks in all output groups that use segmented
     *         outputs. Insertion of a SCTE 35 message typically results in a segment break, in addition to the regular
     *         cadence of breaks. The segment breaks appear in video outputs, audio outputs, and captions outputs (if
     *         any).
     *
     *         ALL_OUTPUT_GROUPS: Default. Insert the segment break in in all output groups that have segmented outputs.
     *         This is the legacy behavior. SCTE35_ENABLED_OUTPUT_GROUPS: Insert the segment break only in output groups
     *         that have SCTE 35 passthrough enabled. This is the recommended value, because it reduces unnecessary
     *         segment breaks.
     * @see Scte35SegmentationScope
     */
    public final String scte35SegmentationScopeAsString() {
        return scte35SegmentationScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availSettings());
        hashCode = 31 * hashCode + Objects.hashCode(scte35SegmentationScopeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailConfiguration)) {
            return false;
        }
        AvailConfiguration other = (AvailConfiguration) obj;
        return Objects.equals(availSettings(), other.availSettings())
                && Objects.equals(scte35SegmentationScopeAsString(), other.scte35SegmentationScopeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AvailConfiguration").add("AvailSettings", availSettings())
                .add("Scte35SegmentationScope", scte35SegmentationScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailSettings":
            return Optional.ofNullable(clazz.cast(availSettings()));
        case "Scte35SegmentationScope":
            return Optional.ofNullable(clazz.cast(scte35SegmentationScopeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("availSettings", AVAIL_SETTINGS_FIELD);
        map.put("scte35SegmentationScope", SCTE35_SEGMENTATION_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AvailConfiguration, T> g) {
        return obj -> g.apply((AvailConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailConfiguration> {
        /**
         * Controls how SCTE-35 messages create cues. Splice Insert mode treats all segmentation signals traditionally.
         * With Time Signal APOS mode only Time Signal Placement Opportunity and Break messages create segment breaks.
         * With ESAM mode, signals are forwarded to an ESAM server for possible update.
         * 
         * @param availSettings
         *        Controls how SCTE-35 messages create cues. Splice Insert mode treats all segmentation signals
         *        traditionally. With Time Signal APOS mode only Time Signal Placement Opportunity and Break messages
         *        create segment breaks. With ESAM mode, signals are forwarded to an ESAM server for possible update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availSettings(AvailSettings availSettings);

        /**
         * Controls how SCTE-35 messages create cues. Splice Insert mode treats all segmentation signals traditionally.
         * With Time Signal APOS mode only Time Signal Placement Opportunity and Break messages create segment breaks.
         * With ESAM mode, signals are forwarded to an ESAM server for possible update. This is a convenience method
         * that creates an instance of the {@link AvailSettings.Builder} avoiding the need to create one manually via
         * {@link AvailSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AvailSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #availSettings(AvailSettings)}.
         * 
         * @param availSettings
         *        a consumer that will call methods on {@link AvailSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availSettings(AvailSettings)
         */
        default Builder availSettings(Consumer<AvailSettings.Builder> availSettings) {
            return availSettings(AvailSettings.builder().applyMutation(availSettings).build());
        }

        /**
         * Configures whether SCTE 35 passthrough triggers segment breaks in all output groups that use segmented
         * outputs. Insertion of a SCTE 35 message typically results in a segment break, in addition to the regular
         * cadence of breaks. The segment breaks appear in video outputs, audio outputs, and captions outputs (if any).
         *
         * ALL_OUTPUT_GROUPS: Default. Insert the segment break in in all output groups that have segmented outputs.
         * This is the legacy behavior. SCTE35_ENABLED_OUTPUT_GROUPS: Insert the segment break only in output groups
         * that have SCTE 35 passthrough enabled. This is the recommended value, because it reduces unnecessary segment
         * breaks.
         * 
         * @param scte35SegmentationScope
         *        Configures whether SCTE 35 passthrough triggers segment breaks in all output groups that use segmented
         *        outputs. Insertion of a SCTE 35 message typically results in a segment break, in addition to the
         *        regular cadence of breaks. The segment breaks appear in video outputs, audio outputs, and captions
         *        outputs (if any).
         *
         *        ALL_OUTPUT_GROUPS: Default. Insert the segment break in in all output groups that have segmented
         *        outputs. This is the legacy behavior. SCTE35_ENABLED_OUTPUT_GROUPS: Insert the segment break only in
         *        output groups that have SCTE 35 passthrough enabled. This is the recommended value, because it reduces
         *        unnecessary segment breaks.
         * @see Scte35SegmentationScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35SegmentationScope
         */
        Builder scte35SegmentationScope(String scte35SegmentationScope);

        /**
         * Configures whether SCTE 35 passthrough triggers segment breaks in all output groups that use segmented
         * outputs. Insertion of a SCTE 35 message typically results in a segment break, in addition to the regular
         * cadence of breaks. The segment breaks appear in video outputs, audio outputs, and captions outputs (if any).
         *
         * ALL_OUTPUT_GROUPS: Default. Insert the segment break in in all output groups that have segmented outputs.
         * This is the legacy behavior. SCTE35_ENABLED_OUTPUT_GROUPS: Insert the segment break only in output groups
         * that have SCTE 35 passthrough enabled. This is the recommended value, because it reduces unnecessary segment
         * breaks.
         * 
         * @param scte35SegmentationScope
         *        Configures whether SCTE 35 passthrough triggers segment breaks in all output groups that use segmented
         *        outputs. Insertion of a SCTE 35 message typically results in a segment break, in addition to the
         *        regular cadence of breaks. The segment breaks appear in video outputs, audio outputs, and captions
         *        outputs (if any).
         *
         *        ALL_OUTPUT_GROUPS: Default. Insert the segment break in in all output groups that have segmented
         *        outputs. This is the legacy behavior. SCTE35_ENABLED_OUTPUT_GROUPS: Insert the segment break only in
         *        output groups that have SCTE 35 passthrough enabled. This is the recommended value, because it reduces
         *        unnecessary segment breaks.
         * @see Scte35SegmentationScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scte35SegmentationScope
         */
        Builder scte35SegmentationScope(Scte35SegmentationScope scte35SegmentationScope);
    }

    static final class BuilderImpl implements Builder {
        private AvailSettings availSettings;

        private String scte35SegmentationScope;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailConfiguration model) {
            availSettings(model.availSettings);
            scte35SegmentationScope(model.scte35SegmentationScope);
        }

        public final AvailSettings.Builder getAvailSettings() {
            return availSettings != null ? availSettings.toBuilder() : null;
        }

        public final void setAvailSettings(AvailSettings.BuilderImpl availSettings) {
            this.availSettings = availSettings != null ? availSettings.build() : null;
        }

        @Override
        public final Builder availSettings(AvailSettings availSettings) {
            this.availSettings = availSettings;
            return this;
        }

        public final String getScte35SegmentationScope() {
            return scte35SegmentationScope;
        }

        public final void setScte35SegmentationScope(String scte35SegmentationScope) {
            this.scte35SegmentationScope = scte35SegmentationScope;
        }

        @Override
        public final Builder scte35SegmentationScope(String scte35SegmentationScope) {
            this.scte35SegmentationScope = scte35SegmentationScope;
            return this;
        }

        @Override
        public final Builder scte35SegmentationScope(Scte35SegmentationScope scte35SegmentationScope) {
            this.scte35SegmentationScope(scte35SegmentationScope == null ? null : scte35SegmentationScope.toString());
            return this;
        }

        @Override
        public AvailConfiguration build() {
            return new AvailConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
