/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Caption Description
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptionDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<CaptionDescription.Builder, CaptionDescription> {
    private static final SdkField<String> ACCESSIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Accessibility").getter(getter(CaptionDescription::accessibilityAsString))
            .setter(setter(Builder::accessibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessibility").build()).build();

    private static final SdkField<String> CAPTION_SELECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaptionSelectorName").getter(getter(CaptionDescription::captionSelectorName))
            .setter(setter(Builder::captionSelectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionSelectorName").build())
            .build();

    private static final SdkField<CaptionDestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField
            .<CaptionDestinationSettings> builder(MarshallingType.SDK_POJO).memberName("DestinationSettings")
            .getter(getter(CaptionDescription::destinationSettings)).setter(setter(Builder::destinationSettings))
            .constructor(CaptionDestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build())
            .build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(CaptionDescription::languageCode)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()).build();

    private static final SdkField<String> LANGUAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageDescription").getter(getter(CaptionDescription::languageDescription))
            .setter(setter(Builder::languageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageDescription").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CaptionDescription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> CAPTION_DASH_ROLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CaptionDashRoles")
            .getter(getter(CaptionDescription::captionDashRolesAsStrings))
            .setter(setter(Builder::captionDashRolesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionDashRoles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DVB_DASH_ACCESSIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DvbDashAccessibility").getter(getter(CaptionDescription::dvbDashAccessibilityAsString))
            .setter(setter(Builder::dvbDashAccessibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbDashAccessibility").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESSIBILITY_FIELD,
            CAPTION_SELECTOR_NAME_FIELD, DESTINATION_SETTINGS_FIELD, LANGUAGE_CODE_FIELD, LANGUAGE_DESCRIPTION_FIELD, NAME_FIELD,
            CAPTION_DASH_ROLES_FIELD, DVB_DASH_ACCESSIBILITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessibility;

    private final String captionSelectorName;

    private final CaptionDestinationSettings destinationSettings;

    private final String languageCode;

    private final String languageDescription;

    private final String name;

    private final List<String> captionDashRoles;

    private final String dvbDashAccessibility;

    private CaptionDescription(BuilderImpl builder) {
        this.accessibility = builder.accessibility;
        this.captionSelectorName = builder.captionSelectorName;
        this.destinationSettings = builder.destinationSettings;
        this.languageCode = builder.languageCode;
        this.languageDescription = builder.languageDescription;
        this.name = builder.name;
        this.captionDashRoles = builder.captionDashRoles;
        this.dvbDashAccessibility = builder.dvbDashAccessibility;
    }

    /**
     * Indicates whether the caption track implements accessibility features such as written descriptions of spoken
     * dialog, music, and sounds. This signaling is added to HLS output group and MediaPackage output group.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessibility}
     * will return {@link AccessibilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accessibilityAsString}.
     * </p>
     * 
     * @return Indicates whether the caption track implements accessibility features such as written descriptions of
     *         spoken dialog, music, and sounds. This signaling is added to HLS output group and MediaPackage output
     *         group.
     * @see AccessibilityType
     */
    public final AccessibilityType accessibility() {
        return AccessibilityType.fromValue(accessibility);
    }

    /**
     * Indicates whether the caption track implements accessibility features such as written descriptions of spoken
     * dialog, music, and sounds. This signaling is added to HLS output group and MediaPackage output group.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessibility}
     * will return {@link AccessibilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #accessibilityAsString}.
     * </p>
     * 
     * @return Indicates whether the caption track implements accessibility features such as written descriptions of
     *         spoken dialog, music, and sounds. This signaling is added to HLS output group and MediaPackage output
     *         group.
     * @see AccessibilityType
     */
    public final String accessibilityAsString() {
        return accessibility;
    }

    /**
     * Specifies which input caption selector to use as a caption source when generating output captions. This field
     * should match a captionSelector name.
     * 
     * @return Specifies which input caption selector to use as a caption source when generating output captions. This
     *         field should match a captionSelector name.
     */
    public final String captionSelectorName() {
        return captionSelectorName;
    }

    /**
     * Additional settings for captions destination that depend on the destination type.
     * 
     * @return Additional settings for captions destination that depend on the destination type.
     */
    public final CaptionDestinationSettings destinationSettings() {
        return destinationSettings;
    }

    /**
     * ISO 639-2 three-digit code: http://www.loc.gov/standards/iso639-2/
     * 
     * @return ISO 639-2 three-digit code: http://www.loc.gov/standards/iso639-2/
     */
    public final String languageCode() {
        return languageCode;
    }

    /**
     * Human readable information to indicate captions available for players (eg. English, or Spanish).
     * 
     * @return Human readable information to indicate captions available for players (eg. English, or Spanish).
     */
    public final String languageDescription() {
        return languageDescription;
    }

    /**
     * Name of the caption description. Used to associate a caption description with an output. Names must be unique
     * within an event.
     * 
     * @return Name of the caption description. Used to associate a caption description with an output. Names must be
     *         unique within an event.
     */
    public final String name() {
        return name;
    }

    /**
     * Identifies the DASH roles to assign to this captions output. Applies only when the captions output is configured
     * for DVB DASH accessibility signaling.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCaptionDashRoles} method.
     * </p>
     * 
     * @return Identifies the DASH roles to assign to this captions output. Applies only when the captions output is
     *         configured for DVB DASH accessibility signaling.
     */
    public final List<DashRoleCaption> captionDashRoles() {
        return ___listOfDashRoleCaptionCopier.copyStringToEnum(captionDashRoles);
    }

    /**
     * For responses, this returns true if the service returned a value for the CaptionDashRoles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCaptionDashRoles() {
        return captionDashRoles != null && !(captionDashRoles instanceof SdkAutoConstructList);
    }

    /**
     * Identifies the DASH roles to assign to this captions output. Applies only when the captions output is configured
     * for DVB DASH accessibility signaling.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCaptionDashRoles} method.
     * </p>
     * 
     * @return Identifies the DASH roles to assign to this captions output. Applies only when the captions output is
     *         configured for DVB DASH accessibility signaling.
     */
    public final List<String> captionDashRolesAsStrings() {
        return captionDashRoles;
    }

    /**
     * Identifies DVB DASH accessibility signaling in this captions output. Used in Microsoft Smooth Streaming outputs
     * to signal accessibility information to packagers.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dvbDashAccessibility} will return {@link DvbDashAccessibility#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dvbDashAccessibilityAsString}.
     * </p>
     * 
     * @return Identifies DVB DASH accessibility signaling in this captions output. Used in Microsoft Smooth Streaming
     *         outputs to signal accessibility information to packagers.
     * @see DvbDashAccessibility
     */
    public final DvbDashAccessibility dvbDashAccessibility() {
        return DvbDashAccessibility.fromValue(dvbDashAccessibility);
    }

    /**
     * Identifies DVB DASH accessibility signaling in this captions output. Used in Microsoft Smooth Streaming outputs
     * to signal accessibility information to packagers.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dvbDashAccessibility} will return {@link DvbDashAccessibility#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dvbDashAccessibilityAsString}.
     * </p>
     * 
     * @return Identifies DVB DASH accessibility signaling in this captions output. Used in Microsoft Smooth Streaming
     *         outputs to signal accessibility information to packagers.
     * @see DvbDashAccessibility
     */
    public final String dvbDashAccessibilityAsString() {
        return dvbDashAccessibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(captionSelectorName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(languageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasCaptionDashRoles() ? captionDashRolesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dvbDashAccessibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionDescription)) {
            return false;
        }
        CaptionDescription other = (CaptionDescription) obj;
        return Objects.equals(accessibilityAsString(), other.accessibilityAsString())
                && Objects.equals(captionSelectorName(), other.captionSelectorName())
                && Objects.equals(destinationSettings(), other.destinationSettings())
                && Objects.equals(languageCode(), other.languageCode())
                && Objects.equals(languageDescription(), other.languageDescription()) && Objects.equals(name(), other.name())
                && hasCaptionDashRoles() == other.hasCaptionDashRoles()
                && Objects.equals(captionDashRolesAsStrings(), other.captionDashRolesAsStrings())
                && Objects.equals(dvbDashAccessibilityAsString(), other.dvbDashAccessibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaptionDescription").add("Accessibility", accessibilityAsString())
                .add("CaptionSelectorName", captionSelectorName()).add("DestinationSettings", destinationSettings())
                .add("LanguageCode", languageCode()).add("LanguageDescription", languageDescription()).add("Name", name())
                .add("CaptionDashRoles", hasCaptionDashRoles() ? captionDashRolesAsStrings() : null)
                .add("DvbDashAccessibility", dvbDashAccessibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Accessibility":
            return Optional.ofNullable(clazz.cast(accessibilityAsString()));
        case "CaptionSelectorName":
            return Optional.ofNullable(clazz.cast(captionSelectorName()));
        case "DestinationSettings":
            return Optional.ofNullable(clazz.cast(destinationSettings()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCode()));
        case "LanguageDescription":
            return Optional.ofNullable(clazz.cast(languageDescription()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CaptionDashRoles":
            return Optional.ofNullable(clazz.cast(captionDashRolesAsStrings()));
        case "DvbDashAccessibility":
            return Optional.ofNullable(clazz.cast(dvbDashAccessibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessibility", ACCESSIBILITY_FIELD);
        map.put("captionSelectorName", CAPTION_SELECTOR_NAME_FIELD);
        map.put("destinationSettings", DESTINATION_SETTINGS_FIELD);
        map.put("languageCode", LANGUAGE_CODE_FIELD);
        map.put("languageDescription", LANGUAGE_DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("captionDashRoles", CAPTION_DASH_ROLES_FIELD);
        map.put("dvbDashAccessibility", DVB_DASH_ACCESSIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaptionDescription, T> g) {
        return obj -> g.apply((CaptionDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptionDescription> {
        /**
         * Indicates whether the caption track implements accessibility features such as written descriptions of spoken
         * dialog, music, and sounds. This signaling is added to HLS output group and MediaPackage output group.
         * 
         * @param accessibility
         *        Indicates whether the caption track implements accessibility features such as written descriptions of
         *        spoken dialog, music, and sounds. This signaling is added to HLS output group and MediaPackage output
         *        group.
         * @see AccessibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessibilityType
         */
        Builder accessibility(String accessibility);

        /**
         * Indicates whether the caption track implements accessibility features such as written descriptions of spoken
         * dialog, music, and sounds. This signaling is added to HLS output group and MediaPackage output group.
         * 
         * @param accessibility
         *        Indicates whether the caption track implements accessibility features such as written descriptions of
         *        spoken dialog, music, and sounds. This signaling is added to HLS output group and MediaPackage output
         *        group.
         * @see AccessibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessibilityType
         */
        Builder accessibility(AccessibilityType accessibility);

        /**
         * Specifies which input caption selector to use as a caption source when generating output captions. This field
         * should match a captionSelector name.
         * 
         * @param captionSelectorName
         *        Specifies which input caption selector to use as a caption source when generating output captions.
         *        This field should match a captionSelector name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionSelectorName(String captionSelectorName);

        /**
         * Additional settings for captions destination that depend on the destination type.
         * 
         * @param destinationSettings
         *        Additional settings for captions destination that depend on the destination type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSettings(CaptionDestinationSettings destinationSettings);

        /**
         * Additional settings for captions destination that depend on the destination type. This is a convenience
         * method that creates an instance of the {@link CaptionDestinationSettings.Builder} avoiding the need to create
         * one manually via {@link CaptionDestinationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CaptionDestinationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationSettings(CaptionDestinationSettings)}.
         * 
         * @param destinationSettings
         *        a consumer that will call methods on {@link CaptionDestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSettings(CaptionDestinationSettings)
         */
        default Builder destinationSettings(Consumer<CaptionDestinationSettings.Builder> destinationSettings) {
            return destinationSettings(CaptionDestinationSettings.builder().applyMutation(destinationSettings).build());
        }

        /**
         * ISO 639-2 three-digit code: http://www.loc.gov/standards/iso639-2/
         * 
         * @param languageCode
         *        ISO 639-2 three-digit code: http://www.loc.gov/standards/iso639-2/
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageCode(String languageCode);

        /**
         * Human readable information to indicate captions available for players (eg. English, or Spanish).
         * 
         * @param languageDescription
         *        Human readable information to indicate captions available for players (eg. English, or Spanish).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageDescription(String languageDescription);

        /**
         * Name of the caption description. Used to associate a caption description with an output. Names must be unique
         * within an event.
         * 
         * @param name
         *        Name of the caption description. Used to associate a caption description with an output. Names must be
         *        unique within an event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Identifies the DASH roles to assign to this captions output. Applies only when the captions output is
         * configured for DVB DASH accessibility signaling.
         * 
         * @param captionDashRoles
         *        Identifies the DASH roles to assign to this captions output. Applies only when the captions output is
         *        configured for DVB DASH accessibility signaling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionDashRolesWithStrings(Collection<String> captionDashRoles);

        /**
         * Identifies the DASH roles to assign to this captions output. Applies only when the captions output is
         * configured for DVB DASH accessibility signaling.
         * 
         * @param captionDashRoles
         *        Identifies the DASH roles to assign to this captions output. Applies only when the captions output is
         *        configured for DVB DASH accessibility signaling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionDashRolesWithStrings(String... captionDashRoles);

        /**
         * Identifies the DASH roles to assign to this captions output. Applies only when the captions output is
         * configured for DVB DASH accessibility signaling.
         * 
         * @param captionDashRoles
         *        Identifies the DASH roles to assign to this captions output. Applies only when the captions output is
         *        configured for DVB DASH accessibility signaling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionDashRoles(Collection<DashRoleCaption> captionDashRoles);

        /**
         * Identifies the DASH roles to assign to this captions output. Applies only when the captions output is
         * configured for DVB DASH accessibility signaling.
         * 
         * @param captionDashRoles
         *        Identifies the DASH roles to assign to this captions output. Applies only when the captions output is
         *        configured for DVB DASH accessibility signaling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionDashRoles(DashRoleCaption... captionDashRoles);

        /**
         * Identifies DVB DASH accessibility signaling in this captions output. Used in Microsoft Smooth Streaming
         * outputs to signal accessibility information to packagers.
         * 
         * @param dvbDashAccessibility
         *        Identifies DVB DASH accessibility signaling in this captions output. Used in Microsoft Smooth
         *        Streaming outputs to signal accessibility information to packagers.
         * @see DvbDashAccessibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbDashAccessibility
         */
        Builder dvbDashAccessibility(String dvbDashAccessibility);

        /**
         * Identifies DVB DASH accessibility signaling in this captions output. Used in Microsoft Smooth Streaming
         * outputs to signal accessibility information to packagers.
         * 
         * @param dvbDashAccessibility
         *        Identifies DVB DASH accessibility signaling in this captions output. Used in Microsoft Smooth
         *        Streaming outputs to signal accessibility information to packagers.
         * @see DvbDashAccessibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbDashAccessibility
         */
        Builder dvbDashAccessibility(DvbDashAccessibility dvbDashAccessibility);
    }

    static final class BuilderImpl implements Builder {
        private String accessibility;

        private String captionSelectorName;

        private CaptionDestinationSettings destinationSettings;

        private String languageCode;

        private String languageDescription;

        private String name;

        private List<String> captionDashRoles = DefaultSdkAutoConstructList.getInstance();

        private String dvbDashAccessibility;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionDescription model) {
            accessibility(model.accessibility);
            captionSelectorName(model.captionSelectorName);
            destinationSettings(model.destinationSettings);
            languageCode(model.languageCode);
            languageDescription(model.languageDescription);
            name(model.name);
            captionDashRolesWithStrings(model.captionDashRoles);
            dvbDashAccessibility(model.dvbDashAccessibility);
        }

        public final String getAccessibility() {
            return accessibility;
        }

        public final void setAccessibility(String accessibility) {
            this.accessibility = accessibility;
        }

        @Override
        public final Builder accessibility(String accessibility) {
            this.accessibility = accessibility;
            return this;
        }

        @Override
        public final Builder accessibility(AccessibilityType accessibility) {
            this.accessibility(accessibility == null ? null : accessibility.toString());
            return this;
        }

        public final String getCaptionSelectorName() {
            return captionSelectorName;
        }

        public final void setCaptionSelectorName(String captionSelectorName) {
            this.captionSelectorName = captionSelectorName;
        }

        @Override
        public final Builder captionSelectorName(String captionSelectorName) {
            this.captionSelectorName = captionSelectorName;
            return this;
        }

        public final CaptionDestinationSettings.Builder getDestinationSettings() {
            return destinationSettings != null ? destinationSettings.toBuilder() : null;
        }

        public final void setDestinationSettings(CaptionDestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        @Override
        public final Builder destinationSettings(CaptionDestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final String getLanguageDescription() {
            return languageDescription;
        }

        public final void setLanguageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
        }

        @Override
        public final Builder languageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getCaptionDashRoles() {
            if (captionDashRoles instanceof SdkAutoConstructList) {
                return null;
            }
            return captionDashRoles;
        }

        public final void setCaptionDashRoles(Collection<String> captionDashRoles) {
            this.captionDashRoles = ___listOfDashRoleCaptionCopier.copy(captionDashRoles);
        }

        @Override
        public final Builder captionDashRolesWithStrings(Collection<String> captionDashRoles) {
            this.captionDashRoles = ___listOfDashRoleCaptionCopier.copy(captionDashRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDashRolesWithStrings(String... captionDashRoles) {
            captionDashRolesWithStrings(Arrays.asList(captionDashRoles));
            return this;
        }

        @Override
        public final Builder captionDashRoles(Collection<DashRoleCaption> captionDashRoles) {
            this.captionDashRoles = ___listOfDashRoleCaptionCopier.copyEnumToString(captionDashRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionDashRoles(DashRoleCaption... captionDashRoles) {
            captionDashRoles(Arrays.asList(captionDashRoles));
            return this;
        }

        public final String getDvbDashAccessibility() {
            return dvbDashAccessibility;
        }

        public final void setDvbDashAccessibility(String dvbDashAccessibility) {
            this.dvbDashAccessibility = dvbDashAccessibility;
        }

        @Override
        public final Builder dvbDashAccessibility(String dvbDashAccessibility) {
            this.dvbDashAccessibility = dvbDashAccessibility;
            return this;
        }

        @Override
        public final Builder dvbDashAccessibility(DvbDashAccessibility dvbDashAccessibility) {
            this.dvbDashAccessibility(dvbDashAccessibility == null ? null : dvbDashAccessibility.toString());
            return this;
        }

        @Override
        public CaptionDescription build() {
            return new CaptionDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
