/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * The resource type this template should dynamically generate cloudwatch metric alarms for.
 */
@Generated("software.amazon.awssdk:codegen")
public enum CloudWatchAlarmTemplateTargetResourceType {
    CLOUDFRONT_DISTRIBUTION("CLOUDFRONT_DISTRIBUTION"),

    MEDIALIVE_MULTIPLEX("MEDIALIVE_MULTIPLEX"),

    MEDIALIVE_CHANNEL("MEDIALIVE_CHANNEL"),

    MEDIALIVE_INPUT_DEVICE("MEDIALIVE_INPUT_DEVICE"),

    MEDIAPACKAGE_CHANNEL("MEDIAPACKAGE_CHANNEL"),

    MEDIAPACKAGE_ORIGIN_ENDPOINT("MEDIAPACKAGE_ORIGIN_ENDPOINT"),

    MEDIACONNECT_FLOW("MEDIACONNECT_FLOW"),

    S3_BUCKET("S3_BUCKET"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CloudWatchAlarmTemplateTargetResourceType> VALUE_MAP = EnumUtils.uniqueIndex(
            CloudWatchAlarmTemplateTargetResourceType.class, CloudWatchAlarmTemplateTargetResourceType::toString);

    private final String value;

    private CloudWatchAlarmTemplateTargetResourceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return CloudWatchAlarmTemplateTargetResourceType corresponding to the value
     */
    public static CloudWatchAlarmTemplateTargetResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link CloudWatchAlarmTemplateTargetResourceType}s
     */
    public static Set<CloudWatchAlarmTemplateTargetResourceType> knownValues() {
        Set<CloudWatchAlarmTemplateTargetResourceType> knownValues = EnumSet
                .allOf(CloudWatchAlarmTemplateTargetResourceType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
