/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Property of ColorCorrectionSettings. Used for custom color space conversion. The object identifies one 3D LUT file
 * and specifies the input/output color space combination that the file will be used for.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColorCorrection implements SdkPojo, Serializable, ToCopyableBuilder<ColorCorrection.Builder, ColorCorrection> {
    private static final SdkField<String> INPUT_COLOR_SPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputColorSpace").getter(getter(ColorCorrection::inputColorSpaceAsString))
            .setter(setter(Builder::inputColorSpace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputColorSpace").build()).build();

    private static final SdkField<String> OUTPUT_COLOR_SPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputColorSpace").getter(getter(ColorCorrection::outputColorSpaceAsString))
            .setter(setter(Builder::outputColorSpace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputColorSpace").build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Uri")
            .getter(getter(ColorCorrection::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_COLOR_SPACE_FIELD,
            OUTPUT_COLOR_SPACE_FIELD, URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inputColorSpace;

    private final String outputColorSpace;

    private final String uri;

    private ColorCorrection(BuilderImpl builder) {
        this.inputColorSpace = builder.inputColorSpace;
        this.outputColorSpace = builder.outputColorSpace;
        this.uri = builder.uri;
    }

    /**
     * The color space of the input.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputColorSpace}
     * will return {@link ColorSpace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputColorSpaceAsString}.
     * </p>
     * 
     * @return The color space of the input.
     * @see ColorSpace
     */
    public final ColorSpace inputColorSpace() {
        return ColorSpace.fromValue(inputColorSpace);
    }

    /**
     * The color space of the input.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputColorSpace}
     * will return {@link ColorSpace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputColorSpaceAsString}.
     * </p>
     * 
     * @return The color space of the input.
     * @see ColorSpace
     */
    public final String inputColorSpaceAsString() {
        return inputColorSpace;
    }

    /**
     * The color space of the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputColorSpace}
     * will return {@link ColorSpace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputColorSpaceAsString}.
     * </p>
     * 
     * @return The color space of the output.
     * @see ColorSpace
     */
    public final ColorSpace outputColorSpace() {
        return ColorSpace.fromValue(outputColorSpace);
    }

    /**
     * The color space of the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputColorSpace}
     * will return {@link ColorSpace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputColorSpaceAsString}.
     * </p>
     * 
     * @return The color space of the output.
     * @see ColorSpace
     */
    public final String outputColorSpaceAsString() {
        return outputColorSpace;
    }

    /**
     * The URI of the 3D LUT file. The protocol must be 's3:' or 's3ssl:':.
     * 
     * @return The URI of the 3D LUT file. The protocol must be 's3:' or 's3ssl:':.
     */
    public final String uri() {
        return uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputColorSpaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputColorSpaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColorCorrection)) {
            return false;
        }
        ColorCorrection other = (ColorCorrection) obj;
        return Objects.equals(inputColorSpaceAsString(), other.inputColorSpaceAsString())
                && Objects.equals(outputColorSpaceAsString(), other.outputColorSpaceAsString())
                && Objects.equals(uri(), other.uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColorCorrection").add("InputColorSpace", inputColorSpaceAsString())
                .add("OutputColorSpace", outputColorSpaceAsString()).add("Uri", uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputColorSpace":
            return Optional.ofNullable(clazz.cast(inputColorSpaceAsString()));
        case "OutputColorSpace":
            return Optional.ofNullable(clazz.cast(outputColorSpaceAsString()));
        case "Uri":
            return Optional.ofNullable(clazz.cast(uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputColorSpace", INPUT_COLOR_SPACE_FIELD);
        map.put("outputColorSpace", OUTPUT_COLOR_SPACE_FIELD);
        map.put("uri", URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColorCorrection, T> g) {
        return obj -> g.apply((ColorCorrection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColorCorrection> {
        /**
         * The color space of the input.
         * 
         * @param inputColorSpace
         *        The color space of the input.
         * @see ColorSpace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorSpace
         */
        Builder inputColorSpace(String inputColorSpace);

        /**
         * The color space of the input.
         * 
         * @param inputColorSpace
         *        The color space of the input.
         * @see ColorSpace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorSpace
         */
        Builder inputColorSpace(ColorSpace inputColorSpace);

        /**
         * The color space of the output.
         * 
         * @param outputColorSpace
         *        The color space of the output.
         * @see ColorSpace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorSpace
         */
        Builder outputColorSpace(String outputColorSpace);

        /**
         * The color space of the output.
         * 
         * @param outputColorSpace
         *        The color space of the output.
         * @see ColorSpace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorSpace
         */
        Builder outputColorSpace(ColorSpace outputColorSpace);

        /**
         * The URI of the 3D LUT file. The protocol must be 's3:' or 's3ssl:':.
         * 
         * @param uri
         *        The URI of the 3D LUT file. The protocol must be 's3:' or 's3ssl:':.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);
    }

    static final class BuilderImpl implements Builder {
        private String inputColorSpace;

        private String outputColorSpace;

        private String uri;

        private BuilderImpl() {
        }

        private BuilderImpl(ColorCorrection model) {
            inputColorSpace(model.inputColorSpace);
            outputColorSpace(model.outputColorSpace);
            uri(model.uri);
        }

        public final String getInputColorSpace() {
            return inputColorSpace;
        }

        public final void setInputColorSpace(String inputColorSpace) {
            this.inputColorSpace = inputColorSpace;
        }

        @Override
        public final Builder inputColorSpace(String inputColorSpace) {
            this.inputColorSpace = inputColorSpace;
            return this;
        }

        @Override
        public final Builder inputColorSpace(ColorSpace inputColorSpace) {
            this.inputColorSpace(inputColorSpace == null ? null : inputColorSpace.toString());
            return this;
        }

        public final String getOutputColorSpace() {
            return outputColorSpace;
        }

        public final void setOutputColorSpace(String outputColorSpace) {
            this.outputColorSpace = outputColorSpace;
        }

        @Override
        public final Builder outputColorSpace(String outputColorSpace) {
            this.outputColorSpace = outputColorSpace;
            return this;
        }

        @Override
        public final Builder outputColorSpace(ColorSpace outputColorSpace) {
            this.outputColorSpace(outputColorSpace == null ? null : outputColorSpace.toString());
            return this;
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public ColorCorrection build() {
            return new ColorCorrection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
