/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for CreateChannelPlacementGroupResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChannelPlacementGroupResponse extends MediaLiveResponse implements
        ToCopyableBuilder<CreateChannelPlacementGroupResponse.Builder, CreateChannelPlacementGroupResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateChannelPlacementGroupResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Channels")
            .getter(getter(CreateChannelPlacementGroupResponse::channels))
            .setter(setter(Builder::channels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(CreateChannelPlacementGroupResponse::clusterId))
            .setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CreateChannelPlacementGroupResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateChannelPlacementGroupResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> NODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Nodes")
            .getter(getter(CreateChannelPlacementGroupResponse::nodes))
            .setter(setter(Builder::nodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CreateChannelPlacementGroupResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNELS_FIELD,
            CLUSTER_ID_FIELD, ID_FIELD, NAME_FIELD, NODES_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final List<String> channels;

    private final String clusterId;

    private final String id;

    private final String name;

    private final List<String> nodes;

    private final String state;

    private CreateChannelPlacementGroupResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.channels = builder.channels;
        this.clusterId = builder.clusterId;
        this.id = builder.id;
        this.name = builder.name;
        this.nodes = builder.nodes;
        this.state = builder.state;
    }

    /**
     * The ARN of this ChannelPlacementGroup. It is automatically assigned when the ChannelPlacementGroup is created.
     * 
     * @return The ARN of this ChannelPlacementGroup. It is automatically assigned when the ChannelPlacementGroup is
     *         created.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Channels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChannels() {
        return channels != null && !(channels instanceof SdkAutoConstructList);
    }

    /**
     * Used in ListChannelPlacementGroupsResult
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannels} method.
     * </p>
     * 
     * @return Used in ListChannelPlacementGroupsResult
     */
    public final List<String> channels() {
        return channels;
    }

    /**
     * The ID of the Cluster that the Node belongs to.
     * 
     * @return The ID of the Cluster that the Node belongs to.
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * The ID of the ChannelPlacementGroup. Unique in the AWS account. The ID is the resource-id portion of the ARN.
     * 
     * @return The ID of the ChannelPlacementGroup. Unique in the AWS account. The ID is the resource-id portion of the
     *         ARN.
     */
    public final String id() {
        return id;
    }

    /**
     * The name that you specified for the ChannelPlacementGroup.
     * 
     * @return The name that you specified for the ChannelPlacementGroup.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Nodes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNodes() {
        return nodes != null && !(nodes instanceof SdkAutoConstructList);
    }

    /**
     * An array with one item, which is the signle Node that is associated with the ChannelPlacementGroup.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodes} method.
     * </p>
     * 
     * @return An array with one item, which is the signle Node that is associated with the ChannelPlacementGroup.
     */
    public final List<String> nodes() {
        return nodes;
    }

    /**
     * The current state of the ChannelPlacementGroup.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ChannelPlacementGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the ChannelPlacementGroup.
     * @see ChannelPlacementGroupState
     */
    public final ChannelPlacementGroupState state() {
        return ChannelPlacementGroupState.fromValue(state);
    }

    /**
     * The current state of the ChannelPlacementGroup.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ChannelPlacementGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the ChannelPlacementGroup.
     * @see ChannelPlacementGroupState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasChannels() ? channels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodes() ? nodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelPlacementGroupResponse)) {
            return false;
        }
        CreateChannelPlacementGroupResponse other = (CreateChannelPlacementGroupResponse) obj;
        return Objects.equals(arn(), other.arn()) && hasChannels() == other.hasChannels()
                && Objects.equals(channels(), other.channels()) && Objects.equals(clusterId(), other.clusterId())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && hasNodes() == other.hasNodes()
                && Objects.equals(nodes(), other.nodes()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChannelPlacementGroupResponse").add("Arn", arn())
                .add("Channels", hasChannels() ? channels() : null).add("ClusterId", clusterId()).add("Id", id())
                .add("Name", name()).add("Nodes", hasNodes() ? nodes() : null).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Channels":
            return Optional.ofNullable(clazz.cast(channels()));
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Nodes":
            return Optional.ofNullable(clazz.cast(nodes()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("channels", CHANNELS_FIELD);
        map.put("clusterId", CLUSTER_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("nodes", NODES_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelPlacementGroupResponse, T> g) {
        return obj -> g.apply((CreateChannelPlacementGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateChannelPlacementGroupResponse> {
        /**
         * The ARN of this ChannelPlacementGroup. It is automatically assigned when the ChannelPlacementGroup is
         * created.
         * 
         * @param arn
         *        The ARN of this ChannelPlacementGroup. It is automatically assigned when the ChannelPlacementGroup is
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Used in ListChannelPlacementGroupsResult
         * 
         * @param channels
         *        Used in ListChannelPlacementGroupsResult
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Collection<String> channels);

        /**
         * Used in ListChannelPlacementGroupsResult
         * 
         * @param channels
         *        Used in ListChannelPlacementGroupsResult
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(String... channels);

        /**
         * The ID of the Cluster that the Node belongs to.
         * 
         * @param clusterId
         *        The ID of the Cluster that the Node belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * The ID of the ChannelPlacementGroup. Unique in the AWS account. The ID is the resource-id portion of the ARN.
         * 
         * @param id
         *        The ID of the ChannelPlacementGroup. Unique in the AWS account. The ID is the resource-id portion of
         *        the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The name that you specified for the ChannelPlacementGroup.
         * 
         * @param name
         *        The name that you specified for the ChannelPlacementGroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * An array with one item, which is the signle Node that is associated with the ChannelPlacementGroup.
         * 
         * @param nodes
         *        An array with one item, which is the signle Node that is associated with the ChannelPlacementGroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodes(Collection<String> nodes);

        /**
         * An array with one item, which is the signle Node that is associated with the ChannelPlacementGroup.
         * 
         * @param nodes
         *        An array with one item, which is the signle Node that is associated with the ChannelPlacementGroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodes(String... nodes);

        /**
         * The current state of the ChannelPlacementGroup.
         * 
         * @param state
         *        The current state of the ChannelPlacementGroup.
         * @see ChannelPlacementGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelPlacementGroupState
         */
        Builder state(String state);

        /**
         * The current state of the ChannelPlacementGroup.
         * 
         * @param state
         *        The current state of the ChannelPlacementGroup.
         * @see ChannelPlacementGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelPlacementGroupState
         */
        Builder state(ChannelPlacementGroupState state);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String arn;

        private List<String> channels = DefaultSdkAutoConstructList.getInstance();

        private String clusterId;

        private String id;

        private String name;

        private List<String> nodes = DefaultSdkAutoConstructList.getInstance();

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelPlacementGroupResponse model) {
            super(model);
            arn(model.arn);
            channels(model.channels);
            clusterId(model.clusterId);
            id(model.id);
            name(model.name);
            nodes(model.nodes);
            state(model.state);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getChannels() {
            if (channels instanceof SdkAutoConstructList) {
                return null;
            }
            return channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ___listOf__stringCopier.copy(channels);
        }

        @Override
        public final Builder channels(Collection<String> channels) {
            this.channels = ___listOf__stringCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(String... channels) {
            channels(Arrays.asList(channels));
            return this;
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getNodes() {
            if (nodes instanceof SdkAutoConstructList) {
                return null;
            }
            return nodes;
        }

        public final void setNodes(Collection<String> nodes) {
            this.nodes = ___listOf__stringCopier.copy(nodes);
        }

        @Override
        public final Builder nodes(Collection<String> nodes) {
            this.nodes = ___listOf__stringCopier.copy(nodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(String... nodes) {
            nodes(Arrays.asList(nodes));
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ChannelPlacementGroupState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public CreateChannelPlacementGroupResponse build() {
            return new CreateChannelPlacementGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
