/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for CreateCloudWatchAlarmTemplateResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCloudWatchAlarmTemplateResponse extends MediaLiveResponse implements
        ToCopyableBuilder<CreateCloudWatchAlarmTemplateResponse.Builder, CreateCloudWatchAlarmTemplateResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateCloudWatchAlarmTemplateResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComparisonOperator").getter(getter(CreateCloudWatchAlarmTemplateResponse::comparisonOperatorAsString))
            .setter(setter(Builder::comparisonOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparisonOperator").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(CreateCloudWatchAlarmTemplateResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> DATAPOINTS_TO_ALARM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DatapointsToAlarm").getter(getter(CreateCloudWatchAlarmTemplateResponse::datapointsToAlarm))
            .setter(setter(Builder::datapointsToAlarm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datapointsToAlarm").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateCloudWatchAlarmTemplateResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Integer> EVALUATION_PERIODS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EvaluationPeriods").getter(getter(CreateCloudWatchAlarmTemplateResponse::evaluationPeriods))
            .setter(setter(Builder::evaluationPeriods))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationPeriods").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(CreateCloudWatchAlarmTemplateResponse::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CreateCloudWatchAlarmTemplateResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(CreateCloudWatchAlarmTemplateResponse::metricName))
            .setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedAt")
            .getter(getter(CreateCloudWatchAlarmTemplateResponse::modifiedAt))
            .setter(setter(Builder::modifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateCloudWatchAlarmTemplateResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Period").getter(getter(CreateCloudWatchAlarmTemplateResponse::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()).build();

    private static final SdkField<String> STATISTIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Statistic").getter(getter(CreateCloudWatchAlarmTemplateResponse::statisticAsString))
            .setter(setter(Builder::statistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistic").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateCloudWatchAlarmTemplateResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TARGET_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetResourceType").getter(getter(CreateCloudWatchAlarmTemplateResponse::targetResourceTypeAsString))
            .setter(setter(Builder::targetResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceType").build())
            .build();

    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Threshold").getter(getter(CreateCloudWatchAlarmTemplateResponse::threshold))
            .setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()).build();

    private static final SdkField<String> TREAT_MISSING_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TreatMissingData").getter(getter(CreateCloudWatchAlarmTemplateResponse::treatMissingDataAsString))
            .setter(setter(Builder::treatMissingData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatMissingData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            COMPARISON_OPERATOR_FIELD, CREATED_AT_FIELD, DATAPOINTS_TO_ALARM_FIELD, DESCRIPTION_FIELD, EVALUATION_PERIODS_FIELD,
            GROUP_ID_FIELD, ID_FIELD, METRIC_NAME_FIELD, MODIFIED_AT_FIELD, NAME_FIELD, PERIOD_FIELD, STATISTIC_FIELD,
            TAGS_FIELD, TARGET_RESOURCE_TYPE_FIELD, THRESHOLD_FIELD, TREAT_MISSING_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String comparisonOperator;

    private final Instant createdAt;

    private final Integer datapointsToAlarm;

    private final String description;

    private final Integer evaluationPeriods;

    private final String groupId;

    private final String id;

    private final String metricName;

    private final Instant modifiedAt;

    private final String name;

    private final Integer period;

    private final String statistic;

    private final Map<String, String> tags;

    private final String targetResourceType;

    private final Double threshold;

    private final String treatMissingData;

    private CreateCloudWatchAlarmTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.comparisonOperator = builder.comparisonOperator;
        this.createdAt = builder.createdAt;
        this.datapointsToAlarm = builder.datapointsToAlarm;
        this.description = builder.description;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.groupId = builder.groupId;
        this.id = builder.id;
        this.metricName = builder.metricName;
        this.modifiedAt = builder.modifiedAt;
        this.name = builder.name;
        this.period = builder.period;
        this.statistic = builder.statistic;
        this.tags = builder.tags;
        this.targetResourceType = builder.targetResourceType;
        this.threshold = builder.threshold;
        this.treatMissingData = builder.treatMissingData;
    }

    /**
     * A cloudwatch alarm template's ARN (Amazon Resource Name)
     * 
     * @return A cloudwatch alarm template's ARN (Amazon Resource Name)
     */
    public final String arn() {
        return arn;
    }

    /**
     * Returns the value of the ComparisonOperator property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link CloudWatchAlarmTemplateComparisonOperator#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The value of the ComparisonOperator property for this object.
     * @see CloudWatchAlarmTemplateComparisonOperator
     */
    public final CloudWatchAlarmTemplateComparisonOperator comparisonOperator() {
        return CloudWatchAlarmTemplateComparisonOperator.fromValue(comparisonOperator);
    }

    /**
     * Returns the value of the ComparisonOperator property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link CloudWatchAlarmTemplateComparisonOperator#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The value of the ComparisonOperator property for this object.
     * @see CloudWatchAlarmTemplateComparisonOperator
     */
    public final String comparisonOperatorAsString() {
        return comparisonOperator;
    }

    /**
     * Returns the value of the CreatedAt property for this object.
     * 
     * @return The value of the CreatedAt property for this object.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * The number of datapoints within the evaluation period that must be breaching to trigger the alarm.
     * 
     * @return The number of datapoints within the evaluation period that must be breaching to trigger the alarm.
     */
    public final Integer datapointsToAlarm() {
        return datapointsToAlarm;
    }

    /**
     * A resource's optional description.
     * 
     * @return A resource's optional description.
     */
    public final String description() {
        return description;
    }

    /**
     * The number of periods over which data is compared to the specified threshold.
     * 
     * @return The number of periods over which data is compared to the specified threshold.
     */
    public final Integer evaluationPeriods() {
        return evaluationPeriods;
    }

    /**
     * A cloudwatch alarm template group's id. AWS provided template groups have ids that start with `aws-`
     * 
     * @return A cloudwatch alarm template group's id. AWS provided template groups have ids that start with `aws-`
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * A cloudwatch alarm template's id. AWS provided templates have ids that start with `aws-`
     * 
     * @return A cloudwatch alarm template's id. AWS provided templates have ids that start with `aws-`
     */
    public final String id() {
        return id;
    }

    /**
     * The name of the metric associated with the alarm. Must be compatible with targetResourceType.
     * 
     * @return The name of the metric associated with the alarm. Must be compatible with targetResourceType.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * Returns the value of the ModifiedAt property for this object.
     * 
     * @return The value of the ModifiedAt property for this object.
     */
    public final Instant modifiedAt() {
        return modifiedAt;
    }

    /**
     * A resource's name. Names must be unique within the scope of a resource type in a specific region.
     * 
     * @return A resource's name. Names must be unique within the scope of a resource type in a specific region.
     */
    public final String name() {
        return name;
    }

    /**
     * The period, in seconds, over which the specified statistic is applied.
     * 
     * @return The period, in seconds, over which the specified statistic is applied.
     */
    public final Integer period() {
        return period;
    }

    /**
     * Returns the value of the Statistic property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link CloudWatchAlarmTemplateStatistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statisticAsString}.
     * </p>
     * 
     * @return The value of the Statistic property for this object.
     * @see CloudWatchAlarmTemplateStatistic
     */
    public final CloudWatchAlarmTemplateStatistic statistic() {
        return CloudWatchAlarmTemplateStatistic.fromValue(statistic);
    }

    /**
     * Returns the value of the Statistic property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link CloudWatchAlarmTemplateStatistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statisticAsString}.
     * </p>
     * 
     * @return The value of the Statistic property for this object.
     * @see CloudWatchAlarmTemplateStatistic
     */
    public final String statisticAsString() {
        return statistic;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * Returns the value of the TargetResourceType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetResourceType} will return {@link CloudWatchAlarmTemplateTargetResourceType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #targetResourceTypeAsString}.
     * </p>
     * 
     * @return The value of the TargetResourceType property for this object.
     * @see CloudWatchAlarmTemplateTargetResourceType
     */
    public final CloudWatchAlarmTemplateTargetResourceType targetResourceType() {
        return CloudWatchAlarmTemplateTargetResourceType.fromValue(targetResourceType);
    }

    /**
     * Returns the value of the TargetResourceType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetResourceType} will return {@link CloudWatchAlarmTemplateTargetResourceType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #targetResourceTypeAsString}.
     * </p>
     * 
     * @return The value of the TargetResourceType property for this object.
     * @see CloudWatchAlarmTemplateTargetResourceType
     */
    public final String targetResourceTypeAsString() {
        return targetResourceType;
    }

    /**
     * The threshold value to compare with the specified statistic.
     * 
     * @return The threshold value to compare with the specified statistic.
     */
    public final Double threshold() {
        return threshold;
    }

    /**
     * Returns the value of the TreatMissingData property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #treatMissingData}
     * will return {@link CloudWatchAlarmTemplateTreatMissingData#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #treatMissingDataAsString}.
     * </p>
     * 
     * @return The value of the TreatMissingData property for this object.
     * @see CloudWatchAlarmTemplateTreatMissingData
     */
    public final CloudWatchAlarmTemplateTreatMissingData treatMissingData() {
        return CloudWatchAlarmTemplateTreatMissingData.fromValue(treatMissingData);
    }

    /**
     * Returns the value of the TreatMissingData property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #treatMissingData}
     * will return {@link CloudWatchAlarmTemplateTreatMissingData#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #treatMissingDataAsString}.
     * </p>
     * 
     * @return The value of the TreatMissingData property for this object.
     * @see CloudWatchAlarmTemplateTreatMissingData
     */
    public final String treatMissingDataAsString() {
        return treatMissingData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(datapointsToAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        hashCode = 31 * hashCode + Objects.hashCode(treatMissingDataAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudWatchAlarmTemplateResponse)) {
            return false;
        }
        CreateCloudWatchAlarmTemplateResponse other = (CreateCloudWatchAlarmTemplateResponse) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(comparisonOperatorAsString(), other.comparisonOperatorAsString())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(datapointsToAlarm(), other.datapointsToAlarm())
                && Objects.equals(description(), other.description())
                && Objects.equals(evaluationPeriods(), other.evaluationPeriods()) && Objects.equals(groupId(), other.groupId())
                && Objects.equals(id(), other.id()) && Objects.equals(metricName(), other.metricName())
                && Objects.equals(modifiedAt(), other.modifiedAt()) && Objects.equals(name(), other.name())
                && Objects.equals(period(), other.period()) && Objects.equals(statisticAsString(), other.statisticAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(targetResourceTypeAsString(), other.targetResourceTypeAsString())
                && Objects.equals(threshold(), other.threshold())
                && Objects.equals(treatMissingDataAsString(), other.treatMissingDataAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCloudWatchAlarmTemplateResponse").add("Arn", arn())
                .add("ComparisonOperator", comparisonOperatorAsString()).add("CreatedAt", createdAt())
                .add("DatapointsToAlarm", datapointsToAlarm()).add("Description", description())
                .add("EvaluationPeriods", evaluationPeriods()).add("GroupId", groupId()).add("Id", id())
                .add("MetricName", metricName()).add("ModifiedAt", modifiedAt()).add("Name", name()).add("Period", period())
                .add("Statistic", statisticAsString()).add("Tags", hasTags() ? tags() : null)
                .add("TargetResourceType", targetResourceTypeAsString()).add("Threshold", threshold())
                .add("TreatMissingData", treatMissingDataAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ComparisonOperator":
            return Optional.ofNullable(clazz.cast(comparisonOperatorAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "DatapointsToAlarm":
            return Optional.ofNullable(clazz.cast(datapointsToAlarm()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EvaluationPeriods":
            return Optional.ofNullable(clazz.cast(evaluationPeriods()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "ModifiedAt":
            return Optional.ofNullable(clazz.cast(modifiedAt()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        case "Statistic":
            return Optional.ofNullable(clazz.cast(statisticAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TargetResourceType":
            return Optional.ofNullable(clazz.cast(targetResourceTypeAsString()));
        case "Threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        case "TreatMissingData":
            return Optional.ofNullable(clazz.cast(treatMissingDataAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("comparisonOperator", COMPARISON_OPERATOR_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("datapointsToAlarm", DATAPOINTS_TO_ALARM_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("evaluationPeriods", EVALUATION_PERIODS_FIELD);
        map.put("groupId", GROUP_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("metricName", METRIC_NAME_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("period", PERIOD_FIELD);
        map.put("statistic", STATISTIC_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("targetResourceType", TARGET_RESOURCE_TYPE_FIELD);
        map.put("threshold", THRESHOLD_FIELD);
        map.put("treatMissingData", TREAT_MISSING_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudWatchAlarmTemplateResponse, T> g) {
        return obj -> g.apply((CreateCloudWatchAlarmTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCloudWatchAlarmTemplateResponse> {
        /**
         * A cloudwatch alarm template's ARN (Amazon Resource Name)
         * 
         * @param arn
         *        A cloudwatch alarm template's ARN (Amazon Resource Name)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Sets the value of the ComparisonOperator property for this object.
         *
         * @param comparisonOperator
         *        The new value for the ComparisonOperator property for this object.
         * @see CloudWatchAlarmTemplateComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchAlarmTemplateComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * Sets the value of the ComparisonOperator property for this object.
         *
         * @param comparisonOperator
         *        The new value for the ComparisonOperator property for this object.
         * @see CloudWatchAlarmTemplateComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchAlarmTemplateComparisonOperator
         */
        Builder comparisonOperator(CloudWatchAlarmTemplateComparisonOperator comparisonOperator);

        /**
         * Sets the value of the CreatedAt property for this object.
         *
         * @param createdAt
         *        The new value for the CreatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * The number of datapoints within the evaluation period that must be breaching to trigger the alarm.
         * 
         * @param datapointsToAlarm
         *        The number of datapoints within the evaluation period that must be breaching to trigger the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datapointsToAlarm(Integer datapointsToAlarm);

        /**
         * A resource's optional description.
         * 
         * @param description
         *        A resource's optional description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The number of periods over which data is compared to the specified threshold.
         * 
         * @param evaluationPeriods
         *        The number of periods over which data is compared to the specified threshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationPeriods(Integer evaluationPeriods);

        /**
         * A cloudwatch alarm template group's id. AWS provided template groups have ids that start with `aws-`
         * 
         * @param groupId
         *        A cloudwatch alarm template group's id. AWS provided template groups have ids that start with `aws-`
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * A cloudwatch alarm template's id. AWS provided templates have ids that start with `aws-`
         * 
         * @param id
         *        A cloudwatch alarm template's id. AWS provided templates have ids that start with `aws-`
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The name of the metric associated with the alarm. Must be compatible with targetResourceType.
         * 
         * @param metricName
         *        The name of the metric associated with the alarm. Must be compatible with targetResourceType.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * Sets the value of the ModifiedAt property for this object.
         *
         * @param modifiedAt
         *        The new value for the ModifiedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedAt(Instant modifiedAt);

        /**
         * A resource's name. Names must be unique within the scope of a resource type in a specific region.
         * 
         * @param name
         *        A resource's name. Names must be unique within the scope of a resource type in a specific region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The period, in seconds, over which the specified statistic is applied.
         * 
         * @param period
         *        The period, in seconds, over which the specified statistic is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * Sets the value of the Statistic property for this object.
         *
         * @param statistic
         *        The new value for the Statistic property for this object.
         * @see CloudWatchAlarmTemplateStatistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchAlarmTemplateStatistic
         */
        Builder statistic(String statistic);

        /**
         * Sets the value of the Statistic property for this object.
         *
         * @param statistic
         *        The new value for the Statistic property for this object.
         * @see CloudWatchAlarmTemplateStatistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchAlarmTemplateStatistic
         */
        Builder statistic(CloudWatchAlarmTemplateStatistic statistic);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * Sets the value of the TargetResourceType property for this object.
         *
         * @param targetResourceType
         *        The new value for the TargetResourceType property for this object.
         * @see CloudWatchAlarmTemplateTargetResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchAlarmTemplateTargetResourceType
         */
        Builder targetResourceType(String targetResourceType);

        /**
         * Sets the value of the TargetResourceType property for this object.
         *
         * @param targetResourceType
         *        The new value for the TargetResourceType property for this object.
         * @see CloudWatchAlarmTemplateTargetResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchAlarmTemplateTargetResourceType
         */
        Builder targetResourceType(CloudWatchAlarmTemplateTargetResourceType targetResourceType);

        /**
         * The threshold value to compare with the specified statistic.
         * 
         * @param threshold
         *        The threshold value to compare with the specified statistic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Double threshold);

        /**
         * Sets the value of the TreatMissingData property for this object.
         *
         * @param treatMissingData
         *        The new value for the TreatMissingData property for this object.
         * @see CloudWatchAlarmTemplateTreatMissingData
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchAlarmTemplateTreatMissingData
         */
        Builder treatMissingData(String treatMissingData);

        /**
         * Sets the value of the TreatMissingData property for this object.
         *
         * @param treatMissingData
         *        The new value for the TreatMissingData property for this object.
         * @see CloudWatchAlarmTemplateTreatMissingData
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchAlarmTemplateTreatMissingData
         */
        Builder treatMissingData(CloudWatchAlarmTemplateTreatMissingData treatMissingData);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String arn;

        private String comparisonOperator;

        private Instant createdAt;

        private Integer datapointsToAlarm;

        private String description;

        private Integer evaluationPeriods;

        private String groupId;

        private String id;

        private String metricName;

        private Instant modifiedAt;

        private String name;

        private Integer period;

        private String statistic;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String targetResourceType;

        private Double threshold;

        private String treatMissingData;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudWatchAlarmTemplateResponse model) {
            super(model);
            arn(model.arn);
            comparisonOperator(model.comparisonOperator);
            createdAt(model.createdAt);
            datapointsToAlarm(model.datapointsToAlarm);
            description(model.description);
            evaluationPeriods(model.evaluationPeriods);
            groupId(model.groupId);
            id(model.id);
            metricName(model.metricName);
            modifiedAt(model.modifiedAt);
            name(model.name);
            period(model.period);
            statistic(model.statistic);
            tags(model.tags);
            targetResourceType(model.targetResourceType);
            threshold(model.threshold);
            treatMissingData(model.treatMissingData);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(CloudWatchAlarmTemplateComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Integer getDatapointsToAlarm() {
            return datapointsToAlarm;
        }

        public final void setDatapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
        }

        @Override
        public final Builder datapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getEvaluationPeriods() {
            return evaluationPeriods;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final Instant getModifiedAt() {
            return modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPeriod() {
            return period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getStatistic() {
            return statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(CloudWatchAlarmTemplateStatistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getTargetResourceType() {
            return targetResourceType;
        }

        public final void setTargetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
        }

        @Override
        public final Builder targetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
            return this;
        }

        @Override
        public final Builder targetResourceType(CloudWatchAlarmTemplateTargetResourceType targetResourceType) {
            this.targetResourceType(targetResourceType == null ? null : targetResourceType.toString());
            return this;
        }

        public final Double getThreshold() {
            return threshold;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getTreatMissingData() {
            return treatMissingData;
        }

        public final void setTreatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
        }

        @Override
        public final Builder treatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        @Override
        public final Builder treatMissingData(CloudWatchAlarmTemplateTreatMissingData treatMissingData) {
            this.treatMissingData(treatMissingData == null ? null : treatMissingData.toString());
            return this;
        }

        @Override
        public CreateCloudWatchAlarmTemplateResponse build() {
            return new CreateCloudWatchAlarmTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
