/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for DeleteChannelResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteChannelResponse extends MediaLiveResponse implements
        ToCopyableBuilder<DeleteChannelResponse.Builder, DeleteChannelResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DeleteChannelResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<CdiInputSpecification> CDI_INPUT_SPECIFICATION_FIELD = SdkField
            .<CdiInputSpecification> builder(MarshallingType.SDK_POJO).memberName("CdiInputSpecification")
            .getter(getter(DeleteChannelResponse::cdiInputSpecification)).setter(setter(Builder::cdiInputSpecification))
            .constructor(CdiInputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cdiInputSpecification").build())
            .build();

    private static final SdkField<String> CHANNEL_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelClass").getter(getter(DeleteChannelResponse::channelClassAsString))
            .setter(setter(Builder::channelClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelClass").build()).build();

    private static final SdkField<List<OutputDestination>> DESTINATIONS_FIELD = SdkField
            .<List<OutputDestination>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(DeleteChannelResponse::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputDestination> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputDestination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ChannelEgressEndpoint>> EGRESS_ENDPOINTS_FIELD = SdkField
            .<List<ChannelEgressEndpoint>> builder(MarshallingType.LIST)
            .memberName("EgressEndpoints")
            .getter(getter(DeleteChannelResponse::egressEndpoints))
            .setter(setter(Builder::egressEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChannelEgressEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChannelEgressEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EncoderSettings> ENCODER_SETTINGS_FIELD = SdkField
            .<EncoderSettings> builder(MarshallingType.SDK_POJO).memberName("EncoderSettings")
            .getter(getter(DeleteChannelResponse::encoderSettings)).setter(setter(Builder::encoderSettings))
            .constructor(EncoderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoderSettings").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DeleteChannelResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<List<InputAttachment>> INPUT_ATTACHMENTS_FIELD = SdkField
            .<List<InputAttachment>> builder(MarshallingType.LIST)
            .memberName("InputAttachments")
            .getter(getter(DeleteChannelResponse::inputAttachments))
            .setter(setter(Builder::inputAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InputSpecification> INPUT_SPECIFICATION_FIELD = SdkField
            .<InputSpecification> builder(MarshallingType.SDK_POJO).memberName("InputSpecification")
            .getter(getter(DeleteChannelResponse::inputSpecification)).setter(setter(Builder::inputSpecification))
            .constructor(InputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSpecification").build())
            .build();

    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogLevel").getter(getter(DeleteChannelResponse::logLevelAsString)).setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()).build();

    private static final SdkField<MaintenanceStatus> MAINTENANCE_FIELD = SdkField
            .<MaintenanceStatus> builder(MarshallingType.SDK_POJO).memberName("Maintenance")
            .getter(getter(DeleteChannelResponse::maintenance)).setter(setter(Builder::maintenance))
            .constructor(MaintenanceStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenance").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DeleteChannelResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<PipelineDetail>> PIPELINE_DETAILS_FIELD = SdkField
            .<List<PipelineDetail>> builder(MarshallingType.LIST)
            .memberName("PipelineDetails")
            .getter(getter(DeleteChannelResponse::pipelineDetails))
            .setter(setter(Builder::pipelineDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PipelineDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(PipelineDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> PIPELINES_RUNNING_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PipelinesRunningCount").getter(getter(DeleteChannelResponse::pipelinesRunningCount))
            .setter(setter(Builder::pipelinesRunningCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelinesRunningCount").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DeleteChannelResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DeleteChannelResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DeleteChannelResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<VpcOutputSettingsDescription> VPC_FIELD = SdkField
            .<VpcOutputSettingsDescription> builder(MarshallingType.SDK_POJO).memberName("Vpc")
            .getter(getter(DeleteChannelResponse::vpc)).setter(setter(Builder::vpc))
            .constructor(VpcOutputSettingsDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()).build();

    private static final SdkField<DescribeAnywhereSettings> ANYWHERE_SETTINGS_FIELD = SdkField
            .<DescribeAnywhereSettings> builder(MarshallingType.SDK_POJO).memberName("AnywhereSettings")
            .getter(getter(DeleteChannelResponse::anywhereSettings)).setter(setter(Builder::anywhereSettings))
            .constructor(DescribeAnywhereSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anywhereSettings").build()).build();

    private static final SdkField<ChannelEngineVersionResponse> CHANNEL_ENGINE_VERSION_FIELD = SdkField
            .<ChannelEngineVersionResponse> builder(MarshallingType.SDK_POJO).memberName("ChannelEngineVersion")
            .getter(getter(DeleteChannelResponse::channelEngineVersion)).setter(setter(Builder::channelEngineVersion))
            .constructor(ChannelEngineVersionResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelEngineVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CDI_INPUT_SPECIFICATION_FIELD, CHANNEL_CLASS_FIELD, DESTINATIONS_FIELD, EGRESS_ENDPOINTS_FIELD,
            ENCODER_SETTINGS_FIELD, ID_FIELD, INPUT_ATTACHMENTS_FIELD, INPUT_SPECIFICATION_FIELD, LOG_LEVEL_FIELD,
            MAINTENANCE_FIELD, NAME_FIELD, PIPELINE_DETAILS_FIELD, PIPELINES_RUNNING_COUNT_FIELD, ROLE_ARN_FIELD, STATE_FIELD,
            TAGS_FIELD, VPC_FIELD, ANYWHERE_SETTINGS_FIELD, CHANNEL_ENGINE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final CdiInputSpecification cdiInputSpecification;

    private final String channelClass;

    private final List<OutputDestination> destinations;

    private final List<ChannelEgressEndpoint> egressEndpoints;

    private final EncoderSettings encoderSettings;

    private final String id;

    private final List<InputAttachment> inputAttachments;

    private final InputSpecification inputSpecification;

    private final String logLevel;

    private final MaintenanceStatus maintenance;

    private final String name;

    private final List<PipelineDetail> pipelineDetails;

    private final Integer pipelinesRunningCount;

    private final String roleArn;

    private final String state;

    private final Map<String, String> tags;

    private final VpcOutputSettingsDescription vpc;

    private final DescribeAnywhereSettings anywhereSettings;

    private final ChannelEngineVersionResponse channelEngineVersion;

    private DeleteChannelResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.cdiInputSpecification = builder.cdiInputSpecification;
        this.channelClass = builder.channelClass;
        this.destinations = builder.destinations;
        this.egressEndpoints = builder.egressEndpoints;
        this.encoderSettings = builder.encoderSettings;
        this.id = builder.id;
        this.inputAttachments = builder.inputAttachments;
        this.inputSpecification = builder.inputSpecification;
        this.logLevel = builder.logLevel;
        this.maintenance = builder.maintenance;
        this.name = builder.name;
        this.pipelineDetails = builder.pipelineDetails;
        this.pipelinesRunningCount = builder.pipelinesRunningCount;
        this.roleArn = builder.roleArn;
        this.state = builder.state;
        this.tags = builder.tags;
        this.vpc = builder.vpc;
        this.anywhereSettings = builder.anywhereSettings;
        this.channelEngineVersion = builder.channelEngineVersion;
    }

    /**
     * The unique arn of the channel.
     * 
     * @return The unique arn of the channel.
     */
    public final String arn() {
        return arn;
    }

    /**
     * Specification of CDI inputs for this channel
     * 
     * @return Specification of CDI inputs for this channel
     */
    public final CdiInputSpecification cdiInputSpecification() {
        return cdiInputSpecification;
    }

    /**
     * The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one
     * pipeline.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelClass} will
     * return {@link ChannelClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelClassAsString}.
     * </p>
     * 
     * @return The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel
     *         with one pipeline.
     * @see ChannelClass
     */
    public final ChannelClass channelClass() {
        return ChannelClass.fromValue(channelClass);
    }

    /**
     * The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one
     * pipeline.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelClass} will
     * return {@link ChannelClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelClassAsString}.
     * </p>
     * 
     * @return The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel
     *         with one pipeline.
     * @see ChannelClass
     */
    public final String channelClassAsString() {
        return channelClass;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * A list of destinations of the channel. For UDP outputs, there is one destination per output. For other types
     * (HLS, for example), there is one destination per packager.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return A list of destinations of the channel. For UDP outputs, there is one destination per output. For other
     *         types (HLS, for example), there is one destination per packager.
     */
    public final List<OutputDestination> destinations() {
        return destinations;
    }

    /**
     * For responses, this returns true if the service returned a value for the EgressEndpoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEgressEndpoints() {
        return egressEndpoints != null && !(egressEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * The endpoints where outgoing connections initiate from
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEgressEndpoints} method.
     * </p>
     * 
     * @return The endpoints where outgoing connections initiate from
     */
    public final List<ChannelEgressEndpoint> egressEndpoints() {
        return egressEndpoints;
    }

    /**
     * Returns the value of the EncoderSettings property for this object.
     * 
     * @return The value of the EncoderSettings property for this object.
     */
    public final EncoderSettings encoderSettings() {
        return encoderSettings;
    }

    /**
     * The unique id of the channel.
     * 
     * @return The unique id of the channel.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputAttachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputAttachments() {
        return inputAttachments != null && !(inputAttachments instanceof SdkAutoConstructList);
    }

    /**
     * List of input attachments for channel.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputAttachments} method.
     * </p>
     * 
     * @return List of input attachments for channel.
     */
    public final List<InputAttachment> inputAttachments() {
        return inputAttachments;
    }

    /**
     * Specification of network and file inputs for this channel
     * 
     * @return Specification of network and file inputs for this channel
     */
    public final InputSpecification inputSpecification() {
        return inputSpecification;
    }

    /**
     * The log level being written to CloudWatch Logs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The log level being written to CloudWatch Logs.
     * @see LogLevel
     */
    public final LogLevel logLevel() {
        return LogLevel.fromValue(logLevel);
    }

    /**
     * The log level being written to CloudWatch Logs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return The log level being written to CloudWatch Logs.
     * @see LogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    /**
     * Maintenance settings for this channel.
     * 
     * @return Maintenance settings for this channel.
     */
    public final MaintenanceStatus maintenance() {
        return maintenance;
    }

    /**
     * The name of the channel. (user-mutable)
     * 
     * @return The name of the channel. (user-mutable)
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the PipelineDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPipelineDetails() {
        return pipelineDetails != null && !(pipelineDetails instanceof SdkAutoConstructList);
    }

    /**
     * Runtime details for the pipelines of a running channel.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPipelineDetails} method.
     * </p>
     * 
     * @return Runtime details for the pipelines of a running channel.
     */
    public final List<PipelineDetail> pipelineDetails() {
        return pipelineDetails;
    }

    /**
     * The number of currently healthy pipelines.
     * 
     * @return The number of currently healthy pipelines.
     */
    public final Integer pipelinesRunningCount() {
        return pipelinesRunningCount;
    }

    /**
     * The Amazon Resource Name (ARN) of the role assumed when running the Channel.
     * 
     * @return The Amazon Resource Name (ARN) of the role assumed when running the Channel.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ChannelState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see ChannelState
     */
    public final ChannelState state() {
        return ChannelState.fromValue(state);
    }

    /**
     * Returns the value of the State property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ChannelState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The value of the State property for this object.
     * @see ChannelState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * A collection of key-value pairs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A collection of key-value pairs.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * Settings for VPC output
     * 
     * @return Settings for VPC output
     */
    public final VpcOutputSettingsDescription vpc() {
        return vpc;
    }

    /**
     * Anywhere settings for this channel.
     * 
     * @return Anywhere settings for this channel.
     */
    public final DescribeAnywhereSettings anywhereSettings() {
        return anywhereSettings;
    }

    /**
     * Requested engine version for this channel.
     * 
     * @return Requested engine version for this channel.
     */
    public final ChannelEngineVersionResponse channelEngineVersion() {
        return channelEngineVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(cdiInputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(channelClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEgressEndpoints() ? egressEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encoderSettings());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputAttachments() ? inputAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maintenance());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelineDetails() ? pipelineDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pipelinesRunningCount());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        hashCode = 31 * hashCode + Objects.hashCode(anywhereSettings());
        hashCode = 31 * hashCode + Objects.hashCode(channelEngineVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteChannelResponse)) {
            return false;
        }
        DeleteChannelResponse other = (DeleteChannelResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(cdiInputSpecification(), other.cdiInputSpecification())
                && Objects.equals(channelClassAsString(), other.channelClassAsString())
                && hasDestinations() == other.hasDestinations() && Objects.equals(destinations(), other.destinations())
                && hasEgressEndpoints() == other.hasEgressEndpoints()
                && Objects.equals(egressEndpoints(), other.egressEndpoints())
                && Objects.equals(encoderSettings(), other.encoderSettings()) && Objects.equals(id(), other.id())
                && hasInputAttachments() == other.hasInputAttachments()
                && Objects.equals(inputAttachments(), other.inputAttachments())
                && Objects.equals(inputSpecification(), other.inputSpecification())
                && Objects.equals(logLevelAsString(), other.logLevelAsString())
                && Objects.equals(maintenance(), other.maintenance()) && Objects.equals(name(), other.name())
                && hasPipelineDetails() == other.hasPipelineDetails()
                && Objects.equals(pipelineDetails(), other.pipelineDetails())
                && Objects.equals(pipelinesRunningCount(), other.pipelinesRunningCount())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(stateAsString(), other.stateAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && Objects.equals(vpc(), other.vpc())
                && Objects.equals(anywhereSettings(), other.anywhereSettings())
                && Objects.equals(channelEngineVersion(), other.channelEngineVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteChannelResponse").add("Arn", arn()).add("CdiInputSpecification", cdiInputSpecification())
                .add("ChannelClass", channelClassAsString()).add("Destinations", hasDestinations() ? destinations() : null)
                .add("EgressEndpoints", hasEgressEndpoints() ? egressEndpoints() : null)
                .add("EncoderSettings", encoderSettings()).add("Id", id())
                .add("InputAttachments", hasInputAttachments() ? inputAttachments() : null)
                .add("InputSpecification", inputSpecification()).add("LogLevel", logLevelAsString())
                .add("Maintenance", maintenance()).add("Name", name())
                .add("PipelineDetails", hasPipelineDetails() ? pipelineDetails() : null)
                .add("PipelinesRunningCount", pipelinesRunningCount()).add("RoleArn", roleArn()).add("State", stateAsString())
                .add("Tags", hasTags() ? tags() : null).add("Vpc", vpc()).add("AnywhereSettings", anywhereSettings())
                .add("ChannelEngineVersion", channelEngineVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CdiInputSpecification":
            return Optional.ofNullable(clazz.cast(cdiInputSpecification()));
        case "ChannelClass":
            return Optional.ofNullable(clazz.cast(channelClassAsString()));
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "EgressEndpoints":
            return Optional.ofNullable(clazz.cast(egressEndpoints()));
        case "EncoderSettings":
            return Optional.ofNullable(clazz.cast(encoderSettings()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "InputAttachments":
            return Optional.ofNullable(clazz.cast(inputAttachments()));
        case "InputSpecification":
            return Optional.ofNullable(clazz.cast(inputSpecification()));
        case "LogLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        case "Maintenance":
            return Optional.ofNullable(clazz.cast(maintenance()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PipelineDetails":
            return Optional.ofNullable(clazz.cast(pipelineDetails()));
        case "PipelinesRunningCount":
            return Optional.ofNullable(clazz.cast(pipelinesRunningCount()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        case "AnywhereSettings":
            return Optional.ofNullable(clazz.cast(anywhereSettings()));
        case "ChannelEngineVersion":
            return Optional.ofNullable(clazz.cast(channelEngineVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("cdiInputSpecification", CDI_INPUT_SPECIFICATION_FIELD);
        map.put("channelClass", CHANNEL_CLASS_FIELD);
        map.put("destinations", DESTINATIONS_FIELD);
        map.put("egressEndpoints", EGRESS_ENDPOINTS_FIELD);
        map.put("encoderSettings", ENCODER_SETTINGS_FIELD);
        map.put("id", ID_FIELD);
        map.put("inputAttachments", INPUT_ATTACHMENTS_FIELD);
        map.put("inputSpecification", INPUT_SPECIFICATION_FIELD);
        map.put("logLevel", LOG_LEVEL_FIELD);
        map.put("maintenance", MAINTENANCE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("pipelineDetails", PIPELINE_DETAILS_FIELD);
        map.put("pipelinesRunningCount", PIPELINES_RUNNING_COUNT_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("state", STATE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("vpc", VPC_FIELD);
        map.put("anywhereSettings", ANYWHERE_SETTINGS_FIELD);
        map.put("channelEngineVersion", CHANNEL_ENGINE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteChannelResponse, T> g) {
        return obj -> g.apply((DeleteChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteChannelResponse> {
        /**
         * The unique arn of the channel.
         * 
         * @param arn
         *        The unique arn of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Specification of CDI inputs for this channel
         * 
         * @param cdiInputSpecification
         *        Specification of CDI inputs for this channel
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdiInputSpecification(CdiInputSpecification cdiInputSpecification);

        /**
         * Specification of CDI inputs for this channel This is a convenience method that creates an instance of the
         * {@link CdiInputSpecification.Builder} avoiding the need to create one manually via
         * {@link CdiInputSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CdiInputSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #cdiInputSpecification(CdiInputSpecification)}.
         * 
         * @param cdiInputSpecification
         *        a consumer that will call methods on {@link CdiInputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cdiInputSpecification(CdiInputSpecification)
         */
        default Builder cdiInputSpecification(Consumer<CdiInputSpecification.Builder> cdiInputSpecification) {
            return cdiInputSpecification(CdiInputSpecification.builder().applyMutation(cdiInputSpecification).build());
        }

        /**
         * The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with
         * one pipeline.
         * 
         * @param channelClass
         *        The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel
         *        with one pipeline.
         * @see ChannelClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelClass
         */
        Builder channelClass(String channelClass);

        /**
         * The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with
         * one pipeline.
         * 
         * @param channelClass
         *        The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel
         *        with one pipeline.
         * @see ChannelClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelClass
         */
        Builder channelClass(ChannelClass channelClass);

        /**
         * A list of destinations of the channel. For UDP outputs, there is one destination per output. For other types
         * (HLS, for example), there is one destination per packager.
         * 
         * @param destinations
         *        A list of destinations of the channel. For UDP outputs, there is one destination per output. For other
         *        types (HLS, for example), there is one destination per packager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<OutputDestination> destinations);

        /**
         * A list of destinations of the channel. For UDP outputs, there is one destination per output. For other types
         * (HLS, for example), there is one destination per packager.
         * 
         * @param destinations
         *        A list of destinations of the channel. For UDP outputs, there is one destination per output. For other
         *        types (HLS, for example), there is one destination per packager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(OutputDestination... destinations);

        /**
         * A list of destinations of the channel. For UDP outputs, there is one destination per output. For other types
         * (HLS, for example), there is one destination per packager. This is a convenience method that creates an
         * instance of the {@link software.amazon.awssdk.services.medialive.model.OutputDestination.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.OutputDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.OutputDestination.Builder#build()} is called
         * immediately and its result is passed to {@link #destinations(List<OutputDestination>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.OutputDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(java.util.Collection<OutputDestination>)
         */
        Builder destinations(Consumer<OutputDestination.Builder>... destinations);

        /**
         * The endpoints where outgoing connections initiate from
         * 
         * @param egressEndpoints
         *        The endpoints where outgoing connections initiate from
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressEndpoints(Collection<ChannelEgressEndpoint> egressEndpoints);

        /**
         * The endpoints where outgoing connections initiate from
         * 
         * @param egressEndpoints
         *        The endpoints where outgoing connections initiate from
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressEndpoints(ChannelEgressEndpoint... egressEndpoints);

        /**
         * The endpoints where outgoing connections initiate from This is a convenience method that creates an instance
         * of the {@link software.amazon.awssdk.services.medialive.model.ChannelEgressEndpoint.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.ChannelEgressEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.ChannelEgressEndpoint.Builder#build()} is called
         * immediately and its result is passed to {@link #egressEndpoints(List<ChannelEgressEndpoint>)}.
         * 
         * @param egressEndpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.ChannelEgressEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressEndpoints(java.util.Collection<ChannelEgressEndpoint>)
         */
        Builder egressEndpoints(Consumer<ChannelEgressEndpoint.Builder>... egressEndpoints);

        /**
         * Sets the value of the EncoderSettings property for this object.
         *
         * @param encoderSettings
         *        The new value for the EncoderSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encoderSettings(EncoderSettings encoderSettings);

        /**
         * Sets the value of the EncoderSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EncoderSettings.Builder} avoiding the
         * need to create one manually via {@link EncoderSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncoderSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #encoderSettings(EncoderSettings)}.
         * 
         * @param encoderSettings
         *        a consumer that will call methods on {@link EncoderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encoderSettings(EncoderSettings)
         */
        default Builder encoderSettings(Consumer<EncoderSettings.Builder> encoderSettings) {
            return encoderSettings(EncoderSettings.builder().applyMutation(encoderSettings).build());
        }

        /**
         * The unique id of the channel.
         * 
         * @param id
         *        The unique id of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * List of input attachments for channel.
         * 
         * @param inputAttachments
         *        List of input attachments for channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAttachments(Collection<InputAttachment> inputAttachments);

        /**
         * List of input attachments for channel.
         * 
         * @param inputAttachments
         *        List of input attachments for channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputAttachments(InputAttachment... inputAttachments);

        /**
         * List of input attachments for channel. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.InputAttachment.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.medialive.model.InputAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.InputAttachment.Builder#build()} is called immediately
         * and its result is passed to {@link #inputAttachments(List<InputAttachment>)}.
         * 
         * @param inputAttachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.InputAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputAttachments(java.util.Collection<InputAttachment>)
         */
        Builder inputAttachments(Consumer<InputAttachment.Builder>... inputAttachments);

        /**
         * Specification of network and file inputs for this channel
         * 
         * @param inputSpecification
         *        Specification of network and file inputs for this channel
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSpecification(InputSpecification inputSpecification);

        /**
         * Specification of network and file inputs for this channel This is a convenience method that creates an
         * instance of the {@link InputSpecification.Builder} avoiding the need to create one manually via
         * {@link InputSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputSpecification.Builder#build()} is called immediately and its
         * result is passed to {@link #inputSpecification(InputSpecification)}.
         * 
         * @param inputSpecification
         *        a consumer that will call methods on {@link InputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputSpecification(InputSpecification)
         */
        default Builder inputSpecification(Consumer<InputSpecification.Builder> inputSpecification) {
            return inputSpecification(InputSpecification.builder().applyMutation(inputSpecification).build());
        }

        /**
         * The log level being written to CloudWatch Logs.
         * 
         * @param logLevel
         *        The log level being written to CloudWatch Logs.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * The log level being written to CloudWatch Logs.
         * 
         * @param logLevel
         *        The log level being written to CloudWatch Logs.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(LogLevel logLevel);

        /**
         * Maintenance settings for this channel.
         * 
         * @param maintenance
         *        Maintenance settings for this channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenance(MaintenanceStatus maintenance);

        /**
         * Maintenance settings for this channel. This is a convenience method that creates an instance of the
         * {@link MaintenanceStatus.Builder} avoiding the need to create one manually via
         * {@link MaintenanceStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaintenanceStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #maintenance(MaintenanceStatus)}.
         * 
         * @param maintenance
         *        a consumer that will call methods on {@link MaintenanceStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenance(MaintenanceStatus)
         */
        default Builder maintenance(Consumer<MaintenanceStatus.Builder> maintenance) {
            return maintenance(MaintenanceStatus.builder().applyMutation(maintenance).build());
        }

        /**
         * The name of the channel. (user-mutable)
         * 
         * @param name
         *        The name of the channel. (user-mutable)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Runtime details for the pipelines of a running channel.
         * 
         * @param pipelineDetails
         *        Runtime details for the pipelines of a running channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDetails(Collection<PipelineDetail> pipelineDetails);

        /**
         * Runtime details for the pipelines of a running channel.
         * 
         * @param pipelineDetails
         *        Runtime details for the pipelines of a running channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDetails(PipelineDetail... pipelineDetails);

        /**
         * Runtime details for the pipelines of a running channel. This is a convenience method that creates an instance
         * of the {@link software.amazon.awssdk.services.medialive.model.PipelineDetail.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.medialive.model.PipelineDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.PipelineDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #pipelineDetails(List<PipelineDetail>)}.
         * 
         * @param pipelineDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.PipelineDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineDetails(java.util.Collection<PipelineDetail>)
         */
        Builder pipelineDetails(Consumer<PipelineDetail.Builder>... pipelineDetails);

        /**
         * The number of currently healthy pipelines.
         * 
         * @param pipelinesRunningCount
         *        The number of currently healthy pipelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelinesRunningCount(Integer pipelinesRunningCount);

        /**
         * The Amazon Resource Name (ARN) of the role assumed when running the Channel.
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role assumed when running the Channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see ChannelState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelState
         */
        Builder state(String state);

        /**
         * Sets the value of the State property for this object.
         *
         * @param state
         *        The new value for the State property for this object.
         * @see ChannelState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelState
         */
        Builder state(ChannelState state);

        /**
         * A collection of key-value pairs.
         * 
         * @param tags
         *        A collection of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * Settings for VPC output
         * 
         * @param vpc
         *        Settings for VPC output
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(VpcOutputSettingsDescription vpc);

        /**
         * Settings for VPC output This is a convenience method that creates an instance of the
         * {@link VpcOutputSettingsDescription.Builder} avoiding the need to create one manually via
         * {@link VpcOutputSettingsDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcOutputSettingsDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #vpc(VpcOutputSettingsDescription)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link VpcOutputSettingsDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(VpcOutputSettingsDescription)
         */
        default Builder vpc(Consumer<VpcOutputSettingsDescription.Builder> vpc) {
            return vpc(VpcOutputSettingsDescription.builder().applyMutation(vpc).build());
        }

        /**
         * Anywhere settings for this channel.
         * 
         * @param anywhereSettings
         *        Anywhere settings for this channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anywhereSettings(DescribeAnywhereSettings anywhereSettings);

        /**
         * Anywhere settings for this channel. This is a convenience method that creates an instance of the
         * {@link DescribeAnywhereSettings.Builder} avoiding the need to create one manually via
         * {@link DescribeAnywhereSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DescribeAnywhereSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #anywhereSettings(DescribeAnywhereSettings)}.
         * 
         * @param anywhereSettings
         *        a consumer that will call methods on {@link DescribeAnywhereSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anywhereSettings(DescribeAnywhereSettings)
         */
        default Builder anywhereSettings(Consumer<DescribeAnywhereSettings.Builder> anywhereSettings) {
            return anywhereSettings(DescribeAnywhereSettings.builder().applyMutation(anywhereSettings).build());
        }

        /**
         * Requested engine version for this channel.
         * 
         * @param channelEngineVersion
         *        Requested engine version for this channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelEngineVersion(ChannelEngineVersionResponse channelEngineVersion);

        /**
         * Requested engine version for this channel. This is a convenience method that creates an instance of the
         * {@link ChannelEngineVersionResponse.Builder} avoiding the need to create one manually via
         * {@link ChannelEngineVersionResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChannelEngineVersionResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #channelEngineVersion(ChannelEngineVersionResponse)}.
         * 
         * @param channelEngineVersion
         *        a consumer that will call methods on {@link ChannelEngineVersionResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelEngineVersion(ChannelEngineVersionResponse)
         */
        default Builder channelEngineVersion(Consumer<ChannelEngineVersionResponse.Builder> channelEngineVersion) {
            return channelEngineVersion(ChannelEngineVersionResponse.builder().applyMutation(channelEngineVersion).build());
        }
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String arn;

        private CdiInputSpecification cdiInputSpecification;

        private String channelClass;

        private List<OutputDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private List<ChannelEgressEndpoint> egressEndpoints = DefaultSdkAutoConstructList.getInstance();

        private EncoderSettings encoderSettings;

        private String id;

        private List<InputAttachment> inputAttachments = DefaultSdkAutoConstructList.getInstance();

        private InputSpecification inputSpecification;

        private String logLevel;

        private MaintenanceStatus maintenance;

        private String name;

        private List<PipelineDetail> pipelineDetails = DefaultSdkAutoConstructList.getInstance();

        private Integer pipelinesRunningCount;

        private String roleArn;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private VpcOutputSettingsDescription vpc;

        private DescribeAnywhereSettings anywhereSettings;

        private ChannelEngineVersionResponse channelEngineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteChannelResponse model) {
            super(model);
            arn(model.arn);
            cdiInputSpecification(model.cdiInputSpecification);
            channelClass(model.channelClass);
            destinations(model.destinations);
            egressEndpoints(model.egressEndpoints);
            encoderSettings(model.encoderSettings);
            id(model.id);
            inputAttachments(model.inputAttachments);
            inputSpecification(model.inputSpecification);
            logLevel(model.logLevel);
            maintenance(model.maintenance);
            name(model.name);
            pipelineDetails(model.pipelineDetails);
            pipelinesRunningCount(model.pipelinesRunningCount);
            roleArn(model.roleArn);
            state(model.state);
            tags(model.tags);
            vpc(model.vpc);
            anywhereSettings(model.anywhereSettings);
            channelEngineVersion(model.channelEngineVersion);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final CdiInputSpecification.Builder getCdiInputSpecification() {
            return cdiInputSpecification != null ? cdiInputSpecification.toBuilder() : null;
        }

        public final void setCdiInputSpecification(CdiInputSpecification.BuilderImpl cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification != null ? cdiInputSpecification.build() : null;
        }

        @Override
        public final Builder cdiInputSpecification(CdiInputSpecification cdiInputSpecification) {
            this.cdiInputSpecification = cdiInputSpecification;
            return this;
        }

        public final String getChannelClass() {
            return channelClass;
        }

        public final void setChannelClass(String channelClass) {
            this.channelClass = channelClass;
        }

        @Override
        public final Builder channelClass(String channelClass) {
            this.channelClass = channelClass;
            return this;
        }

        @Override
        public final Builder channelClass(ChannelClass channelClass) {
            this.channelClass(channelClass == null ? null : channelClass.toString());
            return this;
        }

        public final List<OutputDestination.Builder> getDestinations() {
            List<OutputDestination.Builder> result = ___listOfOutputDestinationCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<OutputDestination.BuilderImpl> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<OutputDestination> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(OutputDestination... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<OutputDestination.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> OutputDestination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ChannelEgressEndpoint.Builder> getEgressEndpoints() {
            List<ChannelEgressEndpoint.Builder> result = ___listOfChannelEgressEndpointCopier.copyToBuilder(this.egressEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEgressEndpoints(Collection<ChannelEgressEndpoint.BuilderImpl> egressEndpoints) {
            this.egressEndpoints = ___listOfChannelEgressEndpointCopier.copyFromBuilder(egressEndpoints);
        }

        @Override
        public final Builder egressEndpoints(Collection<ChannelEgressEndpoint> egressEndpoints) {
            this.egressEndpoints = ___listOfChannelEgressEndpointCopier.copy(egressEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressEndpoints(ChannelEgressEndpoint... egressEndpoints) {
            egressEndpoints(Arrays.asList(egressEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressEndpoints(Consumer<ChannelEgressEndpoint.Builder>... egressEndpoints) {
            egressEndpoints(Stream.of(egressEndpoints).map(c -> ChannelEgressEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final EncoderSettings.Builder getEncoderSettings() {
            return encoderSettings != null ? encoderSettings.toBuilder() : null;
        }

        public final void setEncoderSettings(EncoderSettings.BuilderImpl encoderSettings) {
            this.encoderSettings = encoderSettings != null ? encoderSettings.build() : null;
        }

        @Override
        public final Builder encoderSettings(EncoderSettings encoderSettings) {
            this.encoderSettings = encoderSettings;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<InputAttachment.Builder> getInputAttachments() {
            List<InputAttachment.Builder> result = ___listOfInputAttachmentCopier.copyToBuilder(this.inputAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputAttachments(Collection<InputAttachment.BuilderImpl> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copyFromBuilder(inputAttachments);
        }

        @Override
        public final Builder inputAttachments(Collection<InputAttachment> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copy(inputAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(InputAttachment... inputAttachments) {
            inputAttachments(Arrays.asList(inputAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(Consumer<InputAttachment.Builder>... inputAttachments) {
            inputAttachments(Stream.of(inputAttachments).map(c -> InputAttachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InputSpecification.Builder getInputSpecification() {
            return inputSpecification != null ? inputSpecification.toBuilder() : null;
        }

        public final void setInputSpecification(InputSpecification.BuilderImpl inputSpecification) {
            this.inputSpecification = inputSpecification != null ? inputSpecification.build() : null;
        }

        @Override
        public final Builder inputSpecification(InputSpecification inputSpecification) {
            this.inputSpecification = inputSpecification;
            return this;
        }

        public final String getLogLevel() {
            return logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final MaintenanceStatus.Builder getMaintenance() {
            return maintenance != null ? maintenance.toBuilder() : null;
        }

        public final void setMaintenance(MaintenanceStatus.BuilderImpl maintenance) {
            this.maintenance = maintenance != null ? maintenance.build() : null;
        }

        @Override
        public final Builder maintenance(MaintenanceStatus maintenance) {
            this.maintenance = maintenance;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<PipelineDetail.Builder> getPipelineDetails() {
            List<PipelineDetail.Builder> result = ___listOfPipelineDetailCopier.copyToBuilder(this.pipelineDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineDetails(Collection<PipelineDetail.BuilderImpl> pipelineDetails) {
            this.pipelineDetails = ___listOfPipelineDetailCopier.copyFromBuilder(pipelineDetails);
        }

        @Override
        public final Builder pipelineDetails(Collection<PipelineDetail> pipelineDetails) {
            this.pipelineDetails = ___listOfPipelineDetailCopier.copy(pipelineDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineDetails(PipelineDetail... pipelineDetails) {
            pipelineDetails(Arrays.asList(pipelineDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineDetails(Consumer<PipelineDetail.Builder>... pipelineDetails) {
            pipelineDetails(Stream.of(pipelineDetails).map(c -> PipelineDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getPipelinesRunningCount() {
            return pipelinesRunningCount;
        }

        public final void setPipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
        }

        @Override
        public final Builder pipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ChannelState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final VpcOutputSettingsDescription.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        public final void setVpc(VpcOutputSettingsDescription.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(VpcOutputSettingsDescription vpc) {
            this.vpc = vpc;
            return this;
        }

        public final DescribeAnywhereSettings.Builder getAnywhereSettings() {
            return anywhereSettings != null ? anywhereSettings.toBuilder() : null;
        }

        public final void setAnywhereSettings(DescribeAnywhereSettings.BuilderImpl anywhereSettings) {
            this.anywhereSettings = anywhereSettings != null ? anywhereSettings.build() : null;
        }

        @Override
        public final Builder anywhereSettings(DescribeAnywhereSettings anywhereSettings) {
            this.anywhereSettings = anywhereSettings;
            return this;
        }

        public final ChannelEngineVersionResponse.Builder getChannelEngineVersion() {
            return channelEngineVersion != null ? channelEngineVersion.toBuilder() : null;
        }

        public final void setChannelEngineVersion(ChannelEngineVersionResponse.BuilderImpl channelEngineVersion) {
            this.channelEngineVersion = channelEngineVersion != null ? channelEngineVersion.build() : null;
        }

        @Override
        public final Builder channelEngineVersion(ChannelEngineVersionResponse channelEngineVersion) {
            this.channelEngineVersion = channelEngineVersion;
            return this;
        }

        @Override
        public DeleteChannelResponse build() {
            return new DeleteChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
