/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Elemental anywhere settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAnywhereSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribeAnywhereSettings.Builder, DescribeAnywhereSettings> {
    private static final SdkField<String> CHANNEL_PLACEMENT_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelPlacementGroupId").getter(getter(DescribeAnywhereSettings::channelPlacementGroupId))
            .setter(setter(Builder::channelPlacementGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelPlacementGroupId").build())
            .build();

    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(DescribeAnywhereSettings::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CHANNEL_PLACEMENT_GROUP_ID_FIELD, CLUSTER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String channelPlacementGroupId;

    private final String clusterId;

    private DescribeAnywhereSettings(BuilderImpl builder) {
        this.channelPlacementGroupId = builder.channelPlacementGroupId;
        this.clusterId = builder.clusterId;
    }

    /**
     * The ID of the channel placement group for the channel.
     * 
     * @return The ID of the channel placement group for the channel.
     */
    public final String channelPlacementGroupId() {
        return channelPlacementGroupId;
    }

    /**
     * The ID of the cluster for the channel.
     * 
     * @return The ID of the cluster for the channel.
     */
    public final String clusterId() {
        return clusterId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelPlacementGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnywhereSettings)) {
            return false;
        }
        DescribeAnywhereSettings other = (DescribeAnywhereSettings) obj;
        return Objects.equals(channelPlacementGroupId(), other.channelPlacementGroupId())
                && Objects.equals(clusterId(), other.clusterId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAnywhereSettings").add("ChannelPlacementGroupId", channelPlacementGroupId())
                .add("ClusterId", clusterId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelPlacementGroupId":
            return Optional.ofNullable(clazz.cast(channelPlacementGroupId()));
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channelPlacementGroupId", CHANNEL_PLACEMENT_GROUP_ID_FIELD);
        map.put("clusterId", CLUSTER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnywhereSettings, T> g) {
        return obj -> g.apply((DescribeAnywhereSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribeAnywhereSettings> {
        /**
         * The ID of the channel placement group for the channel.
         * 
         * @param channelPlacementGroupId
         *        The ID of the channel placement group for the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelPlacementGroupId(String channelPlacementGroupId);

        /**
         * The ID of the cluster for the channel.
         * 
         * @param clusterId
         *        The ID of the cluster for the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);
    }

    static final class BuilderImpl implements Builder {
        private String channelPlacementGroupId;

        private String clusterId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnywhereSettings model) {
            channelPlacementGroupId(model.channelPlacementGroupId);
            clusterId(model.clusterId);
        }

        public final String getChannelPlacementGroupId() {
            return channelPlacementGroupId;
        }

        public final void setChannelPlacementGroupId(String channelPlacementGroupId) {
            this.channelPlacementGroupId = channelPlacementGroupId;
        }

        @Override
        public final Builder channelPlacementGroupId(String channelPlacementGroupId) {
            this.channelPlacementGroupId = channelPlacementGroupId;
            return this;
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public DescribeAnywhereSettings build() {
            return new DescribeAnywhereSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
