/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for DescribeInputDeviceThumbnailResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInputDeviceThumbnailResponse extends MediaLiveResponse implements
        ToCopyableBuilder<DescribeInputDeviceThumbnailResponse.Builder, DescribeInputDeviceThumbnailResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(DescribeInputDeviceThumbnailResponse::contentTypeAsString))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<Long> CONTENT_LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ContentLength").getter(getter(DescribeInputDeviceThumbnailResponse::contentLength))
            .setter(setter(Builder::contentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Length").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ETag")
            .getter(getter(DescribeInputDeviceThumbnailResponse::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModified").getter(getter(DescribeInputDeviceThumbnailResponse::lastModified))
            .setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Last-Modified").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            CONTENT_LENGTH_FIELD, E_TAG_FIELD, LAST_MODIFIED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String contentType;

    private final Long contentLength;

    private final String eTag;

    private final Instant lastModified;

    private DescribeInputDeviceThumbnailResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.contentLength = builder.contentLength;
        this.eTag = builder.eTag;
        this.lastModified = builder.lastModified;
    }

    /**
     * Specifies the media type of the thumbnail.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return Specifies the media type of the thumbnail.
     * @see ContentType
     */
    public final ContentType contentType() {
        return ContentType.fromValue(contentType);
    }

    /**
     * Specifies the media type of the thumbnail.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link ContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return Specifies the media type of the thumbnail.
     * @see ContentType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    /**
     * The length of the content.
     * 
     * @return The length of the content.
     */
    public final Long contentLength() {
        return contentLength;
    }

    /**
     * The unique, cacheable version of this thumbnail.
     * 
     * @return The unique, cacheable version of this thumbnail.
     */
    public final String eTag() {
        return eTag;
    }

    /**
     * The date and time the thumbnail was last updated at the device.
     * 
     * @return The date and time the thumbnail was last updated at the device.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentLength());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInputDeviceThumbnailResponse)) {
            return false;
        }
        DescribeInputDeviceThumbnailResponse other = (DescribeInputDeviceThumbnailResponse) obj;
        return Objects.equals(contentTypeAsString(), other.contentTypeAsString())
                && Objects.equals(contentLength(), other.contentLength()) && Objects.equals(eTag(), other.eTag())
                && Objects.equals(lastModified(), other.lastModified());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInputDeviceThumbnailResponse").add("ContentType", contentTypeAsString())
                .add("ContentLength", contentLength()).add("ETag", eTag()).add("LastModified", lastModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        case "ContentLength":
            return Optional.ofNullable(clazz.cast(contentLength()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("Content-Length", CONTENT_LENGTH_FIELD);
        map.put("ETag", E_TAG_FIELD);
        map.put("Last-Modified", LAST_MODIFIED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInputDeviceThumbnailResponse, T> g) {
        return obj -> g.apply((DescribeInputDeviceThumbnailResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInputDeviceThumbnailResponse> {
        /**
         * Specifies the media type of the thumbnail.
         * 
         * @param contentType
         *        Specifies the media type of the thumbnail.
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentType(String contentType);

        /**
         * Specifies the media type of the thumbnail.
         * 
         * @param contentType
         *        Specifies the media type of the thumbnail.
         * @see ContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentType
         */
        Builder contentType(ContentType contentType);

        /**
         * The length of the content.
         * 
         * @param contentLength
         *        The length of the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentLength(Long contentLength);

        /**
         * The unique, cacheable version of this thumbnail.
         * 
         * @param eTag
         *        The unique, cacheable version of this thumbnail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * The date and time the thumbnail was last updated at the device.
         * 
         * @param lastModified
         *        The date and time the thumbnail was last updated at the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String contentType;

        private Long contentLength;

        private String eTag;

        private Instant lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInputDeviceThumbnailResponse model) {
            super(model);
            contentType(model.contentType);
            contentLength(model.contentLength);
            eTag(model.eTag);
            lastModified(model.lastModified);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(ContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final Long getContentLength() {
            return contentLength;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Override
        public DescribeInputDeviceThumbnailResponse build() {
            return new DescribeInputDeviceThumbnailResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
