/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Dvb Sub Source Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class DvbSubSourceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DvbSubSourceSettings.Builder, DvbSubSourceSettings> {
    private static final SdkField<String> OCR_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OcrLanguage").getter(getter(DvbSubSourceSettings::ocrLanguageAsString))
            .setter(setter(Builder::ocrLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocrLanguage").build()).build();

    private static final SdkField<Integer> PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Pid")
            .getter(getter(DvbSubSourceSettings::pid)).setter(setter(Builder::pid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(OCR_LANGUAGE_FIELD, PID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ocrLanguage;

    private final Integer pid;

    private DvbSubSourceSettings(BuilderImpl builder) {
        this.ocrLanguage = builder.ocrLanguage;
        this.pid = builder.pid;
    }

    /**
     * If you will configure a WebVTT caption description that references this caption selector, use this field to
     * provide the language to consider when translating the image-based source to text.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ocrLanguage} will
     * return {@link DvbSubOcrLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ocrLanguageAsString}.
     * </p>
     * 
     * @return If you will configure a WebVTT caption description that references this caption selector, use this field
     *         to provide the language to consider when translating the image-based source to text.
     * @see DvbSubOcrLanguage
     */
    public final DvbSubOcrLanguage ocrLanguage() {
        return DvbSubOcrLanguage.fromValue(ocrLanguage);
    }

    /**
     * If you will configure a WebVTT caption description that references this caption selector, use this field to
     * provide the language to consider when translating the image-based source to text.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ocrLanguage} will
     * return {@link DvbSubOcrLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ocrLanguageAsString}.
     * </p>
     * 
     * @return If you will configure a WebVTT caption description that references this caption selector, use this field
     *         to provide the language to consider when translating the image-based source to text.
     * @see DvbSubOcrLanguage
     */
    public final String ocrLanguageAsString() {
        return ocrLanguage;
    }

    /**
     * When using DVB-Sub with Burn-In or SMPTE-TT, use this PID for the source content. Unused for DVB-Sub passthrough.
     * All DVB-Sub content is passed through, regardless of selectors.
     * 
     * @return When using DVB-Sub with Burn-In or SMPTE-TT, use this PID for the source content. Unused for DVB-Sub
     *         passthrough. All DVB-Sub content is passed through, regardless of selectors.
     */
    public final Integer pid() {
        return pid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ocrLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DvbSubSourceSettings)) {
            return false;
        }
        DvbSubSourceSettings other = (DvbSubSourceSettings) obj;
        return Objects.equals(ocrLanguageAsString(), other.ocrLanguageAsString()) && Objects.equals(pid(), other.pid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DvbSubSourceSettings").add("OcrLanguage", ocrLanguageAsString()).add("Pid", pid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OcrLanguage":
            return Optional.ofNullable(clazz.cast(ocrLanguageAsString()));
        case "Pid":
            return Optional.ofNullable(clazz.cast(pid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ocrLanguage", OCR_LANGUAGE_FIELD);
        map.put("pid", PID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DvbSubSourceSettings, T> g) {
        return obj -> g.apply((DvbSubSourceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DvbSubSourceSettings> {
        /**
         * If you will configure a WebVTT caption description that references this caption selector, use this field to
         * provide the language to consider when translating the image-based source to text.
         * 
         * @param ocrLanguage
         *        If you will configure a WebVTT caption description that references this caption selector, use this
         *        field to provide the language to consider when translating the image-based source to text.
         * @see DvbSubOcrLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbSubOcrLanguage
         */
        Builder ocrLanguage(String ocrLanguage);

        /**
         * If you will configure a WebVTT caption description that references this caption selector, use this field to
         * provide the language to consider when translating the image-based source to text.
         * 
         * @param ocrLanguage
         *        If you will configure a WebVTT caption description that references this caption selector, use this
         *        field to provide the language to consider when translating the image-based source to text.
         * @see DvbSubOcrLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbSubOcrLanguage
         */
        Builder ocrLanguage(DvbSubOcrLanguage ocrLanguage);

        /**
         * When using DVB-Sub with Burn-In or SMPTE-TT, use this PID for the source content. Unused for DVB-Sub
         * passthrough. All DVB-Sub content is passed through, regardless of selectors.
         * 
         * @param pid
         *        When using DVB-Sub with Burn-In or SMPTE-TT, use this PID for the source content. Unused for DVB-Sub
         *        passthrough. All DVB-Sub content is passed through, regardless of selectors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pid(Integer pid);
    }

    static final class BuilderImpl implements Builder {
        private String ocrLanguage;

        private Integer pid;

        private BuilderImpl() {
        }

        private BuilderImpl(DvbSubSourceSettings model) {
            ocrLanguage(model.ocrLanguage);
            pid(model.pid);
        }

        public final String getOcrLanguage() {
            return ocrLanguage;
        }

        public final void setOcrLanguage(String ocrLanguage) {
            this.ocrLanguage = ocrLanguage;
        }

        @Override
        public final Builder ocrLanguage(String ocrLanguage) {
            this.ocrLanguage = ocrLanguage;
            return this;
        }

        @Override
        public final Builder ocrLanguage(DvbSubOcrLanguage ocrLanguage) {
            this.ocrLanguage(ocrLanguage == null ? null : ocrLanguage.toString());
            return this;
        }

        public final Integer getPid() {
            return pid;
        }

        public final void setPid(Integer pid) {
            this.pid = pid;
        }

        @Override
        public final Builder pid(Integer pid) {
            this.pid = pid;
            return this;
        }

        @Override
        public DvbSubSourceSettings build() {
            return new DvbSubSourceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
