/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Embedded Source Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmbeddedSourceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<EmbeddedSourceSettings.Builder, EmbeddedSourceSettings> {
    private static final SdkField<String> CONVERT608_TO708_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Convert608To708").getter(getter(EmbeddedSourceSettings::convert608To708AsString))
            .setter(setter(Builder::convert608To708))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("convert608To708").build()).build();

    private static final SdkField<String> SCTE20_DETECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Scte20Detection").getter(getter(EmbeddedSourceSettings::scte20DetectionAsString))
            .setter(setter(Builder::scte20Detection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte20Detection").build()).build();

    private static final SdkField<Integer> SOURCE608_CHANNEL_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Source608ChannelNumber").getter(getter(EmbeddedSourceSettings::source608ChannelNumber))
            .setter(setter(Builder::source608ChannelNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source608ChannelNumber").build())
            .build();

    private static final SdkField<Integer> SOURCE608_TRACK_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Source608TrackNumber").getter(getter(EmbeddedSourceSettings::source608TrackNumber))
            .setter(setter(Builder::source608TrackNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source608TrackNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERT608_TO708_FIELD,
            SCTE20_DETECTION_FIELD, SOURCE608_CHANNEL_NUMBER_FIELD, SOURCE608_TRACK_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String convert608To708;

    private final String scte20Detection;

    private final Integer source608ChannelNumber;

    private final Integer source608TrackNumber;

    private EmbeddedSourceSettings(BuilderImpl builder) {
        this.convert608To708 = builder.convert608To708;
        this.scte20Detection = builder.scte20Detection;
        this.source608ChannelNumber = builder.source608ChannelNumber;
        this.source608TrackNumber = builder.source608TrackNumber;
    }

    /**
     * If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper as well
     * as translated into 708. 708 data present in the source content will be discarded.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #convert608To708}
     * will return {@link EmbeddedConvert608To708#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #convert608To708AsString}.
     * </p>
     * 
     * @return If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper
     *         as well as translated into 708. 708 data present in the source content will be discarded.
     * @see EmbeddedConvert608To708
     */
    public final EmbeddedConvert608To708 convert608To708() {
        return EmbeddedConvert608To708.fromValue(convert608To708);
    }

    /**
     * If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper as well
     * as translated into 708. 708 data present in the source content will be discarded.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #convert608To708}
     * will return {@link EmbeddedConvert608To708#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #convert608To708AsString}.
     * </p>
     * 
     * @return If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper
     *         as well as translated into 708. 708 data present in the source content will be discarded.
     * @see EmbeddedConvert608To708
     */
    public final String convert608To708AsString() {
        return convert608To708;
    }

    /**
     * Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20 and Embedded captions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte20Detection}
     * will return {@link EmbeddedScte20Detection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #scte20DetectionAsString}.
     * </p>
     * 
     * @return Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20 and Embedded captions.
     * @see EmbeddedScte20Detection
     */
    public final EmbeddedScte20Detection scte20Detection() {
        return EmbeddedScte20Detection.fromValue(scte20Detection);
    }

    /**
     * Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20 and Embedded captions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte20Detection}
     * will return {@link EmbeddedScte20Detection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #scte20DetectionAsString}.
     * </p>
     * 
     * @return Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20 and Embedded captions.
     * @see EmbeddedScte20Detection
     */
    public final String scte20DetectionAsString() {
        return scte20Detection;
    }

    /**
     * Specifies the 608/708 channel number within the video track from which to extract captions. Unused for
     * passthrough.
     * 
     * @return Specifies the 608/708 channel number within the video track from which to extract captions. Unused for
     *         passthrough.
     */
    public final Integer source608ChannelNumber() {
        return source608ChannelNumber;
    }

    /**
     * This field is unused and deprecated.
     * 
     * @return This field is unused and deprecated.
     */
    public final Integer source608TrackNumber() {
        return source608TrackNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(convert608To708AsString());
        hashCode = 31 * hashCode + Objects.hashCode(scte20DetectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(source608ChannelNumber());
        hashCode = 31 * hashCode + Objects.hashCode(source608TrackNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmbeddedSourceSettings)) {
            return false;
        }
        EmbeddedSourceSettings other = (EmbeddedSourceSettings) obj;
        return Objects.equals(convert608To708AsString(), other.convert608To708AsString())
                && Objects.equals(scte20DetectionAsString(), other.scte20DetectionAsString())
                && Objects.equals(source608ChannelNumber(), other.source608ChannelNumber())
                && Objects.equals(source608TrackNumber(), other.source608TrackNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmbeddedSourceSettings").add("Convert608To708", convert608To708AsString())
                .add("Scte20Detection", scte20DetectionAsString()).add("Source608ChannelNumber", source608ChannelNumber())
                .add("Source608TrackNumber", source608TrackNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Convert608To708":
            return Optional.ofNullable(clazz.cast(convert608To708AsString()));
        case "Scte20Detection":
            return Optional.ofNullable(clazz.cast(scte20DetectionAsString()));
        case "Source608ChannelNumber":
            return Optional.ofNullable(clazz.cast(source608ChannelNumber()));
        case "Source608TrackNumber":
            return Optional.ofNullable(clazz.cast(source608TrackNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("convert608To708", CONVERT608_TO708_FIELD);
        map.put("scte20Detection", SCTE20_DETECTION_FIELD);
        map.put("source608ChannelNumber", SOURCE608_CHANNEL_NUMBER_FIELD);
        map.put("source608TrackNumber", SOURCE608_TRACK_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmbeddedSourceSettings, T> g) {
        return obj -> g.apply((EmbeddedSourceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmbeddedSourceSettings> {
        /**
         * If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper as
         * well as translated into 708. 708 data present in the source content will be discarded.
         * 
         * @param convert608To708
         *        If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708
         *        wrapper as well as translated into 708. 708 data present in the source content will be discarded.
         * @see EmbeddedConvert608To708
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmbeddedConvert608To708
         */
        Builder convert608To708(String convert608To708);

        /**
         * If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper as
         * well as translated into 708. 708 data present in the source content will be discarded.
         * 
         * @param convert608To708
         *        If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708
         *        wrapper as well as translated into 708. 708 data present in the source content will be discarded.
         * @see EmbeddedConvert608To708
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmbeddedConvert608To708
         */
        Builder convert608To708(EmbeddedConvert608To708 convert608To708);

        /**
         * Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20 and Embedded captions.
         * 
         * @param scte20Detection
         *        Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20 and Embedded captions.
         * @see EmbeddedScte20Detection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmbeddedScte20Detection
         */
        Builder scte20Detection(String scte20Detection);

        /**
         * Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20 and Embedded captions.
         * 
         * @param scte20Detection
         *        Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20 and Embedded captions.
         * @see EmbeddedScte20Detection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmbeddedScte20Detection
         */
        Builder scte20Detection(EmbeddedScte20Detection scte20Detection);

        /**
         * Specifies the 608/708 channel number within the video track from which to extract captions. Unused for
         * passthrough.
         * 
         * @param source608ChannelNumber
         *        Specifies the 608/708 channel number within the video track from which to extract captions. Unused for
         *        passthrough.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source608ChannelNumber(Integer source608ChannelNumber);

        /**
         * This field is unused and deprecated.
         * 
         * @param source608TrackNumber
         *        This field is unused and deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source608TrackNumber(Integer source608TrackNumber);
    }

    static final class BuilderImpl implements Builder {
        private String convert608To708;

        private String scte20Detection;

        private Integer source608ChannelNumber;

        private Integer source608TrackNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(EmbeddedSourceSettings model) {
            convert608To708(model.convert608To708);
            scte20Detection(model.scte20Detection);
            source608ChannelNumber(model.source608ChannelNumber);
            source608TrackNumber(model.source608TrackNumber);
        }

        public final String getConvert608To708() {
            return convert608To708;
        }

        public final void setConvert608To708(String convert608To708) {
            this.convert608To708 = convert608To708;
        }

        @Override
        public final Builder convert608To708(String convert608To708) {
            this.convert608To708 = convert608To708;
            return this;
        }

        @Override
        public final Builder convert608To708(EmbeddedConvert608To708 convert608To708) {
            this.convert608To708(convert608To708 == null ? null : convert608To708.toString());
            return this;
        }

        public final String getScte20Detection() {
            return scte20Detection;
        }

        public final void setScte20Detection(String scte20Detection) {
            this.scte20Detection = scte20Detection;
        }

        @Override
        public final Builder scte20Detection(String scte20Detection) {
            this.scte20Detection = scte20Detection;
            return this;
        }

        @Override
        public final Builder scte20Detection(EmbeddedScte20Detection scte20Detection) {
            this.scte20Detection(scte20Detection == null ? null : scte20Detection.toString());
            return this;
        }

        public final Integer getSource608ChannelNumber() {
            return source608ChannelNumber;
        }

        public final void setSource608ChannelNumber(Integer source608ChannelNumber) {
            this.source608ChannelNumber = source608ChannelNumber;
        }

        @Override
        public final Builder source608ChannelNumber(Integer source608ChannelNumber) {
            this.source608ChannelNumber = source608ChannelNumber;
            return this;
        }

        public final Integer getSource608TrackNumber() {
            return source608TrackNumber;
        }

        public final void setSource608TrackNumber(Integer source608TrackNumber) {
            this.source608TrackNumber = source608TrackNumber;
        }

        @Override
        public final Builder source608TrackNumber(Integer source608TrackNumber) {
            this.source608TrackNumber = source608TrackNumber;
            return this;
        }

        @Override
        public EmbeddedSourceSettings build() {
            return new EmbeddedSourceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
