/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for a PUSH type input.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<InputDestination.Builder, InputDestination> {
    private static final SdkField<String> IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ip")
            .getter(getter(InputDestination::ip)).setter(setter(Builder::ip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ip").build()).build();

    private static final SdkField<String> PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Port")
            .getter(getter(InputDestination::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(InputDestination::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<InputDestinationVpc> VPC_FIELD = SdkField
            .<InputDestinationVpc> builder(MarshallingType.SDK_POJO).memberName("Vpc").getter(getter(InputDestination::vpc))
            .setter(setter(Builder::vpc)).constructor(InputDestinationVpc::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()).build();

    private static final SdkField<String> NETWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Network")
            .getter(getter(InputDestination::network)).setter(setter(Builder::network))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()).build();

    private static final SdkField<List<InputDestinationRoute>> NETWORK_ROUTES_FIELD = SdkField
            .<List<InputDestinationRoute>> builder(MarshallingType.LIST)
            .memberName("NetworkRoutes")
            .getter(getter(InputDestination::networkRoutes))
            .setter(setter(Builder::networkRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkRoutes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputDestinationRoute> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputDestinationRoute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FIELD, PORT_FIELD,
            URL_FIELD, VPC_FIELD, NETWORK_FIELD, NETWORK_ROUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ip;

    private final String port;

    private final String url;

    private final InputDestinationVpc vpc;

    private final String network;

    private final List<InputDestinationRoute> networkRoutes;

    private InputDestination(BuilderImpl builder) {
        this.ip = builder.ip;
        this.port = builder.port;
        this.url = builder.url;
        this.vpc = builder.vpc;
        this.network = builder.network;
        this.networkRoutes = builder.networkRoutes;
    }

    /**
     * The system-generated static IP address of endpoint. It remains fixed for the lifetime of the input.
     * 
     * @return The system-generated static IP address of endpoint. It remains fixed for the lifetime of the input.
     */
    public final String ip() {
        return ip;
    }

    /**
     * The port number for the input.
     * 
     * @return The port number for the input.
     */
    public final String port() {
        return port;
    }

    /**
     * This represents the endpoint that the customer stream will be pushed to.
     * 
     * @return This represents the endpoint that the customer stream will be pushed to.
     */
    public final String url() {
        return url;
    }

    /**
     * Returns the value of the Vpc property for this object.
     * 
     * @return The value of the Vpc property for this object.
     */
    public final InputDestinationVpc vpc() {
        return vpc;
    }

    /**
     * The ID of the attached network.
     * 
     * @return The ID of the attached network.
     */
    public final String network() {
        return network;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkRoutes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkRoutes() {
        return networkRoutes != null && !(networkRoutes instanceof SdkAutoConstructList);
    }

    /**
     * If the push input has an input location of ON-PREM it's a requirement to specify what the route of the input is
     * going to be on the customer local network.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkRoutes} method.
     * </p>
     * 
     * @return If the push input has an input location of ON-PREM it's a requirement to specify what the route of the
     *         input is going to be on the customer local network.
     */
    public final List<InputDestinationRoute> networkRoutes() {
        return networkRoutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ip());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        hashCode = 31 * hashCode + Objects.hashCode(network());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkRoutes() ? networkRoutes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDestination)) {
            return false;
        }
        InputDestination other = (InputDestination) obj;
        return Objects.equals(ip(), other.ip()) && Objects.equals(port(), other.port()) && Objects.equals(url(), other.url())
                && Objects.equals(vpc(), other.vpc()) && Objects.equals(network(), other.network())
                && hasNetworkRoutes() == other.hasNetworkRoutes() && Objects.equals(networkRoutes(), other.networkRoutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDestination").add("Ip", ip()).add("Port", port()).add("Url", url()).add("Vpc", vpc())
                .add("Network", network()).add("NetworkRoutes", hasNetworkRoutes() ? networkRoutes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ip":
            return Optional.ofNullable(clazz.cast(ip()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        case "Network":
            return Optional.ofNullable(clazz.cast(network()));
        case "NetworkRoutes":
            return Optional.ofNullable(clazz.cast(networkRoutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ip", IP_FIELD);
        map.put("port", PORT_FIELD);
        map.put("url", URL_FIELD);
        map.put("vpc", VPC_FIELD);
        map.put("network", NETWORK_FIELD);
        map.put("networkRoutes", NETWORK_ROUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputDestination, T> g) {
        return obj -> g.apply((InputDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDestination> {
        /**
         * The system-generated static IP address of endpoint. It remains fixed for the lifetime of the input.
         * 
         * @param ip
         *        The system-generated static IP address of endpoint. It remains fixed for the lifetime of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ip(String ip);

        /**
         * The port number for the input.
         * 
         * @param port
         *        The port number for the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(String port);

        /**
         * This represents the endpoint that the customer stream will be pushed to.
         * 
         * @param url
         *        This represents the endpoint that the customer stream will be pushed to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * Sets the value of the Vpc property for this object.
         *
         * @param vpc
         *        The new value for the Vpc property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(InputDestinationVpc vpc);

        /**
         * Sets the value of the Vpc property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InputDestinationVpc.Builder} avoiding the
         * need to create one manually via {@link InputDestinationVpc#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputDestinationVpc.Builder#build()} is called immediately and
         * its result is passed to {@link #vpc(InputDestinationVpc)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link InputDestinationVpc.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(InputDestinationVpc)
         */
        default Builder vpc(Consumer<InputDestinationVpc.Builder> vpc) {
            return vpc(InputDestinationVpc.builder().applyMutation(vpc).build());
        }

        /**
         * The ID of the attached network.
         * 
         * @param network
         *        The ID of the attached network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder network(String network);

        /**
         * If the push input has an input location of ON-PREM it's a requirement to specify what the route of the input
         * is going to be on the customer local network.
         * 
         * @param networkRoutes
         *        If the push input has an input location of ON-PREM it's a requirement to specify what the route of the
         *        input is going to be on the customer local network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkRoutes(Collection<InputDestinationRoute> networkRoutes);

        /**
         * If the push input has an input location of ON-PREM it's a requirement to specify what the route of the input
         * is going to be on the customer local network.
         * 
         * @param networkRoutes
         *        If the push input has an input location of ON-PREM it's a requirement to specify what the route of the
         *        input is going to be on the customer local network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkRoutes(InputDestinationRoute... networkRoutes);

        /**
         * If the push input has an input location of ON-PREM it's a requirement to specify what the route of the input
         * is going to be on the customer local network. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.InputDestinationRoute.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.InputDestinationRoute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.InputDestinationRoute.Builder#build()} is called
         * immediately and its result is passed to {@link #networkRoutes(List<InputDestinationRoute>)}.
         * 
         * @param networkRoutes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.InputDestinationRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkRoutes(java.util.Collection<InputDestinationRoute>)
         */
        Builder networkRoutes(Consumer<InputDestinationRoute.Builder>... networkRoutes);
    }

    static final class BuilderImpl implements Builder {
        private String ip;

        private String port;

        private String url;

        private InputDestinationVpc vpc;

        private String network;

        private List<InputDestinationRoute> networkRoutes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InputDestination model) {
            ip(model.ip);
            port(model.port);
            url(model.url);
            vpc(model.vpc);
            network(model.network);
            networkRoutes(model.networkRoutes);
        }

        public final String getIp() {
            return ip;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final String getPort() {
            return port;
        }

        public final void setPort(String port) {
            this.port = port;
        }

        @Override
        public final Builder port(String port) {
            this.port = port;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final InputDestinationVpc.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        public final void setVpc(InputDestinationVpc.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(InputDestinationVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public final String getNetwork() {
            return network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        public final List<InputDestinationRoute.Builder> getNetworkRoutes() {
            List<InputDestinationRoute.Builder> result = ___listOfInputDestinationRouteCopier.copyToBuilder(this.networkRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkRoutes(Collection<InputDestinationRoute.BuilderImpl> networkRoutes) {
            this.networkRoutes = ___listOfInputDestinationRouteCopier.copyFromBuilder(networkRoutes);
        }

        @Override
        public final Builder networkRoutes(Collection<InputDestinationRoute> networkRoutes) {
            this.networkRoutes = ___listOfInputDestinationRouteCopier.copy(networkRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkRoutes(InputDestinationRoute... networkRoutes) {
            networkRoutes(Arrays.asList(networkRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkRoutes(Consumer<InputDestinationRoute.Builder>... networkRoutes) {
            networkRoutes(Stream.of(networkRoutes).map(c -> InputDestinationRoute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public InputDestination build() {
            return new InputDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
