/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Parameters required to attach a MediaConnect flow to the device.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDeviceMediaConnectConfigurableSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<InputDeviceMediaConnectConfigurableSettings.Builder, InputDeviceMediaConnectConfigurableSettings> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowArn").getter(getter(InputDeviceMediaConnectConfigurableSettings::flowArn))
            .setter(setter(Builder::flowArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(InputDeviceMediaConnectConfigurableSettings::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(InputDeviceMediaConnectConfigurableSettings::secretArn))
            .setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()).build();

    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceName").getter(getter(InputDeviceMediaConnectConfigurableSettings::sourceName))
            .setter(setter(Builder::sourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD,
            ROLE_ARN_FIELD, SECRET_ARN_FIELD, SOURCE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String flowArn;

    private final String roleArn;

    private final String secretArn;

    private final String sourceName;

    private InputDeviceMediaConnectConfigurableSettings(BuilderImpl builder) {
        this.flowArn = builder.flowArn;
        this.roleArn = builder.roleArn;
        this.secretArn = builder.secretArn;
        this.sourceName = builder.sourceName;
    }

    /**
     * The ARN of the MediaConnect flow to attach this device to.
     * 
     * @return The ARN of the MediaConnect flow to attach this device to.
     */
    public final String flowArn() {
        return flowArn;
    }

    /**
     * The ARN for the role that MediaLive assumes to access the attached flow and secret. For more information about
     * how to create this role, see the MediaLive user guide.
     * 
     * @return The ARN for the role that MediaLive assumes to access the attached flow and secret. For more information
     *         about how to create this role, see the MediaLive user guide.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * The ARN for the secret that holds the encryption key to encrypt the content output by the device.
     * 
     * @return The ARN for the secret that holds the encryption key to encrypt the content output by the device.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * The name of the MediaConnect Flow source to stream to.
     * 
     * @return The name of the MediaConnect Flow source to stream to.
     */
    public final String sourceName() {
        return sourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceMediaConnectConfigurableSettings)) {
            return false;
        }
        InputDeviceMediaConnectConfigurableSettings other = (InputDeviceMediaConnectConfigurableSettings) obj;
        return Objects.equals(flowArn(), other.flowArn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(secretArn(), other.secretArn()) && Objects.equals(sourceName(), other.sourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDeviceMediaConnectConfigurableSettings").add("FlowArn", flowArn())
                .add("RoleArn", roleArn()).add("SecretArn", secretArn()).add("SourceName", sourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowArn":
            return Optional.ofNullable(clazz.cast(flowArn()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "SourceName":
            return Optional.ofNullable(clazz.cast(sourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("flowArn", FLOW_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("secretArn", SECRET_ARN_FIELD);
        map.put("sourceName", SOURCE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputDeviceMediaConnectConfigurableSettings, T> g) {
        return obj -> g.apply((InputDeviceMediaConnectConfigurableSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDeviceMediaConnectConfigurableSettings> {
        /**
         * The ARN of the MediaConnect flow to attach this device to.
         * 
         * @param flowArn
         *        The ARN of the MediaConnect flow to attach this device to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowArn(String flowArn);

        /**
         * The ARN for the role that MediaLive assumes to access the attached flow and secret. For more information
         * about how to create this role, see the MediaLive user guide.
         * 
         * @param roleArn
         *        The ARN for the role that MediaLive assumes to access the attached flow and secret. For more
         *        information about how to create this role, see the MediaLive user guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * The ARN for the secret that holds the encryption key to encrypt the content output by the device.
         * 
         * @param secretArn
         *        The ARN for the secret that holds the encryption key to encrypt the content output by the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * The name of the MediaConnect Flow source to stream to.
         * 
         * @param sourceName
         *        The name of the MediaConnect Flow source to stream to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceName(String sourceName);
    }

    static final class BuilderImpl implements Builder {
        private String flowArn;

        private String roleArn;

        private String secretArn;

        private String sourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDeviceMediaConnectConfigurableSettings model) {
            flowArn(model.flowArn);
            roleArn(model.roleArn);
            secretArn(model.secretArn);
            sourceName(model.sourceName);
        }

        public final String getFlowArn() {
            return flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getSourceName() {
            return sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        @Override
        public InputDeviceMediaConnectConfigurableSettings build() {
            return new InputDeviceMediaConnectConfigurableSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
