/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Live Event input parameters. There can be multiple inputs in a single Live Event.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputSettings implements SdkPojo, Serializable, ToCopyableBuilder<InputSettings.Builder, InputSettings> {
    private static final SdkField<List<AudioSelector>> AUDIO_SELECTORS_FIELD = SdkField
            .<List<AudioSelector>> builder(MarshallingType.LIST)
            .memberName("AudioSelectors")
            .getter(getter(InputSettings::audioSelectors))
            .setter(setter(Builder::audioSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSelectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AudioSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudioSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CaptionSelector>> CAPTION_SELECTORS_FIELD = SdkField
            .<List<CaptionSelector>> builder(MarshallingType.LIST)
            .memberName("CaptionSelectors")
            .getter(getter(InputSettings::captionSelectors))
            .setter(setter(Builder::captionSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionSelectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CaptionSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(CaptionSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEBLOCK_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeblockFilter").getter(getter(InputSettings::deblockFilterAsString))
            .setter(setter(Builder::deblockFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deblockFilter").build()).build();

    private static final SdkField<String> DENOISE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DenoiseFilter").getter(getter(InputSettings::denoiseFilterAsString))
            .setter(setter(Builder::denoiseFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("denoiseFilter").build()).build();

    private static final SdkField<Integer> FILTER_STRENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FilterStrength").getter(getter(InputSettings::filterStrength)).setter(setter(Builder::filterStrength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterStrength").build()).build();

    private static final SdkField<String> INPUT_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputFilter").getter(getter(InputSettings::inputFilterAsString)).setter(setter(Builder::inputFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFilter").build()).build();

    private static final SdkField<NetworkInputSettings> NETWORK_INPUT_SETTINGS_FIELD = SdkField
            .<NetworkInputSettings> builder(MarshallingType.SDK_POJO).memberName("NetworkInputSettings")
            .getter(getter(InputSettings::networkInputSettings)).setter(setter(Builder::networkInputSettings))
            .constructor(NetworkInputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInputSettings").build())
            .build();

    private static final SdkField<Integer> SCTE35_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Scte35Pid").getter(getter(InputSettings::scte35Pid)).setter(setter(Builder::scte35Pid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Pid").build()).build();

    private static final SdkField<String> SMPTE2038_DATA_PREFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Smpte2038DataPreference").getter(getter(InputSettings::smpte2038DataPreferenceAsString))
            .setter(setter(Builder::smpte2038DataPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smpte2038DataPreference").build())
            .build();

    private static final SdkField<String> SOURCE_END_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceEndBehavior").getter(getter(InputSettings::sourceEndBehaviorAsString))
            .setter(setter(Builder::sourceEndBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceEndBehavior").build()).build();

    private static final SdkField<VideoSelector> VIDEO_SELECTOR_FIELD = SdkField
            .<VideoSelector> builder(MarshallingType.SDK_POJO).memberName("VideoSelector")
            .getter(getter(InputSettings::videoSelector)).setter(setter(Builder::videoSelector))
            .constructor(VideoSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoSelector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_SELECTORS_FIELD,
            CAPTION_SELECTORS_FIELD, DEBLOCK_FILTER_FIELD, DENOISE_FILTER_FIELD, FILTER_STRENGTH_FIELD, INPUT_FILTER_FIELD,
            NETWORK_INPUT_SETTINGS_FIELD, SCTE35_PID_FIELD, SMPTE2038_DATA_PREFERENCE_FIELD, SOURCE_END_BEHAVIOR_FIELD,
            VIDEO_SELECTOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AudioSelector> audioSelectors;

    private final List<CaptionSelector> captionSelectors;

    private final String deblockFilter;

    private final String denoiseFilter;

    private final Integer filterStrength;

    private final String inputFilter;

    private final NetworkInputSettings networkInputSettings;

    private final Integer scte35Pid;

    private final String smpte2038DataPreference;

    private final String sourceEndBehavior;

    private final VideoSelector videoSelector;

    private InputSettings(BuilderImpl builder) {
        this.audioSelectors = builder.audioSelectors;
        this.captionSelectors = builder.captionSelectors;
        this.deblockFilter = builder.deblockFilter;
        this.denoiseFilter = builder.denoiseFilter;
        this.filterStrength = builder.filterStrength;
        this.inputFilter = builder.inputFilter;
        this.networkInputSettings = builder.networkInputSettings;
        this.scte35Pid = builder.scte35Pid;
        this.smpte2038DataPreference = builder.smpte2038DataPreference;
        this.sourceEndBehavior = builder.sourceEndBehavior;
        this.videoSelector = builder.videoSelector;
    }

    /**
     * For responses, this returns true if the service returned a value for the AudioSelectors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAudioSelectors() {
        return audioSelectors != null && !(audioSelectors instanceof SdkAutoConstructList);
    }

    /**
     * Used to select the audio stream to decode for inputs that have multiple available.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudioSelectors} method.
     * </p>
     * 
     * @return Used to select the audio stream to decode for inputs that have multiple available.
     */
    public final List<AudioSelector> audioSelectors() {
        return audioSelectors;
    }

    /**
     * For responses, this returns true if the service returned a value for the CaptionSelectors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCaptionSelectors() {
        return captionSelectors != null && !(captionSelectors instanceof SdkAutoConstructList);
    }

    /**
     * Used to select the caption input to use for inputs that have multiple available.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCaptionSelectors} method.
     * </p>
     * 
     * @return Used to select the caption input to use for inputs that have multiple available.
     */
    public final List<CaptionSelector> captionSelectors() {
        return captionSelectors;
    }

    /**
     * Enable or disable the deblock filter when filtering.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deblockFilter}
     * will return {@link InputDeblockFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deblockFilterAsString}.
     * </p>
     * 
     * @return Enable or disable the deblock filter when filtering.
     * @see InputDeblockFilter
     */
    public final InputDeblockFilter deblockFilter() {
        return InputDeblockFilter.fromValue(deblockFilter);
    }

    /**
     * Enable or disable the deblock filter when filtering.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deblockFilter}
     * will return {@link InputDeblockFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deblockFilterAsString}.
     * </p>
     * 
     * @return Enable or disable the deblock filter when filtering.
     * @see InputDeblockFilter
     */
    public final String deblockFilterAsString() {
        return deblockFilter;
    }

    /**
     * Enable or disable the denoise filter when filtering.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #denoiseFilter}
     * will return {@link InputDenoiseFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #denoiseFilterAsString}.
     * </p>
     * 
     * @return Enable or disable the denoise filter when filtering.
     * @see InputDenoiseFilter
     */
    public final InputDenoiseFilter denoiseFilter() {
        return InputDenoiseFilter.fromValue(denoiseFilter);
    }

    /**
     * Enable or disable the denoise filter when filtering.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #denoiseFilter}
     * will return {@link InputDenoiseFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #denoiseFilterAsString}.
     * </p>
     * 
     * @return Enable or disable the denoise filter when filtering.
     * @see InputDenoiseFilter
     */
    public final String denoiseFilterAsString() {
        return denoiseFilter;
    }

    /**
     * Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
     * 
     * @return Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
     */
    public final Integer filterStrength() {
        return filterStrength;
    }

    /**
     * Turns on the filter for this input. MPEG-2 inputs have the deblocking filter enabled by default. 1) auto -
     * filtering will be applied depending on input type/quality 2) disabled - no filtering will be applied to the input
     * 3) forced - filtering will be applied regardless of input type
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputFilter} will
     * return {@link InputFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputFilterAsString}.
     * </p>
     * 
     * @return Turns on the filter for this input. MPEG-2 inputs have the deblocking filter enabled by default. 1) auto
     *         - filtering will be applied depending on input type/quality 2) disabled - no filtering will be applied to
     *         the input 3) forced - filtering will be applied regardless of input type
     * @see InputFilter
     */
    public final InputFilter inputFilter() {
        return InputFilter.fromValue(inputFilter);
    }

    /**
     * Turns on the filter for this input. MPEG-2 inputs have the deblocking filter enabled by default. 1) auto -
     * filtering will be applied depending on input type/quality 2) disabled - no filtering will be applied to the input
     * 3) forced - filtering will be applied regardless of input type
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputFilter} will
     * return {@link InputFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputFilterAsString}.
     * </p>
     * 
     * @return Turns on the filter for this input. MPEG-2 inputs have the deblocking filter enabled by default. 1) auto
     *         - filtering will be applied depending on input type/quality 2) disabled - no filtering will be applied to
     *         the input 3) forced - filtering will be applied regardless of input type
     * @see InputFilter
     */
    public final String inputFilterAsString() {
        return inputFilter;
    }

    /**
     * Input settings.
     * 
     * @return Input settings.
     */
    public final NetworkInputSettings networkInputSettings() {
        return networkInputSettings;
    }

    /**
     * PID from which to read SCTE-35 messages. If left undefined, EML will select the first SCTE-35 PID found in the
     * input.
     * 
     * @return PID from which to read SCTE-35 messages. If left undefined, EML will select the first SCTE-35 PID found
     *         in the input.
     */
    public final Integer scte35Pid() {
        return scte35Pid;
    }

    /**
     * Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in this input. Applicable data
     * types are captions, timecode, AFD, and SCTE-104 messages. - PREFER: Extract from SMPTE-2038 if present in this
     * input, otherwise extract from another source (if any). - IGNORE: Never extract any ancillary data from
     * SMPTE-2038.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #smpte2038DataPreference} will return {@link Smpte2038DataPreference#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #smpte2038DataPreferenceAsString}.
     * </p>
     * 
     * @return Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in this input. Applicable
     *         data types are captions, timecode, AFD, and SCTE-104 messages. - PREFER: Extract from SMPTE-2038 if
     *         present in this input, otherwise extract from another source (if any). - IGNORE: Never extract any
     *         ancillary data from SMPTE-2038.
     * @see Smpte2038DataPreference
     */
    public final Smpte2038DataPreference smpte2038DataPreference() {
        return Smpte2038DataPreference.fromValue(smpte2038DataPreference);
    }

    /**
     * Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in this input. Applicable data
     * types are captions, timecode, AFD, and SCTE-104 messages. - PREFER: Extract from SMPTE-2038 if present in this
     * input, otherwise extract from another source (if any). - IGNORE: Never extract any ancillary data from
     * SMPTE-2038.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #smpte2038DataPreference} will return {@link Smpte2038DataPreference#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #smpte2038DataPreferenceAsString}.
     * </p>
     * 
     * @return Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in this input. Applicable
     *         data types are captions, timecode, AFD, and SCTE-104 messages. - PREFER: Extract from SMPTE-2038 if
     *         present in this input, otherwise extract from another source (if any). - IGNORE: Never extract any
     *         ancillary data from SMPTE-2038.
     * @see Smpte2038DataPreference
     */
    public final String smpte2038DataPreferenceAsString() {
        return smpte2038DataPreference;
    }

    /**
     * Loop input if it is a file. This allows a file input to be streamed indefinitely.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceEndBehavior}
     * will return {@link InputSourceEndBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sourceEndBehaviorAsString}.
     * </p>
     * 
     * @return Loop input if it is a file. This allows a file input to be streamed indefinitely.
     * @see InputSourceEndBehavior
     */
    public final InputSourceEndBehavior sourceEndBehavior() {
        return InputSourceEndBehavior.fromValue(sourceEndBehavior);
    }

    /**
     * Loop input if it is a file. This allows a file input to be streamed indefinitely.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceEndBehavior}
     * will return {@link InputSourceEndBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sourceEndBehaviorAsString}.
     * </p>
     * 
     * @return Loop input if it is a file. This allows a file input to be streamed indefinitely.
     * @see InputSourceEndBehavior
     */
    public final String sourceEndBehaviorAsString() {
        return sourceEndBehavior;
    }

    /**
     * Informs which video elementary stream to decode for input types that have multiple available.
     * 
     * @return Informs which video elementary stream to decode for input types that have multiple available.
     */
    public final VideoSelector videoSelector() {
        return videoSelector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAudioSelectors() ? audioSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCaptionSelectors() ? captionSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deblockFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(denoiseFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterStrength());
        hashCode = 31 * hashCode + Objects.hashCode(inputFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(networkInputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(scte35Pid());
        hashCode = 31 * hashCode + Objects.hashCode(smpte2038DataPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceEndBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(videoSelector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSettings)) {
            return false;
        }
        InputSettings other = (InputSettings) obj;
        return hasAudioSelectors() == other.hasAudioSelectors() && Objects.equals(audioSelectors(), other.audioSelectors())
                && hasCaptionSelectors() == other.hasCaptionSelectors()
                && Objects.equals(captionSelectors(), other.captionSelectors())
                && Objects.equals(deblockFilterAsString(), other.deblockFilterAsString())
                && Objects.equals(denoiseFilterAsString(), other.denoiseFilterAsString())
                && Objects.equals(filterStrength(), other.filterStrength())
                && Objects.equals(inputFilterAsString(), other.inputFilterAsString())
                && Objects.equals(networkInputSettings(), other.networkInputSettings())
                && Objects.equals(scte35Pid(), other.scte35Pid())
                && Objects.equals(smpte2038DataPreferenceAsString(), other.smpte2038DataPreferenceAsString())
                && Objects.equals(sourceEndBehaviorAsString(), other.sourceEndBehaviorAsString())
                && Objects.equals(videoSelector(), other.videoSelector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputSettings").add("AudioSelectors", hasAudioSelectors() ? audioSelectors() : null)
                .add("CaptionSelectors", hasCaptionSelectors() ? captionSelectors() : null)
                .add("DeblockFilter", deblockFilterAsString()).add("DenoiseFilter", denoiseFilterAsString())
                .add("FilterStrength", filterStrength()).add("InputFilter", inputFilterAsString())
                .add("NetworkInputSettings", networkInputSettings()).add("Scte35Pid", scte35Pid())
                .add("Smpte2038DataPreference", smpte2038DataPreferenceAsString())
                .add("SourceEndBehavior", sourceEndBehaviorAsString()).add("VideoSelector", videoSelector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioSelectors":
            return Optional.ofNullable(clazz.cast(audioSelectors()));
        case "CaptionSelectors":
            return Optional.ofNullable(clazz.cast(captionSelectors()));
        case "DeblockFilter":
            return Optional.ofNullable(clazz.cast(deblockFilterAsString()));
        case "DenoiseFilter":
            return Optional.ofNullable(clazz.cast(denoiseFilterAsString()));
        case "FilterStrength":
            return Optional.ofNullable(clazz.cast(filterStrength()));
        case "InputFilter":
            return Optional.ofNullable(clazz.cast(inputFilterAsString()));
        case "NetworkInputSettings":
            return Optional.ofNullable(clazz.cast(networkInputSettings()));
        case "Scte35Pid":
            return Optional.ofNullable(clazz.cast(scte35Pid()));
        case "Smpte2038DataPreference":
            return Optional.ofNullable(clazz.cast(smpte2038DataPreferenceAsString()));
        case "SourceEndBehavior":
            return Optional.ofNullable(clazz.cast(sourceEndBehaviorAsString()));
        case "VideoSelector":
            return Optional.ofNullable(clazz.cast(videoSelector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("audioSelectors", AUDIO_SELECTORS_FIELD);
        map.put("captionSelectors", CAPTION_SELECTORS_FIELD);
        map.put("deblockFilter", DEBLOCK_FILTER_FIELD);
        map.put("denoiseFilter", DENOISE_FILTER_FIELD);
        map.put("filterStrength", FILTER_STRENGTH_FIELD);
        map.put("inputFilter", INPUT_FILTER_FIELD);
        map.put("networkInputSettings", NETWORK_INPUT_SETTINGS_FIELD);
        map.put("scte35Pid", SCTE35_PID_FIELD);
        map.put("smpte2038DataPreference", SMPTE2038_DATA_PREFERENCE_FIELD);
        map.put("sourceEndBehavior", SOURCE_END_BEHAVIOR_FIELD);
        map.put("videoSelector", VIDEO_SELECTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputSettings, T> g) {
        return obj -> g.apply((InputSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputSettings> {
        /**
         * Used to select the audio stream to decode for inputs that have multiple available.
         * 
         * @param audioSelectors
         *        Used to select the audio stream to decode for inputs that have multiple available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioSelectors(Collection<AudioSelector> audioSelectors);

        /**
         * Used to select the audio stream to decode for inputs that have multiple available.
         * 
         * @param audioSelectors
         *        Used to select the audio stream to decode for inputs that have multiple available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioSelectors(AudioSelector... audioSelectors);

        /**
         * Used to select the audio stream to decode for inputs that have multiple available. This is a convenience
         * method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.AudioSelector.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.medialive.model.AudioSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.AudioSelector.Builder#build()} is called immediately
         * and its result is passed to {@link #audioSelectors(List<AudioSelector>)}.
         * 
         * @param audioSelectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.AudioSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioSelectors(java.util.Collection<AudioSelector>)
         */
        Builder audioSelectors(Consumer<AudioSelector.Builder>... audioSelectors);

        /**
         * Used to select the caption input to use for inputs that have multiple available.
         * 
         * @param captionSelectors
         *        Used to select the caption input to use for inputs that have multiple available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionSelectors(Collection<CaptionSelector> captionSelectors);

        /**
         * Used to select the caption input to use for inputs that have multiple available.
         * 
         * @param captionSelectors
         *        Used to select the caption input to use for inputs that have multiple available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionSelectors(CaptionSelector... captionSelectors);

        /**
         * Used to select the caption input to use for inputs that have multiple available. This is a convenience method
         * that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.CaptionSelector.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.medialive.model.CaptionSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.CaptionSelector.Builder#build()} is called immediately
         * and its result is passed to {@link #captionSelectors(List<CaptionSelector>)}.
         * 
         * @param captionSelectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.CaptionSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captionSelectors(java.util.Collection<CaptionSelector>)
         */
        Builder captionSelectors(Consumer<CaptionSelector.Builder>... captionSelectors);

        /**
         * Enable or disable the deblock filter when filtering.
         * 
         * @param deblockFilter
         *        Enable or disable the deblock filter when filtering.
         * @see InputDeblockFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeblockFilter
         */
        Builder deblockFilter(String deblockFilter);

        /**
         * Enable or disable the deblock filter when filtering.
         * 
         * @param deblockFilter
         *        Enable or disable the deblock filter when filtering.
         * @see InputDeblockFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDeblockFilter
         */
        Builder deblockFilter(InputDeblockFilter deblockFilter);

        /**
         * Enable or disable the denoise filter when filtering.
         * 
         * @param denoiseFilter
         *        Enable or disable the denoise filter when filtering.
         * @see InputDenoiseFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDenoiseFilter
         */
        Builder denoiseFilter(String denoiseFilter);

        /**
         * Enable or disable the denoise filter when filtering.
         * 
         * @param denoiseFilter
         *        Enable or disable the denoise filter when filtering.
         * @see InputDenoiseFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputDenoiseFilter
         */
        Builder denoiseFilter(InputDenoiseFilter denoiseFilter);

        /**
         * Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
         * 
         * @param filterStrength
         *        Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterStrength(Integer filterStrength);

        /**
         * Turns on the filter for this input. MPEG-2 inputs have the deblocking filter enabled by default. 1) auto -
         * filtering will be applied depending on input type/quality 2) disabled - no filtering will be applied to the
         * input 3) forced - filtering will be applied regardless of input type
         * 
         * @param inputFilter
         *        Turns on the filter for this input. MPEG-2 inputs have the deblocking filter enabled by default. 1)
         *        auto - filtering will be applied depending on input type/quality 2) disabled - no filtering will be
         *        applied to the input 3) forced - filtering will be applied regardless of input type
         * @see InputFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputFilter
         */
        Builder inputFilter(String inputFilter);

        /**
         * Turns on the filter for this input. MPEG-2 inputs have the deblocking filter enabled by default. 1) auto -
         * filtering will be applied depending on input type/quality 2) disabled - no filtering will be applied to the
         * input 3) forced - filtering will be applied regardless of input type
         * 
         * @param inputFilter
         *        Turns on the filter for this input. MPEG-2 inputs have the deblocking filter enabled by default. 1)
         *        auto - filtering will be applied depending on input type/quality 2) disabled - no filtering will be
         *        applied to the input 3) forced - filtering will be applied regardless of input type
         * @see InputFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputFilter
         */
        Builder inputFilter(InputFilter inputFilter);

        /**
         * Input settings.
         * 
         * @param networkInputSettings
         *        Input settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInputSettings(NetworkInputSettings networkInputSettings);

        /**
         * Input settings. This is a convenience method that creates an instance of the
         * {@link NetworkInputSettings.Builder} avoiding the need to create one manually via
         * {@link NetworkInputSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkInputSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #networkInputSettings(NetworkInputSettings)}.
         * 
         * @param networkInputSettings
         *        a consumer that will call methods on {@link NetworkInputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInputSettings(NetworkInputSettings)
         */
        default Builder networkInputSettings(Consumer<NetworkInputSettings.Builder> networkInputSettings) {
            return networkInputSettings(NetworkInputSettings.builder().applyMutation(networkInputSettings).build());
        }

        /**
         * PID from which to read SCTE-35 messages. If left undefined, EML will select the first SCTE-35 PID found in
         * the input.
         * 
         * @param scte35Pid
         *        PID from which to read SCTE-35 messages. If left undefined, EML will select the first SCTE-35 PID
         *        found in the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte35Pid(Integer scte35Pid);

        /**
         * Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in this input. Applicable
         * data types are captions, timecode, AFD, and SCTE-104 messages. - PREFER: Extract from SMPTE-2038 if present
         * in this input, otherwise extract from another source (if any). - IGNORE: Never extract any ancillary data
         * from SMPTE-2038.
         * 
         * @param smpte2038DataPreference
         *        Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in this input.
         *        Applicable data types are captions, timecode, AFD, and SCTE-104 messages. - PREFER: Extract from
         *        SMPTE-2038 if present in this input, otherwise extract from another source (if any). - IGNORE: Never
         *        extract any ancillary data from SMPTE-2038.
         * @see Smpte2038DataPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Smpte2038DataPreference
         */
        Builder smpte2038DataPreference(String smpte2038DataPreference);

        /**
         * Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in this input. Applicable
         * data types are captions, timecode, AFD, and SCTE-104 messages. - PREFER: Extract from SMPTE-2038 if present
         * in this input, otherwise extract from another source (if any). - IGNORE: Never extract any ancillary data
         * from SMPTE-2038.
         * 
         * @param smpte2038DataPreference
         *        Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in this input.
         *        Applicable data types are captions, timecode, AFD, and SCTE-104 messages. - PREFER: Extract from
         *        SMPTE-2038 if present in this input, otherwise extract from another source (if any). - IGNORE: Never
         *        extract any ancillary data from SMPTE-2038.
         * @see Smpte2038DataPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Smpte2038DataPreference
         */
        Builder smpte2038DataPreference(Smpte2038DataPreference smpte2038DataPreference);

        /**
         * Loop input if it is a file. This allows a file input to be streamed indefinitely.
         * 
         * @param sourceEndBehavior
         *        Loop input if it is a file. This allows a file input to be streamed indefinitely.
         * @see InputSourceEndBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputSourceEndBehavior
         */
        Builder sourceEndBehavior(String sourceEndBehavior);

        /**
         * Loop input if it is a file. This allows a file input to be streamed indefinitely.
         * 
         * @param sourceEndBehavior
         *        Loop input if it is a file. This allows a file input to be streamed indefinitely.
         * @see InputSourceEndBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputSourceEndBehavior
         */
        Builder sourceEndBehavior(InputSourceEndBehavior sourceEndBehavior);

        /**
         * Informs which video elementary stream to decode for input types that have multiple available.
         * 
         * @param videoSelector
         *        Informs which video elementary stream to decode for input types that have multiple available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoSelector(VideoSelector videoSelector);

        /**
         * Informs which video elementary stream to decode for input types that have multiple available. This is a
         * convenience method that creates an instance of the {@link VideoSelector.Builder} avoiding the need to create
         * one manually via {@link VideoSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoSelector.Builder#build()} is called immediately and its
         * result is passed to {@link #videoSelector(VideoSelector)}.
         * 
         * @param videoSelector
         *        a consumer that will call methods on {@link VideoSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #videoSelector(VideoSelector)
         */
        default Builder videoSelector(Consumer<VideoSelector.Builder> videoSelector) {
            return videoSelector(VideoSelector.builder().applyMutation(videoSelector).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<AudioSelector> audioSelectors = DefaultSdkAutoConstructList.getInstance();

        private List<CaptionSelector> captionSelectors = DefaultSdkAutoConstructList.getInstance();

        private String deblockFilter;

        private String denoiseFilter;

        private Integer filterStrength;

        private String inputFilter;

        private NetworkInputSettings networkInputSettings;

        private Integer scte35Pid;

        private String smpte2038DataPreference;

        private String sourceEndBehavior;

        private VideoSelector videoSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSettings model) {
            audioSelectors(model.audioSelectors);
            captionSelectors(model.captionSelectors);
            deblockFilter(model.deblockFilter);
            denoiseFilter(model.denoiseFilter);
            filterStrength(model.filterStrength);
            inputFilter(model.inputFilter);
            networkInputSettings(model.networkInputSettings);
            scte35Pid(model.scte35Pid);
            smpte2038DataPreference(model.smpte2038DataPreference);
            sourceEndBehavior(model.sourceEndBehavior);
            videoSelector(model.videoSelector);
        }

        public final List<AudioSelector.Builder> getAudioSelectors() {
            List<AudioSelector.Builder> result = ___listOfAudioSelectorCopier.copyToBuilder(this.audioSelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudioSelectors(Collection<AudioSelector.BuilderImpl> audioSelectors) {
            this.audioSelectors = ___listOfAudioSelectorCopier.copyFromBuilder(audioSelectors);
        }

        @Override
        public final Builder audioSelectors(Collection<AudioSelector> audioSelectors) {
            this.audioSelectors = ___listOfAudioSelectorCopier.copy(audioSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioSelectors(AudioSelector... audioSelectors) {
            audioSelectors(Arrays.asList(audioSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioSelectors(Consumer<AudioSelector.Builder>... audioSelectors) {
            audioSelectors(Stream.of(audioSelectors).map(c -> AudioSelector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CaptionSelector.Builder> getCaptionSelectors() {
            List<CaptionSelector.Builder> result = ___listOfCaptionSelectorCopier.copyToBuilder(this.captionSelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCaptionSelectors(Collection<CaptionSelector.BuilderImpl> captionSelectors) {
            this.captionSelectors = ___listOfCaptionSelectorCopier.copyFromBuilder(captionSelectors);
        }

        @Override
        public final Builder captionSelectors(Collection<CaptionSelector> captionSelectors) {
            this.captionSelectors = ___listOfCaptionSelectorCopier.copy(captionSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionSelectors(CaptionSelector... captionSelectors) {
            captionSelectors(Arrays.asList(captionSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionSelectors(Consumer<CaptionSelector.Builder>... captionSelectors) {
            captionSelectors(Stream.of(captionSelectors).map(c -> CaptionSelector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDeblockFilter() {
            return deblockFilter;
        }

        public final void setDeblockFilter(String deblockFilter) {
            this.deblockFilter = deblockFilter;
        }

        @Override
        public final Builder deblockFilter(String deblockFilter) {
            this.deblockFilter = deblockFilter;
            return this;
        }

        @Override
        public final Builder deblockFilter(InputDeblockFilter deblockFilter) {
            this.deblockFilter(deblockFilter == null ? null : deblockFilter.toString());
            return this;
        }

        public final String getDenoiseFilter() {
            return denoiseFilter;
        }

        public final void setDenoiseFilter(String denoiseFilter) {
            this.denoiseFilter = denoiseFilter;
        }

        @Override
        public final Builder denoiseFilter(String denoiseFilter) {
            this.denoiseFilter = denoiseFilter;
            return this;
        }

        @Override
        public final Builder denoiseFilter(InputDenoiseFilter denoiseFilter) {
            this.denoiseFilter(denoiseFilter == null ? null : denoiseFilter.toString());
            return this;
        }

        public final Integer getFilterStrength() {
            return filterStrength;
        }

        public final void setFilterStrength(Integer filterStrength) {
            this.filterStrength = filterStrength;
        }

        @Override
        public final Builder filterStrength(Integer filterStrength) {
            this.filterStrength = filterStrength;
            return this;
        }

        public final String getInputFilter() {
            return inputFilter;
        }

        public final void setInputFilter(String inputFilter) {
            this.inputFilter = inputFilter;
        }

        @Override
        public final Builder inputFilter(String inputFilter) {
            this.inputFilter = inputFilter;
            return this;
        }

        @Override
        public final Builder inputFilter(InputFilter inputFilter) {
            this.inputFilter(inputFilter == null ? null : inputFilter.toString());
            return this;
        }

        public final NetworkInputSettings.Builder getNetworkInputSettings() {
            return networkInputSettings != null ? networkInputSettings.toBuilder() : null;
        }

        public final void setNetworkInputSettings(NetworkInputSettings.BuilderImpl networkInputSettings) {
            this.networkInputSettings = networkInputSettings != null ? networkInputSettings.build() : null;
        }

        @Override
        public final Builder networkInputSettings(NetworkInputSettings networkInputSettings) {
            this.networkInputSettings = networkInputSettings;
            return this;
        }

        public final Integer getScte35Pid() {
            return scte35Pid;
        }

        public final void setScte35Pid(Integer scte35Pid) {
            this.scte35Pid = scte35Pid;
        }

        @Override
        public final Builder scte35Pid(Integer scte35Pid) {
            this.scte35Pid = scte35Pid;
            return this;
        }

        public final String getSmpte2038DataPreference() {
            return smpte2038DataPreference;
        }

        public final void setSmpte2038DataPreference(String smpte2038DataPreference) {
            this.smpte2038DataPreference = smpte2038DataPreference;
        }

        @Override
        public final Builder smpte2038DataPreference(String smpte2038DataPreference) {
            this.smpte2038DataPreference = smpte2038DataPreference;
            return this;
        }

        @Override
        public final Builder smpte2038DataPreference(Smpte2038DataPreference smpte2038DataPreference) {
            this.smpte2038DataPreference(smpte2038DataPreference == null ? null : smpte2038DataPreference.toString());
            return this;
        }

        public final String getSourceEndBehavior() {
            return sourceEndBehavior;
        }

        public final void setSourceEndBehavior(String sourceEndBehavior) {
            this.sourceEndBehavior = sourceEndBehavior;
        }

        @Override
        public final Builder sourceEndBehavior(String sourceEndBehavior) {
            this.sourceEndBehavior = sourceEndBehavior;
            return this;
        }

        @Override
        public final Builder sourceEndBehavior(InputSourceEndBehavior sourceEndBehavior) {
            this.sourceEndBehavior(sourceEndBehavior == null ? null : sourceEndBehavior.toString());
            return this;
        }

        public final VideoSelector.Builder getVideoSelector() {
            return videoSelector != null ? videoSelector.toBuilder() : null;
        }

        public final void setVideoSelector(VideoSelector.BuilderImpl videoSelector) {
            this.videoSelector = videoSelector != null ? videoSelector.build() : null;
        }

        @Override
        public final Builder videoSelector(VideoSelector videoSelector) {
            this.videoSelector = videoSelector;
            return this;
        }

        @Override
        public InputSettings build() {
            return new InputSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
