/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for ListClustersResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClustersResponse extends MediaLiveResponse implements
        ToCopyableBuilder<ListClustersResponse.Builder, ListClustersResponse> {
    private static final SdkField<List<DescribeClusterSummary>> CLUSTERS_FIELD = SdkField
            .<List<DescribeClusterSummary>> builder(MarshallingType.LIST)
            .memberName("Clusters")
            .getter(getter(ListClustersResponse::clusters))
            .setter(setter(Builder::clusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DescribeClusterSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DescribeClusterSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListClustersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTERS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DescribeClusterSummary> clusters;

    private final String nextToken;

    private ListClustersResponse(BuilderImpl builder) {
        super(builder);
        this.clusters = builder.clusters;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Clusters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasClusters() {
        return clusters != null && !(clusters instanceof SdkAutoConstructList);
    }

    /**
     * A list of the Clusters that exist in your AWS account.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusters} method.
     * </p>
     * 
     * @return A list of the Clusters that exist in your AWS account.
     */
    public final List<DescribeClusterSummary> clusters() {
        return clusters;
    }

    /**
     * Token for the next result.
     * 
     * @return Token for the next result.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasClusters() ? clusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResponse)) {
            return false;
        }
        ListClustersResponse other = (ListClustersResponse) obj;
        return hasClusters() == other.hasClusters() && Objects.equals(clusters(), other.clusters())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClustersResponse").add("Clusters", hasClusters() ? clusters() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Clusters":
            return Optional.ofNullable(clazz.cast(clusters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusters", CLUSTERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListClustersResponse, T> g) {
        return obj -> g.apply((ListClustersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListClustersResponse> {
        /**
         * A list of the Clusters that exist in your AWS account.
         * 
         * @param clusters
         *        A list of the Clusters that exist in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(Collection<DescribeClusterSummary> clusters);

        /**
         * A list of the Clusters that exist in your AWS account.
         * 
         * @param clusters
         *        A list of the Clusters that exist in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusters(DescribeClusterSummary... clusters);

        /**
         * A list of the Clusters that exist in your AWS account. This is a convenience method that creates an instance
         * of the {@link software.amazon.awssdk.services.medialive.model.DescribeClusterSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.DescribeClusterSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.DescribeClusterSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #clusters(List<DescribeClusterSummary>)}.
         * 
         * @param clusters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.DescribeClusterSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusters(java.util.Collection<DescribeClusterSummary>)
         */
        Builder clusters(Consumer<DescribeClusterSummary.Builder>... clusters);

        /**
         * Token for the next result.
         * 
         * @param nextToken
         *        Token for the next result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private List<DescribeClusterSummary> clusters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersResponse model) {
            super(model);
            clusters(model.clusters);
            nextToken(model.nextToken);
        }

        public final List<DescribeClusterSummary.Builder> getClusters() {
            List<DescribeClusterSummary.Builder> result = ___listOfDescribeClusterSummaryCopier.copyToBuilder(this.clusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusters(Collection<DescribeClusterSummary.BuilderImpl> clusters) {
            this.clusters = ___listOfDescribeClusterSummaryCopier.copyFromBuilder(clusters);
        }

        @Override
        public final Builder clusters(Collection<DescribeClusterSummary> clusters) {
            this.clusters = ___listOfDescribeClusterSummaryCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(DescribeClusterSummary... clusters) {
            clusters(Arrays.asList(clusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Consumer<DescribeClusterSummary.Builder>... clusters) {
            clusters(Stream.of(clusters).map(c -> DescribeClusterSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListClustersResponse build() {
            return new ListClustersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
