/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An AWS resource used in media workflows.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaResource implements SdkPojo, Serializable, ToCopyableBuilder<MediaResource.Builder, MediaResource> {
    private static final SdkField<List<MediaResourceNeighbor>> DESTINATIONS_FIELD = SdkField
            .<List<MediaResourceNeighbor>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(MediaResource::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaResourceNeighbor> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaResourceNeighbor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(MediaResource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<MediaResourceNeighbor>> SOURCES_FIELD = SdkField
            .<List<MediaResourceNeighbor>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(MediaResource::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaResourceNeighbor> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaResourceNeighbor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATIONS_FIELD,
            NAME_FIELD, SOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<MediaResourceNeighbor> destinations;

    private final String name;

    private final List<MediaResourceNeighbor> sources;

    private MediaResource(BuilderImpl builder) {
        this.destinations = builder.destinations;
        this.name = builder.name;
        this.sources = builder.sources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Destinations property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return The value of the Destinations property for this object.
     */
    public final List<MediaResourceNeighbor> destinations() {
        return destinations;
    }

    /**
     * The logical name of an AWS media resource.
     * 
     * @return The logical name of an AWS media resource.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Sources property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The value of the Sources property for this object.
     */
    public final List<MediaResourceNeighbor> sources() {
        return sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaResource)) {
            return false;
        }
        MediaResource other = (MediaResource) obj;
        return hasDestinations() == other.hasDestinations() && Objects.equals(destinations(), other.destinations())
                && Objects.equals(name(), other.name()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaResource").add("Destinations", hasDestinations() ? destinations() : null)
                .add("Name", name()).add("Sources", hasSources() ? sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinations", DESTINATIONS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("sources", SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaResource, T> g) {
        return obj -> g.apply((MediaResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaResource> {
        /**
         * Sets the value of the Destinations property for this object.
         *
         * @param destinations
         *        The new value for the Destinations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<MediaResourceNeighbor> destinations);

        /**
         * Sets the value of the Destinations property for this object.
         *
         * @param destinations
         *        The new value for the Destinations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(MediaResourceNeighbor... destinations);

        /**
         * Sets the value of the Destinations property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.MediaResourceNeighbor.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.MediaResourceNeighbor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.MediaResourceNeighbor.Builder#build()} is called
         * immediately and its result is passed to {@link #destinations(List<MediaResourceNeighbor>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.MediaResourceNeighbor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(java.util.Collection<MediaResourceNeighbor>)
         */
        Builder destinations(Consumer<MediaResourceNeighbor.Builder>... destinations);

        /**
         * The logical name of an AWS media resource.
         * 
         * @param name
         *        The logical name of an AWS media resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Sources property for this object.
         *
         * @param sources
         *        The new value for the Sources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<MediaResourceNeighbor> sources);

        /**
         * Sets the value of the Sources property for this object.
         *
         * @param sources
         *        The new value for the Sources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(MediaResourceNeighbor... sources);

        /**
         * Sets the value of the Sources property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.MediaResourceNeighbor.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.MediaResourceNeighbor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.MediaResourceNeighbor.Builder#build()} is called
         * immediately and its result is passed to {@link #sources(List<MediaResourceNeighbor>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.MediaResourceNeighbor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<MediaResourceNeighbor>)
         */
        Builder sources(Consumer<MediaResourceNeighbor.Builder>... sources);
    }

    static final class BuilderImpl implements Builder {
        private List<MediaResourceNeighbor> destinations = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private List<MediaResourceNeighbor> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MediaResource model) {
            destinations(model.destinations);
            name(model.name);
            sources(model.sources);
        }

        public final List<MediaResourceNeighbor.Builder> getDestinations() {
            List<MediaResourceNeighbor.Builder> result = ___listOfMediaResourceNeighborCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<MediaResourceNeighbor.BuilderImpl> destinations) {
            this.destinations = ___listOfMediaResourceNeighborCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<MediaResourceNeighbor> destinations) {
            this.destinations = ___listOfMediaResourceNeighborCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(MediaResourceNeighbor... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<MediaResourceNeighbor.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> MediaResourceNeighbor.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<MediaResourceNeighbor.Builder> getSources() {
            List<MediaResourceNeighbor.Builder> result = ___listOfMediaResourceNeighborCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<MediaResourceNeighbor.BuilderImpl> sources) {
            this.sources = ___listOfMediaResourceNeighborCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<MediaResourceNeighbor> sources) {
            this.sources = ___listOfMediaResourceNeighborCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(MediaResourceNeighbor... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<MediaResourceNeighbor.Builder>... sources) {
            sources(Stream.of(sources).map(c -> MediaResourceNeighbor.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public MediaResource build() {
            return new MediaResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
