/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Multicast-specific input settings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MulticastInputSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MulticastInputSettings.Builder, MulticastInputSettings> {
    private static final SdkField<String> SOURCE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceIpAddress").getter(getter(MulticastInputSettings::sourceIpAddress))
            .setter(setter(Builder::sourceIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIpAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IP_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceIpAddress;

    private MulticastInputSettings(BuilderImpl builder) {
        this.sourceIpAddress = builder.sourceIpAddress;
    }

    /**
     * Optionally, a source ip address to filter by for Source-specific Multicast (SSM)
     * 
     * @return Optionally, a source ip address to filter by for Source-specific Multicast (SSM)
     */
    public final String sourceIpAddress() {
        return sourceIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceIpAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MulticastInputSettings)) {
            return false;
        }
        MulticastInputSettings other = (MulticastInputSettings) obj;
        return Objects.equals(sourceIpAddress(), other.sourceIpAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MulticastInputSettings").add("SourceIpAddress", sourceIpAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceIpAddress":
            return Optional.ofNullable(clazz.cast(sourceIpAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceIpAddress", SOURCE_IP_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MulticastInputSettings, T> g) {
        return obj -> g.apply((MulticastInputSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MulticastInputSettings> {
        /**
         * Optionally, a source ip address to filter by for Source-specific Multicast (SSM)
         * 
         * @param sourceIpAddress
         *        Optionally, a source ip address to filter by for Source-specific Multicast (SSM)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIpAddress(String sourceIpAddress);
    }

    static final class BuilderImpl implements Builder {
        private String sourceIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(MulticastInputSettings model) {
            sourceIpAddress(model.sourceIpAddress);
        }

        public final String getSourceIpAddress() {
            return sourceIpAddress;
        }

        public final void setSourceIpAddress(String sourceIpAddress) {
            this.sourceIpAddress = sourceIpAddress;
        }

        @Override
        public final Builder sourceIpAddress(String sourceIpAddress) {
            this.sourceIpAddress = sourceIpAddress;
            return this;
        }

        @Override
        public MulticastInputSettings build() {
            return new MulticastInputSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
