/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Multiplex M2ts Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiplexM2tsSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiplexM2tsSettings.Builder, MultiplexM2tsSettings> {
    private static final SdkField<String> ABSENT_INPUT_AUDIO_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AbsentInputAudioBehavior").getter(getter(MultiplexM2tsSettings::absentInputAudioBehaviorAsString))
            .setter(setter(Builder::absentInputAudioBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("absentInputAudioBehavior").build())
            .build();

    private static final SdkField<String> ARIB_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arib")
            .getter(getter(MultiplexM2tsSettings::aribAsString)).setter(setter(Builder::arib))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arib").build()).build();

    private static final SdkField<String> AUDIO_BUFFER_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioBufferModel").getter(getter(MultiplexM2tsSettings::audioBufferModelAsString))
            .setter(setter(Builder::audioBufferModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioBufferModel").build()).build();

    private static final SdkField<Integer> AUDIO_FRAMES_PER_PES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AudioFramesPerPes").getter(getter(MultiplexM2tsSettings::audioFramesPerPes))
            .setter(setter(Builder::audioFramesPerPes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioFramesPerPes").build()).build();

    private static final SdkField<String> AUDIO_STREAM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioStreamType").getter(getter(MultiplexM2tsSettings::audioStreamTypeAsString))
            .setter(setter(Builder::audioStreamType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioStreamType").build()).build();

    private static final SdkField<String> CC_DESCRIPTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CcDescriptor").getter(getter(MultiplexM2tsSettings::ccDescriptorAsString))
            .setter(setter(Builder::ccDescriptor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ccDescriptor").build()).build();

    private static final SdkField<String> EBIF_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Ebif")
            .getter(getter(MultiplexM2tsSettings::ebifAsString)).setter(setter(Builder::ebif))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebif").build()).build();

    private static final SdkField<String> ES_RATE_IN_PES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EsRateInPes").getter(getter(MultiplexM2tsSettings::esRateInPesAsString))
            .setter(setter(Builder::esRateInPes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("esRateInPes").build()).build();

    private static final SdkField<String> KLV_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Klv")
            .getter(getter(MultiplexM2tsSettings::klvAsString)).setter(setter(Builder::klv))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("klv").build()).build();

    private static final SdkField<String> NIELSEN_ID3_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NielsenId3Behavior").getter(getter(MultiplexM2tsSettings::nielsenId3BehaviorAsString))
            .setter(setter(Builder::nielsenId3Behavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenId3Behavior").build())
            .build();

    private static final SdkField<String> PCR_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PcrControl").getter(getter(MultiplexM2tsSettings::pcrControlAsString))
            .setter(setter(Builder::pcrControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pcrControl").build()).build();

    private static final SdkField<Integer> PCR_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PcrPeriod").getter(getter(MultiplexM2tsSettings::pcrPeriod)).setter(setter(Builder::pcrPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pcrPeriod").build()).build();

    private static final SdkField<String> SCTE35_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Scte35Control").getter(getter(MultiplexM2tsSettings::scte35ControlAsString))
            .setter(setter(Builder::scte35Control))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Control").build()).build();

    private static final SdkField<Double> SCTE35_PREROLL_PULLUP_MILLISECONDS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("Scte35PrerollPullupMilliseconds")
            .getter(getter(MultiplexM2tsSettings::scte35PrerollPullupMilliseconds))
            .setter(setter(Builder::scte35PrerollPullupMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35PrerollPullupMilliseconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ABSENT_INPUT_AUDIO_BEHAVIOR_FIELD, ARIB_FIELD, AUDIO_BUFFER_MODEL_FIELD, AUDIO_FRAMES_PER_PES_FIELD,
            AUDIO_STREAM_TYPE_FIELD, CC_DESCRIPTOR_FIELD, EBIF_FIELD, ES_RATE_IN_PES_FIELD, KLV_FIELD,
            NIELSEN_ID3_BEHAVIOR_FIELD, PCR_CONTROL_FIELD, PCR_PERIOD_FIELD, SCTE35_CONTROL_FIELD,
            SCTE35_PREROLL_PULLUP_MILLISECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String absentInputAudioBehavior;

    private final String arib;

    private final String audioBufferModel;

    private final Integer audioFramesPerPes;

    private final String audioStreamType;

    private final String ccDescriptor;

    private final String ebif;

    private final String esRateInPes;

    private final String klv;

    private final String nielsenId3Behavior;

    private final String pcrControl;

    private final Integer pcrPeriod;

    private final String scte35Control;

    private final Double scte35PrerollPullupMilliseconds;

    private MultiplexM2tsSettings(BuilderImpl builder) {
        this.absentInputAudioBehavior = builder.absentInputAudioBehavior;
        this.arib = builder.arib;
        this.audioBufferModel = builder.audioBufferModel;
        this.audioFramesPerPes = builder.audioFramesPerPes;
        this.audioStreamType = builder.audioStreamType;
        this.ccDescriptor = builder.ccDescriptor;
        this.ebif = builder.ebif;
        this.esRateInPes = builder.esRateInPes;
        this.klv = builder.klv;
        this.nielsenId3Behavior = builder.nielsenId3Behavior;
        this.pcrControl = builder.pcrControl;
        this.pcrPeriod = builder.pcrPeriod;
        this.scte35Control = builder.scte35Control;
        this.scte35PrerollPullupMilliseconds = builder.scte35PrerollPullupMilliseconds;
    }

    /**
     * When set to drop, output audio streams will be removed from the program if the selected input audio stream is
     * removed from the input. This allows the output audio configuration to dynamically change based on input
     * configuration. If this is set to encodeSilence, all output audio streams will output encoded silence when not
     * connected to an active input stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #absentInputAudioBehavior} will return {@link M2tsAbsentInputAudioBehavior#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #absentInputAudioBehaviorAsString}.
     * </p>
     * 
     * @return When set to drop, output audio streams will be removed from the program if the selected input audio
     *         stream is removed from the input. This allows the output audio configuration to dynamically change based
     *         on input configuration. If this is set to encodeSilence, all output audio streams will output encoded
     *         silence when not connected to an active input stream.
     * @see M2tsAbsentInputAudioBehavior
     */
    public final M2tsAbsentInputAudioBehavior absentInputAudioBehavior() {
        return M2tsAbsentInputAudioBehavior.fromValue(absentInputAudioBehavior);
    }

    /**
     * When set to drop, output audio streams will be removed from the program if the selected input audio stream is
     * removed from the input. This allows the output audio configuration to dynamically change based on input
     * configuration. If this is set to encodeSilence, all output audio streams will output encoded silence when not
     * connected to an active input stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #absentInputAudioBehavior} will return {@link M2tsAbsentInputAudioBehavior#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #absentInputAudioBehaviorAsString}.
     * </p>
     * 
     * @return When set to drop, output audio streams will be removed from the program if the selected input audio
     *         stream is removed from the input. This allows the output audio configuration to dynamically change based
     *         on input configuration. If this is set to encodeSilence, all output audio streams will output encoded
     *         silence when not connected to an active input stream.
     * @see M2tsAbsentInputAudioBehavior
     */
    public final String absentInputAudioBehaviorAsString() {
        return absentInputAudioBehavior;
    }

    /**
     * When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #arib} will return
     * {@link M2tsArib#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aribAsString}.
     * </p>
     * 
     * @return When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
     * @see M2tsArib
     */
    public final M2tsArib arib() {
        return M2tsArib.fromValue(arib);
    }

    /**
     * When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #arib} will return
     * {@link M2tsArib#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aribAsString}.
     * </p>
     * 
     * @return When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
     * @see M2tsArib
     */
    public final String aribAsString() {
        return arib;
    }

    /**
     * When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is used.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioBufferModel}
     * will return {@link M2tsAudioBufferModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #audioBufferModelAsString}.
     * </p>
     * 
     * @return When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is used.
     * @see M2tsAudioBufferModel
     */
    public final M2tsAudioBufferModel audioBufferModel() {
        return M2tsAudioBufferModel.fromValue(audioBufferModel);
    }

    /**
     * When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is used.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioBufferModel}
     * will return {@link M2tsAudioBufferModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #audioBufferModelAsString}.
     * </p>
     * 
     * @return When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is used.
     * @see M2tsAudioBufferModel
     */
    public final String audioBufferModelAsString() {
        return audioBufferModel;
    }

    /**
     * The number of audio frames to insert for each PES packet.
     * 
     * @return The number of audio frames to insert for each PES packet.
     */
    public final Integer audioFramesPerPes() {
        return audioFramesPerPes;
    }

    /**
     * When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses stream
     * type = 0x06.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioStreamType}
     * will return {@link M2tsAudioStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #audioStreamTypeAsString}.
     * </p>
     * 
     * @return When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses
     *         stream type = 0x06.
     * @see M2tsAudioStreamType
     */
    public final M2tsAudioStreamType audioStreamType() {
        return M2tsAudioStreamType.fromValue(audioStreamType);
    }

    /**
     * When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses stream
     * type = 0x06.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioStreamType}
     * will return {@link M2tsAudioStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #audioStreamTypeAsString}.
     * </p>
     * 
     * @return When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses
     *         stream type = 0x06.
     * @see M2tsAudioStreamType
     */
    public final String audioStreamTypeAsString() {
        return audioStreamType;
    }

    /**
     * When set to enabled, generates captionServiceDescriptor in PMT.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ccDescriptor} will
     * return {@link M2tsCcDescriptor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ccDescriptorAsString}.
     * </p>
     * 
     * @return When set to enabled, generates captionServiceDescriptor in PMT.
     * @see M2tsCcDescriptor
     */
    public final M2tsCcDescriptor ccDescriptor() {
        return M2tsCcDescriptor.fromValue(ccDescriptor);
    }

    /**
     * When set to enabled, generates captionServiceDescriptor in PMT.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ccDescriptor} will
     * return {@link M2tsCcDescriptor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ccDescriptorAsString}.
     * </p>
     * 
     * @return When set to enabled, generates captionServiceDescriptor in PMT.
     * @see M2tsCcDescriptor
     */
    public final String ccDescriptorAsString() {
        return ccDescriptor;
    }

    /**
     * If set to passthrough, passes any EBIF data from the input source to this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ebif} will return
     * {@link M2tsEbifControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ebifAsString}.
     * </p>
     * 
     * @return If set to passthrough, passes any EBIF data from the input source to this output.
     * @see M2tsEbifControl
     */
    public final M2tsEbifControl ebif() {
        return M2tsEbifControl.fromValue(ebif);
    }

    /**
     * If set to passthrough, passes any EBIF data from the input source to this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ebif} will return
     * {@link M2tsEbifControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ebifAsString}.
     * </p>
     * 
     * @return If set to passthrough, passes any EBIF data from the input source to this output.
     * @see M2tsEbifControl
     */
    public final String ebifAsString() {
        return ebif;
    }

    /**
     * Include or exclude the ES Rate field in the PES header.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #esRateInPes} will
     * return {@link M2tsEsRateInPes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #esRateInPesAsString}.
     * </p>
     * 
     * @return Include or exclude the ES Rate field in the PES header.
     * @see M2tsEsRateInPes
     */
    public final M2tsEsRateInPes esRateInPes() {
        return M2tsEsRateInPes.fromValue(esRateInPes);
    }

    /**
     * Include or exclude the ES Rate field in the PES header.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #esRateInPes} will
     * return {@link M2tsEsRateInPes#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #esRateInPesAsString}.
     * </p>
     * 
     * @return Include or exclude the ES Rate field in the PES header.
     * @see M2tsEsRateInPes
     */
    public final String esRateInPesAsString() {
        return esRateInPes;
    }

    /**
     * If set to passthrough, passes any KLV data from the input source to this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #klv} will return
     * {@link M2tsKlv#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #klvAsString}.
     * </p>
     * 
     * @return If set to passthrough, passes any KLV data from the input source to this output.
     * @see M2tsKlv
     */
    public final M2tsKlv klv() {
        return M2tsKlv.fromValue(klv);
    }

    /**
     * If set to passthrough, passes any KLV data from the input source to this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #klv} will return
     * {@link M2tsKlv#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #klvAsString}.
     * </p>
     * 
     * @return If set to passthrough, passes any KLV data from the input source to this output.
     * @see M2tsKlv
     */
    public final String klvAsString() {
        return klv;
    }

    /**
     * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
     * equivalent ID3 tag will be inserted in the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nielsenId3Behavior} will return {@link M2tsNielsenId3Behavior#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nielsenId3BehaviorAsString}.
     * </p>
     * 
     * @return If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and
     *         an equivalent ID3 tag will be inserted in the output.
     * @see M2tsNielsenId3Behavior
     */
    public final M2tsNielsenId3Behavior nielsenId3Behavior() {
        return M2tsNielsenId3Behavior.fromValue(nielsenId3Behavior);
    }

    /**
     * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
     * equivalent ID3 tag will be inserted in the output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nielsenId3Behavior} will return {@link M2tsNielsenId3Behavior#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nielsenId3BehaviorAsString}.
     * </p>
     * 
     * @return If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and
     *         an equivalent ID3 tag will be inserted in the output.
     * @see M2tsNielsenId3Behavior
     */
    public final String nielsenId3BehaviorAsString() {
        return nielsenId3Behavior;
    }

    /**
     * When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream
     * (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary
     * stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pcrControl} will
     * return {@link M2tsPcrControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pcrControlAsString}.
     * </p>
     * 
     * @return When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized
     *         Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the
     *         video or audio elementary stream.
     * @see M2tsPcrControl
     */
    public final M2tsPcrControl pcrControl() {
        return M2tsPcrControl.fromValue(pcrControl);
    }

    /**
     * When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream
     * (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary
     * stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pcrControl} will
     * return {@link M2tsPcrControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pcrControlAsString}.
     * </p>
     * 
     * @return When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized
     *         Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the
     *         video or audio elementary stream.
     * @see M2tsPcrControl
     */
    public final String pcrControlAsString() {
        return pcrControl;
    }

    /**
     * Maximum time in milliseconds between Program Clock Reference (PCRs) inserted into the transport stream.
     * 
     * @return Maximum time in milliseconds between Program Clock Reference (PCRs) inserted into the transport stream.
     */
    public final Integer pcrPeriod() {
        return pcrPeriod;
    }

    /**
     * Optionally pass SCTE-35 signals from the input source to this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Control}
     * will return {@link M2tsScte35Control#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scte35ControlAsString}.
     * </p>
     * 
     * @return Optionally pass SCTE-35 signals from the input source to this output.
     * @see M2tsScte35Control
     */
    public final M2tsScte35Control scte35Control() {
        return M2tsScte35Control.fromValue(scte35Control);
    }

    /**
     * Optionally pass SCTE-35 signals from the input source to this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Control}
     * will return {@link M2tsScte35Control#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scte35ControlAsString}.
     * </p>
     * 
     * @return Optionally pass SCTE-35 signals from the input source to this output.
     * @see M2tsScte35Control
     */
    public final String scte35ControlAsString() {
        return scte35Control;
    }

    /**
     * Defines the amount SCTE-35 preroll will be increased (in milliseconds) on the output. Preroll is the amount of
     * time between the presence of a SCTE-35 indication in a transport stream and the PTS of the video frame it
     * references. Zero means don't add pullup (it doesn't mean set the preroll to zero). Negative pullup is not
     * supported, which means that you can't make the preroll shorter. Be aware that latency in the output will increase
     * by the pullup amount.
     * 
     * @return Defines the amount SCTE-35 preroll will be increased (in milliseconds) on the output. Preroll is the
     *         amount of time between the presence of a SCTE-35 indication in a transport stream and the PTS of the
     *         video frame it references. Zero means don't add pullup (it doesn't mean set the preroll to zero).
     *         Negative pullup is not supported, which means that you can't make the preroll shorter. Be aware that
     *         latency in the output will increase by the pullup amount.
     */
    public final Double scte35PrerollPullupMilliseconds() {
        return scte35PrerollPullupMilliseconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(absentInputAudioBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aribAsString());
        hashCode = 31 * hashCode + Objects.hashCode(audioBufferModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(audioFramesPerPes());
        hashCode = 31 * hashCode + Objects.hashCode(audioStreamTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ccDescriptorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ebifAsString());
        hashCode = 31 * hashCode + Objects.hashCode(esRateInPesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(klvAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nielsenId3BehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pcrControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pcrPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(scte35ControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scte35PrerollPullupMilliseconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexM2tsSettings)) {
            return false;
        }
        MultiplexM2tsSettings other = (MultiplexM2tsSettings) obj;
        return Objects.equals(absentInputAudioBehaviorAsString(), other.absentInputAudioBehaviorAsString())
                && Objects.equals(aribAsString(), other.aribAsString())
                && Objects.equals(audioBufferModelAsString(), other.audioBufferModelAsString())
                && Objects.equals(audioFramesPerPes(), other.audioFramesPerPes())
                && Objects.equals(audioStreamTypeAsString(), other.audioStreamTypeAsString())
                && Objects.equals(ccDescriptorAsString(), other.ccDescriptorAsString())
                && Objects.equals(ebifAsString(), other.ebifAsString())
                && Objects.equals(esRateInPesAsString(), other.esRateInPesAsString())
                && Objects.equals(klvAsString(), other.klvAsString())
                && Objects.equals(nielsenId3BehaviorAsString(), other.nielsenId3BehaviorAsString())
                && Objects.equals(pcrControlAsString(), other.pcrControlAsString())
                && Objects.equals(pcrPeriod(), other.pcrPeriod())
                && Objects.equals(scte35ControlAsString(), other.scte35ControlAsString())
                && Objects.equals(scte35PrerollPullupMilliseconds(), other.scte35PrerollPullupMilliseconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiplexM2tsSettings").add("AbsentInputAudioBehavior", absentInputAudioBehaviorAsString())
                .add("Arib", aribAsString()).add("AudioBufferModel", audioBufferModelAsString())
                .add("AudioFramesPerPes", audioFramesPerPes()).add("AudioStreamType", audioStreamTypeAsString())
                .add("CcDescriptor", ccDescriptorAsString()).add("Ebif", ebifAsString())
                .add("EsRateInPes", esRateInPesAsString()).add("Klv", klvAsString())
                .add("NielsenId3Behavior", nielsenId3BehaviorAsString()).add("PcrControl", pcrControlAsString())
                .add("PcrPeriod", pcrPeriod()).add("Scte35Control", scte35ControlAsString())
                .add("Scte35PrerollPullupMilliseconds", scte35PrerollPullupMilliseconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AbsentInputAudioBehavior":
            return Optional.ofNullable(clazz.cast(absentInputAudioBehaviorAsString()));
        case "Arib":
            return Optional.ofNullable(clazz.cast(aribAsString()));
        case "AudioBufferModel":
            return Optional.ofNullable(clazz.cast(audioBufferModelAsString()));
        case "AudioFramesPerPes":
            return Optional.ofNullable(clazz.cast(audioFramesPerPes()));
        case "AudioStreamType":
            return Optional.ofNullable(clazz.cast(audioStreamTypeAsString()));
        case "CcDescriptor":
            return Optional.ofNullable(clazz.cast(ccDescriptorAsString()));
        case "Ebif":
            return Optional.ofNullable(clazz.cast(ebifAsString()));
        case "EsRateInPes":
            return Optional.ofNullable(clazz.cast(esRateInPesAsString()));
        case "Klv":
            return Optional.ofNullable(clazz.cast(klvAsString()));
        case "NielsenId3Behavior":
            return Optional.ofNullable(clazz.cast(nielsenId3BehaviorAsString()));
        case "PcrControl":
            return Optional.ofNullable(clazz.cast(pcrControlAsString()));
        case "PcrPeriod":
            return Optional.ofNullable(clazz.cast(pcrPeriod()));
        case "Scte35Control":
            return Optional.ofNullable(clazz.cast(scte35ControlAsString()));
        case "Scte35PrerollPullupMilliseconds":
            return Optional.ofNullable(clazz.cast(scte35PrerollPullupMilliseconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("absentInputAudioBehavior", ABSENT_INPUT_AUDIO_BEHAVIOR_FIELD);
        map.put("arib", ARIB_FIELD);
        map.put("audioBufferModel", AUDIO_BUFFER_MODEL_FIELD);
        map.put("audioFramesPerPes", AUDIO_FRAMES_PER_PES_FIELD);
        map.put("audioStreamType", AUDIO_STREAM_TYPE_FIELD);
        map.put("ccDescriptor", CC_DESCRIPTOR_FIELD);
        map.put("ebif", EBIF_FIELD);
        map.put("esRateInPes", ES_RATE_IN_PES_FIELD);
        map.put("klv", KLV_FIELD);
        map.put("nielsenId3Behavior", NIELSEN_ID3_BEHAVIOR_FIELD);
        map.put("pcrControl", PCR_CONTROL_FIELD);
        map.put("pcrPeriod", PCR_PERIOD_FIELD);
        map.put("scte35Control", SCTE35_CONTROL_FIELD);
        map.put("scte35PrerollPullupMilliseconds", SCTE35_PREROLL_PULLUP_MILLISECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiplexM2tsSettings, T> g) {
        return obj -> g.apply((MultiplexM2tsSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiplexM2tsSettings> {
        /**
         * When set to drop, output audio streams will be removed from the program if the selected input audio stream is
         * removed from the input. This allows the output audio configuration to dynamically change based on input
         * configuration. If this is set to encodeSilence, all output audio streams will output encoded silence when not
         * connected to an active input stream.
         * 
         * @param absentInputAudioBehavior
         *        When set to drop, output audio streams will be removed from the program if the selected input audio
         *        stream is removed from the input. This allows the output audio configuration to dynamically change
         *        based on input configuration. If this is set to encodeSilence, all output audio streams will output
         *        encoded silence when not connected to an active input stream.
         * @see M2tsAbsentInputAudioBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsAbsentInputAudioBehavior
         */
        Builder absentInputAudioBehavior(String absentInputAudioBehavior);

        /**
         * When set to drop, output audio streams will be removed from the program if the selected input audio stream is
         * removed from the input. This allows the output audio configuration to dynamically change based on input
         * configuration. If this is set to encodeSilence, all output audio streams will output encoded silence when not
         * connected to an active input stream.
         * 
         * @param absentInputAudioBehavior
         *        When set to drop, output audio streams will be removed from the program if the selected input audio
         *        stream is removed from the input. This allows the output audio configuration to dynamically change
         *        based on input configuration. If this is set to encodeSilence, all output audio streams will output
         *        encoded silence when not connected to an active input stream.
         * @see M2tsAbsentInputAudioBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsAbsentInputAudioBehavior
         */
        Builder absentInputAudioBehavior(M2tsAbsentInputAudioBehavior absentInputAudioBehavior);

        /**
         * When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
         * 
         * @param arib
         *        When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
         * @see M2tsArib
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsArib
         */
        Builder arib(String arib);

        /**
         * When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
         * 
         * @param arib
         *        When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
         * @see M2tsArib
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsArib
         */
        Builder arib(M2tsArib arib);

        /**
         * When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is used.
         * 
         * @param audioBufferModel
         *        When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is
         *        used.
         * @see M2tsAudioBufferModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsAudioBufferModel
         */
        Builder audioBufferModel(String audioBufferModel);

        /**
         * When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is used.
         * 
         * @param audioBufferModel
         *        When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is
         *        used.
         * @see M2tsAudioBufferModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsAudioBufferModel
         */
        Builder audioBufferModel(M2tsAudioBufferModel audioBufferModel);

        /**
         * The number of audio frames to insert for each PES packet.
         * 
         * @param audioFramesPerPes
         *        The number of audio frames to insert for each PES packet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioFramesPerPes(Integer audioFramesPerPes);

        /**
         * When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses
         * stream type = 0x06.
         * 
         * @param audioStreamType
         *        When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb,
         *        uses stream type = 0x06.
         * @see M2tsAudioStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsAudioStreamType
         */
        Builder audioStreamType(String audioStreamType);

        /**
         * When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses
         * stream type = 0x06.
         * 
         * @param audioStreamType
         *        When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb,
         *        uses stream type = 0x06.
         * @see M2tsAudioStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsAudioStreamType
         */
        Builder audioStreamType(M2tsAudioStreamType audioStreamType);

        /**
         * When set to enabled, generates captionServiceDescriptor in PMT.
         * 
         * @param ccDescriptor
         *        When set to enabled, generates captionServiceDescriptor in PMT.
         * @see M2tsCcDescriptor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsCcDescriptor
         */
        Builder ccDescriptor(String ccDescriptor);

        /**
         * When set to enabled, generates captionServiceDescriptor in PMT.
         * 
         * @param ccDescriptor
         *        When set to enabled, generates captionServiceDescriptor in PMT.
         * @see M2tsCcDescriptor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsCcDescriptor
         */
        Builder ccDescriptor(M2tsCcDescriptor ccDescriptor);

        /**
         * If set to passthrough, passes any EBIF data from the input source to this output.
         * 
         * @param ebif
         *        If set to passthrough, passes any EBIF data from the input source to this output.
         * @see M2tsEbifControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsEbifControl
         */
        Builder ebif(String ebif);

        /**
         * If set to passthrough, passes any EBIF data from the input source to this output.
         * 
         * @param ebif
         *        If set to passthrough, passes any EBIF data from the input source to this output.
         * @see M2tsEbifControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsEbifControl
         */
        Builder ebif(M2tsEbifControl ebif);

        /**
         * Include or exclude the ES Rate field in the PES header.
         * 
         * @param esRateInPes
         *        Include or exclude the ES Rate field in the PES header.
         * @see M2tsEsRateInPes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsEsRateInPes
         */
        Builder esRateInPes(String esRateInPes);

        /**
         * Include or exclude the ES Rate field in the PES header.
         * 
         * @param esRateInPes
         *        Include or exclude the ES Rate field in the PES header.
         * @see M2tsEsRateInPes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsEsRateInPes
         */
        Builder esRateInPes(M2tsEsRateInPes esRateInPes);

        /**
         * If set to passthrough, passes any KLV data from the input source to this output.
         * 
         * @param klv
         *        If set to passthrough, passes any KLV data from the input source to this output.
         * @see M2tsKlv
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsKlv
         */
        Builder klv(String klv);

        /**
         * If set to passthrough, passes any KLV data from the input source to this output.
         * 
         * @param klv
         *        If set to passthrough, passes any KLV data from the input source to this output.
         * @see M2tsKlv
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsKlv
         */
        Builder klv(M2tsKlv klv);

        /**
         * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
         * equivalent ID3 tag will be inserted in the output.
         * 
         * @param nielsenId3Behavior
         *        If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio
         *        and an equivalent ID3 tag will be inserted in the output.
         * @see M2tsNielsenId3Behavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsNielsenId3Behavior
         */
        Builder nielsenId3Behavior(String nielsenId3Behavior);

        /**
         * If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an
         * equivalent ID3 tag will be inserted in the output.
         * 
         * @param nielsenId3Behavior
         *        If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio
         *        and an equivalent ID3 tag will be inserted in the output.
         * @see M2tsNielsenId3Behavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsNielsenId3Behavior
         */
        Builder nielsenId3Behavior(M2tsNielsenId3Behavior nielsenId3Behavior);

        /**
         * When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary
         * Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio
         * elementary stream.
         * 
         * @param pcrControl
         *        When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized
         *        Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the
         *        video or audio elementary stream.
         * @see M2tsPcrControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsPcrControl
         */
        Builder pcrControl(String pcrControl);

        /**
         * When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary
         * Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio
         * elementary stream.
         * 
         * @param pcrControl
         *        When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized
         *        Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the
         *        video or audio elementary stream.
         * @see M2tsPcrControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsPcrControl
         */
        Builder pcrControl(M2tsPcrControl pcrControl);

        /**
         * Maximum time in milliseconds between Program Clock Reference (PCRs) inserted into the transport stream.
         * 
         * @param pcrPeriod
         *        Maximum time in milliseconds between Program Clock Reference (PCRs) inserted into the transport
         *        stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pcrPeriod(Integer pcrPeriod);

        /**
         * Optionally pass SCTE-35 signals from the input source to this output.
         * 
         * @param scte35Control
         *        Optionally pass SCTE-35 signals from the input source to this output.
         * @see M2tsScte35Control
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsScte35Control
         */
        Builder scte35Control(String scte35Control);

        /**
         * Optionally pass SCTE-35 signals from the input source to this output.
         * 
         * @param scte35Control
         *        Optionally pass SCTE-35 signals from the input source to this output.
         * @see M2tsScte35Control
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2tsScte35Control
         */
        Builder scte35Control(M2tsScte35Control scte35Control);

        /**
         * Defines the amount SCTE-35 preroll will be increased (in milliseconds) on the output. Preroll is the amount
         * of time between the presence of a SCTE-35 indication in a transport stream and the PTS of the video frame it
         * references. Zero means don't add pullup (it doesn't mean set the preroll to zero). Negative pullup is not
         * supported, which means that you can't make the preroll shorter. Be aware that latency in the output will
         * increase by the pullup amount.
         * 
         * @param scte35PrerollPullupMilliseconds
         *        Defines the amount SCTE-35 preroll will be increased (in milliseconds) on the output. Preroll is the
         *        amount of time between the presence of a SCTE-35 indication in a transport stream and the PTS of the
         *        video frame it references. Zero means don't add pullup (it doesn't mean set the preroll to zero).
         *        Negative pullup is not supported, which means that you can't make the preroll shorter. Be aware that
         *        latency in the output will increase by the pullup amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte35PrerollPullupMilliseconds(Double scte35PrerollPullupMilliseconds);
    }

    static final class BuilderImpl implements Builder {
        private String absentInputAudioBehavior;

        private String arib;

        private String audioBufferModel;

        private Integer audioFramesPerPes;

        private String audioStreamType;

        private String ccDescriptor;

        private String ebif;

        private String esRateInPes;

        private String klv;

        private String nielsenId3Behavior;

        private String pcrControl;

        private Integer pcrPeriod;

        private String scte35Control;

        private Double scte35PrerollPullupMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexM2tsSettings model) {
            absentInputAudioBehavior(model.absentInputAudioBehavior);
            arib(model.arib);
            audioBufferModel(model.audioBufferModel);
            audioFramesPerPes(model.audioFramesPerPes);
            audioStreamType(model.audioStreamType);
            ccDescriptor(model.ccDescriptor);
            ebif(model.ebif);
            esRateInPes(model.esRateInPes);
            klv(model.klv);
            nielsenId3Behavior(model.nielsenId3Behavior);
            pcrControl(model.pcrControl);
            pcrPeriod(model.pcrPeriod);
            scte35Control(model.scte35Control);
            scte35PrerollPullupMilliseconds(model.scte35PrerollPullupMilliseconds);
        }

        public final String getAbsentInputAudioBehavior() {
            return absentInputAudioBehavior;
        }

        public final void setAbsentInputAudioBehavior(String absentInputAudioBehavior) {
            this.absentInputAudioBehavior = absentInputAudioBehavior;
        }

        @Override
        public final Builder absentInputAudioBehavior(String absentInputAudioBehavior) {
            this.absentInputAudioBehavior = absentInputAudioBehavior;
            return this;
        }

        @Override
        public final Builder absentInputAudioBehavior(M2tsAbsentInputAudioBehavior absentInputAudioBehavior) {
            this.absentInputAudioBehavior(absentInputAudioBehavior == null ? null : absentInputAudioBehavior.toString());
            return this;
        }

        public final String getArib() {
            return arib;
        }

        public final void setArib(String arib) {
            this.arib = arib;
        }

        @Override
        public final Builder arib(String arib) {
            this.arib = arib;
            return this;
        }

        @Override
        public final Builder arib(M2tsArib arib) {
            this.arib(arib == null ? null : arib.toString());
            return this;
        }

        public final String getAudioBufferModel() {
            return audioBufferModel;
        }

        public final void setAudioBufferModel(String audioBufferModel) {
            this.audioBufferModel = audioBufferModel;
        }

        @Override
        public final Builder audioBufferModel(String audioBufferModel) {
            this.audioBufferModel = audioBufferModel;
            return this;
        }

        @Override
        public final Builder audioBufferModel(M2tsAudioBufferModel audioBufferModel) {
            this.audioBufferModel(audioBufferModel == null ? null : audioBufferModel.toString());
            return this;
        }

        public final Integer getAudioFramesPerPes() {
            return audioFramesPerPes;
        }

        public final void setAudioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
        }

        @Override
        public final Builder audioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
            return this;
        }

        public final String getAudioStreamType() {
            return audioStreamType;
        }

        public final void setAudioStreamType(String audioStreamType) {
            this.audioStreamType = audioStreamType;
        }

        @Override
        public final Builder audioStreamType(String audioStreamType) {
            this.audioStreamType = audioStreamType;
            return this;
        }

        @Override
        public final Builder audioStreamType(M2tsAudioStreamType audioStreamType) {
            this.audioStreamType(audioStreamType == null ? null : audioStreamType.toString());
            return this;
        }

        public final String getCcDescriptor() {
            return ccDescriptor;
        }

        public final void setCcDescriptor(String ccDescriptor) {
            this.ccDescriptor = ccDescriptor;
        }

        @Override
        public final Builder ccDescriptor(String ccDescriptor) {
            this.ccDescriptor = ccDescriptor;
            return this;
        }

        @Override
        public final Builder ccDescriptor(M2tsCcDescriptor ccDescriptor) {
            this.ccDescriptor(ccDescriptor == null ? null : ccDescriptor.toString());
            return this;
        }

        public final String getEbif() {
            return ebif;
        }

        public final void setEbif(String ebif) {
            this.ebif = ebif;
        }

        @Override
        public final Builder ebif(String ebif) {
            this.ebif = ebif;
            return this;
        }

        @Override
        public final Builder ebif(M2tsEbifControl ebif) {
            this.ebif(ebif == null ? null : ebif.toString());
            return this;
        }

        public final String getEsRateInPes() {
            return esRateInPes;
        }

        public final void setEsRateInPes(String esRateInPes) {
            this.esRateInPes = esRateInPes;
        }

        @Override
        public final Builder esRateInPes(String esRateInPes) {
            this.esRateInPes = esRateInPes;
            return this;
        }

        @Override
        public final Builder esRateInPes(M2tsEsRateInPes esRateInPes) {
            this.esRateInPes(esRateInPes == null ? null : esRateInPes.toString());
            return this;
        }

        public final String getKlv() {
            return klv;
        }

        public final void setKlv(String klv) {
            this.klv = klv;
        }

        @Override
        public final Builder klv(String klv) {
            this.klv = klv;
            return this;
        }

        @Override
        public final Builder klv(M2tsKlv klv) {
            this.klv(klv == null ? null : klv.toString());
            return this;
        }

        public final String getNielsenId3Behavior() {
            return nielsenId3Behavior;
        }

        public final void setNielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
        }

        @Override
        public final Builder nielsenId3Behavior(String nielsenId3Behavior) {
            this.nielsenId3Behavior = nielsenId3Behavior;
            return this;
        }

        @Override
        public final Builder nielsenId3Behavior(M2tsNielsenId3Behavior nielsenId3Behavior) {
            this.nielsenId3Behavior(nielsenId3Behavior == null ? null : nielsenId3Behavior.toString());
            return this;
        }

        public final String getPcrControl() {
            return pcrControl;
        }

        public final void setPcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
        }

        @Override
        public final Builder pcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
            return this;
        }

        @Override
        public final Builder pcrControl(M2tsPcrControl pcrControl) {
            this.pcrControl(pcrControl == null ? null : pcrControl.toString());
            return this;
        }

        public final Integer getPcrPeriod() {
            return pcrPeriod;
        }

        public final void setPcrPeriod(Integer pcrPeriod) {
            this.pcrPeriod = pcrPeriod;
        }

        @Override
        public final Builder pcrPeriod(Integer pcrPeriod) {
            this.pcrPeriod = pcrPeriod;
            return this;
        }

        public final String getScte35Control() {
            return scte35Control;
        }

        public final void setScte35Control(String scte35Control) {
            this.scte35Control = scte35Control;
        }

        @Override
        public final Builder scte35Control(String scte35Control) {
            this.scte35Control = scte35Control;
            return this;
        }

        @Override
        public final Builder scte35Control(M2tsScte35Control scte35Control) {
            this.scte35Control(scte35Control == null ? null : scte35Control.toString());
            return this;
        }

        public final Double getScte35PrerollPullupMilliseconds() {
            return scte35PrerollPullupMilliseconds;
        }

        public final void setScte35PrerollPullupMilliseconds(Double scte35PrerollPullupMilliseconds) {
            this.scte35PrerollPullupMilliseconds = scte35PrerollPullupMilliseconds;
        }

        @Override
        public final Builder scte35PrerollPullupMilliseconds(Double scte35PrerollPullupMilliseconds) {
            this.scte35PrerollPullupMilliseconds = scte35PrerollPullupMilliseconds;
            return this;
        }

        @Override
        public MultiplexM2tsSettings build() {
            return new MultiplexM2tsSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
