/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Packet identifiers map for a given Multiplex program.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiplexProgramPacketIdentifiersMap implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiplexProgramPacketIdentifiersMap.Builder, MultiplexProgramPacketIdentifiersMap> {
    private static final SdkField<List<Integer>> AUDIO_PIDS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("AudioPids")
            .getter(getter(MultiplexProgramPacketIdentifiersMap::audioPids))
            .setter(setter(Builder::audioPids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioPids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Integer>> DVB_SUB_PIDS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("DvbSubPids")
            .getter(getter(MultiplexProgramPacketIdentifiersMap::dvbSubPids))
            .setter(setter(Builder::dvbSubPids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbSubPids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> DVB_TELETEXT_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DvbTeletextPid").getter(getter(MultiplexProgramPacketIdentifiersMap::dvbTeletextPid))
            .setter(setter(Builder::dvbTeletextPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbTeletextPid").build()).build();

    private static final SdkField<Integer> ETV_PLATFORM_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EtvPlatformPid").getter(getter(MultiplexProgramPacketIdentifiersMap::etvPlatformPid))
            .setter(setter(Builder::etvPlatformPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("etvPlatformPid").build()).build();

    private static final SdkField<Integer> ETV_SIGNAL_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EtvSignalPid").getter(getter(MultiplexProgramPacketIdentifiersMap::etvSignalPid))
            .setter(setter(Builder::etvSignalPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("etvSignalPid").build()).build();

    private static final SdkField<List<Integer>> KLV_DATA_PIDS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("KlvDataPids")
            .getter(getter(MultiplexProgramPacketIdentifiersMap::klvDataPids))
            .setter(setter(Builder::klvDataPids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("klvDataPids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> PCR_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PcrPid").getter(getter(MultiplexProgramPacketIdentifiersMap::pcrPid)).setter(setter(Builder::pcrPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pcrPid").build()).build();

    private static final SdkField<Integer> PMT_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PmtPid").getter(getter(MultiplexProgramPacketIdentifiersMap::pmtPid)).setter(setter(Builder::pmtPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pmtPid").build()).build();

    private static final SdkField<Integer> PRIVATE_METADATA_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PrivateMetadataPid").getter(getter(MultiplexProgramPacketIdentifiersMap::privateMetadataPid))
            .setter(setter(Builder::privateMetadataPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateMetadataPid").build())
            .build();

    private static final SdkField<List<Integer>> SCTE27_PIDS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Scte27Pids")
            .getter(getter(MultiplexProgramPacketIdentifiersMap::scte27Pids))
            .setter(setter(Builder::scte27Pids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte27Pids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> SCTE35_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Scte35Pid").getter(getter(MultiplexProgramPacketIdentifiersMap::scte35Pid))
            .setter(setter(Builder::scte35Pid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Pid").build()).build();

    private static final SdkField<Integer> TIMED_METADATA_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimedMetadataPid").getter(getter(MultiplexProgramPacketIdentifiersMap::timedMetadataPid))
            .setter(setter(Builder::timedMetadataPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataPid").build()).build();

    private static final SdkField<Integer> VIDEO_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VideoPid").getter(getter(MultiplexProgramPacketIdentifiersMap::videoPid))
            .setter(setter(Builder::videoPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoPid").build()).build();

    private static final SdkField<Integer> ARIB_CAPTIONS_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AribCaptionsPid").getter(getter(MultiplexProgramPacketIdentifiersMap::aribCaptionsPid))
            .setter(setter(Builder::aribCaptionsPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aribCaptionsPid").build()).build();

    private static final SdkField<List<Integer>> DVB_TELETEXT_PIDS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("DvbTeletextPids")
            .getter(getter(MultiplexProgramPacketIdentifiersMap::dvbTeletextPids))
            .setter(setter(Builder::dvbTeletextPids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbTeletextPids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> ECM_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EcmPid").getter(getter(MultiplexProgramPacketIdentifiersMap::ecmPid)).setter(setter(Builder::ecmPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecmPid").build()).build();

    private static final SdkField<Integer> SMPTE2038_PID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Smpte2038Pid").getter(getter(MultiplexProgramPacketIdentifiersMap::smpte2038Pid))
            .setter(setter(Builder::smpte2038Pid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smpte2038Pid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_PIDS_FIELD,
            DVB_SUB_PIDS_FIELD, DVB_TELETEXT_PID_FIELD, ETV_PLATFORM_PID_FIELD, ETV_SIGNAL_PID_FIELD, KLV_DATA_PIDS_FIELD,
            PCR_PID_FIELD, PMT_PID_FIELD, PRIVATE_METADATA_PID_FIELD, SCTE27_PIDS_FIELD, SCTE35_PID_FIELD,
            TIMED_METADATA_PID_FIELD, VIDEO_PID_FIELD, ARIB_CAPTIONS_PID_FIELD, DVB_TELETEXT_PIDS_FIELD, ECM_PID_FIELD,
            SMPTE2038_PID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Integer> audioPids;

    private final List<Integer> dvbSubPids;

    private final Integer dvbTeletextPid;

    private final Integer etvPlatformPid;

    private final Integer etvSignalPid;

    private final List<Integer> klvDataPids;

    private final Integer pcrPid;

    private final Integer pmtPid;

    private final Integer privateMetadataPid;

    private final List<Integer> scte27Pids;

    private final Integer scte35Pid;

    private final Integer timedMetadataPid;

    private final Integer videoPid;

    private final Integer aribCaptionsPid;

    private final List<Integer> dvbTeletextPids;

    private final Integer ecmPid;

    private final Integer smpte2038Pid;

    private MultiplexProgramPacketIdentifiersMap(BuilderImpl builder) {
        this.audioPids = builder.audioPids;
        this.dvbSubPids = builder.dvbSubPids;
        this.dvbTeletextPid = builder.dvbTeletextPid;
        this.etvPlatformPid = builder.etvPlatformPid;
        this.etvSignalPid = builder.etvSignalPid;
        this.klvDataPids = builder.klvDataPids;
        this.pcrPid = builder.pcrPid;
        this.pmtPid = builder.pmtPid;
        this.privateMetadataPid = builder.privateMetadataPid;
        this.scte27Pids = builder.scte27Pids;
        this.scte35Pid = builder.scte35Pid;
        this.timedMetadataPid = builder.timedMetadataPid;
        this.videoPid = builder.videoPid;
        this.aribCaptionsPid = builder.aribCaptionsPid;
        this.dvbTeletextPids = builder.dvbTeletextPids;
        this.ecmPid = builder.ecmPid;
        this.smpte2038Pid = builder.smpte2038Pid;
    }

    /**
     * For responses, this returns true if the service returned a value for the AudioPids property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAudioPids() {
        return audioPids != null && !(audioPids instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AudioPids property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudioPids} method.
     * </p>
     * 
     * @return The value of the AudioPids property for this object.
     */
    public final List<Integer> audioPids() {
        return audioPids;
    }

    /**
     * For responses, this returns true if the service returned a value for the DvbSubPids property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDvbSubPids() {
        return dvbSubPids != null && !(dvbSubPids instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the DvbSubPids property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDvbSubPids} method.
     * </p>
     * 
     * @return The value of the DvbSubPids property for this object.
     */
    public final List<Integer> dvbSubPids() {
        return dvbSubPids;
    }

    /**
     * Returns the value of the DvbTeletextPid property for this object.
     * 
     * @return The value of the DvbTeletextPid property for this object.
     */
    public final Integer dvbTeletextPid() {
        return dvbTeletextPid;
    }

    /**
     * Returns the value of the EtvPlatformPid property for this object.
     * 
     * @return The value of the EtvPlatformPid property for this object.
     */
    public final Integer etvPlatformPid() {
        return etvPlatformPid;
    }

    /**
     * Returns the value of the EtvSignalPid property for this object.
     * 
     * @return The value of the EtvSignalPid property for this object.
     */
    public final Integer etvSignalPid() {
        return etvSignalPid;
    }

    /**
     * For responses, this returns true if the service returned a value for the KlvDataPids property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKlvDataPids() {
        return klvDataPids != null && !(klvDataPids instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the KlvDataPids property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKlvDataPids} method.
     * </p>
     * 
     * @return The value of the KlvDataPids property for this object.
     */
    public final List<Integer> klvDataPids() {
        return klvDataPids;
    }

    /**
     * Returns the value of the PcrPid property for this object.
     * 
     * @return The value of the PcrPid property for this object.
     */
    public final Integer pcrPid() {
        return pcrPid;
    }

    /**
     * Returns the value of the PmtPid property for this object.
     * 
     * @return The value of the PmtPid property for this object.
     */
    public final Integer pmtPid() {
        return pmtPid;
    }

    /**
     * Returns the value of the PrivateMetadataPid property for this object.
     * 
     * @return The value of the PrivateMetadataPid property for this object.
     */
    public final Integer privateMetadataPid() {
        return privateMetadataPid;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scte27Pids property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScte27Pids() {
        return scte27Pids != null && !(scte27Pids instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Scte27Pids property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScte27Pids} method.
     * </p>
     * 
     * @return The value of the Scte27Pids property for this object.
     */
    public final List<Integer> scte27Pids() {
        return scte27Pids;
    }

    /**
     * Returns the value of the Scte35Pid property for this object.
     * 
     * @return The value of the Scte35Pid property for this object.
     */
    public final Integer scte35Pid() {
        return scte35Pid;
    }

    /**
     * Returns the value of the TimedMetadataPid property for this object.
     * 
     * @return The value of the TimedMetadataPid property for this object.
     */
    public final Integer timedMetadataPid() {
        return timedMetadataPid;
    }

    /**
     * Returns the value of the VideoPid property for this object.
     * 
     * @return The value of the VideoPid property for this object.
     */
    public final Integer videoPid() {
        return videoPid;
    }

    /**
     * Returns the value of the AribCaptionsPid property for this object.
     * 
     * @return The value of the AribCaptionsPid property for this object.
     */
    public final Integer aribCaptionsPid() {
        return aribCaptionsPid;
    }

    /**
     * For responses, this returns true if the service returned a value for the DvbTeletextPids property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDvbTeletextPids() {
        return dvbTeletextPids != null && !(dvbTeletextPids instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the DvbTeletextPids property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDvbTeletextPids} method.
     * </p>
     * 
     * @return The value of the DvbTeletextPids property for this object.
     */
    public final List<Integer> dvbTeletextPids() {
        return dvbTeletextPids;
    }

    /**
     * Returns the value of the EcmPid property for this object.
     * 
     * @return The value of the EcmPid property for this object.
     */
    public final Integer ecmPid() {
        return ecmPid;
    }

    /**
     * Returns the value of the Smpte2038Pid property for this object.
     * 
     * @return The value of the Smpte2038Pid property for this object.
     */
    public final Integer smpte2038Pid() {
        return smpte2038Pid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAudioPids() ? audioPids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDvbSubPids() ? dvbSubPids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dvbTeletextPid());
        hashCode = 31 * hashCode + Objects.hashCode(etvPlatformPid());
        hashCode = 31 * hashCode + Objects.hashCode(etvSignalPid());
        hashCode = 31 * hashCode + Objects.hashCode(hasKlvDataPids() ? klvDataPids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pcrPid());
        hashCode = 31 * hashCode + Objects.hashCode(pmtPid());
        hashCode = 31 * hashCode + Objects.hashCode(privateMetadataPid());
        hashCode = 31 * hashCode + Objects.hashCode(hasScte27Pids() ? scte27Pids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scte35Pid());
        hashCode = 31 * hashCode + Objects.hashCode(timedMetadataPid());
        hashCode = 31 * hashCode + Objects.hashCode(videoPid());
        hashCode = 31 * hashCode + Objects.hashCode(aribCaptionsPid());
        hashCode = 31 * hashCode + Objects.hashCode(hasDvbTeletextPids() ? dvbTeletextPids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ecmPid());
        hashCode = 31 * hashCode + Objects.hashCode(smpte2038Pid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexProgramPacketIdentifiersMap)) {
            return false;
        }
        MultiplexProgramPacketIdentifiersMap other = (MultiplexProgramPacketIdentifiersMap) obj;
        return hasAudioPids() == other.hasAudioPids() && Objects.equals(audioPids(), other.audioPids())
                && hasDvbSubPids() == other.hasDvbSubPids() && Objects.equals(dvbSubPids(), other.dvbSubPids())
                && Objects.equals(dvbTeletextPid(), other.dvbTeletextPid())
                && Objects.equals(etvPlatformPid(), other.etvPlatformPid())
                && Objects.equals(etvSignalPid(), other.etvSignalPid()) && hasKlvDataPids() == other.hasKlvDataPids()
                && Objects.equals(klvDataPids(), other.klvDataPids()) && Objects.equals(pcrPid(), other.pcrPid())
                && Objects.equals(pmtPid(), other.pmtPid()) && Objects.equals(privateMetadataPid(), other.privateMetadataPid())
                && hasScte27Pids() == other.hasScte27Pids() && Objects.equals(scte27Pids(), other.scte27Pids())
                && Objects.equals(scte35Pid(), other.scte35Pid()) && Objects.equals(timedMetadataPid(), other.timedMetadataPid())
                && Objects.equals(videoPid(), other.videoPid()) && Objects.equals(aribCaptionsPid(), other.aribCaptionsPid())
                && hasDvbTeletextPids() == other.hasDvbTeletextPids()
                && Objects.equals(dvbTeletextPids(), other.dvbTeletextPids()) && Objects.equals(ecmPid(), other.ecmPid())
                && Objects.equals(smpte2038Pid(), other.smpte2038Pid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiplexProgramPacketIdentifiersMap").add("AudioPids", hasAudioPids() ? audioPids() : null)
                .add("DvbSubPids", hasDvbSubPids() ? dvbSubPids() : null).add("DvbTeletextPid", dvbTeletextPid())
                .add("EtvPlatformPid", etvPlatformPid()).add("EtvSignalPid", etvSignalPid())
                .add("KlvDataPids", hasKlvDataPids() ? klvDataPids() : null).add("PcrPid", pcrPid()).add("PmtPid", pmtPid())
                .add("PrivateMetadataPid", privateMetadataPid()).add("Scte27Pids", hasScte27Pids() ? scte27Pids() : null)
                .add("Scte35Pid", scte35Pid()).add("TimedMetadataPid", timedMetadataPid()).add("VideoPid", videoPid())
                .add("AribCaptionsPid", aribCaptionsPid())
                .add("DvbTeletextPids", hasDvbTeletextPids() ? dvbTeletextPids() : null).add("EcmPid", ecmPid())
                .add("Smpte2038Pid", smpte2038Pid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioPids":
            return Optional.ofNullable(clazz.cast(audioPids()));
        case "DvbSubPids":
            return Optional.ofNullable(clazz.cast(dvbSubPids()));
        case "DvbTeletextPid":
            return Optional.ofNullable(clazz.cast(dvbTeletextPid()));
        case "EtvPlatformPid":
            return Optional.ofNullable(clazz.cast(etvPlatformPid()));
        case "EtvSignalPid":
            return Optional.ofNullable(clazz.cast(etvSignalPid()));
        case "KlvDataPids":
            return Optional.ofNullable(clazz.cast(klvDataPids()));
        case "PcrPid":
            return Optional.ofNullable(clazz.cast(pcrPid()));
        case "PmtPid":
            return Optional.ofNullable(clazz.cast(pmtPid()));
        case "PrivateMetadataPid":
            return Optional.ofNullable(clazz.cast(privateMetadataPid()));
        case "Scte27Pids":
            return Optional.ofNullable(clazz.cast(scte27Pids()));
        case "Scte35Pid":
            return Optional.ofNullable(clazz.cast(scte35Pid()));
        case "TimedMetadataPid":
            return Optional.ofNullable(clazz.cast(timedMetadataPid()));
        case "VideoPid":
            return Optional.ofNullable(clazz.cast(videoPid()));
        case "AribCaptionsPid":
            return Optional.ofNullable(clazz.cast(aribCaptionsPid()));
        case "DvbTeletextPids":
            return Optional.ofNullable(clazz.cast(dvbTeletextPids()));
        case "EcmPid":
            return Optional.ofNullable(clazz.cast(ecmPid()));
        case "Smpte2038Pid":
            return Optional.ofNullable(clazz.cast(smpte2038Pid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("audioPids", AUDIO_PIDS_FIELD);
        map.put("dvbSubPids", DVB_SUB_PIDS_FIELD);
        map.put("dvbTeletextPid", DVB_TELETEXT_PID_FIELD);
        map.put("etvPlatformPid", ETV_PLATFORM_PID_FIELD);
        map.put("etvSignalPid", ETV_SIGNAL_PID_FIELD);
        map.put("klvDataPids", KLV_DATA_PIDS_FIELD);
        map.put("pcrPid", PCR_PID_FIELD);
        map.put("pmtPid", PMT_PID_FIELD);
        map.put("privateMetadataPid", PRIVATE_METADATA_PID_FIELD);
        map.put("scte27Pids", SCTE27_PIDS_FIELD);
        map.put("scte35Pid", SCTE35_PID_FIELD);
        map.put("timedMetadataPid", TIMED_METADATA_PID_FIELD);
        map.put("videoPid", VIDEO_PID_FIELD);
        map.put("aribCaptionsPid", ARIB_CAPTIONS_PID_FIELD);
        map.put("dvbTeletextPids", DVB_TELETEXT_PIDS_FIELD);
        map.put("ecmPid", ECM_PID_FIELD);
        map.put("smpte2038Pid", SMPTE2038_PID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiplexProgramPacketIdentifiersMap, T> g) {
        return obj -> g.apply((MultiplexProgramPacketIdentifiersMap) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiplexProgramPacketIdentifiersMap> {
        /**
         * Sets the value of the AudioPids property for this object.
         *
         * @param audioPids
         *        The new value for the AudioPids property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioPids(Collection<Integer> audioPids);

        /**
         * Sets the value of the AudioPids property for this object.
         *
         * @param audioPids
         *        The new value for the AudioPids property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioPids(Integer... audioPids);

        /**
         * Sets the value of the DvbSubPids property for this object.
         *
         * @param dvbSubPids
         *        The new value for the DvbSubPids property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbSubPids(Collection<Integer> dvbSubPids);

        /**
         * Sets the value of the DvbSubPids property for this object.
         *
         * @param dvbSubPids
         *        The new value for the DvbSubPids property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbSubPids(Integer... dvbSubPids);

        /**
         * Sets the value of the DvbTeletextPid property for this object.
         *
         * @param dvbTeletextPid
         *        The new value for the DvbTeletextPid property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbTeletextPid(Integer dvbTeletextPid);

        /**
         * Sets the value of the EtvPlatformPid property for this object.
         *
         * @param etvPlatformPid
         *        The new value for the EtvPlatformPid property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder etvPlatformPid(Integer etvPlatformPid);

        /**
         * Sets the value of the EtvSignalPid property for this object.
         *
         * @param etvSignalPid
         *        The new value for the EtvSignalPid property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder etvSignalPid(Integer etvSignalPid);

        /**
         * Sets the value of the KlvDataPids property for this object.
         *
         * @param klvDataPids
         *        The new value for the KlvDataPids property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder klvDataPids(Collection<Integer> klvDataPids);

        /**
         * Sets the value of the KlvDataPids property for this object.
         *
         * @param klvDataPids
         *        The new value for the KlvDataPids property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder klvDataPids(Integer... klvDataPids);

        /**
         * Sets the value of the PcrPid property for this object.
         *
         * @param pcrPid
         *        The new value for the PcrPid property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pcrPid(Integer pcrPid);

        /**
         * Sets the value of the PmtPid property for this object.
         *
         * @param pmtPid
         *        The new value for the PmtPid property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pmtPid(Integer pmtPid);

        /**
         * Sets the value of the PrivateMetadataPid property for this object.
         *
         * @param privateMetadataPid
         *        The new value for the PrivateMetadataPid property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateMetadataPid(Integer privateMetadataPid);

        /**
         * Sets the value of the Scte27Pids property for this object.
         *
         * @param scte27Pids
         *        The new value for the Scte27Pids property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte27Pids(Collection<Integer> scte27Pids);

        /**
         * Sets the value of the Scte27Pids property for this object.
         *
         * @param scte27Pids
         *        The new value for the Scte27Pids property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte27Pids(Integer... scte27Pids);

        /**
         * Sets the value of the Scte35Pid property for this object.
         *
         * @param scte35Pid
         *        The new value for the Scte35Pid property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte35Pid(Integer scte35Pid);

        /**
         * Sets the value of the TimedMetadataPid property for this object.
         *
         * @param timedMetadataPid
         *        The new value for the TimedMetadataPid property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timedMetadataPid(Integer timedMetadataPid);

        /**
         * Sets the value of the VideoPid property for this object.
         *
         * @param videoPid
         *        The new value for the VideoPid property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoPid(Integer videoPid);

        /**
         * Sets the value of the AribCaptionsPid property for this object.
         *
         * @param aribCaptionsPid
         *        The new value for the AribCaptionsPid property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aribCaptionsPid(Integer aribCaptionsPid);

        /**
         * Sets the value of the DvbTeletextPids property for this object.
         *
         * @param dvbTeletextPids
         *        The new value for the DvbTeletextPids property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbTeletextPids(Collection<Integer> dvbTeletextPids);

        /**
         * Sets the value of the DvbTeletextPids property for this object.
         *
         * @param dvbTeletextPids
         *        The new value for the DvbTeletextPids property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbTeletextPids(Integer... dvbTeletextPids);

        /**
         * Sets the value of the EcmPid property for this object.
         *
         * @param ecmPid
         *        The new value for the EcmPid property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecmPid(Integer ecmPid);

        /**
         * Sets the value of the Smpte2038Pid property for this object.
         *
         * @param smpte2038Pid
         *        The new value for the Smpte2038Pid property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smpte2038Pid(Integer smpte2038Pid);
    }

    static final class BuilderImpl implements Builder {
        private List<Integer> audioPids = DefaultSdkAutoConstructList.getInstance();

        private List<Integer> dvbSubPids = DefaultSdkAutoConstructList.getInstance();

        private Integer dvbTeletextPid;

        private Integer etvPlatformPid;

        private Integer etvSignalPid;

        private List<Integer> klvDataPids = DefaultSdkAutoConstructList.getInstance();

        private Integer pcrPid;

        private Integer pmtPid;

        private Integer privateMetadataPid;

        private List<Integer> scte27Pids = DefaultSdkAutoConstructList.getInstance();

        private Integer scte35Pid;

        private Integer timedMetadataPid;

        private Integer videoPid;

        private Integer aribCaptionsPid;

        private List<Integer> dvbTeletextPids = DefaultSdkAutoConstructList.getInstance();

        private Integer ecmPid;

        private Integer smpte2038Pid;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexProgramPacketIdentifiersMap model) {
            audioPids(model.audioPids);
            dvbSubPids(model.dvbSubPids);
            dvbTeletextPid(model.dvbTeletextPid);
            etvPlatformPid(model.etvPlatformPid);
            etvSignalPid(model.etvSignalPid);
            klvDataPids(model.klvDataPids);
            pcrPid(model.pcrPid);
            pmtPid(model.pmtPid);
            privateMetadataPid(model.privateMetadataPid);
            scte27Pids(model.scte27Pids);
            scte35Pid(model.scte35Pid);
            timedMetadataPid(model.timedMetadataPid);
            videoPid(model.videoPid);
            aribCaptionsPid(model.aribCaptionsPid);
            dvbTeletextPids(model.dvbTeletextPids);
            ecmPid(model.ecmPid);
            smpte2038Pid(model.smpte2038Pid);
        }

        public final Collection<Integer> getAudioPids() {
            if (audioPids instanceof SdkAutoConstructList) {
                return null;
            }
            return audioPids;
        }

        public final void setAudioPids(Collection<Integer> audioPids) {
            this.audioPids = ___listOf__integerCopier.copy(audioPids);
        }

        @Override
        public final Builder audioPids(Collection<Integer> audioPids) {
            this.audioPids = ___listOf__integerCopier.copy(audioPids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioPids(Integer... audioPids) {
            audioPids(Arrays.asList(audioPids));
            return this;
        }

        public final Collection<Integer> getDvbSubPids() {
            if (dvbSubPids instanceof SdkAutoConstructList) {
                return null;
            }
            return dvbSubPids;
        }

        public final void setDvbSubPids(Collection<Integer> dvbSubPids) {
            this.dvbSubPids = ___listOf__integerCopier.copy(dvbSubPids);
        }

        @Override
        public final Builder dvbSubPids(Collection<Integer> dvbSubPids) {
            this.dvbSubPids = ___listOf__integerCopier.copy(dvbSubPids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dvbSubPids(Integer... dvbSubPids) {
            dvbSubPids(Arrays.asList(dvbSubPids));
            return this;
        }

        public final Integer getDvbTeletextPid() {
            return dvbTeletextPid;
        }

        public final void setDvbTeletextPid(Integer dvbTeletextPid) {
            this.dvbTeletextPid = dvbTeletextPid;
        }

        @Override
        public final Builder dvbTeletextPid(Integer dvbTeletextPid) {
            this.dvbTeletextPid = dvbTeletextPid;
            return this;
        }

        public final Integer getEtvPlatformPid() {
            return etvPlatformPid;
        }

        public final void setEtvPlatformPid(Integer etvPlatformPid) {
            this.etvPlatformPid = etvPlatformPid;
        }

        @Override
        public final Builder etvPlatformPid(Integer etvPlatformPid) {
            this.etvPlatformPid = etvPlatformPid;
            return this;
        }

        public final Integer getEtvSignalPid() {
            return etvSignalPid;
        }

        public final void setEtvSignalPid(Integer etvSignalPid) {
            this.etvSignalPid = etvSignalPid;
        }

        @Override
        public final Builder etvSignalPid(Integer etvSignalPid) {
            this.etvSignalPid = etvSignalPid;
            return this;
        }

        public final Collection<Integer> getKlvDataPids() {
            if (klvDataPids instanceof SdkAutoConstructList) {
                return null;
            }
            return klvDataPids;
        }

        public final void setKlvDataPids(Collection<Integer> klvDataPids) {
            this.klvDataPids = ___listOf__integerCopier.copy(klvDataPids);
        }

        @Override
        public final Builder klvDataPids(Collection<Integer> klvDataPids) {
            this.klvDataPids = ___listOf__integerCopier.copy(klvDataPids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder klvDataPids(Integer... klvDataPids) {
            klvDataPids(Arrays.asList(klvDataPids));
            return this;
        }

        public final Integer getPcrPid() {
            return pcrPid;
        }

        public final void setPcrPid(Integer pcrPid) {
            this.pcrPid = pcrPid;
        }

        @Override
        public final Builder pcrPid(Integer pcrPid) {
            this.pcrPid = pcrPid;
            return this;
        }

        public final Integer getPmtPid() {
            return pmtPid;
        }

        public final void setPmtPid(Integer pmtPid) {
            this.pmtPid = pmtPid;
        }

        @Override
        public final Builder pmtPid(Integer pmtPid) {
            this.pmtPid = pmtPid;
            return this;
        }

        public final Integer getPrivateMetadataPid() {
            return privateMetadataPid;
        }

        public final void setPrivateMetadataPid(Integer privateMetadataPid) {
            this.privateMetadataPid = privateMetadataPid;
        }

        @Override
        public final Builder privateMetadataPid(Integer privateMetadataPid) {
            this.privateMetadataPid = privateMetadataPid;
            return this;
        }

        public final Collection<Integer> getScte27Pids() {
            if (scte27Pids instanceof SdkAutoConstructList) {
                return null;
            }
            return scte27Pids;
        }

        public final void setScte27Pids(Collection<Integer> scte27Pids) {
            this.scte27Pids = ___listOf__integerCopier.copy(scte27Pids);
        }

        @Override
        public final Builder scte27Pids(Collection<Integer> scte27Pids) {
            this.scte27Pids = ___listOf__integerCopier.copy(scte27Pids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scte27Pids(Integer... scte27Pids) {
            scte27Pids(Arrays.asList(scte27Pids));
            return this;
        }

        public final Integer getScte35Pid() {
            return scte35Pid;
        }

        public final void setScte35Pid(Integer scte35Pid) {
            this.scte35Pid = scte35Pid;
        }

        @Override
        public final Builder scte35Pid(Integer scte35Pid) {
            this.scte35Pid = scte35Pid;
            return this;
        }

        public final Integer getTimedMetadataPid() {
            return timedMetadataPid;
        }

        public final void setTimedMetadataPid(Integer timedMetadataPid) {
            this.timedMetadataPid = timedMetadataPid;
        }

        @Override
        public final Builder timedMetadataPid(Integer timedMetadataPid) {
            this.timedMetadataPid = timedMetadataPid;
            return this;
        }

        public final Integer getVideoPid() {
            return videoPid;
        }

        public final void setVideoPid(Integer videoPid) {
            this.videoPid = videoPid;
        }

        @Override
        public final Builder videoPid(Integer videoPid) {
            this.videoPid = videoPid;
            return this;
        }

        public final Integer getAribCaptionsPid() {
            return aribCaptionsPid;
        }

        public final void setAribCaptionsPid(Integer aribCaptionsPid) {
            this.aribCaptionsPid = aribCaptionsPid;
        }

        @Override
        public final Builder aribCaptionsPid(Integer aribCaptionsPid) {
            this.aribCaptionsPid = aribCaptionsPid;
            return this;
        }

        public final Collection<Integer> getDvbTeletextPids() {
            if (dvbTeletextPids instanceof SdkAutoConstructList) {
                return null;
            }
            return dvbTeletextPids;
        }

        public final void setDvbTeletextPids(Collection<Integer> dvbTeletextPids) {
            this.dvbTeletextPids = ___listOf__integerCopier.copy(dvbTeletextPids);
        }

        @Override
        public final Builder dvbTeletextPids(Collection<Integer> dvbTeletextPids) {
            this.dvbTeletextPids = ___listOf__integerCopier.copy(dvbTeletextPids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dvbTeletextPids(Integer... dvbTeletextPids) {
            dvbTeletextPids(Arrays.asList(dvbTeletextPids));
            return this;
        }

        public final Integer getEcmPid() {
            return ecmPid;
        }

        public final void setEcmPid(Integer ecmPid) {
            this.ecmPid = ecmPid;
        }

        @Override
        public final Builder ecmPid(Integer ecmPid) {
            this.ecmPid = ecmPid;
            return this;
        }

        public final Integer getSmpte2038Pid() {
            return smpte2038Pid;
        }

        public final void setSmpte2038Pid(Integer smpte2038Pid) {
            this.smpte2038Pid = smpte2038Pid;
        }

        @Override
        public final Builder smpte2038Pid(Integer smpte2038Pid) {
            this.smpte2038Pid = smpte2038Pid;
            return this;
        }

        @Override
        public MultiplexProgramPacketIdentifiersMap build() {
            return new MultiplexProgramPacketIdentifiersMap(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
