/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The current source for one of the pipelines in the multiplex.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiplexProgramPipelineDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiplexProgramPipelineDetail.Builder, MultiplexProgramPipelineDetail> {
    private static final SdkField<String> ACTIVE_CHANNEL_PIPELINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveChannelPipeline").getter(getter(MultiplexProgramPipelineDetail::activeChannelPipeline))
            .setter(setter(Builder::activeChannelPipeline))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeChannelPipeline").build())
            .build();

    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineId").getter(getter(MultiplexProgramPipelineDetail::pipelineId))
            .setter(setter(Builder::pipelineId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_CHANNEL_PIPELINE_FIELD,
            PIPELINE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String activeChannelPipeline;

    private final String pipelineId;

    private MultiplexProgramPipelineDetail(BuilderImpl builder) {
        this.activeChannelPipeline = builder.activeChannelPipeline;
        this.pipelineId = builder.pipelineId;
    }

    /**
     * Identifies the channel pipeline that is currently active for the pipeline (identified by PipelineId) in the
     * multiplex.
     * 
     * @return Identifies the channel pipeline that is currently active for the pipeline (identified by PipelineId) in
     *         the multiplex.
     */
    public final String activeChannelPipeline() {
        return activeChannelPipeline;
    }

    /**
     * Identifies a specific pipeline in the multiplex.
     * 
     * @return Identifies a specific pipeline in the multiplex.
     */
    public final String pipelineId() {
        return pipelineId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeChannelPipeline());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexProgramPipelineDetail)) {
            return false;
        }
        MultiplexProgramPipelineDetail other = (MultiplexProgramPipelineDetail) obj;
        return Objects.equals(activeChannelPipeline(), other.activeChannelPipeline())
                && Objects.equals(pipelineId(), other.pipelineId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiplexProgramPipelineDetail").add("ActiveChannelPipeline", activeChannelPipeline())
                .add("PipelineId", pipelineId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveChannelPipeline":
            return Optional.ofNullable(clazz.cast(activeChannelPipeline()));
        case "PipelineId":
            return Optional.ofNullable(clazz.cast(pipelineId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("activeChannelPipeline", ACTIVE_CHANNEL_PIPELINE_FIELD);
        map.put("pipelineId", PIPELINE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiplexProgramPipelineDetail, T> g) {
        return obj -> g.apply((MultiplexProgramPipelineDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiplexProgramPipelineDetail> {
        /**
         * Identifies the channel pipeline that is currently active for the pipeline (identified by PipelineId) in the
         * multiplex.
         * 
         * @param activeChannelPipeline
         *        Identifies the channel pipeline that is currently active for the pipeline (identified by PipelineId)
         *        in the multiplex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeChannelPipeline(String activeChannelPipeline);

        /**
         * Identifies a specific pipeline in the multiplex.
         * 
         * @param pipelineId
         *        Identifies a specific pipeline in the multiplex.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineId(String pipelineId);
    }

    static final class BuilderImpl implements Builder {
        private String activeChannelPipeline;

        private String pipelineId;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexProgramPipelineDetail model) {
            activeChannelPipeline(model.activeChannelPipeline);
            pipelineId(model.pipelineId);
        }

        public final String getActiveChannelPipeline() {
            return activeChannelPipeline;
        }

        public final void setActiveChannelPipeline(String activeChannelPipeline) {
            this.activeChannelPipeline = activeChannelPipeline;
        }

        @Override
        public final Builder activeChannelPipeline(String activeChannelPipeline) {
            this.activeChannelPipeline = activeChannelPipeline;
            return this;
        }

        public final String getPipelineId() {
            return pipelineId;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        @Override
        public MultiplexProgramPipelineDetail build() {
            return new MultiplexProgramPipelineDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
