/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Nielsen Naes Ii Nw
 */
@Generated("software.amazon.awssdk:codegen")
public final class NielsenNaesIiNw implements SdkPojo, Serializable, ToCopyableBuilder<NielsenNaesIiNw.Builder, NielsenNaesIiNw> {
    private static final SdkField<String> CHECK_DIGIT_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CheckDigitString").getter(getter(NielsenNaesIiNw::checkDigitString))
            .setter(setter(Builder::checkDigitString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkDigitString").build()).build();

    private static final SdkField<Double> SID_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Sid")
            .getter(getter(NielsenNaesIiNw::sid)).setter(setter(Builder::sid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sid").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(NielsenNaesIiNw::timezoneAsString)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timezone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_DIGIT_STRING_FIELD,
            SID_FIELD, TIMEZONE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String checkDigitString;

    private final Double sid;

    private final String timezone;

    private NielsenNaesIiNw(BuilderImpl builder) {
        this.checkDigitString = builder.checkDigitString;
        this.sid = builder.sid;
        this.timezone = builder.timezone;
    }

    /**
     * Enter the check digit string for the watermark
     * 
     * @return Enter the check digit string for the watermark
     */
    public final String checkDigitString() {
        return checkDigitString;
    }

    /**
     * Enter the Nielsen Source ID (SID) to include in the watermark
     * 
     * @return Enter the Nielsen Source ID (SID) to include in the watermark
     */
    public final Double sid() {
        return sid;
    }

    /**
     * Choose the timezone for the time stamps in the watermark. If not provided, the timestamps will be in Coordinated
     * Universal Time (UTC)
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timezone} will
     * return {@link NielsenWatermarkTimezones#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timezoneAsString}.
     * </p>
     * 
     * @return Choose the timezone for the time stamps in the watermark. If not provided, the timestamps will be in
     *         Coordinated Universal Time (UTC)
     * @see NielsenWatermarkTimezones
     */
    public final NielsenWatermarkTimezones timezone() {
        return NielsenWatermarkTimezones.fromValue(timezone);
    }

    /**
     * Choose the timezone for the time stamps in the watermark. If not provided, the timestamps will be in Coordinated
     * Universal Time (UTC)
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timezone} will
     * return {@link NielsenWatermarkTimezones#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timezoneAsString}.
     * </p>
     * 
     * @return Choose the timezone for the time stamps in the watermark. If not provided, the timestamps will be in
     *         Coordinated Universal Time (UTC)
     * @see NielsenWatermarkTimezones
     */
    public final String timezoneAsString() {
        return timezone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(checkDigitString());
        hashCode = 31 * hashCode + Objects.hashCode(sid());
        hashCode = 31 * hashCode + Objects.hashCode(timezoneAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NielsenNaesIiNw)) {
            return false;
        }
        NielsenNaesIiNw other = (NielsenNaesIiNw) obj;
        return Objects.equals(checkDigitString(), other.checkDigitString()) && Objects.equals(sid(), other.sid())
                && Objects.equals(timezoneAsString(), other.timezoneAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NielsenNaesIiNw").add("CheckDigitString", checkDigitString()).add("Sid", sid())
                .add("Timezone", timezoneAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CheckDigitString":
            return Optional.ofNullable(clazz.cast(checkDigitString()));
        case "Sid":
            return Optional.ofNullable(clazz.cast(sid()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezoneAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("checkDigitString", CHECK_DIGIT_STRING_FIELD);
        map.put("sid", SID_FIELD);
        map.put("timezone", TIMEZONE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NielsenNaesIiNw, T> g) {
        return obj -> g.apply((NielsenNaesIiNw) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NielsenNaesIiNw> {
        /**
         * Enter the check digit string for the watermark
         * 
         * @param checkDigitString
         *        Enter the check digit string for the watermark
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkDigitString(String checkDigitString);

        /**
         * Enter the Nielsen Source ID (SID) to include in the watermark
         * 
         * @param sid
         *        Enter the Nielsen Source ID (SID) to include in the watermark
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sid(Double sid);

        /**
         * Choose the timezone for the time stamps in the watermark. If not provided, the timestamps will be in
         * Coordinated Universal Time (UTC)
         * 
         * @param timezone
         *        Choose the timezone for the time stamps in the watermark. If not provided, the timestamps will be in
         *        Coordinated Universal Time (UTC)
         * @see NielsenWatermarkTimezones
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NielsenWatermarkTimezones
         */
        Builder timezone(String timezone);

        /**
         * Choose the timezone for the time stamps in the watermark. If not provided, the timestamps will be in
         * Coordinated Universal Time (UTC)
         * 
         * @param timezone
         *        Choose the timezone for the time stamps in the watermark. If not provided, the timestamps will be in
         *        Coordinated Universal Time (UTC)
         * @see NielsenWatermarkTimezones
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NielsenWatermarkTimezones
         */
        Builder timezone(NielsenWatermarkTimezones timezone);
    }

    static final class BuilderImpl implements Builder {
        private String checkDigitString;

        private Double sid;

        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(NielsenNaesIiNw model) {
            checkDigitString(model.checkDigitString);
            sid(model.sid);
            timezone(model.timezone);
        }

        public final String getCheckDigitString() {
            return checkDigitString;
        }

        public final void setCheckDigitString(String checkDigitString) {
            this.checkDigitString = checkDigitString;
        }

        @Override
        public final Builder checkDigitString(String checkDigitString) {
            this.checkDigitString = checkDigitString;
            return this;
        }

        public final Double getSid() {
            return sid;
        }

        public final void setSid(Double sid) {
            this.sid = sid;
        }

        @Override
        public final Builder sid(Double sid) {
            this.sid = sid;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Override
        public final Builder timezone(NielsenWatermarkTimezones timezone) {
            this.timezone(timezone == null ? null : timezone.toString());
            return this;
        }

        @Override
        public NielsenNaesIiNw build() {
            return new NielsenNaesIiNw(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
